/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal.el;

import org.eclipse.core.resources.IProject;
import org.eclipse.jst.jsf.context.symbol.internal.provisional.IInstanceSymbol;
import org.eclipse.jst.jsf.context.symbol.internal.provisional.IMethodSymbol;
import org.eclipse.jst.jsf.context.symbol.internal.provisional.IObjectSymbol;
import org.eclipse.jst.jsf.context.symbol.internal.provisional.ISymbol;
import org.eclipse.jst.jsf.context.symbol.internal.provisional.ITypeDescriptor;
import org.eclipse.jst.jsf.core.internal.types.MethodType;
import org.eclipse.jst.jsf.core.internal.types.SignatureBasedType;
import org.eclipse.jst.jsf.core.internal.types.ValueType;
import org.eclipse.jst.jsf.designtime.internal.provisional.DesignTimeApplicationManager;
import org.eclipse.jst.jsf.designtime.internal.provisional.el.AbstractDTMethodResolver;
import org.eclipse.jst.jsf.designtime.internal.provisional.el.AbstractDTPropertyResolver;
import org.eclipse.jst.jsf.validation.internal.el.Activator;

class ValueExpressionTracker {
    private final IProject _project;
    private IInstanceSymbol _rootSymbol;
    private boolean _isRootValid;
    private ISymbol _curMemberSymbol;
    private int _curPropertySymbolOffset;
    private int _curPropertySymbolLength;
    private boolean _errorFlag;

    public ValueExpressionTracker(IProject project) {
        this._project = project;
    }

    public void setRootSymbol(IInstanceSymbol rootSymbol) {
        this._isRootValid = rootSymbol != null;
        this._rootSymbol = rootSymbol;
    }

    public boolean isRootValid() {
        return this._isRootValid;
    }

    public ISymbol getRootSymbol() {
        return this._rootSymbol;
    }

    public ISymbol getNextPropertySymbol(String name) {
        ISymbol curSymbol;
        Object object = curSymbol = this._curMemberSymbol != null ? this._curMemberSymbol : this._rootSymbol;
        if (curSymbol instanceof IObjectSymbol) {
            return this.getMemberSymbol((IObjectSymbol)curSymbol, name);
        }
        return null;
    }

    public boolean isValidMemberOfCurrentSymbol(String name) {
        if (this._curMemberSymbol == null) {
            return this.isValidMemberOfRoot(name);
        }
        if (this._curMemberSymbol instanceof IObjectSymbol) {
            return this.getMemberSymbol((IObjectSymbol)this._curMemberSymbol, name) != null;
        }
        return false;
    }

    public ISymbol getCurMemberSymbol() {
        return this._curMemberSymbol;
    }

    public void setCurMemberSymbol(ISymbol memberSymbol, int offset, int length) {
        this._curMemberSymbol = memberSymbol;
        this._curPropertySymbolOffset = offset;
        this._curPropertySymbolLength = length;
    }

    public int getCurPropertySymbolOffset() {
        return this._curPropertySymbolOffset;
    }

    public int getCurPropertySymbolLength() {
        return this._curPropertySymbolLength;
    }

    public boolean isErrorFlag() {
        return this._errorFlag;
    }

    public void setErrorFlag(boolean flag) {
        if (!this._errorFlag) {
            this._errorFlag = flag;
        }
    }

    public SignatureBasedType resolveType() {
        if (!this._isRootValid || this._rootSymbol == null) {
            throw new IllegalStateException("Cannot resolve type without root symbol");
        }
        if (this._errorFlag) {
            return null;
        }
        if (this._curMemberSymbol instanceof IMethodSymbol) {
            return new MethodType(this._curMemberSymbol.getName(), ((IMethodSymbol)this._curMemberSymbol).getSignature());
        }
        Object objectSymbol = null;
        objectSymbol = this._curMemberSymbol == null ? this._rootSymbol : (IObjectSymbol)this._curMemberSymbol;
        ITypeDescriptor typeDesc = objectSymbol.getTypeDescriptor();
        int assignability = 0;
        assignability |= objectSymbol.isReadable() ? 2 : 0;
        int n = objectSymbol.isWritable() ? 1 : 0;
        String typeDescString = typeDesc.getTypeSignature();
        String[] superTypes = (String[])typeDesc.getSuperTypeSignatures().toArray((Object[])new String[0]);
        String[] interfaceTypes = (String[])typeDesc.getInterfaceTypeSignatures().toArray((Object[])new String[0]);
        return new ValueType(typeDescString, superTypes, interfaceTypes, assignability |= n);
    }

    private boolean isValidMemberOfRoot(String name) {
        if (this._rootSymbol == null || name == null || "".equals(name)) {
            return false;
        }
        return this.getMemberSymbol((IObjectSymbol)this._rootSymbol, name) != null;
    }

    private ISymbol getMemberSymbol(IObjectSymbol symbol, String name) {
        ISymbol memberSymbol = this.getPropertySymbol((ISymbol)symbol, name);
        if (memberSymbol != null) {
            return memberSymbol;
        }
        memberSymbol = this.getMethodSymbol(symbol, name);
        if (memberSymbol != null) {
            return memberSymbol;
        }
        return null;
    }

    private ISymbol getPropertySymbol(ISymbol symbol, String name) {
        DesignTimeApplicationManager dtAppMgr = DesignTimeApplicationManager.getInstance((IProject)this._project);
        AbstractDTPropertyResolver resolver = dtAppMgr.getPropertyResolver();
        if (resolver != null) {
            return resolver.getProperty(symbol, (Object)name);
        }
        Activator.log("Error acquiring property resolver", new Throwable());
        return null;
    }

    private IMethodSymbol getMethodSymbol(IObjectSymbol symbol, String name) {
        DesignTimeApplicationManager dtAppMgr = DesignTimeApplicationManager.getInstance((IProject)this._project);
        AbstractDTMethodResolver resolver = dtAppMgr.getMethodResolver();
        if (resolver != null) {
            return resolver.getMethod(symbol, (Object)name);
        }
        Activator.log("Error acquiring property resolver", new Throwable());
        return null;
    }
}

