/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.tests.dbdefinition;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.TestCase;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;
import org.eclipse.wst.rdb.internal.models.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.wst.rdb.internal.models.sql.datatypes.DataType;
import org.eclipse.wst.rdb.internal.models.sql.datatypes.PredefinedDataType;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;

public class DatabaseDefinitionGenericTest
extends TestCase {
    private final String PACKAGE_NAME = "org.eclipse.wst.rdb.internal.core.definition";
    private final String FILE_NAME = "DatabaseDefinition.java";
    private DatabaseDefinition definition = null;
    private Iterator product = null;
    private Iterator productVersion = null;
    private ArrayList definitionCollection = new ArrayList();
    private ArrayList dbInformationCollection = new ArrayList();
    private String strProduct = null;
    private String strProductVersion = null;
    private String strException = null;
    private Iterator dataType;
    private PredefinedDataTypeDefinition typeDefinition = null;
    private DataType type = null;
    private PredefinedDataType predefDataType = null;

    public void setUp() {
        try {
            this.product = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getProducts();
            DatabaseDefinitionGenericTest.assertNotNull((String)"\nMethod: getProducts()\nError: The method returns a NULL value in startUp()!", (Object)this.product);
            while (this.product.hasNext()) {
                this.strProduct = this.product.next().toString();
                this.productVersion = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getVersions(this.strProduct);
                DatabaseDefinitionGenericTest.assertNotNull((String)"\nMethod: getVersions()\nError: The method returns a NULL value in startUp()", (Object)this.productVersion);
                while (this.productVersion.hasNext()) {
                    this.strProductVersion = this.productVersion.next().toString();
                    this.definition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.strProduct, this.strProductVersion);
                    DatabaseDefinitionGenericTest.assertNotNull((String)"\nMethod: getDefinition()\nError: The method returns a NULL value in startUp()", (Object)this.definition);
                    this.dbInformationCollection.add(this.strProduct);
                    this.dbInformationCollection.add(this.strProductVersion);
                    this.definitionCollection.add(this.definition);
                }
            }
        }
        catch (Exception e) {
            DatabaseDefinitionGenericTest.fail((String)("\nMethod: setUp()\nException: " + e.toString() + "\nDescription: The set up is incomplete"));
        }
    }

    public void testGetProduct() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                DatabaseDefinitionGenericTest.assertNotNull((String)this.getAssertionFailureMessage("getProduct()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1)), (Object)((DatabaseDefinition)this.definitionCollection.get(i)).getProduct());
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("getProduct()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testGetProductDisplayString() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                DatabaseDefinitionGenericTest.assertNotNull((String)this.getAssertionFailureMessage("getProductDisplayString()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1)), (Object)((DatabaseDefinition)this.definitionCollection.get(i)).getProductDisplayString());
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("getProductDisplayString()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testGetVersion() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                DatabaseDefinitionGenericTest.assertNotNull((String)this.getAssertionFailureMessage("getVersion()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1)), (Object)((DatabaseDefinition)this.definitionCollection.get(i)).getVersion());
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("getVersion()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testGetVersionDisplayString() throws IOException {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                DatabaseDefinitionGenericTest.assertNotNull((String)this.getAssertionFailureMessage("getVersionDisplayString()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1)), (Object)((DatabaseDefinition)this.definitionCollection.get(i)).getVersionDisplayString());
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("getVersionDisplayString()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testGetDescription() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).getDescription();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("getDescription()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testGetDataModelElementFactory() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                DatabaseDefinitionGenericTest.assertNotNull((String)this.getAssertionFailureMessage("getDataModelElementFactory()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1)), (Object)((DatabaseDefinition)this.definitionCollection.get(i)).getDataModelElementFactory());
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("getDataModelElementFactory()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testGetPredefinedDataTypes() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                DatabaseDefinitionGenericTest.assertNotNull((String)this.getAssertionFailureMessage("getPredefinedDataTypes()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1)), (Object)((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes());
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("getPredefinedDataTypes()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testGetSequenceSupportedPredefinedDataTypes() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                DatabaseDefinitionGenericTest.assertNotNull((String)this.getAssertionFailureMessage("getSequenceSupportedPredefinedDataTypes()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1)), (Object)((DatabaseDefinition)this.definitionCollection.get(i)).getSequenceSupportedPredefinedDataTypes());
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("getSequenceSupportedPredefinedDataTypes()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testGetIdentityColumnSupportedPredefinedDataTypes() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                DatabaseDefinitionGenericTest.assertNotNull((String)this.getAssertionFailureMessage("getIdentityColumnSupportedPredefinedDataTypes()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1)), (Object)((DatabaseDefinition)this.definitionCollection.get(i)).getIdentityColumnSupportedPredefinedDataTypes());
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("getIdentityColumnSupportedPredefinedDataTypes()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testSupportsSchema() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).supportsSchema();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("supportsSchema()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testSupportsIdentityColumns() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).supportsIdentityColumns();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("supportsIdentityColumns()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testSupportsComputedColumns() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).supportsComputedColumns();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("supportsComputedColumns()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testSupportsSequence() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).supportsSequence();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("supportsSequence()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testSupportsPackage() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).supportsPackage();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("supportsPackage()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testSupportsMQT() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).supportsMQT();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("supportsMQT()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testSupportsMQTIndex() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).supportsMQTIndex();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("supportsMQTIndex()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testSupportsDeferrableConstraints() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).supportsDeferrableConstraints();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("supportsDeferrableConstraints()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testSupportsInformationalConstraints() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).supportsInformationalConstraints();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("supportsInformationalConstraints()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testSupportsClusteredIndexes() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).supportsClusteredIndexes();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("supportsClusteredIndexes()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testIsUniqueKeyNullable() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).isUniqueKeyNullable();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("isUniqueKeyNullable()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testGetParentDeleteDRIRules() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                DatabaseDefinitionGenericTest.assertNotNull((String)this.getAssertionFailureMessage("getParentDeleteDRIRules()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1)), (Object)((DatabaseDefinition)this.definitionCollection.get(i)).getParentDeleteDRIRules());
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("getParentDeleteDRIRules()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testGetParentUpdateDRIRules() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                DatabaseDefinitionGenericTest.assertNotNull((String)this.getAssertionFailureMessage("getParentUpdateDRIRules()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1)), (Object)((DatabaseDefinition)this.definitionCollection.get(i)).getParentUpdateDRIRules());
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("getParentUpdateDRIRules()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testSupportsConstraints() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).supportsConstraints();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("supportsConstraints()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testQueryMaxCommentLength() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).queryMaxCommentLength();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("queryMaxCommentLength()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testQueryMaxIdentifierLength() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).queryMaxIdentifierLength();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("queryMaxIdentifierLength()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testQueryMaxCheckExpression() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).queryMaxCheckExpression();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("queryMaxCheckExpression()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testQueryTriggerMaxReferencePartLength() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).queryTriggerMaxReferencePartLength();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("queryTriggerMaxReferencePartLength()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testQueryTriggerMaxActionBodyLength() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).queryTriggerMaxActionBodyLength();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("queryTriggerMaxActionBodyLength()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testQueryStoredProcedureMaxActionBodyLength() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).queryStoredProcedureMaxActionBodyLength();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("queryStoredProcedureMaxActionBodyLength()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testSupportsStoredProcedureNullInputAction() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).supportsStoredProcedureNullInputAction();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("supportsStoredProcedureNullInputAction()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testSupportsNicknames() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).supportsNicknames();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("supportsNicknames()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testSupportsNicknameConstraints() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).supportsNicknameConstraints();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("supportsNicknameConstraints()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testSupportsNicknameIndex() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).supportsNicknameIndex();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("supportsNicknameIndex()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testSupportsQuotedDML() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).supportsQuotedDML();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("supportsQuotedDML()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testSupportsQuotedDDL() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).supportsQuotedDDL();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("supportsQuotedDDL()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testSupportsAlias() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).supportsAlias();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("supportsAlias()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testSupportsSynonym() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).supportsSynonym();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("supportsSynonym()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testSupportsTriggers() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).supportsTriggers();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("supportsTriggers()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testSupportsTriggerTypes() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).supportsTriggerTypes();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("supportsTriggerTypes()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testSupportsInsteadOfTrigger() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).supportsInsteadOfTrigger();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("supportsInsteadOfTrigger()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testSupportsPerColumnUpdateTrigger() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).supportsPerColumnUpdateTrigger();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("supportsPerColumnUpdateTrigger()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testSupportsTriggerReferencesClause() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).supportsTriggerReferencesClause();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("supportsTriggerReferencesClause()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testSupportsRowTriggerReference() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).supportsRowTriggerReference();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("supportsRowTriggerReference()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testSupportsTableTriggerReference() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).supportsTableTriggerReference();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("supportsTableTriggerReference()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testSupportTriggerWhenClause() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).supportTriggerWhenClause();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("supportTriggerWhenClause()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testSupportsTriggerGranularity() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).supportsTriggerGranularity();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("supportsTriggerGranularity()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testSupportsUserDefinedType() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).supportsUserDefinedType();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("supportsUserDefinedType()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testSupportsSnapshotViews() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).supportsSnapshotViews();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("supportsSnapshotViews()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testSupportsViewTriggers() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).supportsViewTriggers();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("supportsViewTriggers()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testIsKeyConstraintSupported() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    this.type = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataType(this.typeDefinition);
                    ((DatabaseDefinition)this.definitionCollection.get(i)).isKeyConstraintSupported(this.type);
                }
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("isKeyConstraintSupported(DataType dataType)", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testGetIdentifierQuoteString() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                DatabaseDefinitionGenericTest.assertNotNull((String)this.getAssertionFailureMessage("getIdentifierQuoteString()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1)), (Object)((DatabaseDefinition)this.definitionCollection.get(i)).getIdentifierQuoteString());
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("getIdentifierQuoteString()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testGetHostVariableMarker() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                DatabaseDefinitionGenericTest.assertNotNull((String)this.getAssertionFailureMessage("getHostVariableMarker()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1)), (Object)((DatabaseDefinition)this.definitionCollection.get(i)).getHostVariableMarker());
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("getHostVariableMarker()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testSupportsHostVariableMarker() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).supportsHostVariableMarker();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("supportsHostVariableMarker()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testSupportsCastExpression() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).supportsCastExpression();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("supportsCastExpression()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testSupportsDefaultKeywordForInsertValue() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).supportsDefaultKeywordForInsertValue();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("supportsDefaultKeywordForInsertValue()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testSupportsExtendedGrouping() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).supportsExtendedGrouping();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("supportsExtendedGrouping()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testSupportsTableAliasInDelete() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).supportsTableAliasInDelete();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("supportsTableAliasInDelete()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testGetProcedureLanguageType() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                DatabaseDefinitionGenericTest.assertNotNull((String)this.getAssertionFailureMessage("getProcedureLanguageType()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1)), (Object)((DatabaseDefinition)this.definitionCollection.get(i)).getProcedureLanguageType());
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("getProcedureLanguageType()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testGetFunctionLanguageType() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                DatabaseDefinitionGenericTest.assertNotNull((String)this.getAssertionFailureMessage("getFunctionLanguageType()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1)), (Object)((DatabaseDefinition)this.definitionCollection.get(i)).getFunctionLanguageType());
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("getFunctionLanguageType()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testSupportsSQLStatement() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).supportsSQLStatement();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("supportsSQLStatement()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testGetSQLKeywords() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                DatabaseDefinitionGenericTest.assertNotNull((String)this.getAssertionFailureMessage("getSQLKeywords()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1)), (Object)((DatabaseDefinition)this.definitionCollection.get(i)).getSQLKeywords());
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("getSQLKeywords()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testGetSQLOperators() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                DatabaseDefinitionGenericTest.assertNotNull((String)this.getAssertionFailureMessage("getSQLOperators()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1)), (Object)((DatabaseDefinition)this.definitionCollection.get(i)).getSQLOperators());
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("getSQLOperators()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testIsSQLKeyword() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).isSQLKeyword("AND");
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("isSQLKeyword(String word)", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testIsSQLOperator() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).isSQLOperator("+");
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("isSQLOperator(String word)", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testGetSQLTerminationCharacter() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                DatabaseDefinitionGenericTest.assertNotNull((String)this.getAssertionFailureMessage("getSQLTerminationCharacter()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1)), (Object)((DatabaseDefinition)this.definitionCollection.get(i)).getSQLTerminationCharacter());
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("getSQLTerminationCharacter()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testGetMaximumIdentifierLength() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).getMaximumIdentifierLength();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("getMaximumIdentifierLength()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testGetMaximumIdentifierLengthBySQLObject() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    this.type = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataType(this.typeDefinition);
                    ((DatabaseDefinition)this.definitionCollection.get(i)).getMaximumIdentifierLength((SQLObject)this.type);
                }
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("getMaximumIdentifierLength(SQLObject sqlObject)", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testGetDatabaseMaximumIdentifierLength() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).getDatabaseMaximumIdentifierLength();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("getDatabaseMaximumIdentifierLength()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testGetSchemaMaximumIdentifierLength() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).getSchemaMaximumIdentifierLength();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("getSchemaMaximumIdentifierLength()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testGetTableMaximumIdentifierLength() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).getTableMaximumIdentifierLength();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("getTableMaximumIdentifierLength()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testGetViewMaximumIdentifierLength() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).getViewMaximumIdentifierLength();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("getViewMaximumIdentifierLength()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testGetColumnMaximumIdentifierLength() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).getColumnMaximumIdentifierLength();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("getColumnMaximumIdentifierLength()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testGetTriggerMaximumIdentifierLength() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).getTriggerMaximumIdentifierLength();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("getTriggerMaximumIdentifierLength()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testGetPrimarykeyIdentifierLength() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).getPrimarykeyIdentifierLength();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("getPrimarykeyIdentifierLength()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testGetForeignKeyMaximumIdentifierLength() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).getForeignKeyMaximumIdentifierLength();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("getForeignKeyMaximumIdentifierLength()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testGetCheckConstraintMaximumIdentifierLength() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).getCheckConstraintMaximumIdentifierLength();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("getCheckConstraintMaximumIdentifierLength()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testGetNicknameMaximumIdentifierLength() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).getNicknameMaximumIdentifierLength();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("getNicknameMaximumIdentifierLength()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testGetUserDefinedTypeMaximumIdentifierLength() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).getUserDefinedTypeMaximumIdentifierLength();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("getUserDefinedTypeMaximumIdentifierLength()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testGetTablespaceMaximumIdentifierLength() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).getTablespaceMaximumIdentifierLength();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("getTablespaceMaximumIdentifierLength()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testGetPredefinedDataTypeDefinitionsByJDBCEnumType() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                DatabaseDefinitionGenericTest.assertNotNull((String)this.getAssertionFailureMessage("getPredefinedDataTypeDefinitionsByJDBCEnumType(int jdbcEnumType)", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1)), (Object)((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypeDefinitionsByJDBCEnumType(1));
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("getPredefinedDataTypeDefinitionsByJDBCEnumType(int jdbcEnumType)", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testGetPredefinedDataTypesByJDBCEnumType() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                DatabaseDefinitionGenericTest.assertNotNull((String)this.getAssertionFailureMessage("getPredefinedDataTypesByJDBCEnumType(int jdbcEnumType)", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1)), (Object)((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypesByJDBCEnumType(1));
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("getPredefinedDataTypesByJDBCEnumType(int jdbcEnumType)", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testGetPredefinedDataType() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                DatabaseDefinitionGenericTest.assertNotNull((String)this.getAssertionFailureMessage("getPredefinedDataType(String dataTypeName)", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1)), (Object)((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataType("int"));
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("getPredefinedDataType(String dataTypeName)", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testGetPredefinedDataTypeDefinition() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                DatabaseDefinitionGenericTest.assertNotNull((String)this.getAssertionFailureMessage("getPredefinedDataTypeDefinition(String dataTypeName)", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1)), (Object)((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypeDefinition("int"));
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("getPredefinedDataTypeDefinition(String dataTypeName)", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testGetPredefinedDataTypeByPredefinedDataTypeDefinition() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    DatabaseDefinitionGenericTest.assertNotNull((String)this.getAssertionFailureMessage("getPredefinedDataType(PredefinedDataTypeDefinition predefinedDataTypeDefinition)", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1)), (Object)((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataType(this.typeDefinition));
                }
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("getPredefinedDataType(PredefinedDataTypeDefinition predefinedDataTypeDefinition)", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testGetPredefinedDataTypeDefinitionByNameAndJDBCEnumType() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypeDefinitionByNameAndJDBCEnumType("int", 1);
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("getPredefinedDataTypeDefinitionByNameAndJDBCEnumType(String dataTypeName, int jdbcEnumType)", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testGetPredefinedDataTypeByNameAndJDBCEnumType() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypeByNameAndJDBCEnumType("int", 1);
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("getPredefinedDataTypeByNameAndJDBCEnumType(String dataTypeName, int jdbcEnumType)", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testGetPredefinedDataTypeFormattedName() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.predefDataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataType("int");
                DatabaseDefinitionGenericTest.assertNotNull((String)this.getAssertionFailureMessage("getPredefinedDataTypeFormattedName(PredefinedDataType predefinedDataType)", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1)), (Object)((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypeFormattedName(this.predefDataType));
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("getPredefinedDataTypeFormattedName(PredefinedDataType predefinedDataType)", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testGetDdlParser() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).getDdlParser();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("getDdlParser()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testGetDatabaseCatalogProvider() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                DatabaseDefinitionGenericTest.assertNotNull((String)this.getAssertionFailureMessage("getDatabaseCatalogProvider()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1)), (Object)((DatabaseDefinition)this.definitionCollection.get(i)).getDatabaseCatalogProvider());
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("getDatabaseCatalogProvider()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testGetDDLGenerator() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                DatabaseDefinitionGenericTest.assertNotNull((String)this.getAssertionFailureMessage("getDDLGenerator()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1)), (Object)((DatabaseDefinition)this.definitionCollection.get(i)).getDDLGenerator());
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("getDDLGenerator()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testGetDeltaDDLGenerator() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                DatabaseDefinitionGenericTest.assertNotNull((String)this.getAssertionFailureMessage("getDeltaDDLGenerator()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1)), (Object)((DatabaseDefinition)this.definitionCollection.get(i)).getDeltaDDLGenerator());
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("getDeltaDDLGenerator()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    public void testSupportsXML() {
        int i = 0;
        int j = 0;
        while (i < this.definitionCollection.size()) {
            try {
                ((DatabaseDefinition)this.definitionCollection.get(i)).supportsXML();
            }
            catch (Exception e) {
                DatabaseDefinitionGenericTest.fail((String)this.getExceptionMessage("supportsXML()", this.dbInformationCollection.get(j), this.dbInformationCollection.get(j + 1), e));
            }
            ++i;
            j += 2;
        }
    }

    private String getAssertionFailureMessage(String methodName, Object productName, Object versionName) {
        return "\nPackage: org.eclipse.wst.rdb.internal.core.definition\nFile: DatabaseDefinition.java\nMethod: " + methodName + "\nProduct: " + productName + "\nVersion: " + versionName + "\nAssertion Failure: The assertion condtion fails in the try block";
    }

    private String getExceptionMessage(String methodName, Object productName, Object versionName, Exception e) {
        return "\nPackage: org.eclipse.wst.rdb.internal.core.definition\nFile: DatabaseDefinition.java\nMethod: " + methodName + "\nProduct: " + productName + "\nVersion: " + versionName + "\nException: " + e.toString() + "\nDescription: The exception is thrown in the test case";
    }

    public void tearDown() {
        this.definition = null;
        this.product = null;
        this.productVersion = null;
        this.definitionCollection = new ArrayList();
        this.dbInformationCollection = new ArrayList();
        this.strProduct = null;
        this.strProductVersion = null;
        this.strException = null;
        this.dataType = null;
        this.typeDefinition = null;
        this.type = null;
        this.predefDataType = null;
    }
}

