/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.asd.design.figures;

import java.util.Iterator;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;

public class ListFigure
extends Figure {
    boolean isOpaque = false;
    boolean isHorizontal = false;
    boolean paintFirstLine = true;

    public ListFigure(boolean isHorizontal) {
        this.isHorizontal = isHorizontal;
    }

    public ListFigure() {
        this(false);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        boolean isFirst = true;
        Iterator i = this.getChildren().iterator();
        while (i.hasNext()) {
            Figure figure = (Figure)i.next();
            if (isFirst && !this.paintFirstLine) {
                isFirst = false;
                continue;
            }
            Rectangle r = figure.getBounds();
            if (this.isHorizontal) {
                graphics.drawLine(r.x, r.y, r.x, r.y + r.height);
                continue;
            }
            graphics.drawLine(r.x, r.y, r.x + r.width, r.y);
        }
    }

    public boolean isOpaque() {
        return this.isOpaque;
    }

    public void setOpaque(boolean isOpaque) {
        this.isOpaque = isOpaque;
    }

    public boolean isPaintFirstLine() {
        return this.paintFirstLine;
    }

    public void setPaintFirstLine(boolean paintFirstLine) {
        this.paintFirstLine = paintFirstLine;
    }
}

