<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet
    version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:output
        method="html"
        indent="yes" />

    <xsl:template match="/">
        <html>
            <body>
                <xsl:apply-templates select="versioningReport" />
            </body>
        </html>
    </xsl:template>

    <xsl:template match="versioningReport">
        <h2>Versioning Report</h2>
        <xsl:apply-templates select="versioningReportData" />
    </xsl:template>



    <xsl:template
        name="errors"
        match="versioningReportData">
        <p>
            For
            <xsl:value-of select="@current" />
            using
            <xsl:value-of select="@id" />
            as the reference.
        </p>
        <h3>Bundles with versioning errors</h3>
        <dl>
            <xsl:for-each select="versioningCompare">
                <xsl:if
                    test="@kind = 'error' and @codePackageType ='bundle'">
                    <dt style="font-weight: bold; color: crimson">
                        <xsl:value-of select="entry" />
                    </dt>
                    <dd style="font-family: monospace;">
                        <xsl:value-of select="current" />
                        (current)
                    </dd>
                    <dd style="font-family: monospace;">
                        <xsl:value-of select="reference" />
                        (reference)
                    </dd>
                </xsl:if>
            </xsl:for-each>
        </dl>
        <h3>Features with versioning errors</h3>
        <dl>
            <xsl:for-each select="versioningCompare">
                <xsl:if
                    test="@kind = 'error' and @codePackageType ='feature'">
                    <dt style="font-weight: bold; color: crimson">
                        <xsl:value-of select="entry" />
                    </dt>
                    <dd style="font-family: monospace;">
                        <xsl:value-of select="current" />
                        (current)
                    </dd>
                    <dd style="font-family: monospace;">
                        <xsl:value-of select="reference" />
                        (reference)
                    </dd>
                </xsl:if>
            </xsl:for-each>
        </dl>
        <h3>Bundles with qualifier-only increases</h3>
        <dl>
            <xsl:for-each select="versioningCompare">
                <xsl:if
                    test="@kind = 'increase' and @field='qualifier' and @codePackageType ='bundle'">
                    <dt style="font-weight: bold; color: gold">
                        <xsl:value-of select="entry" />
                    </dt>
                    <dd style="font-family: monospace">
                        <xsl:value-of select="current" />
                        (current)
                    </dd>
                    <dd style="font-family: monospace">
                        <xsl:value-of select="reference" />
                        (reference)
                    </dd>
                </xsl:if>
            </xsl:for-each>
        </dl>
        <h3>Features with qualifier-only increases</h3>
        <dl>
            <xsl:for-each select="versioningCompare">
                <xsl:if
                    test="@kind = 'increase' and @field='qualifier' and @codePackageType ='features'">
                    <dt style="font-weight: bold; color: gold">
                        <xsl:value-of select="entry" />
                    </dt>
                    <dd style="font-family: monospace">
                        <xsl:value-of select="current" />
                        (current)
                    </dd>
                    <dd style="font-family: monospace">
                        <xsl:value-of select="reference" />
                        (reference)
                    </dd>
                </xsl:if>
            </xsl:for-each>
        </dl>
        <h3>New bundles or features not in reference</h3>
        <ul>
            <xsl:for-each select="versioningCompare">
                <xsl:if test="@kind = 'extraInCurrent'">
                    <ul>
                        <xsl:value-of select="entry" />
                    </ul>
                </xsl:if>
            </xsl:for-each>
        </ul>
        <h3>Bundles or features with major, minor or service increase</h3>
        <ul>
            <xsl:for-each select="versioningCompare">
                <xsl:if test="@kind = 'increase'">
                    <ul>
                        <xsl:value-of select="entry" />
                    </ul>
                </xsl:if>
            </xsl:for-each>
        </ul>
        <h3>Bundles or features with no change</h3>
        <ul>
            <xsl:for-each select="versioningCompare">
                <xsl:if test="@kind = 'noChange'">
                    <ul>
                        <xsl:value-of select="entry" />
                    </ul>
                </xsl:if>
            </xsl:for-each>
        </ul>
    </xsl:template>


</xsl:stylesheet>