/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.context;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDropToFrame;
import org.eclipse.debug.internal.ui.actions.context.StandardActionAdapter;
import org.eclipse.debug.internal.ui.actions.provisional.IAsynchronousDropToFrameAdapter;
import org.eclipse.debug.internal.ui.actions.provisional.IBooleanRequestMonitor;
import org.eclipse.debug.internal.ui.viewers.provisional.IAsynchronousRequestMonitor;
import org.eclipse.debug.ui.IDebugUIConstants;

public class DropToFrameAdapter
extends StandardActionAdapter
implements IAsynchronousDropToFrameAdapter {
    static /* synthetic */ Class class$0;

    public void canDropToFrame(final Object element, final IBooleanRequestMonitor monitor) {
        Job job = new Job("canDropToFrame"){

            protected IStatus run(IProgressMonitor pm) {
                if (!pm.isCanceled()) {
                    IDropToFrame dropToFrame = DropToFrameAdapter.this.getTarget(element);
                    if (dropToFrame != null) {
                        monitor.setResult(dropToFrame.canDropToFrame());
                    } else {
                        monitor.setResult(false);
                    }
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setRule(this.createUpdateSchedulingRule());
        job.schedule();
    }

    public void dropToFrame(final Object element, final IAsynchronousRequestMonitor monitor) {
        Job job = new Job("dropToFrame"){

            protected IStatus run(IProgressMonitor pm) {
                if (!pm.isCanceled()) {
                    IDropToFrame dropToFrame = DropToFrameAdapter.this.getTarget(element);
                    if (dropToFrame != null) {
                        try {
                            dropToFrame.dropToFrame();
                        }
                        catch (DebugException e) {
                            monitor.setStatus(e.getStatus());
                        }
                    } else {
                        monitor.setStatus((IStatus)new Status(4, IDebugUIConstants.PLUGIN_ID, 120, "element must be an instance of or adapt to IDropToFrame", null));
                    }
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private IDropToFrame getTarget(Object element) {
        if (element instanceof IDropToFrame) {
            return (IDropToFrame)element;
        }
        if (element instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IDropToFrame");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IDropToFrame)iAdaptable.getAdapter((Class)clazz);
        }
        return null;
    }
}

