/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.eclipse.pde.internal.build.IXMLConstants;
import org.eclipse.swt.tools.internal.IconExe;

public class BrandingIron
implements IXMLConstants {
    private static final String MARKER_NAME = "%EXECUTABLE_NAME%";
    private static final String BUNDLE_NAME = "%BUNDLE_NAME%";
    private static final String ICON_NAME = "%ICON_NAME%";
    private static final String MARKER_KEY = "<key>CFBundleExecutable</key>";
    private static final String BUNDLE_KEY = "<key>CFBundleName</key>";
    private static final String ICON_KEY = "<key>CFBundleIconFile</key>";
    private static final String STRING_START = "<string>";
    private static final String STRING_END = "</string>";
    private static final String XDOC_ICON = "-Xdock:icon=../Resources/Eclipse.icns";
    private String[] icons = null;
    private String root;
    private String name;
    private String os = "win32";
    private boolean brandIcons = true;

    public void setName(String value) {
        this.name = value;
    }

    public void setIcons(String value) {
        this.icons = value.split(",\\s*");
        if (this.icons[0].startsWith("${")) {
            if (this.icons.length > 1) {
                String[] temp = new String[this.icons.length - 1];
                System.arraycopy(this.icons, 1, temp, 0, temp.length);
                this.icons = temp;
            } else {
                this.icons = null;
            }
        }
    }

    public void setRoot(String value) {
        this.root = value;
    }

    public void brand() throws Exception {
        String testName;
        if (this.name.startsWith("${")) {
            return;
        }
        if (this.icons == null || this.icons[0].startsWith("${")) {
            this.brandIcons = false;
        }
        String string = testName = this.os.equals("win32") ? String.valueOf(this.name) + ".exe" : this.name;
        if (!new File(this.root).exists() || !this.brandIcons && new File(this.root, testName).exists()) {
            return;
        }
        if ("win32".equals(this.os)) {
            this.brandWindows();
        }
        if ("linux".equals(this.os)) {
            this.brandLinux();
        }
        if ("solaris".equals(this.os)) {
            this.brandSolaris();
        }
        if ("macosx".equals(this.os)) {
            this.brandMac();
        }
        if ("aix".equals(this.os)) {
            this.brandAIX();
        }
        if ("hpux".equals(this.os)) {
            this.brandHPUX();
        }
    }

    private void brandAIX() {
        this.renameLauncher();
    }

    private void brandHPUX() {
        this.renameLauncher();
    }

    private void brandLinux() throws Exception {
        this.renameLauncher();
        if (this.brandIcons) {
            this.copy(new File(this.icons[0]), new File(this.root, "icon.xpm"));
        }
    }

    private void brandSolaris() throws Exception {
        this.renameLauncher();
        if (!this.brandIcons) {
            return;
        }
        int i = 0;
        while (i < this.icons.length) {
            String icon = this.icons[i];
            if (icon.endsWith(".l.pm")) {
                this.copy(new File(icon), new File(this.root, String.valueOf(this.name) + ".l.pm"));
            }
            if (icon.endsWith(".m.pm")) {
                this.copy(new File(icon), new File(this.root, String.valueOf(this.name) + ".m.pm"));
            }
            if (icon.endsWith(".s.pm")) {
                this.copy(new File(icon), new File(this.root, String.valueOf(this.name) + ".s.pm"));
            }
            if (icon.endsWith(".t.pm")) {
                this.copy(new File(icon), new File(this.root, String.valueOf(this.name) + ".t.pm"));
            }
            ++i;
        }
    }

    private void brandMac() throws Exception {
        String target = String.valueOf(this.root) + '/' + this.name + ".app/Contents";
        new File(target).mkdirs();
        new File(String.valueOf(target) + "/MacOS").mkdirs();
        new File(String.valueOf(target) + "/Resources").mkdirs();
        String initialRoot = String.valueOf(this.root) + "/Launcher.app/Contents";
        if (!new File(initialRoot).exists()) {
            initialRoot = String.valueOf(this.root) + "/Eclipse.app/Contents";
        }
        this.copyMacLauncher(initialRoot, target);
        String iconName = "";
        File splashApp = new File(initialRoot, "Resources/Splash.app");
        if (this.brandIcons) {
            File icon = new File(this.icons[0]);
            iconName = icon.getName();
            this.copy(icon, new File(String.valueOf(target) + "/Resources/" + icon.getName()));
            new File(String.valueOf(initialRoot) + "/Resources/Eclipse.icns").delete();
            if (!splashApp.exists()) {
                new File(String.valueOf(initialRoot) + "/Resources/").delete();
            }
        }
        this.copyMacIni(initialRoot, target, iconName);
        this.modifyInfoPListFile(initialRoot, target, iconName);
        if (splashApp.exists()) {
            this.brandMacSplash(initialRoot, target, iconName);
        }
        File rootFolder = new File(initialRoot);
        rootFolder.delete();
        if (rootFolder.exists()) {
            this.moveContents(rootFolder, new File(target));
        }
        rootFolder.getParentFile().delete();
    }

    private void brandMacSplash(String initialRoot, String target, String iconName) {
        String splashContents = "/Resources/Splash.app/Contents";
        this.modifyInfoPListFile(String.valueOf(initialRoot) + splashContents, String.valueOf(target) + splashContents, iconName);
        int result = -1;
        String osName = System.getProperty("os.name");
        if (osName != null && !osName.startsWith("Windows")) {
            try {
                String[] command = new String[]{"ln", "-sf", "../../../MacOS/" + this.name, "MacOS/" + this.name};
                File linkDir = new File(target, splashContents);
                Process proc = Runtime.getRuntime().exec(command, null, linkDir);
                result = proc.waitFor();
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {}
        }
        if (result != 0) {
            File macOSDir = new File(target, "MacOS");
            File splashMacOSDir = new File(target, String.valueOf(splashContents) + "/MacOS");
            splashMacOSDir.mkdirs();
            try {
                File targetFile = new File(splashMacOSDir, this.name);
                this.copy(new File(macOSDir, this.name), targetFile);
                try {
                    Runtime.getRuntime().exec(new String[]{"chmod", "755", targetFile.getAbsolutePath()});
                }
                catch (IOException iOException) {}
            }
            catch (IOException iOException) {
                System.out.println("Could not copy macosx splash launcher");
            }
        }
    }

    private void moveContents(File source, File target) {
        if (!source.exists()) {
            return;
        }
        try {
            if (source.getCanonicalFile().equals(target.getCanonicalFile())) {
                return;
            }
        }
        catch (IOException iOException) {
            System.out.println("Could not copy macosx resources.");
            return;
        }
        target.getParentFile().mkdirs();
        if (source.isDirectory()) {
            target.mkdirs();
            File[] contents = source.listFiles();
            int i = 0;
            while (i < contents.length) {
                File dest = new File(target, contents[i].getName());
                if (contents[i].isFile()) {
                    contents[i].renameTo(dest);
                } else {
                    this.moveContents(contents[i], dest);
                }
                ++i;
            }
            source.delete();
        } else {
            source.renameTo(target);
        }
    }

    private void brandWindows() throws Exception {
        File templateLauncher = new File(this.root, "launcher.exe");
        if (!templateLauncher.exists()) {
            templateLauncher = new File(this.root, "eclipse.exe");
        }
        if (this.brandIcons) {
            String[] args = new String[this.icons.length + 1];
            args[0] = templateLauncher.getAbsolutePath();
            System.arraycopy(this.icons, 0, args, 1, this.icons.length);
            IconExe.main(args);
        }
        templateLauncher.renameTo(new File(this.root, String.valueOf(this.name) + ".exe"));
    }

    private void renameLauncher() {
        if (!new File(this.root, "launcher").renameTo(new File(this.root, this.name))) {
            new File(this.root, "eclipse").renameTo(new File(this.root, this.name));
        }
    }

    private void copyMacLauncher(String initialRoot, String target) {
        String targetLauncher = String.valueOf(target) + "/MacOS/";
        File launcher = new File(String.valueOf(initialRoot) + "/MacOS/launcher");
        File eclipseLauncher = new File(String.valueOf(initialRoot) + "/MacOS/eclipse");
        if (!launcher.exists()) {
            launcher = eclipseLauncher;
        } else if (eclipseLauncher.exists()) {
            eclipseLauncher.delete();
        }
        File targetFile = new File(targetLauncher, this.name);
        try {
            if (targetFile.getCanonicalFile().equals(launcher.getCanonicalFile())) {
                try {
                    Runtime.getRuntime().exec(new String[]{"chmod", "755", targetFile.getAbsolutePath()});
                }
                catch (IOException iOException) {}
                return;
            }
            this.copy(launcher, targetFile);
        }
        catch (IOException iOException) {
            System.out.println("Could not copy macosx launcher");
            return;
        }
        try {
            Runtime.getRuntime().exec(new String[]{"chmod", "755", targetFile.getAbsolutePath()});
        }
        catch (IOException iOException) {}
        launcher.delete();
        launcher.getParentFile().delete();
    }

    private void copyMacIni(String initialRoot, String target, String iconName) {
        int xdoc;
        StringBuffer buffer;
        File ini = new File(initialRoot, "/MacOS/eclipse.ini");
        if (!ini.exists()) {
            return;
        }
        try {
            buffer = this.readFile(ini);
            ini.delete();
        }
        catch (IOException iOException) {
            System.out.println("Impossible to brand ini file");
            return;
        }
        if (iconName.length() > 0 && (xdoc = this.scan(buffer, 0, XDOC_ICON)) != -1) {
            String icns = XDOC_ICON.replaceFirst("Eclipse.icns", iconName);
            buffer.replace(xdoc, xdoc + XDOC_ICON.length(), icns);
        }
        try {
            File targetFile = new File(target, "/MacOS/" + this.name + ".ini");
            this.transferStreams(new ByteArrayInputStream(buffer.toString().getBytes()), new FileOutputStream(targetFile));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Impossible to brand ini file");
            return;
        }
        catch (IOException iOException) {
            System.out.println("Impossible to brand ini file");
            return;
        }
    }

    private void modifyInfoPListFile(String initialRoot, String targetRoot, String iconName) {
        StringBuffer buffer;
        File infoPList = new File(initialRoot, "Info.plist");
        try {
            buffer = this.readFile(infoPList);
        }
        catch (IOException iOException) {
            System.out.println("Impossible to brand info.plist file");
            return;
        }
        int exePos = this.scan(buffer, 0, MARKER_NAME);
        if (exePos != -1) {
            buffer.replace(exePos, exePos + MARKER_NAME.length(), this.name);
        } else {
            exePos = this.scan(buffer, 0, MARKER_KEY);
            if (exePos != -1) {
                int start = this.scan(buffer, exePos + MARKER_KEY.length(), STRING_START);
                int end = this.scan(buffer, start + STRING_START.length(), STRING_END);
                if (start > -1 && end > start) {
                    buffer.replace(start + STRING_START.length(), end, this.name);
                }
            }
        }
        int bundlePos = this.scan(buffer, 0, BUNDLE_NAME);
        if (bundlePos != -1) {
            buffer.replace(bundlePos, bundlePos + BUNDLE_NAME.length(), this.name);
        } else {
            exePos = this.scan(buffer, 0, BUNDLE_KEY);
            if (exePos != -1) {
                int start = this.scan(buffer, exePos + BUNDLE_KEY.length(), STRING_START);
                int end = this.scan(buffer, start + STRING_START.length(), STRING_END);
                if (start > -1 && end > start) {
                    buffer.replace(start + STRING_START.length(), end, this.name);
                }
            }
        }
        int iconPos = this.scan(buffer, 0, ICON_NAME);
        if (iconPos != -1) {
            buffer.replace(iconPos, iconPos + ICON_NAME.length(), iconName);
        } else {
            exePos = this.scan(buffer, 0, ICON_KEY);
            if (exePos != -1) {
                int start = this.scan(buffer, exePos + ICON_KEY.length(), STRING_START);
                int end = this.scan(buffer, start + STRING_START.length(), STRING_END);
                if (start > -1 && end > start) {
                    buffer.replace(start + STRING_START.length(), end, iconName);
                }
            }
        }
        File target = null;
        try {
            target = new File(targetRoot, "Info.plist");
            target.getParentFile().mkdirs();
            this.transferStreams(new ByteArrayInputStream(buffer.toString().getBytes()), new FileOutputStream(target));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Impossible to brand info.plist file");
            return;
        }
        catch (IOException iOException) {
            System.out.println("Impossible to brand info.plist file");
            return;
        }
        try {
            if (!infoPList.getCanonicalFile().equals(target.getCanonicalFile())) {
                infoPList.delete();
            }
        }
        catch (IOException iOException) {}
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void copy(File source, File destination) throws IOException {
        in = null;
        out = null;
        try {
            in = new FileInputStream(source);
            out = new FileOutputStream(destination);
            buffer = new byte[8192];
            while (true) {
                bytesRead = -1;
                bytesRead = in.read(buffer);
                if (bytesRead == -1) break;
                out.write(buffer, 0, bytesRead);
            }
            var7_9 = null;
            ** GOTO lbl23
        }
        catch (Throwable var8_7) {
            var7_8 = null;
            try {
                if (in != null) {
                    in.close();
                }
                v0 = null;
                ** GOTO lbl30
lbl23:
                // 1 sources

                ** try [egrp 1[TRYBLOCK] [2 : 77->88)] { 
lbl24:
                // 1 sources

                if (in != null) {
                    in.close();
                }
                v1 = null;
                ** GOTO lbl36
            }
            catch (Throwable var10_10) {
                v0 = null;
lbl30:
                // 2 sources

                var9_12 = v0;
                if (out == null) throw var8_7;
                out.close();
                throw var8_7;
            }
        }
lbl34:
        // 1 sources

        catch (Throwable var10_11) {
            v1 = null;
lbl36:
            // 2 sources

            var9_13 = v1;
            if (out == null) return;
            out.close();
            return;
        }
    }

    private int scan(StringBuffer buf, int start, String targetName) {
        return this.scan(buf, start, new String[]{targetName});
    }

    private int scan(StringBuffer buf, int start, String[] targets) {
        int i = start;
        while (i < buf.length()) {
            int j = 0;
            while (j < targets.length) {
                String match;
                if (i < buf.length() - targets[j].length() && targets[j].equalsIgnoreCase(match = buf.substring(i, i + targets[j].length()))) {
                    return i;
                }
                ++j;
            }
            ++i;
        }
        return -1;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private StringBuffer readFile(File targetName) throws IOException {
        InputStreamReader reader = new InputStreamReader(new BufferedInputStream(new FileInputStream(targetName)));
        StringBuffer result = new StringBuffer();
        char[] buf = new char[4096];
        try {
            int count = reader.read(buf, 0, buf.length);
            while (count != -1) {
                result.append(buf, 0, count);
                count = reader.read(buf, 0, buf.length);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        try {}
        catch (IOException iOException) {
            return result;
        }
        reader.close();
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void transferStreams(InputStream source, OutputStream destination) throws IOException {
        source = new BufferedInputStream(source);
        destination = new BufferedOutputStream(destination);
        try {
            byte[] buffer = new byte[8192];
            while (true) {
                int bytesRead = -1;
                bytesRead = source.read(buffer);
                if (bytesRead != -1) {
                    destination.write(buffer, 0, bytesRead);
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                source.close();
            }
            catch (IOException iOException) {}
            try {
                destination.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        try {}
        catch (IOException iOException) {}
        source.close();
        try {}
        catch (IOException iOException) {
            return;
        }
        destination.close();
    }

    public void setOS(String value) {
        this.os = value;
    }
}

