/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.internal.models.sql.accesscontrol.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.wst.rdb.internal.models.sql.accesscontrol.AuthorizationIdentifier;
import org.eclipse.wst.rdb.internal.models.sql.accesscontrol.SQLAccessControlPackage;
import org.eclipse.wst.rdb.internal.models.sql.accesscontrol.TablePrivilege;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Table Privilege</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.wst.rdb.internal.models.sql.accesscontrol.impl.TablePrivilegeImpl#isWithHierarchy <em>With Hierarchy</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TablePrivilegeImpl extends PrivilegeImpl implements TablePrivilege {
	/**
	 * The default value of the '{@link #isWithHierarchy() <em>With Hierarchy</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isWithHierarchy()
	 * @generated
	 * @ordered
	 */
	protected static final boolean WITH_HIERARCHY_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isWithHierarchy() <em>With Hierarchy</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isWithHierarchy()
	 * @generated
	 * @ordered
	 */
	protected boolean withHierarchy = WITH_HIERARCHY_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TablePrivilegeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return SQLAccessControlPackage.eINSTANCE.getTablePrivilege();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isWithHierarchy() {
		return withHierarchy;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setWithHierarchy(boolean newWithHierarchy) {
		boolean oldWithHierarchy = withHierarchy;
		withHierarchy = newWithHierarchy;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SQLAccessControlPackage.TABLE_PRIVILEGE__WITH_HIERARCHY, oldWithHierarchy, withHierarchy));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case SQLAccessControlPackage.TABLE_PRIVILEGE__EANNOTATIONS:
					return ((InternalEList)getEAnnotations()).basicAdd(otherEnd, msgs);
				case SQLAccessControlPackage.TABLE_PRIVILEGE__COMMENTS:
					return ((InternalEList)getComments()).basicAdd(otherEnd, msgs);
				case SQLAccessControlPackage.TABLE_PRIVILEGE__GRANTOR:
					if (grantor != null)
						msgs = ((InternalEObject)grantor).eInverseRemove(this, SQLAccessControlPackage.AUTHORIZATION_IDENTIFIER__GRANTED_PRIVILEGE, AuthorizationIdentifier.class, msgs);
					return basicSetGrantor((AuthorizationIdentifier)otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case SQLAccessControlPackage.TABLE_PRIVILEGE__EANNOTATIONS:
					return ((InternalEList)getEAnnotations()).basicRemove(otherEnd, msgs);
				case SQLAccessControlPackage.TABLE_PRIVILEGE__DEPENDENCIES:
					return ((InternalEList)getDependencies()).basicRemove(otherEnd, msgs);
				case SQLAccessControlPackage.TABLE_PRIVILEGE__COMMENTS:
					return ((InternalEList)getComments()).basicRemove(otherEnd, msgs);
				case SQLAccessControlPackage.TABLE_PRIVILEGE__GRANTOR:
					return basicSetGrantor(null, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case SQLAccessControlPackage.TABLE_PRIVILEGE__EANNOTATIONS:
				return getEAnnotations();
			case SQLAccessControlPackage.TABLE_PRIVILEGE__NAME:
				return getName();
			case SQLAccessControlPackage.TABLE_PRIVILEGE__DEPENDENCIES:
				return getDependencies();
			case SQLAccessControlPackage.TABLE_PRIVILEGE__DESCRIPTION:
				return getDescription();
			case SQLAccessControlPackage.TABLE_PRIVILEGE__LABEL:
				return getLabel();
			case SQLAccessControlPackage.TABLE_PRIVILEGE__COMMENTS:
				return getComments();
			case SQLAccessControlPackage.TABLE_PRIVILEGE__GRANTABLE:
				return isGrantable() ? Boolean.TRUE : Boolean.FALSE;
			case SQLAccessControlPackage.TABLE_PRIVILEGE__ACTION:
				return getAction();
			case SQLAccessControlPackage.TABLE_PRIVILEGE__GRANTOR:
				if (resolve) return getGrantor();
				return basicGetGrantor();
			case SQLAccessControlPackage.TABLE_PRIVILEGE__OBJECT:
				if (resolve) return getObject();
				return basicGetObject();
			case SQLAccessControlPackage.TABLE_PRIVILEGE__WITH_HIERARCHY:
				return isWithHierarchy() ? Boolean.TRUE : Boolean.FALSE;
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case SQLAccessControlPackage.TABLE_PRIVILEGE__EANNOTATIONS:
				getEAnnotations().clear();
				getEAnnotations().addAll((Collection)newValue);
				return;
			case SQLAccessControlPackage.TABLE_PRIVILEGE__NAME:
				setName((String)newValue);
				return;
			case SQLAccessControlPackage.TABLE_PRIVILEGE__DEPENDENCIES:
				getDependencies().clear();
				getDependencies().addAll((Collection)newValue);
				return;
			case SQLAccessControlPackage.TABLE_PRIVILEGE__DESCRIPTION:
				setDescription((String)newValue);
				return;
			case SQLAccessControlPackage.TABLE_PRIVILEGE__LABEL:
				setLabel((String)newValue);
				return;
			case SQLAccessControlPackage.TABLE_PRIVILEGE__COMMENTS:
				getComments().clear();
				getComments().addAll((Collection)newValue);
				return;
			case SQLAccessControlPackage.TABLE_PRIVILEGE__GRANTABLE:
				setGrantable(((Boolean)newValue).booleanValue());
				return;
			case SQLAccessControlPackage.TABLE_PRIVILEGE__ACTION:
				setAction((String)newValue);
				return;
			case SQLAccessControlPackage.TABLE_PRIVILEGE__GRANTOR:
				setGrantor((AuthorizationIdentifier)newValue);
				return;
			case SQLAccessControlPackage.TABLE_PRIVILEGE__OBJECT:
				setObject((SQLObject)newValue);
				return;
			case SQLAccessControlPackage.TABLE_PRIVILEGE__WITH_HIERARCHY:
				setWithHierarchy(((Boolean)newValue).booleanValue());
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case SQLAccessControlPackage.TABLE_PRIVILEGE__EANNOTATIONS:
				getEAnnotations().clear();
				return;
			case SQLAccessControlPackage.TABLE_PRIVILEGE__NAME:
				setName(NAME_EDEFAULT);
				return;
			case SQLAccessControlPackage.TABLE_PRIVILEGE__DEPENDENCIES:
				getDependencies().clear();
				return;
			case SQLAccessControlPackage.TABLE_PRIVILEGE__DESCRIPTION:
				setDescription(DESCRIPTION_EDEFAULT);
				return;
			case SQLAccessControlPackage.TABLE_PRIVILEGE__LABEL:
				setLabel(LABEL_EDEFAULT);
				return;
			case SQLAccessControlPackage.TABLE_PRIVILEGE__COMMENTS:
				getComments().clear();
				return;
			case SQLAccessControlPackage.TABLE_PRIVILEGE__GRANTABLE:
				setGrantable(GRANTABLE_EDEFAULT);
				return;
			case SQLAccessControlPackage.TABLE_PRIVILEGE__ACTION:
				setAction(ACTION_EDEFAULT);
				return;
			case SQLAccessControlPackage.TABLE_PRIVILEGE__GRANTOR:
				setGrantor((AuthorizationIdentifier)null);
				return;
			case SQLAccessControlPackage.TABLE_PRIVILEGE__OBJECT:
				setObject((SQLObject)null);
				return;
			case SQLAccessControlPackage.TABLE_PRIVILEGE__WITH_HIERARCHY:
				setWithHierarchy(WITH_HIERARCHY_EDEFAULT);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case SQLAccessControlPackage.TABLE_PRIVILEGE__EANNOTATIONS:
				return eAnnotations != null && !eAnnotations.isEmpty();
			case SQLAccessControlPackage.TABLE_PRIVILEGE__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case SQLAccessControlPackage.TABLE_PRIVILEGE__DEPENDENCIES:
				return dependencies != null && !dependencies.isEmpty();
			case SQLAccessControlPackage.TABLE_PRIVILEGE__DESCRIPTION:
				return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
			case SQLAccessControlPackage.TABLE_PRIVILEGE__LABEL:
				return LABEL_EDEFAULT == null ? label != null : !LABEL_EDEFAULT.equals(label);
			case SQLAccessControlPackage.TABLE_PRIVILEGE__COMMENTS:
				return comments != null && !comments.isEmpty();
			case SQLAccessControlPackage.TABLE_PRIVILEGE__GRANTABLE:
				return grantable != GRANTABLE_EDEFAULT;
			case SQLAccessControlPackage.TABLE_PRIVILEGE__ACTION:
				return ACTION_EDEFAULT == null ? action != null : !ACTION_EDEFAULT.equals(action);
			case SQLAccessControlPackage.TABLE_PRIVILEGE__GRANTOR:
				return grantor != null;
			case SQLAccessControlPackage.TABLE_PRIVILEGE__OBJECT:
				return object != null;
			case SQLAccessControlPackage.TABLE_PRIVILEGE__WITH_HIERARCHY:
				return withHierarchy != WITH_HIERARCHY_EDEFAULT;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (withHierarchy: "); //$NON-NLS-1$
		result.append(withHierarchy);
		result.append(')');
		return result.toString();
	}

} //TablePrivilegeImpl
