/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.core.internal.ui.explorer.providers.content.virtual;

import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IConnectionNode;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IGroupIDNode;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;


/**
 * @author ljulien
 */
public class ConnectionNode extends VirtualNode implements IConnectionNode
{
	private static final String TRUE = "true"; //$NON-NLS-1$
	private static final String FALSE = "false"; //$NON-NLS-1$
	private static final String IS_OFFLINE = "isOffline"; //$NON-NLS-1$
	private static final String IS_CONNECTED = "isConnected"; //$NON-NLS-1$
	
	private boolean shouldDisconnect = false;

	private ConnectionInfo connectionInfo;
	private Database database;
	private String userName;
	private String urlString;
	private String databaseVersion;
	private String databaseType;
	private String driverClassName;
	private String loadingPath;
	
	/**
	 * @param name
	 * @param displayName
	 */
	public ConnectionNode(String name, String displayName, Object parent, ConnectionInfo info)
	{
		super(name, displayName, parent);
		this.connectionInfo = info;
	}

	/**
	 * @see org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IConnectionNode#isConnected()
	 */
	public boolean isConnected()
	{
		return this.connectionInfo.getSharedDatabase() != null;
	}

	/**
	 * @see org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IConnectionNode#setConnected(boolean)
	 */
	public void setConnected(boolean isConnected)
	{
		if (!isConnected() && hasChildren())
		{
		    shouldDisconnect = false;
		    getChildren().removeAll(getChildren());
		}
	}

	public boolean testAttribute(Object target, String name, String value)
	{
		if (value.equals(TRUE) && name.equals(IS_CONNECTED) && isConnected() 
		        || value.equals(FALSE) && name.equals(IS_CONNECTED) && !isConnected())
		{
			return true;
		}
		else if (	value.equals(FALSE) && 
		        	name.equals(IS_OFFLINE) && 
		        	this.connectionInfo.getSharedConnection() != null && 
		        	this.connectionInfo.getSharedDatabase() != null)
		{
		    return true;
		}
		else
		{
			return false;
		}
	}

    /**
     * @see org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IConnectionNode#shouldDisconnect()
     */
    public boolean shouldDisconnect()
    {
        return shouldDisconnect;
    }

    /**
     * @see org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IConnectionNode#shouldDisconnect(boolean)
     */
    public void shouldDisconnect(boolean connection)
    {
        shouldDisconnect = connection;
    }

    public ConnectionInfo getConnectionInfo()
    {
        return this.connectionInfo;
    }

    public String getGroupID ()
    {
        return IGroupIDNode.CONNECTION;
    }
}
