/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.context.symbol.internal.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsf.context.symbol.SymbolFactory;
import org.eclipse.jst.jsf.context.symbol.SymbolPackage;
import org.eclipse.jst.jsf.context.symbol.internal.impl.ITypeDescriptorImpl;
import org.eclipse.jst.jsf.context.symbol.internal.provisional.IBeanMethodSymbol;
import org.eclipse.jst.jsf.context.symbol.internal.provisional.IBeanPropertySymbol;
import org.eclipse.jst.jsf.context.symbol.internal.provisional.IJavaTypeDescriptor2;
import org.eclipse.jst.jsf.context.symbol.plugin.SymbolsPlugin;
import org.eclipse.jst.jsf.core.internal.provisional.util.JDTBeanIntrospector;
import org.eclipse.jst.jsf.core.internal.provisional.util.JDTBeanProperty;
import org.eclipse.jst.jsf.core.internal.provisional.util.TypeUtil;

public class IJavaTypeDescriptor2Impl
extends ITypeDescriptorImpl
implements IJavaTypeDescriptor2 {
    public static final String copyright = "Copyright 2006 Oracle";
    protected static final IType TYPE_EDEFAULT = null;
    protected IType type = TYPE_EDEFAULT;

    protected IJavaTypeDescriptor2Impl() {
    }

    protected EClass eStaticClass() {
        return SymbolPackage.Literals.IJAVA_TYPE_DESCRIPTOR2;
    }

    public IType getType() {
        return this.type;
    }

    public void setType(IType newType) {
        IType oldType = this.type;
        this.type = newType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldType, (Object)this.type));
        }
    }

    public EList getInterfaceTypeSignatures() {
        BasicEList interfaces = new BasicEList();
        IType type_ = this.getType();
        if (type_ != null) {
            try {
                ITypeHierarchy hierarchy = type_.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                IType[] interfaceTypes = hierarchy.getAllInterfaces();
                this.copySignatures((List)interfaces, interfaceTypes);
            }
            catch (JavaModelException e) {
                SymbolsPlugin.log(e);
            }
        }
        return interfaces;
    }

    public EList getSuperTypeSignatures() {
        BasicEList interfaces = new BasicEList();
        IType type_ = this.getType();
        if (type_ != null) {
            try {
                ITypeHierarchy hierarchy = type_.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                IType[] interfaceTypes = hierarchy.getAllSuperclasses(type_);
                this.copySignatures((List)interfaces, interfaceTypes);
            }
            catch (JavaModelException e) {
                SymbolsPlugin.log(e);
            }
        }
        return interfaces;
    }

    private void copySignatures(List list, IType[] types) {
        int i = 0;
        while (i < types.length) {
            IType type_ = types[i];
            String signature = TypeUtil.getSignature((IType)type_);
            if (signature != null) {
                list.add(signature);
            }
            ++i;
        }
    }

    public EList getProperties() {
        return this.getBeanProperties();
    }

    public EList getMethods() {
        return this.getBeanMethods();
    }

    public EList getBeanProperties() {
        BasicEList list = new BasicEList();
        list.addAll(this.getPropertiesInternal());
        return list;
    }

    public EList getBeanMethods() {
        BasicEList list = new BasicEList();
        list.addAll(this.getMethodsInternal());
        return list;
    }

    public String getTypeSignature() {
        if (this.getType() == null) {
            if (this.eIsSet(4)) {
                return this.getTypeSignatureDelegate();
            }
            return null;
        }
        return TypeUtil.getSignature((IType)this.getType());
    }

    private Collection getPropertiesInternal() {
        JDTBeanIntrospector introspector = new JDTBeanIntrospector(this.getType());
        Map properties = introspector.getProperties();
        ArrayList<IBeanPropertySymbol> calculatedProps = new ArrayList<IBeanPropertySymbol>(properties.size());
        Iterator it = properties.keySet().iterator();
        while (it.hasNext()) {
            String propertyName = (String)it.next();
            JDTBeanProperty property = (JDTBeanProperty)properties.get(propertyName);
            IBeanPropertySymbol workingCopy = SymbolFactory.eINSTANCE.createIBeanPropertySymbol();
            workingCopy.setName(propertyName);
            workingCopy.setOwner(this);
            IJavaTypeDescriptor2 workingCopyDesc = SymbolFactory.eINSTANCE.createIJavaTypeDescriptor2();
            workingCopy.setTypeDescriptor(workingCopyDesc);
            workingCopy.setReadable(property.isReadable());
            workingCopy.setWritable(property.isWritable());
            String signature = property.getTypeSignature();
            IType newType = property.getType();
            if (newType != null) {
                workingCopyDesc.setType(newType);
            } else {
                workingCopyDesc.setTypeSignatureDelegate(signature);
            }
            calculatedProps.add(workingCopy);
        }
        return calculatedProps;
    }

    private Collection getMethodsInternal() {
        JDTBeanIntrospector introspector = new JDTBeanIntrospector(this.getType());
        IMethod[] methods = introspector.getAllMethods();
        ArrayList<IBeanMethodSymbol> methodSymbols = new ArrayList<IBeanMethodSymbol>();
        int i = 0;
        while (i < methods.length) {
            IMethod method = methods[i];
            try {
                if (!method.isConstructor() && (method.getFlags() & 1) != 0 && (method.getFlags() & 8) == 0) {
                    String methodName = method.getElementName();
                    IBeanMethodSymbol workingCopy = SymbolFactory.eINSTANCE.createIBeanMethodSymbol();
                    workingCopy.setName(methodName);
                    workingCopy.setOwner(this);
                    workingCopy.setSignature(TypeUtil.resolveMethodSignature((IType)this.getType(), (String)method.getSignature()));
                    methodSymbols.add(workingCopy);
                }
            }
            catch (JavaModelException jme) {
                SymbolsPlugin.log(jme);
            }
            ++i;
        }
        return methodSymbols;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 6: {
                return this.getType();
            }
            case 7: {
                return this.getBeanProperties();
            }
            case 8: {
                return this.getBeanMethods();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 6: {
                this.setType((IType)newValue);
                return;
            }
            case 7: {
                this.getBeanProperties().clear();
                this.getBeanProperties().addAll((Collection)newValue);
                return;
            }
            case 8: {
                this.getBeanMethods().clear();
                this.getBeanMethods().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 6: {
                this.setType(TYPE_EDEFAULT);
                return;
            }
            case 7: {
                this.getBeanProperties().clear();
                return;
            }
            case 8: {
                this.getBeanMethods().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 6: {
                return TYPE_EDEFAULT == null ? this.type != null : !TYPE_EDEFAULT.equals(this.type);
            }
            case 7: {
                return !this.getBeanProperties().isEmpty();
            }
            case 8: {
                return !this.getBeanMethods().isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (type: ");
        result.append(this.type);
        result.append(')');
        return result.toString();
    }
}

