/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.context.symbol.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.jst.jsf.context.symbol.internal.provisional.source.AbstractContextSymbolFactory;
import org.eclipse.jst.jsf.context.symbol.internal.provisional.source.ISymbolSourceProvider;
import org.eclipse.jst.jsf.context.symbol.internal.provisional.source.ISymbolSourceProviderFactory;
import org.osgi.framework.Bundle;

public final class SymbolsPlugin
extends EMFPlugin {
    public static final String copyright = "Copyright 2006 Oracle";
    private static List registeredSymbolSourceProviders;
    private static Map registeredSymbolFactories;
    public static final SymbolsPlugin INSTANCE;
    private static Implementation plugin;

    static {
        INSTANCE = new SymbolsPlugin();
    }

    public SymbolsPlugin() {
        super(new ResourceLocator[0]);
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    public static ISymbolSourceProvider[] getSymbolSourceProvider() {
        return registeredSymbolSourceProviders.toArray(new ISymbolSourceProvider[0]);
    }

    public static synchronized List getSymbolSourceProviders() {
        if (registeredSymbolSourceProviders == null) {
            SymbolsPlugin.registerProviders();
            if (registeredSymbolSourceProviders == null) {
                throw new AssertionError((Object)"registerProviders failed");
            }
        }
        return Collections.unmodifiableList(registeredSymbolSourceProviders);
    }

    private static void registerProviders() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(plugin.getBundle().getSymbolicName(), "symbolSourceProvider");
        IExtension[] extensions = point.getExtensions();
        registeredSymbolSourceProviders = new ArrayList(extensions.length);
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            String bundleId = extension.getContributor().getName();
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement element = elements[j];
                if ("symbolSourceId".equals(element.getName()) && element.getAttribute("factory") != null) {
                    String factoryClassName = element.getAttribute("factory");
                    Bundle bundle = Platform.getBundle((String)bundleId);
                    if (bundle != null) {
                        try {
                            Class factoryClass = bundle.loadClass(factoryClassName);
                            ISymbolSourceProviderFactory factory = (ISymbolSourceProviderFactory)factoryClass.newInstance();
                            registeredSymbolSourceProviders.add(factory);
                        }
                        catch (Exception e) {
                            plugin.log(new Status(4, plugin.getBundle().getSymbolicName(), 0, "Error loading symbol provider extension point", (Throwable)e));
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public static synchronized Map getSymbolFactories() {
        if (registeredSymbolFactories == null) {
            SymbolsPlugin.registerSymbolFactories();
            if (registeredSymbolFactories == null) {
                throw new AssertionError((Object)"registerProviders failed");
            }
        }
        return Collections.unmodifiableMap(registeredSymbolFactories);
    }

    private static void registerSymbolFactories() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(plugin.getBundle().getSymbolicName(), "contextSymbolFactory");
        IExtension[] extensions = point.getExtensions();
        registeredSymbolFactories = new HashMap(extensions.length);
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            String bundleId = extension.getContributor().getName();
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement element = elements[j];
                if ("contextSymbolFactory".equals(element.getName()) && element.getAttribute("factory") != null) {
                    String factoryClassName = element.getAttribute("factory");
                    String factoryId = element.getAttribute("factoryId");
                    Bundle bundle = Platform.getBundle((String)bundleId);
                    if (bundle != null) {
                        try {
                            Class factoryClass = bundle.loadClass(factoryClassName);
                            AbstractContextSymbolFactory factory = (AbstractContextSymbolFactory)factoryClass.newInstance();
                            registeredSymbolFactories.put(factoryId, factory);
                        }
                        catch (Exception e) {
                            plugin.log(new Status(4, plugin.getBundle().getSymbolicName(), 0, "Error loading symbol factory extension point", (Throwable)e));
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public static void log(Throwable t) {
        ILog log = SymbolsPlugin.getPlugin().getLog();
        Status status = new Status(4, SymbolsPlugin.getPlugin().getSymbolicName(), 0, "Caught exception", t);
        log.log((IStatus)status);
    }

    public static class Implementation
    extends EMFPlugin.EclipsePlugin {
        public static final String SYMBOL_SOURCE_EXT_ID = "symbolSourceProvider";
        public static final String SYMBOL_FACTORY_EXT_ID = "contextSymbolFactory";

        public Implementation() {
            plugin = this;
        }
    }
}

