/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.jsflibraryconfig;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.J2EEModuleDependencyDelegate;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryConfigPersistData;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryDecorator;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibrary;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibraryRegistry;

public class JSFLibraryConfigModelAdapter {
    private IProject project;
    private JSFLibraryRegistry jsfLibReg;
    private List colJSFImplLib;
    private List colJSFCompLib;
    private JSFLibraryConfigPersistData data;
    private J2EEModuleDependencyDelegate modulesDep;

    public JSFLibraryConfigModelAdapter(IProject project) {
        this.project = project;
        this.jsfLibReg = JSFCorePlugin.getDefault().getJSFLibraryRegistry();
        this.data = new JSFLibraryConfigPersistData(this.project);
        this.modulesDep = new J2EEModuleDependencyDelegate(this.project);
    }

    public void updateProjectDependencies() {
        NullProgressMonitor monitor = new NullProgressMonitor();
        JSFLibraryDecorator newImplLib = this.getSelectedJSFImplLibrary();
        JSFLibraryDecorator preSelectedJSFImplLib = this.getSavedJSFImplementationLibrary();
        if (preSelectedJSFImplLib != null) {
            this.modulesDep.removeProjectDependency(preSelectedJSFImplLib.getLibrary(), (IProgressMonitor)monitor);
            this.modulesDep.addProjectDependency(newImplLib.getLibrary(), newImplLib.isCheckedToBeDeployed(), (IProgressMonitor)monitor);
        } else {
            this.modulesDep.addProjectDependency(newImplLib.getLibrary(), newImplLib.isCheckedToBeDeployed(), (IProgressMonitor)monitor);
        }
        List ComponentLibs = this.getSavedJSFComponentLibraries();
        JSFLibraryDecorator prjJSFCompLib = null;
        JSFLibrary compLib = null;
        int i = 0;
        while (i < ComponentLibs.size()) {
            prjJSFCompLib = (JSFLibraryDecorator)ComponentLibs.get(i);
            compLib = prjJSFCompLib.getLibrary();
            this.modulesDep.removeProjectDependency(compLib, (IProgressMonitor)monitor);
            ++i;
        }
        List SelComponentLibs = this.getSelectedJSFCompLibraries();
        JSFLibraryDecorator jsfCompLibDctr = null;
        int i2 = 0;
        while (i2 < SelComponentLibs.size()) {
            jsfCompLibDctr = (JSFLibraryDecorator)SelComponentLibs.get(i2);
            if (jsfCompLibDctr.isSelected()) {
                this.modulesDep.addProjectDependency(jsfCompLibDctr.getLibrary(), jsfCompLibDctr.isCheckedToBeDeployed(), (IProgressMonitor)monitor);
            }
            ++i2;
        }
    }

    public JSFLibraryDecorator getSavedJSFImplementationLibrary() {
        return this.data.getSavedJSFImplLib();
    }

    public List getSavedJSFComponentLibraries() {
        return this.data.getSavedJSFCompLibs();
    }

    public List getJSFImplementationLibraries() {
        if (this.colJSFImplLib == null) {
            ArrayList<JSFLibraryDecorator> list = new ArrayList<JSFLibraryDecorator>(Collections.EMPTY_LIST);
            JSFLibraryDecorator savedImplLib = this.data.getSavedJSFImplLib();
            if (savedImplLib != null) {
                list.add(savedImplLib);
            }
            this.colJSFImplLib = this.buildJSFLibraryDecoratorList(this.jsfLibReg.getImplJSFLibraries(), list);
        }
        return this.colJSFImplLib;
    }

    public List getJSFComponentLibraries() {
        if (this.colJSFCompLib == null) {
            this.colJSFCompLib = this.buildJSFLibraryDecoratorList(this.jsfLibReg.getNonImplJSFLibraries(), this.data.getSavedJSFCompLibs());
        }
        return this.colJSFCompLib;
    }

    public JSFLibraryDecorator getSelectedJSFImplLibrary() {
        List list = this.getSelectedJSFImplLibs();
        if (list.size() > 0) {
            return (JSFLibraryDecorator)list.get(0);
        }
        return null;
    }

    public List getSelectedJSFCompLibraries() {
        return this.getSelectedJSFCompLibs();
    }

    public void addJSFLibrary(JSFLibraryDecorator jsflib) {
        List list = null;
        list = jsflib.isImplementation() ? this.getJSFImplementationLibraries() : this.getJSFComponentLibraries();
        list.add(jsflib);
    }

    public void updateJSFImplementationLibrary(JSFLibraryDecorator jsflib) {
        if (jsflib != null) {
            Iterator it = this.getJSFImplementationLibraries().iterator();
            JSFLibraryDecorator crtjsflib = null;
            while (it.hasNext()) {
                crtjsflib = (JSFLibraryDecorator)it.next();
                if (crtjsflib.getID().equals(jsflib.getID())) {
                    crtjsflib.setSelected(true);
                    crtjsflib.setToBeDeployed(jsflib.isCheckedToBeDeployed());
                    continue;
                }
                crtjsflib.setSelected(false);
            }
        }
    }

    public void updateJSFComponentLibraries(List complibs) {
        if (complibs != null) {
            this.setJSFLibrariesSelection(this.getJSFComponentLibraries(), false);
            Iterator it = complibs.iterator();
            while (it.hasNext()) {
                JSFLibraryDecorator crtjsflib = (JSFLibraryDecorator)it.next();
                this.setJSFLibStateAsGivenTarget(this.getJSFComponentLibraries(), crtjsflib);
            }
        }
    }

    public void saveData() {
        this.data.saveData(this.getSelectedJSFImplLibs(), this.getSelectedJSFCompLibs());
        this.colJSFImplLib = null;
        this.colJSFCompLib = null;
    }

    public JSFLibraryDecorator getDefaultJSFImplemntationLibrary() {
        return this.data.getDefaultJSFImplLib();
    }

    private List getSelectedJSFImplLibs() {
        ArrayList<JSFLibraryDecorator> list = new ArrayList<JSFLibraryDecorator>(Collections.EMPTY_LIST);
        Iterator it = this.getJSFImplementationLibraries().iterator();
        JSFLibraryDecorator jsflib = null;
        while (it.hasNext()) {
            jsflib = (JSFLibraryDecorator)it.next();
            if (!jsflib.isSelected()) continue;
            list.add(jsflib);
            break;
        }
        return list;
    }

    private List getSelectedJSFCompLibs() {
        ArrayList<JSFLibraryDecorator> list = new ArrayList<JSFLibraryDecorator>(Collections.EMPTY_LIST);
        Iterator it = this.getJSFComponentLibraries().iterator();
        JSFLibraryDecorator jsflib = null;
        while (it.hasNext()) {
            jsflib = (JSFLibraryDecorator)it.next();
            if (!jsflib.isSelected()) continue;
            list.add(jsflib);
        }
        return list;
    }

    private void setJSFLibStateAsGivenTarget(List jsflibs, JSFLibraryDecorator target) {
        Iterator it = jsflibs.iterator();
        JSFLibraryDecorator crtjsflib = null;
        while (it.hasNext()) {
            crtjsflib = (JSFLibraryDecorator)it.next();
            if (!crtjsflib.getID().equals(target.getID())) continue;
            crtjsflib.setSelected(true);
            crtjsflib.setToBeDeployed(target.isCheckedToBeDeployed());
            break;
        }
    }

    private void setJSFLibrariesSelection(List libs, boolean state) {
        Iterator it = libs.iterator();
        while (it.hasNext()) {
            JSFLibraryDecorator crtjsflib = (JSFLibraryDecorator)it.next();
            crtjsflib.setSelected(state);
        }
    }

    private List buildJSFLibraryDecoratorList(EList wsJSFLibs, List pjJSFLibs) {
        ArrayList<JSFLibraryDecorator> list = new ArrayList<JSFLibraryDecorator>(Collections.EMPTY_LIST);
        JSFLibraryDecorator prjJSFLib = null;
        Iterator it = wsJSFLibs.iterator();
        while (it.hasNext()) {
            JSFLibrary jsfLib = (JSFLibrary)it.next();
            Iterator itPrjLibs = pjJSFLibs.iterator();
            boolean selected = false;
            while (itPrjLibs.hasNext()) {
                prjJSFLib = (JSFLibraryDecorator)itPrjLibs.next();
                selected = prjJSFLib.getID().equals(jsfLib.getID());
                if (selected) break;
            }
            JSFLibraryDecorator newPrjJSFLib = selected && prjJSFLib != null ? prjJSFLib : new JSFLibraryDecorator(jsfLib, false, true);
            list.add(newPrjJSFLib);
        }
        return list;
    }
}

