/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.jsflibraryconfig;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.Messages;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryDecorator;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibrary;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibraryRegistry;
import org.eclipse.osgi.util.NLS;

public class JSFLibraryConfigPersistData {
    protected static final String SPTR_TUPLE = ":";
    protected static final String EO_TUPLE = ";";
    private IProject project;
    private JSFLibraryRegistry jsfLibReg;
    private JSFLibraryDecorator dftImplLib = null;
    private JSFLibraryDecorator selJSFLibImpl = null;
    private List selJSFLibComp = null;

    protected JSFLibraryConfigPersistData(IProject project) {
        this.project = project;
        this.jsfLibReg = JSFCorePlugin.getDefault().getJSFLibraryRegistry();
        if (!this.isProjectFirstCreated()) {
            this.VerifySavedLibAvailability();
        }
    }

    protected JSFLibraryDecorator getDefaultJSFImplLib() {
        JSFLibrary jsfLib;
        if (this.dftImplLib == null && this.jsfLibReg != null && (jsfLib = this.jsfLibReg.getDefaultImplementation()) != null) {
            this.dftImplLib = new JSFLibraryDecorator(jsfLib, true, true);
        }
        return this.dftImplLib;
    }

    protected JSFLibraryDecorator getSavedJSFImplLib() {
        try {
            if (!this.isProjectFirstCreated()) {
                if (this.selJSFLibImpl == null) {
                    String strImplLibs = this.project.getPersistentProperty(new QualifiedName("", "jsf.implementation.libraries"));
                    this.selJSFLibImpl = this.getJSFImplLibfromPersistentProperties(this.getTuples(strImplLibs));
                    if (this.selJSFLibImpl == null) {
                        this.selJSFLibImpl = this.getDefaultJSFImplLib();
                    }
                }
            } else {
                this.selJSFLibImpl = this.getDefaultJSFImplLib();
            }
        }
        catch (CoreException e) {
            JSFCorePlugin.getDefault().getMsgLogger().log((Throwable)e);
        }
        return this.selJSFLibImpl;
    }

    protected List getSavedJSFCompLibs() {
        try {
            if (!this.isProjectFirstCreated()) {
                if (this.selJSFLibComp == null) {
                    this.selJSFLibComp = new ArrayList(Collections.EMPTY_LIST);
                    String strCompLibs = this.project.getPersistentProperty(new QualifiedName("", "jsf.component.libraries"));
                    this.getJSFCompLibsfromPersistentProperties(this.getTuples(strCompLibs), this.selJSFLibComp);
                }
            } else {
                this.selJSFLibComp = new ArrayList(Collections.EMPTY_LIST);
            }
        }
        catch (CoreException e) {
            JSFCorePlugin.getDefault().getMsgLogger().log((Throwable)e);
        }
        return this.selJSFLibComp;
    }

    protected void saveData(List selJSFLibImpl, List selJSFLibComp) {
        try {
            this.project.setPersistentProperty(new QualifiedName("", "jsf.implementation.libraries"), this.generatePersistString(selJSFLibImpl));
            this.project.setPersistentProperty(new QualifiedName("", "jsf.component.libraries"), this.generatePersistString(selJSFLibComp));
            this.selJSFLibImpl = null;
            this.selJSFLibComp = null;
        }
        catch (CoreException e) {
            JSFCorePlugin.getDefault().getMsgLogger().log((Throwable)e);
        }
    }

    private boolean isProjectFirstCreated() {
        boolean isNew = false;
        try {
            this.project.getPersistentProperty(new QualifiedName("", "jsf.implementation.libraries"));
        }
        catch (CoreException coreException) {
            isNew = true;
        }
        return isNew;
    }

    private void VerifySavedLibAvailability() {
        try {
            String strImplLibs = this.project.getPersistentProperty(new QualifiedName("", "jsf.implementation.libraries"));
            String strCompLibs = this.project.getPersistentProperty(new QualifiedName("", "jsf.component.libraries"));
            this.logMissingLib(this.getTuples(strImplLibs), true);
            this.logMissingLib(this.getTuples(strCompLibs), false);
        }
        catch (CoreException e) {
            JSFCorePlugin.getDefault().getMsgLogger().log((Throwable)e);
        }
    }

    private void logMissingLib(List jsfLibTuples, boolean isVerifyImpl) {
        if (this.jsfLibReg != null) {
            Iterator itTuple = jsfLibTuples.iterator();
            while (itTuple.hasNext()) {
                Tuple tuple = (Tuple)itTuple.next();
                JSFLibrary jsfLib = this.jsfLibReg.getJSFLibraryByID(tuple.ID);
                if (jsfLib != null) continue;
                String prjName = this.project.getName();
                String msg = isVerifyImpl ? Messages.JSFLibraryConfigPersistData_SAVED_IMPLLIB_NOT_FOUND : Messages.JSFLibraryConfigPersistData_SAVED_COMPLIB_NOT_FOUND;
                JSFCorePlugin.log(1, NLS.bind((String)msg, (Object)prjName));
            }
        }
    }

    private JSFLibraryDecorator getJSFImplLibfromPersistentProperties(List jsfLibTuples) {
        if (this.jsfLibReg != null) {
            Iterator itTuple = jsfLibTuples.iterator();
            while (itTuple.hasNext()) {
                Tuple tuple = (Tuple)itTuple.next();
                JSFLibrary jsfLib = this.jsfLibReg.getJSFLibraryByID(tuple.ID);
                if (jsfLib == null) continue;
                return new JSFLibraryDecorator(jsfLib, tuple.selected, tuple.deploy);
            }
        }
        return null;
    }

    private void getJSFCompLibsfromPersistentProperties(List jsfLibTuples, List JSFCompLibs) {
        if (this.jsfLibReg != null) {
            Iterator itTuple = jsfLibTuples.iterator();
            while (itTuple.hasNext()) {
                Tuple tuple = (Tuple)itTuple.next();
                JSFLibrary jsfLib = this.jsfLibReg.getJSFLibraryByID(tuple.ID);
                if (jsfLib == null) continue;
                JSFLibraryDecorator newJSFLibDcrt = new JSFLibraryDecorator(jsfLib, tuple.selected, tuple.deploy);
                JSFCompLibs.add(newJSFLibDcrt);
            }
        }
    }

    private String generatePersistString(List list) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < list.size()) {
            JSFLibraryDecorator jsfLibItem = (JSFLibraryDecorator)list.get(i);
            sb = sb.append(jsfLibItem.generatePersistString());
            sb.append(EO_TUPLE);
            ++i;
        }
        return sb.toString();
    }

    private List getTuples(String strJSFLibs) {
        ArrayList<Tuple> list = new ArrayList<Tuple>(Collections.EMPTY_LIST);
        if (strJSFLibs != null) {
            String patternStr = EO_TUPLE;
            String[] fields = strJSFLibs.split(patternStr);
            if (strJSFLibs.length() > 0) {
                int i = 0;
                while (i < fields.length) {
                    Tuple tuple = new Tuple(fields[i]);
                    list.add(tuple);
                    ++i;
                }
            }
        }
        return list;
    }

    class Tuple {
        private String ID;
        private boolean selected = false;
        private boolean deploy = true;

        Tuple(String ID, boolean selected, boolean deploy) {
            this.ID = ID;
            this.selected = selected;
            this.deploy = deploy;
        }

        Tuple(String tuple) {
            String[] fields = tuple.split(JSFLibraryConfigPersistData.SPTR_TUPLE);
            this.ID = fields[0];
            this.selected = Boolean.valueOf(fields[1]);
            this.deploy = Boolean.valueOf(fields[2]);
        }

        String getID() {
            return this.ID;
        }

        boolean isSelected() {
            return this.selected;
        }

        boolean needDeploy() {
            return this.deploy;
        }
    }
}

