/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.provisional.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.provisional.util.JDTBeanProperty;
import org.eclipse.jst.jsf.core.internal.provisional.util.TypeUtil;

public class JDTBeanPropertyWorkingCopy
extends JDTBeanProperty {
    private final List _setters = new ArrayList();
    private IMethod _isGetter;

    public JDTBeanPropertyWorkingCopy(IType type) {
        super(type);
    }

    public JDTBeanProperty toValueObject() {
        IMethod getter = this.getIsGetter() != null ? this.getIsGetter() : this.getGetter();
        IMethod matchedSetter = null;
        if (getter != null) {
            matchedSetter = this.determineMatchedSetter(getter);
        } else if (this._setters.size() > 0) {
            matchedSetter = (IMethod)this._setters.get(0);
        }
        JDTBeanProperty beanProp = new JDTBeanProperty(this._type);
        beanProp.setGetter(getter);
        beanProp.setSetter(matchedSetter);
        return beanProp;
    }

    private IMethod determineMatchedSetter(IMethod getter) {
        IMethod matchedSetter = null;
        try {
            String getterSig = TypeUtil.resolveTypeSignature(this._type, getter.getReturnType());
            Iterator it = this._setters.iterator();
            while (it.hasNext()) {
                String paramSig;
                IMethod setter = (IMethod)it.next();
                if (setter.getNumberOfParameters() != 1 || !(paramSig = TypeUtil.resolveTypeSignature(this._type, setter.getParameterTypes()[0])).equals(getterSig)) continue;
                matchedSetter = setter;
                break;
            }
        }
        catch (JavaModelException jme) {
            JSFCorePlugin.log((Exception)((Object)jme), "Error determining getter return type, bean properties analysis may be inaccurate");
        }
        return matchedSetter;
    }

    public void setGetter(IMethod getter) {
        super.setGetter(getter);
    }

    public void setIsGetter(IMethod isGetter) {
        this._isGetter = isGetter;
    }

    public void addSetter(IMethod setter) {
        if (setter != null && setter.getNumberOfParameters() == 1) {
            this._setters.add(setter);
        }
    }

    public final IMethod getSetter() {
        throw new UnsupportedOperationException("Setter not calculated in working copy.  Call toValueObject().getSetter()");
    }

    public IMethod getIsGetter() {
        return this._isGetter;
    }
}

