/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.tests.dbdefinition;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;
import org.eclipse.wst.rdb.internal.models.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.wst.rdb.internal.models.sql.routines.Procedure;
import org.eclipse.wst.rdb.internal.models.sql.routines.SQLRoutinesFactory;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;

public class DerbyTest
extends TestCase {
    private final int MAXIMUM_IDENTIFIER_LENGTH_COLUMN_10 = 30;
    private final int MAXIMUM_IDENTIFIER_LENGTH_DATABASE_10 = 8;
    private final int MAXIMUM_IDENTIFIER_LENGTH_SCHEMA_10 = 30;
    private final int MAXIMUM_IDENTIFIER_LENGTH_STORED_PROCEDURE_10 = 128;
    private final int MAXIMUM_IDENTIFIER_LENGTH_TABLE_10 = 128;
    private final int MAXIMUM_IDENTIFIER_LENGTH_TRIGGER_10 = 18;
    private final int MAXIMUM_IDENTIFIER_LENGTH_VIEW_10 = 128;
    private final int MAXIMUM_LENGTH_BLOB_10 = Integer.MAX_VALUE;
    private final int MAXIMUM_LENGTH_CLOB_10 = Integer.MAX_VALUE;
    private final int MAXIMUM_LENGTH_CHAR_10 = 254;
    private final int MAXIMUM_LENGTH_VARCHAR_10 = 32672;
    private final int MAXIMUM_PRECISION_DECIMAL_10 = 31;
    private final int MAXIMUM_PRECISION_FLOAT_10 = 53;
    private final int MAXIMUM_PRECISION_NUMERIC_10 = 31;
    private final int MAXIMUM_IDENTIFIER_LENGTH_COLUMN_101 = 128;
    private final int MAXIMUM_IDENTIFIER_LENGTH_DATABASE_101 = 128;
    private final int MAXIMUM_IDENTIFIER_LENGTH_SCHEMA_101 = 128;
    private final int MAXIMUM_IDENTIFIER_LENGTH_STORED_PROCEDURE_101 = 128;
    private final int MAXIMUM_IDENTIFIER_LENGTH_TABLE_101 = 128;
    private final int MAXIMUM_IDENTIFIER_LENGTH_TRIGGER_101 = 128;
    private final int MAXIMUM_IDENTIFIER_LENGTH_VIEW_101 = 128;
    private final int MAXIMUM_LENGTH_BLOB_101 = Integer.MAX_VALUE;
    private final int MAXIMUM_LENGTH_CLOB_101 = Integer.MAX_VALUE;
    private final int MAXIMUM_LENGTH_CHAR_101 = 254;
    private final int MAXIMUM_LENGTH_VARCHAR_101 = 32672;
    private final int MAXIMUM_PRECISION_DECIMAL_101 = 31;
    private final int MAXIMUM_PRECISION_FLOAT_101 = 53;
    private final int MAXIMUM_PRECISION_NUMERIC_101 = 31;
    private final String strProduct = "Derby";
    private final String PACKAGE_NAME = "org.eclipse.wst.rdb.internal.models.dbdefinition";
    private int expectedMaxPrecision = 0;
    private int expectedMaxLength = 0;
    private int expectedIdentifierLength = 0;
    private int actualIdentifierLength = 0;
    private Iterator productVersion = null;
    private Iterator dataType;
    private List dataTypeList;
    private ArrayList definitionCollection = new ArrayList();
    private ArrayList dbInformationCollection = new ArrayList();
    private String strProductVersion = null;
    private DatabaseDefinition definition = null;
    private PredefinedDataTypeDefinition typeDefinition = null;
    private Procedure procedure = null;

    public void setUp() {
        try {
            this.productVersion = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getVersions("Derby");
            DerbyTest.assertNotNull((String)"\nMethod: getVersions()\nError: The method returns a NULL value in startUp()", (Object)this.productVersion);
            while (this.productVersion.hasNext()) {
                this.strProductVersion = this.productVersion.next().toString();
                this.definition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition("Derby", this.strProductVersion);
                DerbyTest.assertNotNull((String)"\nMethod: getDefinition()\nError: The method returns a NULL value in startUp()", (Object)this.definition);
                this.dbInformationCollection.add(this.strProductVersion);
                this.definitionCollection.add(this.definition);
            }
        }
        catch (Exception e) {
            DerbyTest.fail((String)("\nMethod: setUp()\nException: " + e.toString() + "\nDescription: The set up is incomplete"));
        }
    }

    public void testGetMaximumPrecision_DECIMAL_10() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("10.0")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxPrecision = 31;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("DECIMAL")) {
                            DerbyTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumPrecision()", this.dbInformationCollection.get(i), "DECIMAL"), (int)this.expectedMaxPrecision, (int)this.typeDefinition.getMaximumPrecision());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                DerbyTest.fail((String)this.getExceptionMessage("getMaximumPrecision()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetMaximumPrecision_NUMERIC_10() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("10.0")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxPrecision = 31;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("NUMERIC")) {
                            DerbyTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumPrecision()", this.dbInformationCollection.get(i), "NUMERIC"), (int)this.expectedMaxPrecision, (int)this.typeDefinition.getMaximumPrecision());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                DerbyTest.fail((String)this.getExceptionMessage("getMaximumPrecision()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetMaximumPrecision_FLOAT_10() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("10.0")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxPrecision = 53;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("FLOAT")) {
                            DerbyTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumPrecision()", this.dbInformationCollection.get(i), "FLOAT"), (int)this.expectedMaxPrecision, (int)this.typeDefinition.getMaximumPrecision());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                DerbyTest.fail((String)this.getExceptionMessage("getMaximumPrecision()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_CHAR_10() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("10.0")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxLength = 254;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("CHAR")) {
                            DerbyTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "CHAR"), (int)this.expectedMaxLength, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                DerbyTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_VARCHAR_10() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("10.0")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxLength = 32672;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("VARCHAR")) {
                            DerbyTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "VARCHAR"), (int)this.expectedMaxLength, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                DerbyTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_CLOB_10() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("10.0")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxLength = Integer.MAX_VALUE;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("CLOB")) {
                            DerbyTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "CLOB"), (int)this.expectedMaxLength, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                DerbyTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_BLOB_10() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("10.0")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxLength = Integer.MAX_VALUE;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("BLOB")) {
                            DerbyTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "BLOB"), (int)this.expectedMaxLength, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                DerbyTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetDatabaseMaximumIdentifierLength_10() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("10.0")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getDatabaseMaximumIdentifierLength();
                    this.expectedIdentifierLength = 8;
                    DerbyTest.assertEquals((String)this.getAssertionFailureMessage("getDatabaseMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                DerbyTest.fail((String)this.getExceptionMessage("getDatabaseMaximumIdentifierLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetSchemaMaximumIdentifierLength_10() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("10.0")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getSchemaMaximumIdentifierLength();
                    this.expectedIdentifierLength = 30;
                    DerbyTest.assertEquals((String)this.getAssertionFailureMessage("getSchemaMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                DerbyTest.fail((String)this.getExceptionMessage("getSchemaMaximumIdentifierLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetTableMaximumIdentifierLength_10() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("10.0")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getTableMaximumIdentifierLength();
                    this.expectedIdentifierLength = 128;
                    DerbyTest.assertEquals((String)this.getAssertionFailureMessage("getTableMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                DerbyTest.fail((String)this.getExceptionMessage("getTableMaximumIdentifierLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetViewMaximumIdentifierLength_10() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("10.0")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getViewMaximumIdentifierLength();
                    this.expectedIdentifierLength = 128;
                    DerbyTest.assertEquals((String)this.getAssertionFailureMessage("getViewMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                DerbyTest.fail((String)this.getExceptionMessage("getViewMaximumIdentifierLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetColumnMaximumIdentifierLength_10() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("10.0")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getColumnMaximumIdentifierLength();
                    this.expectedIdentifierLength = 30;
                    DerbyTest.assertEquals((String)this.getAssertionFailureMessage("getColumnMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                DerbyTest.fail((String)this.getExceptionMessage("getColumnMaximumIdentifierLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetTriggerMaximumIdentifierLength_10() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("10.0")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getTriggerMaximumIdentifierLength();
                    this.expectedIdentifierLength = 18;
                    DerbyTest.assertEquals((String)this.getAssertionFailureMessage("getTriggerMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                DerbyTest.fail((String)this.getExceptionMessage("getTriggerMaximumIdentifierLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetStoredProcedureMaximumIdentifierLength_10() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("10.0")) {
                    this.procedure = SQLRoutinesFactory.eINSTANCE.createProcedure();
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getMaximumIdentifierLength((SQLObject)this.procedure);
                    this.expectedIdentifierLength = 128;
                    DerbyTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumIdentifierLength(SQLObject sqlObject)", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                DerbyTest.fail((String)this.getExceptionMessage("getMaximumIdentifierLength(SQLObject sqlObject)", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetMaximumPrecision_DECIMAL_101() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("10.1")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxPrecision = 31;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("DECIMAL")) {
                            DerbyTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumPrecision()", this.dbInformationCollection.get(i), "DECIMAL"), (int)this.expectedMaxPrecision, (int)this.typeDefinition.getMaximumPrecision());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                DerbyTest.fail((String)this.getExceptionMessage("getMaximumPrecision()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetMaximumPrecision_NUMERIC_101() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("10.1")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxPrecision = 31;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("NUMERIC")) {
                            DerbyTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumPrecision()", this.dbInformationCollection.get(i), "NUMERIC"), (int)this.expectedMaxPrecision, (int)this.typeDefinition.getMaximumPrecision());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                DerbyTest.fail((String)this.getExceptionMessage("getMaximumPrecision()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetMaximumPrecision_FLOAT_101() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("10.1")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxPrecision = 53;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("FLOAT")) {
                            DerbyTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumPrecision()", this.dbInformationCollection.get(i), "FLOAT"), (int)this.expectedMaxPrecision, (int)this.typeDefinition.getMaximumPrecision());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                DerbyTest.fail((String)this.getExceptionMessage("getMaximumPrecision()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_CHAR_101() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("10.1")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxLength = 254;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("CHAR")) {
                            DerbyTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "CHAR"), (int)this.expectedMaxLength, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                DerbyTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_VARCHAR_101() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("10.1")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxLength = 32672;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("VARCHAR")) {
                            DerbyTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "VARCHAR"), (int)this.expectedMaxLength, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                DerbyTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_CLOB_101() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("10.1")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxLength = Integer.MAX_VALUE;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("CLOB")) {
                            DerbyTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "CLOB"), (int)this.expectedMaxLength, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                DerbyTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_BLOB_101() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("10.1")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxLength = Integer.MAX_VALUE;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("BLOB")) {
                            DerbyTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "BLOB"), (int)this.expectedMaxLength, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                DerbyTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetDatabaseMaximumIdentifierLength_101() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("10.1")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getDatabaseMaximumIdentifierLength();
                    this.expectedIdentifierLength = 128;
                    DerbyTest.assertEquals((String)this.getAssertionFailureMessage("getDatabaseMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                DerbyTest.fail((String)this.getExceptionMessage("getDatabaseMaximumIdentifierLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetSchemaMaximumIdentifierLength_101() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("10.1")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getSchemaMaximumIdentifierLength();
                    this.expectedIdentifierLength = 128;
                    DerbyTest.assertEquals((String)this.getAssertionFailureMessage("getSchemaMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                DerbyTest.fail((String)this.getExceptionMessage("getSchemaMaximumIdentifierLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetTableMaximumIdentifierLength_101() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("10.1")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getTableMaximumIdentifierLength();
                    this.expectedIdentifierLength = 128;
                    DerbyTest.assertEquals((String)this.getAssertionFailureMessage("getTableMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                DerbyTest.fail((String)this.getExceptionMessage("getTableMaximumIdentifierLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetViewMaximumIdentifierLength_101() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("10.1")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getViewMaximumIdentifierLength();
                    this.expectedIdentifierLength = 128;
                    DerbyTest.assertEquals((String)this.getAssertionFailureMessage("getViewMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                DerbyTest.fail((String)this.getExceptionMessage("getViewMaximumIdentifierLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetColumnMaximumIdentifierLength_101() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("10.1")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getColumnMaximumIdentifierLength();
                    this.expectedIdentifierLength = 128;
                    DerbyTest.assertEquals((String)this.getAssertionFailureMessage("getColumnMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                DerbyTest.fail((String)this.getExceptionMessage("getColumnMaximumIdentifierLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetTriggerMaximumIdentifierLength_101() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("10.1")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getTriggerMaximumIdentifierLength();
                    this.expectedIdentifierLength = 128;
                    DerbyTest.assertEquals((String)this.getAssertionFailureMessage("getTriggerMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                DerbyTest.fail((String)this.getExceptionMessage("getTriggerMaximumIdentifierLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetStoredProcedureMaximumIdentifierLength_101() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("10.1")) {
                    this.procedure = SQLRoutinesFactory.eINSTANCE.createProcedure();
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getMaximumIdentifierLength((SQLObject)this.procedure);
                    this.expectedIdentifierLength = 128;
                    DerbyTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumIdentifierLength(SQLObject sqlObject)", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                DerbyTest.fail((String)this.getExceptionMessage("getMaximumIdentifierLength(SQLObject sqlObject)", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    private String getAssertionFailureMessage(String methodName, Object versionName, String dataName) {
        String temp = "\nData type: ";
        if (dataName.equals("")) {
            temp = "";
        }
        return "\nPackage: org.eclipse.wst.rdb.internal.models.dbdefinition\nMethod: " + methodName + "\nProduct: " + "Derby" + "\nVersion: " + versionName + temp + dataName + "\nResult: The actual value does not agree with vendor doc. ";
    }

    private String getExceptionMessage(String methodName, Object versionName, Exception e) {
        return "\nMethod: " + methodName + "\nProduct: " + "Derby" + "\nVersion: " + versionName + "\nException: " + e.toString() + "\nDescription: The exception is thrown in the test case";
    }

    public void tearDown() {
        this.expectedMaxPrecision = 0;
        this.expectedMaxLength = 0;
        this.expectedIdentifierLength = 0;
        this.actualIdentifierLength = 0;
        this.productVersion = null;
        this.dataType = null;
        this.dataTypeList = null;
        this.definitionCollection = new ArrayList();
        this.dbInformationCollection = new ArrayList();
        this.strProductVersion = null;
        this.definition = null;
        this.typeDefinition = null;
        this.procedure = null;
    }
}

