/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.Theme;
import org.eclipse.swt.internal.theme.ToolBarDrawData;

public class ToolItemDrawData
extends DrawData {
    public ToolBarDrawData parent;
    static final int ARROW_WIDTH = 8;
    static final int ARROW_HEIGHT = 6;

    public ToolItemDrawData() {
        this.state = new int[2];
    }

    Rectangle computeTrim(Theme theme, GC gc) {
        int buttonHandle = theme.buttonHandle;
        int gtkStyle = OS.gtk_widget_get_style(buttonHandle);
        int focus_width = theme.getWidgetProperty(buttonHandle, "focus-line-width");
        int focus_padding = theme.getWidgetProperty(buttonHandle, "focus-padding");
        int xthickness = OS.gtk_style_get_xthickness(gtkStyle);
        int ythickness = OS.gtk_style_get_ythickness(gtkStyle);
        int borderX = xthickness + focus_width + focus_padding;
        int borderY = ythickness + focus_width + focus_padding;
        int x = this.clientArea.x - borderX;
        int y = this.clientArea.y - borderY;
        int width = this.clientArea.width + 2 * borderX;
        int height = this.clientArea.height + 2 * borderY;
        if ((this.style & 4) != 0) {
            width += 8;
        }
        return new Rectangle(x, y, width, height);
    }

    void draw(Theme theme, GC gc, Rectangle bounds) {
        int state = this.state[0];
        int drawable = gc.getGCData().drawable;
        if ((this.style & 2) != 0) {
            int state_type = this.getStateType(0);
            int separatorHandle = theme.separatorHandle;
            byte[] detail = Converter.wcsToMbcs(null, "vseparator", true);
            int gtkStyle = OS.gtk_widget_get_style(separatorHandle);
            theme.transferClipping(gc, gtkStyle);
            if ((this.parent.style & 0x200) != 0) {
                OS.gtk_paint_hline(gtkStyle, drawable, state_type, null, separatorHandle, detail, bounds.x, bounds.x + bounds.width, bounds.y + bounds.height / 2);
            } else {
                OS.gtk_paint_vline(gtkStyle, drawable, state_type, null, separatorHandle, detail, bounds.y, bounds.y + bounds.height, bounds.x + bounds.width / 2);
            }
            return;
        }
        int buttonHandle = theme.buttonHandle;
        int gtkStyle = OS.gtk_widget_get_style(buttonHandle);
        theme.transferClipping(gc, gtkStyle);
        int focus_line_width = theme.getWidgetProperty(buttonHandle, "focus-line-width");
        int focus_padding = theme.getWidgetProperty(buttonHandle, "focus-padding");
        int border_width = OS.gtk_container_get_border_width(buttonHandle);
        int x = bounds.x + border_width;
        int y = bounds.y + border_width;
        int width = bounds.width - border_width * 2;
        int height = bounds.height - border_width * 2;
        byte[] detail = null;
        if ((this.style & 0xC) != 0) {
            detail = Converter.wcsToMbcs(null, "button", true);
        } else if ((this.style & 0x30) != 0) {
            detail = Converter.wcsToMbcs(null, "togglebutton", true);
        }
        int[] relief = new int[1];
        int toolbarHandle = theme.toolbarHandle;
        OS.gtk_widget_style_get(toolbarHandle, OS.button_relief, relief, 0);
        int shadow_type = 2;
        if ((state & 0xA) != 0) {
            shadow_type = 1;
        }
        int state_type = this.getStateType(0);
        if (relief[0] != 2 || (state & 0x4A) != 0) {
            OS.gtk_paint_box(gtkStyle, drawable, state_type, shadow_type, null, buttonHandle, detail, x, y, width, height);
        }
        if (this.clientArea != null) {
            this.clientArea.x = bounds.x + border_width;
            this.clientArea.y = bounds.y + border_width;
            this.clientArea.width = bounds.width - 2 * border_width;
            this.clientArea.height = bounds.height - 2 * border_width;
        }
        int xthickness = OS.gtk_style_get_xthickness(gtkStyle);
        int interior_focus = theme.getWidgetProperty(buttonHandle, "interior-focus");
        if ((this.style & 4) != 0) {
            int arrow_width = 8;
            int arrow_height = 6;
            int arrow_x = x + width - arrow_width - xthickness - focus_padding;
            if (interior_focus == 0) {
                arrow_x -= focus_line_width;
            }
            int arrow_y = y + (height - arrow_height) / 2;
            byte[] arrow_detail = Converter.wcsToMbcs(null, "arrow", true);
            OS.gtk_paint_arrow(gtkStyle, drawable, state_type, 0, null, theme.arrowHandle, arrow_detail, 1, true, arrow_x, arrow_y, arrow_width, arrow_height);
            if (this.clientArea != null) {
                this.clientArea.width -= bounds.x + bounds.width - arrow_x;
            }
        }
        if ((state & 4) != 0) {
            int child_displacement_y = theme.getWidgetProperty(buttonHandle, "child-displacement-y");
            int child_displacement_x = theme.getWidgetProperty(buttonHandle, "child-displacement-x");
            int displace_focus = 0;
            if (OS.GTK_VERSION >= OS.VERSION(2, 6, 0)) {
                displace_focus = theme.getWidgetProperty(buttonHandle, "displace-focus");
            }
            if (interior_focus != 0) {
                int ythickness = OS.gtk_style_get_ythickness(gtkStyle);
                x += xthickness + focus_padding;
                y += ythickness + focus_padding;
                width -= 2 * (xthickness + focus_padding);
                height -= 2 * (ythickness + focus_padding);
            } else {
                x -= focus_line_width + focus_padding;
                y -= focus_line_width + focus_padding;
                width += 2 * (focus_line_width + focus_padding);
                height += 2 * (focus_line_width + focus_padding);
            }
            if ((state & 0xA) != 0 && displace_focus != 0) {
                x += child_displacement_x;
                y += child_displacement_y;
            }
            OS.gtk_paint_focus(gtkStyle, drawable, state_type, null, buttonHandle, detail, x, y, width, height);
        }
    }

    int hit(Theme theme, Point position, Rectangle bounds) {
        if (!bounds.contains(position)) {
            return -1;
        }
        if ((this.style & 4) != 0) {
            int buttonHandle = theme.buttonHandle;
            int gtkStyle = OS.gtk_widget_get_style(buttonHandle);
            int xthickness = OS.gtk_style_get_xthickness(gtkStyle);
            int interior_focus = theme.getWidgetProperty(buttonHandle, "interior-focus");
            int focus_line_width = theme.getWidgetProperty(buttonHandle, "focus-line-width");
            int focus_padding = theme.getWidgetProperty(buttonHandle, "focus-padding");
            int arrow_width = 8;
            int arrow_x = bounds.x + bounds.width - arrow_width - xthickness - focus_padding;
            if (interior_focus == 0) {
                arrow_x -= focus_line_width;
            }
            if (arrow_x <= position.x) {
                return 1;
            }
        }
        return 0;
    }
}

