/*******************************************************************************
* Copyright (c) 2000, 2005 IBM Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     IBM Corporation - initial API and implementation
*******************************************************************************/

package org.eclipse.wst.rdb.internal.outputview;

import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

/**
 * This interface defines the methods that an extension must implement to add
 * a org.eclipse.swt.TabItem to the Data Output view TabFolder, along side the
 * standard Messages, Parameters, and Results tabs.  The implementing class is
 * expected to be a subtype of org.eclipse.swt.TabItem.
 */
public interface IAdditionalOutputViewTab {
	/**
	 * Retrieve the tab that is contributed.
	 * @return TabItem that is to be contributed. 
	 */
	TabItem getTab (TabFolder parent);
	
	/**
	 * Clear out the contents associated with the tab
	 */
	void clearContents();

	/**
	 * Refresh the tab, using the current contents
	 */
	void refresh();

	/**
	 * Set new contents for the tab.
	 * @param contents The contents associated with the tab. It is the responsibility of the caller to pass the content expected by the receiver so that the receiver can properly process the content object.
	 */
	void setContents(Object contents);
}
