/*******************************************************************************
 * Copyright (c) 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.javascript.core.internal.jsparser.lexer;

/* This file was generated by SableCC (http://www.sablecc.org/). */

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackReader;

import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.javascript.core.internal.JavaScriptCoreMessages;
import org.eclipse.wst.javascript.core.internal.jsparser.node.EOF;
import org.eclipse.wst.javascript.core.internal.jsparser.node.TBlank;
import org.eclipse.wst.javascript.core.internal.jsparser.node.TCommenttok;
import org.eclipse.wst.javascript.core.internal.jsparser.node.TDecimalLiteral;
import org.eclipse.wst.javascript.core.internal.jsparser.node.TErrorChar;
import org.eclipse.wst.javascript.core.internal.jsparser.node.THexIntegerLiteral;
import org.eclipse.wst.javascript.core.internal.jsparser.node.TIdentifier;
import org.eclipse.wst.javascript.core.internal.jsparser.node.TPunctuator1;
import org.eclipse.wst.javascript.core.internal.jsparser.node.TRegularExpressionLiteral;
import org.eclipse.wst.javascript.core.internal.jsparser.node.TStringLiteral;
import org.eclipse.wst.javascript.core.internal.jsparser.node.TUnterminatedComment;
import org.eclipse.wst.javascript.core.internal.jsparser.node.TUnterminatedStringLiteral;
import org.eclipse.wst.javascript.core.internal.jsparser.node.Token;

public class Lexer implements ILexer {


	/*  {
	 // INITIAL
	 {-1, 10, 0, 0, 0, 0, 0, 5, 7, 9, 5, 5, 7, 5, 5, 5, 5, 5, 5, 5, 5, 3, 3, 5, 5, 5, 5, 5, 5, 9, 5, 10, 5, 5, 9, 9, 5, 5, 5, 5, 0, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 0, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 0, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 7, 6, -1, 9, 9, 9, -1, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 5, 5, 5, 7, 6, -1, 5, 5, 5, 5, 5, 3, -1, 2, 1, 5, -1, 3, -1, -1, -1, -1, 3, 5, 5, 5, 5, 5, -1, 5, 5, 5, 5, 7, 7, 7, -1, -1, -1, 7, 7, 7, -1, -1, -1, -1, -1, 8, -1, 2, 2, 2, 1, -1, 3, -1, -1, -1, -1, 3, 4, 5, 5, 5, 5, -1, -1, -1, -1, -1, -1, -1, -1, 3, 8, 8, 8, -1, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, -1, 2, 2, 2, 2, 2, 2, 2, 1, -1, -1, 3, 5, -1, -1, 7, -1, -1, 7, -1, 1, 1, -1, -1, -1, -1, -1, 9, 7, 9, 7, -1, -1, 8, },

	 };*/

	public static class State {
		public final static State INITIAL = new State(0);

		private int fid;

		private State(int id) {
			this.fid = id;
		}

		public int id() {
			return fid;
		}
	}

	protected Token ftoken;
	protected State state = State.INITIAL;
	private PushbackReader in;
	private int lpoffset;
	private int line;
	private int pos;
	private boolean cr;
	private boolean eof;
	private final StringBuffer text = new StringBuffer();
	private static int[][][][] gotoTable;
	/*  {
	 { // INITIAL
	 {{0, 8, 1}, {9, 9, 2}, {10, 10, 3}, {11, 11, 4}, {12, 12, 5}, {13, 13, 3}, {14, 31, 1}, {32, 32, 6}, {33, 33, 7}, {34, 34, 8}, {35, 35, 1}, {36, 36, 9}, {37, 37, 10}, {38, 38, 11}, {39, 39, 12}, {40, 40, 13}, {41, 41, 14}, {42, 42, 15}, {43, 43, 16}, {44, 44, 17}, {45, 45, 18}, {46, 46, 19}, {47, 47, 20}, {48, 48, 21}, {49, 57, 22}, {58, 58, 23}, {59, 59, 24}, {60, 60, 25}, {61, 61, 26}, {62, 62, 27}, {63, 63, 28}, {64, 64, 1}, {65, 90, 29}, {91, 91, 30}, {92, 92, 31}, {93, 93, 32}, {94, 94, 33}, {95, 95, 34}, {96, 96, 1}, {97, 122, 35}, {123, 123, 36}, {124, 124, 37}, {125, 125, 38}, {126, 126, 39}, {127, 159, 1}, {160, 160, 40}, {161, 169, 1}, {170, 170, 41}, {171, 180, 1}, {181, 181, 42}, {182, 185, 1}, {186, 186, 43}, {187, 191, 1}, {192, 214, 44}, {215, 215, 1}, {216, 246, 45}, {247, 247, 1}, {248, 543, 46}, {544, 545, 1}, {546, 563, 47}, {564, 591, 1}, {592, 685, 48}, {686, 687, 1}, {688, 696, 49}, {697, 698, 1}, {699, 705, 50}, {706, 719, 1}, {720, 721, 51}, {722, 735, 1}, {736, 740, 52}, {741, 749, 1}, {750, 750, 53}, {751, 889, 1}, {890, 890, 54}, {891, 901, 1}, {902, 902, 55}, {903, 903, 1}, {904, 906, 56}, {907, 907, 1}, {908, 908, 57}, {909, 909, 1}, {910, 929, 58}, {930, 930, 1}, {931, 974, 59}, {975, 975, 1}, {976, 983, 60}, {984, 985, 1}, {986, 1011, 61}, {1012, 1023, 1}, {1024, 1153, 62}, {1154, 1163, 1}, {1164, 1220, 63}, {1221, 1222, 1}, {1223, 1224, 64}, {1225, 1226, 1}, {1227, 1228, 65}, {1229, 1231, 1}, {1232, 1269, 66}, {1270, 1271, 1}, {1272, 1273, 67}, {1274, 1328, 1}, {1329, 1366, 68}, {1367, 1368, 1}, {1369, 1369, 69}, {1370, 1376, 1}, {1377, 1415, 70}, {1416, 1487, 1}, {1488, 1514, 71}, {1515, 1519, 1}, {1520, 1522, 72}, {1523, 1568, 1}, {1569, 1594, 73}, {1595, 1599, 1}, {1600, 1610, 74}, {1611, 1648, 1}, {1649, 1747, 75}, {1748, 1748, 1}, {1749, 1749, 76}, {1750, 1764, 1}, {1765, 1766, 77}, {1767, 1785, 1}, {1786, 1788, 78}, {1789, 1807, 1}, {1808, 1808, 79}, {1809, 1809, 1}, {1810, 1836, 80}, {1837, 1919, 1}, {1920, 1957, 81}, {1958, 2308, 1}, {2309, 2361, 82}, {2362, 2364, 1}, {2365, 2365, 83}, {2366, 2383, 1}, {2384, 2384, 84}, {2385, 2391, 1}, {2392, 2401, 85}, {2402, 2436, 1}, {2437, 2444, 86}, {2445, 2446, 1}, {2447, 2448, 87}, {2449, 2450, 1}, {2451, 2472, 88}, {2473, 2473, 1}, {2474, 2480, 89}, {2481, 2481, 1}, {2482, 2482, 90}, {2483, 2485, 1}, {2486, 2489, 91}, {2490, 2523, 1}, {2524, 2525, 92}, {2526, 2526, 1}, {2527, 2529, 93}, {2530, 2543, 1}, {2544, 2545, 94}, {2546, 2564, 1}, {2565, 2570, 95}, {2571, 2574, 1}, {2575, 2576, 96}, {2577, 2578, 1}, {2579, 2600, 97}, {2601, 2601, 1}, {2602, 2608, 98}, {2609, 2609, 1}, {2610, 2611, 99}, {2612, 2612, 1}, {2613, 2614, 100}, {2615, 2615, 1}, {2616, 2617, 101}, {2618, 2648, 1}, {2649, 2652, 102}, {2653, 2653, 1}, {2654, 2654, 103}, {2655, 2673, 1}, {2674, 2676, 104}, {2677, 2692, 1}, {2693, 2699, 105}, {2700, 2700, 1}, {2701, 2701, 106}, {2702, 2702, 1}, {2703, 2705, 107}, {2706, 2706, 1}, {2707, 2728, 108}, {2729, 2729, 1}, {2730, 2736, 109}, {2737, 2737, 1}, {2738, 2739, 110}, {2740, 2740, 1}, {2741, 2745, 111}, {2746, 2748, 1}, {2749, 2749, 112}, {2750, 2767, 1}, {2768, 2768, 113}, {2769, 2783, 1}, {2784, 2784, 114}, {2785, 2820, 1}, {2821, 2828, 115}, {2829, 2830, 1}, {2831, 2832, 116}, {2833, 2834, 1}, {2835, 2856, 117}, {2857, 2857, 1}, {2858, 2864, 118}, {2865, 2865, 1}, {2866, 2867, 119}, {2868, 2869, 1}, {2870, 2873, 120}, {2874, 2876, 1}, {2877, 2877, 121}, {2878, 2907, 1}, {2908, 2909, 122}, {2910, 2910, 1}, {2911, 2913, 123}, {2914, 2948, 1}, {2949, 2954, 124}, {2955, 2957, 1}, {2958, 2960, 125}, {2961, 2961, 1}, {2962, 2965, 126}, {2966, 2968, 1}, {2969, 2970, 127}, {2971, 2971, 1}, {2972, 2972, 128}, {2973, 2973, 1}, {2974, 2975, 129}, {2976, 2978, 1}, {2979, 2980, 130}, {2981, 2983, 1}, {2984, 2986, 131}, {2987, 2989, 1}, {2990, 2997, 132}, {2998, 2998, 1}, {2999, 3001, 133}, {3002, 3076, 1}, {3077, 3084, 134}, {3085, 3085, 1}, {3086, 3088, 135}, {3089, 3089, 1}, {3090, 3112, 136}, {3113, 3113, 1}, {3114, 3123, 137}, {3124, 3124, 1}, {3125, 3129, 138}, {3130, 3167, 1}, {3168, 3169, 139}, {3170, 3204, 1}, {3205, 3212, 140}, {3213, 3213, 1}, {3214, 3216, 141}, {3217, 3217, 1}, {3218, 3240, 142}, {3241, 3241, 1}, {3242, 3251, 143}, {3252, 3252, 1}, {3253, 3257, 144}, {3258, 3293, 1}, {3294, 3294, 145}, {3295, 3295, 1}, {3296, 3297, 146}, {3298, 3332, 1}, {3333, 3340, 147}, {3341, 3341, 1}, {3342, 3344, 148}, {3345, 3345, 1}, {3346, 3368, 149}, {3369, 3369, 1}, {3370, 3385, 150}, {3386, 3423, 1}, {3424, 3425, 151}, {3426, 3460, 1}, {3461, 3478, 152}, {3479, 3481, 1}, {3482, 3505, 153}, {3506, 3506, 1}, {3507, 3515, 154}, {3516, 3516, 1}, {3517, 3517, 155}, {3518, 3519, 1}, {3520, 3526, 156}, {3527, 3584, 1}, {3585, 3632, 157}, {3633, 3633, 1}, {3634, 3635, 158}, {3636, 3647, 1}, {3648, 3654, 159}, {3655, 3712, 1}, {3713, 3714, 160}, {3715, 3715, 1}, {3716, 3716, 161}, {3717, 3718, 1}, {3719, 3720, 162}, {3721, 3721, 1}, {3722, 3722, 163}, {3723, 3724, 1}, {3725, 3725, 164}, {3726, 3731, 1}, {3732, 3735, 165}, {3736, 3736, 1}, {3737, 3743, 166}, {3744, 3744, 1}, {3745, 3747, 167}, {3748, 3748, 1}, {3749, 3749, 168}, {3750, 3750, 1}, {3751, 3751, 169}, {3752, 3753, 1}, {3754, 3755, 170}, {3756, 3756, 1}, {3757, 3760, 171}, {3761, 3761, 1}, {3762, 3763, 172}, {3764, 3772, 1}, {3773, 3780, 173}, {3781, 3781, 1}, {3782, 3782, 174}, {3783, 3803, 1}, {3804, 3805, 175}, {3806, 3839, 1}, {3840, 3840, 176}, {3841, 3903, 1}, {3904, 3946, 177}, {3947, 3975, 1}, {3976, 3979, 178}, {3980, 4095, 1}, {4096, 4129, 179}, {4130, 4130, 1}, {4131, 4135, 180}, {4136, 4136, 1}, {4137, 4138, 181}, {4139, 4175, 1}, {4176, 4181, 182}, {4182, 4255, 1}, {4256, 4293, 183}, {4294, 4303, 1}, {4304, 4342, 184}, {4343, 4351, 1}, {4352, 4441, 185}, {4442, 4446, 1}, {4447, 4514, 186}, {4515, 4519, 1}, {4520, 4601, 187}, {4602, 4607, 1}, {4608, 4614, 188}, {4615, 4615, 1}, {4616, 4678, 189}, {4679, 4679, 1}, {4680, 4680, 190}, {4681, 4681, 1}, {4682, 4685, 191}, {4686, 4687, 1}, {4688, 4694, 192}, {4695, 4695, 1}, {4696, 4696, 193}, {4697, 4697, 1}, {4698, 4701, 194}, {4702, 4703, 1}, {4704, 4742, 195}, {4743, 4743, 1}, {4744, 4744, 196}, {4745, 4745, 1}, {4746, 4749, 197}, {4750, 4751, 1}, {4752, 4782, 198}, {4783, 4783, 1}, {4784, 4784, 199}, {4785, 4785, 1}, {4786, 4789, 200}, {4790, 4791, 1}, {4792, 4798, 201}, {4799, 4799, 1}, {4800, 4800, 202}, {4801, 4801, 1}, {4802, 4805, 203}, {4806, 4807, 1}, {4808, 4814, 204}, {4815, 4815, 1}, {4816, 4822, 205}, {4823, 4823, 1}, {4824, 4846, 206}, {4847, 4847, 1}, {4848, 4878, 207}, {4879, 4879, 1}, {4880, 4880, 208}, {4881, 4881, 1}, {4882, 4885, 209}, {4886, 4887, 1}, {4888, 4894, 210}, {4895, 4895, 1}, {4896, 4934, 211}, {4935, 4935, 1}, {4936, 4954, 212}, {4955, 5023, 1}, {5024, 5040, 213}, {5041, 5108, 214}, {5109, 5120, 1}, {5121, 5750, 215}, {5751, 5759, 1}, {5760, 5760, 216}, {5761, 5786, 217}, {5787, 5791, 1}, {5792, 5866, 218}, {5867, 6015, 1}, {6016, 6067, 219}, {6068, 6175, 1}, {6176, 6263, 220}, {6264, 6271, 1}, {6272, 6312, 221}, {6313, 7679, 1}, {7680, 7835, 222}, {7836, 7839, 1}, {7840, 7904, 223}, {7905, 7929, 224}, {7930, 7935, 1}, {7936, 7957, 225}, {7958, 7959, 1}, {7960, 7965, 226}, {7966, 7967, 1}, {7968, 7993, 227}, {7994, 8005, 228}, {8006, 8007, 1}, {8008, 8013, 229}, {8014, 8015, 1}, {8016, 8023, 230}, {8024, 8024, 1}, {8025, 8025, 231}, {8026, 8026, 1}, {8027, 8027, 232}, {8028, 8028, 1}, {8029, 8029, 233}, {8030, 8030, 1}, {8031, 8061, 234}, {8062, 8063, 1}, {8064, 8116, 235}, {8117, 8117, 1}, {8118, 8124, 236}, {8125, 8125, 1}, {8126, 8126, 237}, {8127, 8129, 1}, {8130, 8132, 238}, {8133, 8133, 1}, {8134, 8140, 239}, {8141, 8143, 1}, {8144, 8147, 240}, {8148, 8149, 1}, {8150, 8155, 241}, {8156, 8159, 1}, {8160, 8172, 242}, {8173, 8177, 1}, {8178, 8180, 243}, {8181, 8181, 1}, {8182, 8188, 244}, {8189, 8191, 1}, {8192, 8192, 245}, {8193, 8193, 246}, {8194, 8194, 247}, {8195, 8195, 248}, {8196, 8196, 249}, {8197, 8197, 250}, {8198, 8198, 251}, {8199, 8199, 252}, {8200, 8200, 253}, {8201, 8201, 254}, {8202, 8202, 255}, {8203, 8203, 256}, {8204, 8231, 1}, {8232, 8233, 3}, {8234, 8238, 1}, {8239, 8239, 257}, {8240, 8318, 1}, {8319, 8319, 258}, {8320, 8449, 1}, {8450, 8450, 259}, {8451, 8454, 1}, {8455, 8455, 260}, {8456, 8457, 1}, {8458, 8467, 261}, {8468, 8468, 1}, {8469, 8469, 262}, {8470, 8472, 1}, {8473, 8477, 263}, {8478, 8483, 1}, {8484, 8484, 264}, {8485, 8485, 1}, {8486, 8486, 265}, {8487, 8487, 1}, {8488, 8488, 266}, {8489, 8489, 1}, {8490, 8493, 267}, {8494, 8494, 1}, {8495, 8497, 268}, {8498, 8498, 1}, {8499, 8505, 269}, {8506, 8543, 1}, {8544, 8579, 270}, {8580, 12287, 1}, {12288, 12288, 271}, {12289, 12292, 1}, {12293, 12295, 272}, {12296, 12320, 1}, {12321, 12329, 273}, {12330, 12336, 1}, {12337, 12341, 274}, {12342, 12343, 1}, {12344, 12346, 275}, {12347, 12352, 1}, {12353, 12436, 276}, {12437, 12444, 1}, {12445, 12446, 277}, {12447, 12448, 1}, {12449, 12538, 278}, {12539, 12539, 1}, {12540, 12542, 279}, {12543, 12548, 1}, {12549, 12588, 280}, {12589, 12592, 1}, {12593, 12686, 281}, {12687, 12703, 1}, {12704, 12727, 282}, {12728, 13311, 1}, {13312, 13312, 283}, {13313, 19892, 1}, {19893, 19893, 284}, {19894, 19967, 1}, {19968, 19968, 285}, {19969, 40868, 1}, {40869, 40869, 286}, {40870, 40959, 1}, {40960, 42124, 287}, {42125, 44031, 1}, {44032, 44032, 288}, {44033, 55202, 1}, {55203, 55203, 289}, {55204, 63743, 1}, {63744, 64045, 290}, {64046, 64255, 1}, {64256, 64262, 291}, {64263, 64274, 1}, {64275, 64279, 292}, {64280, 64284, 1}, {64285, 64285, 293}, {64286, 64286, 1}, {64287, 64296, 294}, {64297, 64297, 1}, {64298, 64310, 295}, {64311, 64311, 1}, {64312, 64316, 296}, {64317, 64317, 1}, {64318, 64318, 297}, {64319, 64319, 1}, {64320, 64321, 298}, {64322, 64322, 1}, {64323, 64324, 299}, {64325, 64325, 1}, {64326, 64433, 300}, {64434, 64466, 1}, {64467, 64829, 301}, {64830, 64847, 1}, {64848, 64911, 302}, {64912, 64913, 1}, {64914, 64967, 303}, {64968, 65007, 1}, {65008, 65019, 304}, {65020, 65135, 1}, {65136, 65138, 305}, {65139, 65139, 1}, {65140, 65140, 306}, {65141, 65141, 1}, {65142, 65276, 307}, {65277, 65312, 1}, {65313, 65338, 308}, {65339, 65344, 1}, {65345, 65370, 309}, {65371, 65381, 1}, {65382, 65470, 310}, {65471, 65473, 1}, {65474, 65479, 311}, {65480, 65481, 1}, {65482, 65487, 312}, {65488, 65489, 1}, {65490, 65495, 313}, {65496, 65497, 1}, {65498, 65500, 314}, {65501, 65535, 1}, },
	 {},
	 {{9, 9, 315}, {10, 10, 316}, {11, 11, 317}, {12, 12, 318}, {13, 13, 316}, {32, 32, 319}, {160, 160, 320}, {5760, 5760, 321}, {8192, 8192, 322}, {8193, 8193, 323}, {8194, 8194, 324}, {8195, 8195, 325}, {8196, 8196, 326}, {8197, 8197, 327}, {8198, 8198, 328}, {8199, 8199, 329}, {8200, 8200, 330}, {8201, 8201, 331}, {8202, 8202, 332}, {8203, 8203, 333}, {8232, 8233, 316}, {8239, 8239, 334}, {12288, 12288, 335}, },
	 {{9, 12288, -4}, },
	 {{9, 12288, -4}, },
	 {{9, 12288, -4}, },
	 {{9, 12288, -4}, },
	 {{61, 61, 336}, },
	 {{0, 9, 337}, {11, 12, 337}, {14, 33, 337}, {34, 34, 338}, {35, 91, 337}, {92, 92, 339}, {93, 8231, 337}, {8234, 65535, 337}, },
	 {{36, 36, 340}, {48, 57, 341}, {65, 90, 342}, {92, 92, 343}, {95, 95, 344}, {97, 122, 345}, {170, 170, 346}, {181, 181, 347}, {186, 186, 348}, {192, 214, 349}, {216, 246, 350}, {248, 543, 351}, {546, 563, 352}, {592, 685, 353}, {688, 696, 354}, {699, 705, 355}, {720, 721, 356}, {736, 740, 357}, {750, 750, 358}, {768, 846, 359}, {864, 866, 360}, {890, 890, 361}, {902, 902, 362}, {904, 906, 363}, {908, 908, 364}, {910, 929, 365}, {931, 974, 366}, {976, 983, 367}, {986, 1011, 368}, {1024, 1153, 369}, {1155, 1158, 370}, {1164, 1220, 371}, {1223, 1224, 372}, {1227, 1228, 373}, {1232, 1269, 374}, {1272, 1273, 375}, {1329, 1366, 376}, {1369, 1369, 377}, {1377, 1415, 378}, {1425, 1441, 379}, {1443, 1465, 380}, {1467, 1469, 381}, {1471, 1471, 382}, {1473, 1474, 383}, {1476, 1476, 384}, {1488, 1514, 385}, {1520, 1522, 386}, {1569, 1594, 387}, {1600, 1610, 388}, {1611, 1621, 389}, {1632, 1641, 390}, {1648, 1648, 391}, {1649, 1747, 392}, {1749, 1749, 393}, {1750, 1756, 394}, {1759, 1764, 395}, {1765, 1766, 396}, {1767, 1768, 397}, {1770, 1773, 398}, {1776, 1785, 399}, {1786, 1788, 400}, {1808, 1808, 401}, {1809, 1809, 402}, {1810, 1836, 403}, {1840, 1866, 404}, {1920, 1957, 405}, {1958, 1968, 406}, {2305, 2307, 407}, {2309, 2361, 408}, {2364, 2364, 409}, {2365, 2365, 410}, {2366, 2381, 411}, {2384, 2384, 412}, {2385, 2388, 413}, {2392, 2401, 414}, {2402, 2403, 415}, {2406, 2415, 416}, {2433, 2435, 417}, {2437, 2444, 418}, {2447, 2448, 419}, {2451, 2472, 420}, {2474, 2480, 421}, {2482, 2482, 422}, {2486, 2489, 423}, {2492, 2500, 424}, {2503, 2504, 425}, {2507, 2509, 426}, {2519, 2519, 427}, {2524, 2525, 428}, {2527, 2529, 429}, {2530, 2531, 430}, {2534, 2543, 431}, {2544, 2545, 432}, {2562, 2562, 433}, {2565, 2570, 434}, {2575, 2576, 435}, {2579, 2600, 436}, {2602, 2608, 437}, {2610, 2611, 438}, {2613, 2614, 439}, {2616, 2617, 440}, {2620, 2620, 441}, {2622, 2626, 442}, {2631, 2632, 443}, {2635, 2637, 444}, {2649, 2652, 445}, {2654, 2654, 446}, {2662, 2671, 447}, {2672, 2673, 448}, {2674, 2676, 449}, {2689, 2691, 450}, {2693, 2699, 451}, {2701, 2701, 452}, {2703, 2705, 453}, {2707, 2728, 454}, {2730, 2736, 455}, {2738, 2739, 456}, {2741, 2745, 457}, {2748, 2748, 458}, {2749, 2749, 459}, {2750, 2757, 460}, {2759, 2761, 461}, {2763, 2765, 462}, {2768, 2768, 463}, {2784, 2784, 464}, {2790, 2799, 465}, {2817, 2819, 466}, {2821, 2828, 467}, {2831, 2832, 468}, {2835, 2856, 469}, {2858, 2864, 470}, {2866, 2867, 471}, {2870, 2873, 472}, {2876, 2876, 473}, {2877, 2877, 474}, {2878, 2883, 475}, {2887, 2888, 476}, {2891, 2893, 477}, {2902, 2903, 478}, {2908, 2909, 479}, {2911, 2913, 480}, {2918, 2927, 481}, {2946, 2947, 482}, {2949, 2954, 483}, {2958, 2960, 484}, {2962, 2965, 485}, {2969, 2970, 486}, {2972, 2972, 487}, {2974, 2975, 488}, {2979, 2980, 489}, {2984, 2986, 490}, {2990, 2997, 491}, {2999, 3001, 492}, {3006, 3010, 493}, {3014, 3016, 494}, {3018, 3021, 495}, {3031, 3031, 496}, {3047, 3055, 497}, {3073, 3075, 498}, {3077, 3084, 499}, {3086, 3088, 500}, {3090, 3112, 501}, {3114, 3123, 502}, {3125, 3129, 503}, {3134, 3140, 504}, {3142, 3144, 505}, {3146, 3149, 506}, {3157, 3158, 507}, {3168, 3169, 508}, {3174, 3183, 509}, {3202, 3203, 510}, {3205, 3212, 511}, {3214, 3216, 512}, {3218, 3240, 513}, {3242, 3251, 514}, {3253, 3257, 515}, {3262, 3268, 516}, {3270, 3272, 517}, {3274, 3277, 518}, {3285, 3286, 519}, {3294, 3294, 520}, {3296, 3297, 521}, {3302, 3311, 522}, {3330, 3331, 523}, {3333, 3340, 524}, {3342, 3344, 525}, {3346, 3368, 526}, {3370, 3385, 527}, {3390, 3395, 528}, {3398, 3400, 529}, {3402, 3405, 530}, {3415, 3415, 531}, {3424, 3425, 532}, {3430, 3439, 533}, {3458, 3459, 534}, {3461, 3478, 535}, {3482, 3505, 536}, {3507, 3515, 537}, {3517, 3517, 538}, {3520, 3526, 539}, {3530, 3530, 540}, {3535, 3540, 541}, {3542, 3542, 542}, {3544, 3551, 543}, {3570, 3571, 544}, {3585, 3632, 545}, {3633, 3633, 546}, {3634, 3635, 547}, {3636, 3642, 548}, {3648, 3654, 549}, {3655, 3662, 550}, {3664, 3673, 551}, {3713, 3714, 552}, {3716, 3716, 553}, {3719, 3720, 554}, {3722, 3722, 555}, {3725, 3725, 556}, {3732, 3735, 557}, {3737, 3743, 558}, {3745, 3747, 559}, {3749, 3749, 560}, {3751, 3751, 561}, {3754, 3755, 562}, {3757, 3760, 563}, {3761, 3761, 564}, {3762, 3763, 565}, {3764, 3769, 566}, {3771, 3772, 567}, {3773, 3780, 568}, {3782, 3782, 569}, {3784, 3789, 570}, {3792, 3801, 571}, {3804, 3805, 572}, {3840, 3840, 573}, {3864, 3865, 574}, {3872, 3881, 575}, {3893, 3893, 576}, {3895, 3895, 577}, {3897, 3897, 578}, {3902, 3903, 579}, {3904, 3946, 580}, {3953, 3972, 581}, {3974, 3975, 582}, {3976, 3979, 583}, {3984, 3991, 584}, {3993, 4028, 585}, {4038, 4038, 586}, {4096, 4129, 587}, {4131, 4135, 588}, {4137, 4138, 589}, {4140, 4146, 590}, {4150, 4153, 591}, {4160, 4169, 592}, {4176, 4181, 593}, {4182, 4185, 594}, {4256, 4293, 595}, {4304, 4342, 596}, {4352, 4441, 597}, {4447, 4514, 598}, {4520, 4601, 599}, {4608, 4614, 600}, {4616, 4678, 601}, {4680, 4680, 602}, {4682, 4685, 603}, {4688, 4694, 604}, {4696, 4696, 605}, {4698, 4701, 606}, {4704, 4742, 607}, {4744, 4744, 608}, {4746, 4749, 609}, {4752, 4782, 610}, {4784, 4784, 611}, {4786, 4789, 612}, {4792, 4798, 613}, {4800, 4800, 614}, {4802, 4805, 615}, {4808, 4814, 616}, {4816, 4822, 617}, {4824, 4846, 618}, {4848, 4878, 619}, {4880, 4880, 620}, {4882, 4885, 621}, {4888, 4894, 622}, {4896, 4934, 623}, {4936, 4954, 624}, {4969, 4977, 625}, {5024, 5040, 626}, {5041, 5108, 627}, {5121, 5750, 628}, {5761, 5786, 629}, {5792, 5866, 630}, {6016, 6067, 631}, {6068, 6099, 632}, {6112, 6121, 633}, {6160, 6169, 634}, {6176, 6263, 635}, {6272, 6312, 636}, {6313, 6313, 637}, {7680, 7835, 638}, {7840, 7904, 639}, {7905, 7929, 640}, {7936, 7957, 641}, {7960, 7965, 642}, {7968, 7993, 643}, {7994, 8005, 644}, {8008, 8013, 645}, {8016, 8023, 646}, {8025, 8025, 647}, {8027, 8027, 648}, {8029, 8029, 649}, {8031, 8061, 650}, {8064, 8116, 651}, {8118, 8124, 652}, {8126, 8126, 653}, {8130, 8132, 654}, {8134, 8140, 655}, {8144, 8147, 656}, {8150, 8155, 657}, {8160, 8172, 658}, {8178, 8180, 659}, {8182, 8188, 660}, {8255, 8256, 661}, {8319, 8319, 662}, {8400, 8412, 663}, {8417, 8417, 664}, {8450, 8450, 665}, {8455, 8455, 666}, {8458, 8467, 667}, {8469, 8469, 668}, {8473, 8477, 669}, {8484, 8484, 670}, {8486, 8486, 671}, {8488, 8488, 672}, {8490, 8493, 673}, {8495, 8497, 674}, {8499, 8505, 675}, {8544, 8579, 676}, {12293, 12295, 677}, {12321, 12329, 678}, {12330, 12335, 679}, {12337, 12341, 680}, {12344, 12346, 681}, {12353, 12436, 682}, {12441, 12442, 683}, {12445, 12446, 684}, {12449, 12538, 685}, {12539, 12539, 686}, {12540, 12542, 687}, {12549, 12588, 688}, {12593, 12686, 689}, {12704, 12727, 690}, {13312, 13312, 691}, {19893, 19893, 692}, {19968, 19968, 693}, {40869, 40869, 694}, {40960, 42124, 695}, {44032, 44032, 696}, {55203, 55203, 697}, {63744, 64045, 698}, {64256, 64262, 699}, {64275, 64279, 700}, {64285, 64285, 701}, {64286, 64286, 702}, {64287, 64296, 703}, {64298, 64310, 704}, {64312, 64316, 705}, {64318, 64318, 706}, {64320, 64321, 707}, {64323, 64324, 708}, {64326, 64433, 709}, {64467, 64829, 710}, {64848, 64911, 711}, {64914, 64967, 712}, {65008, 65019, 713}, {65056, 65059, 714}, {65075, 65076, 715}, {65101, 65103, 716}, {65136, 65138, 717}, {65140, 65140, 718}, {65142, 65276, 719}, {65296, 65305, 720}, {65313, 65338, 721}, {65343, 65343, 722}, {65345, 65370, 723}, {65381, 65381, 724}, {65382, 65470, 725}, {65474, 65479, 726}, {65482, 65487, 727}, {65490, 65495, 728}, {65498, 65500, 729}, },
	 {{61, 61, 730}, },
	 {{38, 38, 731}, {61, 61, 732}, },
	 {{0, 9, 733}, {11, 12, 733}, {14, 38, 733}, {39, 39, 734}, {40, 91, 733}, {92, 92, 735}, {93, 8231, 733}, {8234, 65535, 733}, },
	 {},
	 {},
	 {{61, 61, 736}, },
	 {{43, 43, 737}, {61, 61, 738}, },
	 {},
	 {{45, 45, 739}, {61, 61, 740}, },
	 {{48, 57, 741}, },
	 {{0, 9, 742}, {11, 12, 742}, {14, 41, 742}, {42, 42, 743}, {43, 46, 742}, {47, 47, 744}, {48, 60, 742}, {61, 61, 745}, {62, 91, 742}, {92, 92, 746}, {93, 8231, 742}, {8234, 65535, 742}, },
	 {{46, 46, 747}, {69, 69, 748}, {88, 88, 749}, {101, 101, 750}, {120, 120, 751}, },
	 {{46, 46, 747}, {48, 57, 752}, {69, 69, 748}, {101, 101, 750}, },
	 {},
	 {},
	 {{60, 60, 753}, {61, 61, 754}, },
	 {{61, 61, 755}, },
	 {{61, 61, 756}, {62, 62, 757}, },
	 {},
	 {{36, 65500, -11}, },
	 {},
	 {{117, 117, 758}, },
	 {},
	 {{61, 61, 759}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {},
	 {{61, 61, 760}, {124, 124, 761}, },
	 {},
	 {},
	 {{9, 12288, -4}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{9, 12288, -4}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{9, 12288, -4}, },
	 {{9, 12288, -4}, },
	 {{9, 12288, -4}, },
	 {{9, 12288, -4}, },
	 {{9, 12288, -4}, },
	 {{9, 12288, -4}, },
	 {{9, 12288, -4}, },
	 {{9, 12288, -4}, },
	 {{9, 12288, -4}, },
	 {{9, 12288, -4}, },
	 {{9, 12288, -4}, },
	 {{9, 12288, -4}, },
	 {{9, 12288, -4}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{9, 12288, -4}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{9, 12288, -4}, },
	 {{9, 12288, -4}, },
	 {{9, 12288, -4}, },
	 {{9, 12288, -4}, },
	 {{9, 12288, -4}, },
	 {{9, 12288, -4}, },
	 {{9, 12288, -4}, },
	 {{9, 12288, -4}, },
	 {{9, 12288, -4}, },
	 {{9, 12288, -4}, },
	 {{9, 12288, -4}, },
	 {{9, 12288, -4}, },
	 {{9, 12288, -4}, },
	 {{9, 12288, -4}, },
	 {{9, 12288, -4}, },
	 {{9, 12288, -4}, },
	 {{9, 12288, -4}, },
	 {{9, 12288, -4}, },
	 {{9, 12288, -4}, },
	 {{9, 12288, -4}, },
	 {{9, 12288, -4}, },
	 {{61, 61, 762}, },
	 {{0, 65535, -10}, },
	 {},
	 {{0, 9, 763}, {11, 12, 763}, {14, 33, 763}, {34, 34, 764}, {35, 38, 763}, {39, 39, 764}, {40, 47, 763}, {48, 48, 765}, {58, 91, 763}, {92, 92, 764}, {93, 97, 763}, {98, 98, 764}, {99, 101, 763}, {102, 102, 764}, {103, 109, 763}, {110, 110, 764}, {111, 113, 763}, {114, 114, 764}, {115, 115, 763}, {116, 116, 764}, {117, 117, 766}, {118, 118, 764}, {119, 119, 763}, {120, 120, 767}, {121, 8231, 763}, {8234, 65535, 763}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{117, 117, 768}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {{36, 65500, -11}, },
	 {},
	 {},
	 {},
	 {{0, 65535, -14}, },
	 {},
	 {{0, 9, 769}, {11, 12, 769}, {14, 33, 769}, {34, 34, 770}, {35, 38, 769}, {39, 39, 770}, {40, 47, 769}, {48, 48, 771}, {58, 91, 769}, {92, 92, 770}, {93, 97, 769}, {98, 98, 770}, {99, 101, 769}, {102, 102, 770}, {103, 109, 769}, {110, 110, 770}, {111, 113, 769}, {114, 114, 770}, {115, 115, 769}, {116, 116, 770}, {117, 117, 772}, {118, 118, 770}, {119, 119, 769}, {120, 120, 773}, {121, 8231, 769}, {8234, 65535, 769}, },
	 {},
	 {},
	 {},
	 {},
	 {},
	 {{48, 57, 741}, {69, 69, 774}, {101, 101, 775}, },
	 {{0, 9, 776}, {11, 12, 776}, {14, 46, 776}, {47, 47, 777}, {48, 91, 776}, {92, 92, 778}, {93, 8231, 776}, {8234, 65535, 776}, },
	 {{0, 9, 779}, {10, 10, 780}, {11, 12, 779}, {13, 13, 780}, {14, 41, 779}, {42, 42, 781}, {43, 46, 779}, {48, 8231, 779}, {8232, 8233, 780}, {8234, 65535, 779}, },
	 {{0, 9, 782}, {11, 12, 782}, {14, 8231, 782}, {8234, 65535, 782}, },
	 {{0, 65535, -744}, },
	 {{0, 9, 783}, {11, 12, 783}, {14, 8231, 783}, {8234, 65535, 783}, },
	 {{48, 57, 784}, {69, 69, 785}, {101, 101, 786}, },
	 {{43, 43, 787}, {45, 45, 788}, {48, 57, 789}, },
	 {{48, 57, 790}, {65, 70, 790}, {97, 102, 790}, },
	 {{43, 57, -750}, },
	 {{48, 102, -751}, },
	 {{46, 101, -24}, },
	 {{61, 61, 791}, },
	 {},
	 {{61, 61, 792}, },
	 {},
	 {{61, 61, 793}, {62, 62, 794}, },
	 {{48, 57, 795}, {65, 70, 795}, {97, 102, 795}, },
	 {},
	 {},
	 {},
	 {},
	 {{0, 65535, -10}, },
	 {{0, 65535, -10}, },
	 {{0, 65535, -10}, },
	 {{48, 57, 796}, {65, 70, 796}, {97, 102, 796}, },
	 {{48, 57, 797}, {65, 70, 797}, {97, 102, 797}, },
	 {{48, 57, 798}, {65, 70, 798}, {97, 102, 798}, },
	 {{0, 65535, -14}, },
	 {{0, 65535, -14}, },
	 {{0, 65535, -14}, },
	 {{48, 57, 799}, {65, 70, 799}, {97, 102, 799}, },
	 {{48, 57, 800}, {65, 70, 800}, {97, 102, 800}, },
	 {{43, 43, 801}, {45, 45, 802}, {48, 57, 803}, },
	 {{43, 57, -776}, },
	 {{0, 65535, -744}, },
	 {{36, 36, 804}, {48, 57, 805}, {65, 90, 806}, {92, 92, 807}, {95, 95, 808}, {97, 122, 809}, {170, 170, 810}, {181, 181, 811}, {186, 186, 812}, {192, 214, 813}, {216, 246, 814}, {248, 543, 815}, {546, 563, 816}, {592, 685, 817}, {688, 696, 818}, {699, 705, 819}, {720, 721, 820}, {736, 740, 821}, {750, 750, 822}, {768, 846, 823}, {864, 866, 824}, {890, 890, 825}, {902, 902, 826}, {904, 906, 827}, {908, 908, 828}, {910, 929, 829}, {931, 974, 830}, {976, 983, 831}, {986, 1011, 832}, {1024, 1153, 833}, {1155, 1158, 834}, {1164, 1220, 835}, {1223, 1224, 836}, {1227, 1228, 837}, {1232, 1269, 838}, {1272, 1273, 839}, {1329, 1366, 840}, {1369, 1369, 841}, {1377, 1415, 842}, {1425, 1441, 843}, {1443, 1465, 844}, {1467, 1469, 845}, {1471, 1471, 846}, {1473, 1474, 847}, {1476, 1476, 848}, {1488, 1514, 849}, {1520, 1522, 850}, {1569, 1594, 851}, {1600, 1610, 852}, {1611, 1621, 853}, {1632, 1641, 854}, {1648, 1648, 855}, {1649, 1747, 856}, {1749, 1749, 857}, {1750, 1756, 858}, {1759, 1764, 859}, {1765, 1766, 860}, {1767, 1768, 861}, {1770, 1773, 862}, {1776, 1785, 863}, {1786, 1788, 864}, {1808, 1808, 865}, {1809, 1809, 866}, {1810, 1836, 867}, {1840, 1866, 868}, {1920, 1957, 869}, {1958, 1968, 870}, {2305, 2307, 871}, {2309, 2361, 872}, {2364, 2364, 873}, {2365, 2365, 874}, {2366, 2381, 875}, {2384, 2384, 876}, {2385, 2388, 877}, {2392, 2401, 878}, {2402, 2403, 879}, {2406, 2415, 880}, {2433, 2435, 881}, {2437, 2444, 882}, {2447, 2448, 883}, {2451, 2472, 884}, {2474, 2480, 885}, {2482, 2482, 886}, {2486, 2489, 887}, {2492, 2500, 888}, {2503, 2504, 889}, {2507, 2509, 890}, {2519, 2519, 891}, {2524, 2525, 892}, {2527, 2529, 893}, {2530, 2531, 894}, {2534, 2543, 895}, {2544, 2545, 896}, {2562, 2562, 897}, {2565, 2570, 898}, {2575, 2576, 899}, {2579, 2600, 900}, {2602, 2608, 901}, {2610, 2611, 902}, {2613, 2614, 903}, {2616, 2617, 904}, {2620, 2620, 905}, {2622, 2626, 906}, {2631, 2632, 907}, {2635, 2637, 908}, {2649, 2652, 909}, {2654, 2654, 910}, {2662, 2671, 911}, {2672, 2673, 912}, {2674, 2676, 913}, {2689, 2691, 914}, {2693, 2699, 915}, {2701, 2701, 916}, {2703, 2705, 917}, {2707, 2728, 918}, {2730, 2736, 919}, {2738, 2739, 920}, {2741, 2745, 921}, {2748, 2748, 922}, {2749, 2749, 923}, {2750, 2757, 924}, {2759, 2761, 925}, {2763, 2765, 926}, {2768, 2768, 927}, {2784, 2784, 928}, {2790, 2799, 929}, {2817, 2819, 930}, {2821, 2828, 931}, {2831, 2832, 932}, {2835, 2856, 933}, {2858, 2864, 934}, {2866, 2867, 935}, {2870, 2873, 936}, {2876, 2876, 937}, {2877, 2877, 938}, {2878, 2883, 939}, {2887, 2888, 940}, {2891, 2893, 941}, {2902, 2903, 942}, {2908, 2909, 943}, {2911, 2913, 944}, {2918, 2927, 945}, {2946, 2947, 946}, {2949, 2954, 947}, {2958, 2960, 948}, {2962, 2965, 949}, {2969, 2970, 950}, {2972, 2972, 951}, {2974, 2975, 952}, {2979, 2980, 953}, {2984, 2986, 954}, {2990, 2997, 955}, {2999, 3001, 956}, {3006, 3010, 957}, {3014, 3016, 958}, {3018, 3021, 959}, {3031, 3031, 960}, {3047, 3055, 961}, {3073, 3075, 962}, {3077, 3084, 963}, {3086, 3088, 964}, {3090, 3112, 965}, {3114, 3123, 966}, {3125, 3129, 967}, {3134, 3140, 968}, {3142, 3144, 969}, {3146, 3149, 970}, {3157, 3158, 971}, {3168, 3169, 972}, {3174, 3183, 973}, {3202, 3203, 974}, {3205, 3212, 975}, {3214, 3216, 976}, {3218, 3240, 977}, {3242, 3251, 978}, {3253, 3257, 979}, {3262, 3268, 980}, {3270, 3272, 981}, {3274, 3277, 982}, {3285, 3286, 983}, {3294, 3294, 984}, {3296, 3297, 985}, {3302, 3311, 986}, {3330, 3331, 987}, {3333, 3340, 988}, {3342, 3344, 989}, {3346, 3368, 990}, {3370, 3385, 991}, {3390, 3395, 992}, {3398, 3400, 993}, {3402, 3405, 994}, {3415, 3415, 995}, {3424, 3425, 996}, {3430, 3439, 997}, {3458, 3459, 998}, {3461, 3478, 999}, {3482, 3505, 1000}, {3507, 3515, 1001}, {3517, 3517, 1002}, {3520, 3526, 1003}, {3530, 3530, 1004}, {3535, 3540, 1005}, {3542, 3542, 1006}, {3544, 3551, 1007}, {3570, 3571, 1008}, {3585, 3632, 1009}, {3633, 3633, 1010}, {3634, 3635, 1011}, {3636, 3642, 1012}, {3648, 3654, 1013}, {3655, 3662, 1014}, {3664, 3673, 1015}, {3713, 3714, 1016}, {3716, 3716, 1017}, {3719, 3720, 1018}, {3722, 3722, 1019}, {3725, 3725, 1020}, {3732, 3735, 1021}, {3737, 3743, 1022}, {3745, 3747, 1023}, {3749, 3749, 1024}, {3751, 3751, 1025}, {3754, 3755, 1026}, {3757, 3760, 1027}, {3761, 3761, 1028}, {3762, 3763, 1029}, {3764, 3769, 1030}, {3771, 3772, 1031}, {3773, 3780, 1032}, {3782, 3782, 1033}, {3784, 3789, 1034}, {3792, 3801, 1035}, {3804, 3805, 1036}, {3840, 3840, 1037}, {3864, 3865, 1038}, {3872, 3881, 1039}, {3893, 3893, 1040}, {3895, 3895, 1041}, {3897, 3897, 1042}, {3902, 3903, 1043}, {3904, 3946, 1044}, {3953, 3972, 1045}, {3974, 3975, 1046}, {3976, 3979, 1047}, {3984, 3991, 1048}, {3993, 4028, 1049}, {4038, 4038, 1050}, {4096, 4129, 1051}, {4131, 4135, 1052}, {4137, 4138, 1053}, {4140, 4146, 1054}, {4150, 4153, 1055}, {4160, 4169, 1056}, {4176, 4181, 1057}, {4182, 4185, 1058}, {4256, 4293, 1059}, {4304, 4342, 1060}, {4352, 4441, 1061}, {4447, 4514, 1062}, {4520, 4601, 1063}, {4608, 4614, 1064}, {4616, 4678, 1065}, {4680, 4680, 1066}, {4682, 4685, 1067}, {4688, 4694, 1068}, {4696, 4696, 1069}, {4698, 4701, 1070}, {4704, 4742, 1071}, {4744, 4744, 1072}, {4746, 4749, 1073}, {4752, 4782, 1074}, {4784, 4784, 1075}, {4786, 4789, 1076}, {4792, 4798, 1077}, {4800, 4800, 1078}, {4802, 4805, 1079}, {4808, 4814, 1080}, {4816, 4822, 1081}, {4824, 4846, 1082}, {4848, 4878, 1083}, {4880, 4880, 1084}, {4882, 4885, 1085}, {4888, 4894, 1086}, {4896, 4934, 1087}, {4936, 4954, 1088}, {4969, 4977, 1089}, {5024, 5040, 1090}, {5041, 5108, 1091}, {5121, 5750, 1092}, {5761, 5786, 1093}, {5792, 5866, 1094}, {6016, 6067, 1095}, {6068, 6099, 1096}, {6112, 6121, 1097}, {6160, 6169, 1098}, {6176, 6263, 1099}, {6272, 6312, 1100}, {6313, 6313, 1101}, {7680, 7835, 1102}, {7840, 7904, 1103}, {7905, 7929, 1104}, {7936, 7957, 1105}, {7960, 7965, 1106}, {7968, 7993, 1107}, {7994, 8005, 1108}, {8008, 8013, 1109}, {8016, 8023, 1110}, {8025, 8025, 1111}, {8027, 8027, 1112}, {8029, 8029, 1113}, {8031, 8061, 1114}, {8064, 8116, 1115}, {8118, 8124, 1116}, {8126, 8126, 1117}, {8130, 8132, 1118}, {8134, 8140, 1119}, {8144, 8147, 1120}, {8150, 8155, 1121}, {8160, 8172, 1122}, {8178, 8180, 1123}, {8182, 8188, 1124}, {8255, 8256, 1125}, {8319, 8319, 1126}, {8400, 8412, 1127}, {8417, 8417, 1128}, {8450, 8450, 1129}, {8455, 8455, 1130}, {8458, 8467, 1131}, {8469, 8469, 1132}, {8473, 8477, 1133}, {8484, 8484, 1134}, {8486, 8486, 1135}, {8488, 8488, 1136}, {8490, 8493, 1137}, {8495, 8497, 1138}, {8499, 8505, 1139}, {8544, 8579, 1140}, {12293, 12295, 1141}, {12321, 12329, 1142}, {12330, 12335, 1143}, {12337, 12341, 1144}, {12344, 12346, 1145}, {12353, 12436, 1146}, {12441, 12442, 1147}, {12445, 12446, 1148}, {12449, 12538, 1149}, {12539, 12539, 1150}, {12540, 12542, 1151}, {12549, 12588, 1152}, {12593, 12686, 1153}, {12704, 12727, 1154}, {13312, 13312, 1155}, {19893, 19893, 1156}, {19968, 19968, 1157}, {40869, 40869, 1158}, {40960, 42124, 1159}, {44032, 44032, 1160}, {55203, 55203, 1161}, {63744, 64045, 1162}, {64256, 64262, 1163}, {64275, 64279, 1164}, {64285, 64285, 1165}, {64286, 64286, 1166}, {64287, 64296, 1167}, {64298, 64310, 1168}, {64312, 64316, 1169}, {64318, 64318, 1170}, {64320, 64321, 1171}, {64323, 64324, 1172}, {64326, 64433, 1173}, {64467, 64829, 1174}, {64848, 64911, 1175}, {64914, 64967, 1176}, {65008, 65019, 1177}, {65056, 65059, 1178}, {65075, 65076, 1179}, {65101, 65103, 1180}, {65136, 65138, 1181}, {65140, 65140, 1182}, {65142, 65276, 1183}, {65296, 65305, 1184}, {65313, 65338, 1185}, {65343, 65343, 1186}, {65345, 65370, 1187}, {65381, 65381, 1188}, {65382, 65470, 1189}, {65474, 65479, 1190}, {65482, 65487, 1191}, {65490, 65495, 1192}, {65498, 65500, 1193}, },
	 {{0, 9, 1194}, {11, 12, 1194}, {14, 8231, 1194}, {8234, 65535, 1194}, },
	 {{0, 9, 1195}, {10, 10, 1196}, {11, 12, 1195}, {13, 13, 1196}, {14, 41, 1195}, {42, 42, 1197}, {43, 46, 1195}, {47, 47, 1198}, {48, 8231, 1195}, {8232, 8233, 1196}, {8234, 65535, 1195}, },
	 {{0, 41, 1196}, {42, 42, 1199}, {43, 46, 1196}, {47, 47, 1200}, {48, 65535, 1196}, },
	 {{0, 41, -745}, {42, 42, 1201}, {43, 46, 779}, {47, 47, 1202}, {48, 65535, -745}, },
	 {{0, 65535, -746}, },
	 {{0, 65535, -744}, },
	 {{48, 101, -749}, },
	 {{43, 43, 1203}, {45, 45, 1204}, {48, 57, 1205}, },
	 {{43, 57, -787}, },
	 {{48, 57, 789}, },
	 {{48, 57, 789}, },
	 {{48, 57, 789}, },
	 {{48, 102, -751}, },
	 {},
	 {},
	 {},
	 {{61, 61, 1206}, },
	 {{48, 57, 1207}, {65, 70, 1207}, {97, 102, 1207}, },
	 {{48, 57, 1208}, {65, 70, 1208}, {97, 102, 1208}, },
	 {{48, 57, 1209}, {65, 70, 1209}, {97, 102, 1209}, },
	 {{48, 57, 1210}, {65, 70, 1210}, {97, 102, 1210}, },
	 {{48, 57, 1211}, {65, 70, 1211}, {97, 102, 1211}, },
	 {{48, 57, 1212}, {65, 70, 1212}, {97, 102, 1212}, },
	 {{48, 57, 803}, },
	 {{48, 57, 803}, },
	 {{48, 57, 803}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{117, 117, 1213}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{36, 65500, -779}, },
	 {{0, 65535, -744}, },
	 {{0, 65535, -781}, },
	 {{0, 65535, -782}, },
	 {{0, 41, -745}, {42, 42, 1197}, {43, 46, 779}, {47, 47, 1214}, {48, 65535, -745}, },
	 {{0, 65535, -781}, },
	 {{0, 41, 780}, {42, 42, 1199}, {43, 46, 780}, {47, 47, 1215}, {48, 65535, 780}, },
	 {{0, 65535, -782}, },
	 {{0, 46, -783}, {47, 65535, -1199}, },
	 {},
	 {{48, 57, 1205}, },
	 {{48, 57, 1205}, },
	 {{48, 57, 1205}, },
	 {},
	 {{48, 57, 1216}, {65, 70, 1216}, {97, 102, 1216}, },
	 {{48, 57, 1217}, {65, 70, 1217}, {97, 102, 1217}, },
	 {{0, 65535, -10}, },
	 {{48, 57, 1218}, {65, 70, 1218}, {97, 102, 1218}, },
	 {{48, 57, 1219}, {65, 70, 1219}, {97, 102, 1219}, },
	 {{0, 65535, -14}, },
	 {{48, 57, 1220}, {65, 70, 1220}, {97, 102, 1220}, },
	 {},
	 {},
	 {{48, 57, 1221}, {65, 70, 1221}, {97, 102, 1221}, },
	 {{48, 57, 1222}, {65, 70, 1222}, {97, 102, 1222}, },
	 {{48, 57, 1223}, {65, 70, 1223}, {97, 102, 1223}, },
	 {{48, 57, 1224}, {65, 70, 1224}, {97, 102, 1224}, },
	 {{48, 57, 1225}, {65, 70, 1225}, {97, 102, 1225}, },
	 {{36, 65500, -11}, },
	 {{0, 65535, -10}, },
	 {{36, 65500, -11}, },
	 {{0, 65535, -14}, },
	 {{48, 57, 1226}, {65, 70, 1226}, {97, 102, 1226}, },
	 {{48, 57, 1227}, {65, 70, 1227}, {97, 102, 1227}, },
	 {{36, 65500, -779}, },
	 }
	 };*/

	private static int[][] accept;

	public Lexer(PushbackReader in1Param) {
		this.in = in1Param;
		DataInputStream s = null;
		if (gotoTable == null) {
			try {
				InputStream inStream = Lexer.class.getResourceAsStream("javascript.llex");//$NON-NLS-1$
				if (inStream == null)
					throw new RuntimeWrappedException(JavaScriptCoreMessages.__javascript_llex___not_fo_EXC_); //$NON-NLS-1$ = "\"javascript.llex\" not found on classpath"

				s = new DataInputStream(new BufferedInputStream(inStream));

				// read gotoTable
				int length = s.readInt();
				gotoTable = new int[length][][][];
				for (int i = 0; i < gotoTable.length; i++) {
					length = s.readInt();
					gotoTable[i] = new int[length][][];
					for (int j = 0; j < gotoTable[i].length; j++) {
						length = s.readInt();
						gotoTable[i][j] = new int[length][3];
						for (int k = 0; k < gotoTable[i][j].length; k++) {
							for (int l = 0; l < 3; l++) {
								gotoTable[i][j][k][l] = s.readInt();
							}
						}
					}
				}

				// read accept
				length = s.readInt();
				accept = new int[length][];
				for (int i = 0; i < accept.length; i++) {
					length = s.readInt();
					accept[i] = new int[length];
					for (int j = 0; j < accept[i].length; j++) {
						accept[i][j] = s.readInt();
					}
				}
			}
			catch (IOException e) {
				throw new RuntimeWrappedException(JavaScriptCoreMessages.The_file___javascript_llex_EXC_); //$NON-NLS-1$ = "The file \"javascript.llex\" is either missing or corrupted."
			}
			finally {
				try {
					// be sure to check for null, or else
					// a null pointer exception will mask
					// the true exception
					if (s != null)
						s.close();
				}
				catch (IOException e) {
					throw new RuntimeWrappedException(e);
				}
			}
		}
	}

	private int getChar() throws IOException {
		if (eof) {
			return -1;
		}

		int result = in.read();

		if (result == -1) {
			eof = true;
		}

		return result;
	}

	private String getText(int acceptLength) {
		StringBuffer s = new StringBuffer(acceptLength);
		for (int i = 0; i < acceptLength; i++) {
			s.append(text.charAt(i));
		}

		return s.toString();
	}

	protected Token getToken() throws IOException, LexerException {
		int dfa_state = 0;

		int start_pos = pos;
		int start_line = line;
		int start_lpoffset = lpoffset;

		int accept_state = -1;
		int accept_token = -1;
		int accept_length = -1;
		int accept_pos = -1;
		int accept_line = -1;
		int accept_lpoffset = -1;

		int[][][] gotoTable1 = Lexer.gotoTable[state.id()];
		int[] accept1 = Lexer.accept[state.id()];
		text.setLength(0);

		while (true) {
			int c = getChar();

			if (c != -1) {
				switch (c) {
					case 10 :
						if (cr) {
							cr = false;
						}
						else {
							line++;
							pos = 0;
						}
						break;
					case 13 :
						line++;
						pos = 0;
						cr = true;
						break;
					default :
						pos++;
						cr = false;
						break;
				}
				lpoffset++;

				text.append((char) c);

				do {
					int oldState = (dfa_state < -1) ? (-2 - dfa_state) : dfa_state;

					dfa_state = -1;

					int[][] tmp1 = gotoTable1[oldState];
					int low = 0;
					int high = tmp1.length - 1;

					while (low <= high) {
						int middle = (low + high) / 2;
						int[] tmp2 = tmp1[middle];

						if (c < tmp2[0]) {
							high = middle - 1;
						}
						else if (c > tmp2[1]) {
							low = middle + 1;
						}
						else {
							dfa_state = tmp2[2];
							break;
						}
					}
				}
				while (dfa_state < -1);
			}
			else {
				dfa_state = -1;
			}

			if (dfa_state >= 0) {
				if (accept1[dfa_state] != -1) {
					accept_state = dfa_state;
					accept_token = accept1[dfa_state];
					accept_length = text.length();
					accept_pos = pos;
					accept_line = line;
					accept_lpoffset = lpoffset;
				}
			}
			else {
				if (accept_state != -1) {
					switch (accept_token) {
						case 0 :
							{
								Token token = new0(getText(accept_length), start_line + 1, start_pos + 1, start_lpoffset, accept_line > start_line);
								pushBack(accept_length);
								pos = accept_pos;
								line = accept_line;
								lpoffset = accept_lpoffset;
								return token;
							}
						case 1 :
							{
								Token token = new1(getText(accept_length), start_line + 1, start_pos + 1, start_lpoffset, accept_line > start_line);
								pushBack(accept_length);
								pos = accept_pos;
								line = accept_line;
								lpoffset = accept_lpoffset;
								return token;
							}
						case 2 :
							{
								Token token = new2(getText(accept_length), start_line + 1, start_pos + 1, start_lpoffset, accept_line > start_line);
								pushBack(accept_length);
								pos = accept_pos;
								line = accept_line;
								lpoffset = accept_lpoffset;
								return token;
							}
						case 3 :
							{
								Token token = new3(getText(accept_length), start_line + 1, start_pos + 1, start_lpoffset, accept_line > start_line);
								pushBack(accept_length);
								pos = accept_pos;
								line = accept_line;
								lpoffset = accept_lpoffset;
								return token;
							}
						case 4 :
							{
								Token token = new4(getText(accept_length), start_line + 1, start_pos + 1, start_lpoffset, accept_line > start_line);
								pushBack(accept_length);
								pos = accept_pos;
								line = accept_line;
								lpoffset = accept_lpoffset;
								return token;
							}
						case 5 :
							{
								Token token = new5(getText(accept_length), start_line + 1, start_pos + 1, start_lpoffset, accept_line > start_line);
								pushBack(accept_length);
								pos = accept_pos;
								line = accept_line;
								lpoffset = accept_lpoffset;
								return token;
							}
						case 6 :
							{
								Token token = new6(getText(accept_length), start_line + 1, start_pos + 1, start_lpoffset, accept_line > start_line);
								pushBack(accept_length);
								pos = accept_pos;
								line = accept_line;
								lpoffset = accept_lpoffset;
								return token;
							}
						case 7 :
							{
								Token token = new7(getText(accept_length), start_line + 1, start_pos + 1, start_lpoffset, accept_line > start_line);
								pushBack(accept_length);
								pos = accept_pos;
								line = accept_line;
								lpoffset = accept_lpoffset;
								return token;
							}
						case 8 :
							{
								Token token = new8(getText(accept_length), start_line + 1, start_pos + 1, start_lpoffset, accept_line > start_line);
								pushBack(accept_length);
								pos = accept_pos;
								line = accept_line;
								lpoffset = accept_lpoffset;
								return token;
							}
						case 9 :
							{
								Token token = new9(getText(accept_length), start_line + 1, start_pos + 1, start_lpoffset, accept_line > start_line);
								pushBack(accept_length);
								pos = accept_pos;
								line = accept_line;
								lpoffset = accept_lpoffset;
								return token;
							}
						case 10 :
							{
								Token token = new10(getText(accept_length), start_line + 1, start_pos + 1, start_lpoffset, accept_line > start_line);
								pushBack(accept_length);
								pos = accept_pos;
								line = accept_line;
								lpoffset = accept_lpoffset;
								return token;
							}
					}
				}
				else {
					if (text.length() > 0) {
						throw new LexerException(NLS.bind(JavaScriptCoreMessages._Unknown_token___EXC_,
									(new Object[]{Integer.toString((start_line + 1)), Integer.toString((start_pos + 1)), text})));
					}
					//else {
						EOF token = new EOF(start_line + 1, start_pos + 1, start_lpoffset);
						return token;
					//}
				}
			}
		}
	}

	Token new0(String text, int line, int pos, int lpoffset, boolean blContainsLineTerminator) {
		return new TBlank(text, line, pos, lpoffset, blContainsLineTerminator);
	}

	Token new1(String text, int line, int pos, int lpoffset, boolean blContainsLineTerminator) {
		return new TCommenttok(text, line, pos, lpoffset, blContainsLineTerminator);
	}

	Token new10(String text, int line, int pos, int lpoffset, boolean blContainsLineTerminator) {
		return new TErrorChar(text, line, pos, lpoffset, blContainsLineTerminator);
	}

	Token new2(String text, int line, int pos, int lpoffset, boolean blContainsLineTerminator) {
		return new TUnterminatedComment(text, line, pos, lpoffset, blContainsLineTerminator);
	}

	Token new3(String text, int line, int pos, int lpoffset, boolean blContainsLineTerminator) {
		return new TDecimalLiteral(text, line, pos, lpoffset, blContainsLineTerminator);
	}

	Token new4(String text, int line, int pos, int lpoffset, boolean blContainsLineTerminator) {
		return new THexIntegerLiteral(text, line, pos, lpoffset, blContainsLineTerminator);
	}

	Token new5(String text, int line, int pos, int lpoffset, boolean blContainsLineTerminator) {
		return new TPunctuator1(text, line, pos, lpoffset, blContainsLineTerminator);
	}

	Token new6(String text, int line, int pos, int lpoffset, boolean blContainsLineTerminator) {
		return new TStringLiteral(text, line, pos, lpoffset, blContainsLineTerminator);
	}

	Token new7(String text, int line, int pos, int lpoffset, boolean blContainsLineTerminator) {
		return new TUnterminatedStringLiteral(text, line, pos, lpoffset, blContainsLineTerminator);
	}

	Token new8(String text, int line, int pos, int lpoffset, boolean blContainsLineTerminator) {
		return new TRegularExpressionLiteral(text, line, pos, lpoffset, blContainsLineTerminator);
	}

	Token new9(String text, int line, int pos, int lpoffset, boolean blContainsLineTerminator) {
		return new TIdentifier(text, line, pos, lpoffset, blContainsLineTerminator);
	}

	public Token next() throws LexerException, IOException {
		while (ftoken == null) {
			ftoken = getToken();
		}

		Token result = ftoken;
		ftoken = null;
		return result;
	}

	public Token peek() throws LexerException, IOException {
		while (ftoken == null) {
			ftoken = getToken();
		}

		return ftoken;
	}

	private void pushBack(int acceptLength) throws IOException {
		int length = text.length();
		for (int i = length - 1; i >= acceptLength; i--) {
			eof = false;

			in.unread(text.charAt(i));
		}
	}

	protected void unread(Token token) throws IOException {
		String text = token.getText();
		int length = text.length();

		for (int i = length - 1; i >= 0; i--) {
			eof = false;

			in.unread(text.charAt(i));
		}

		pos = token.getPos() - 1;
		line = token.getLine() - 1;
	}
}