/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.types;

import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.jsf.core.internal.types.TypeUtil;

public class CompositeType {
    private final String[] _signatures;
    private final int _assignmentType;
    private boolean[] _isTypeSignature;

    public CompositeType(String[] signatureStrings, int assignmentType) {
        if (signatureStrings == null || signatureStrings.length < 1) {
            throw new AssertionError((Object)"Must specify at least one signature string");
        }
        this._signatures = new String[signatureStrings.length];
        System.arraycopy(signatureStrings, 0, this._signatures, 0, this._signatures.length);
        this._assignmentType = assignmentType;
    }

    public CompositeType(String signatureString, int assignmentType) {
        this(new String[]{signatureString}, assignmentType);
    }

    public int getAssignmentTypeMask() {
        return this._assignmentType;
    }

    public boolean isLHS() {
        return TypeUtil.matchesLHS(this._assignmentType);
    }

    public boolean isRHS() {
        return TypeUtil.matchesRHS(this._assignmentType);
    }

    public boolean[] getIsTypeSignature() {
        return this.getTypeSignatureFlags();
    }

    public String[] getSignatures() {
        String[] copy = new String[this._signatures.length];
        System.arraycopy(this._signatures, 0, copy, 0, this._signatures.length);
        return copy;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int i = 0;
        while (i < this._signatures.length) {
            stringBuffer.append(this._signatures[i]);
            stringBuffer.append(" | ");
            ++i;
        }
        return stringBuffer.toString();
    }

    public String toUserReadableString() {
        StringBuffer stringBuffer = new StringBuffer();
        int i = 0;
        while (i < this._signatures.length) {
            String signature = this._signatures[i];
            if (this.getTypeSignatureFlags()[i]) {
                stringBuffer.append(Signature.getSignatureSimpleName((String)signature));
            }
            if (i < this._signatures.length - 1) {
                stringBuffer.append(", ");
            }
            ++i;
        }
        return stringBuffer.toString();
    }

    private boolean[] getTypeSignatureFlags() {
        if (this._isTypeSignature == null) {
            this._isTypeSignature = new boolean[this._signatures.length];
            int i = 0;
            while (i < this._signatures.length) {
                try {
                    Signature.getTypeSignatureKind((String)this._signatures[i]);
                    this._isTypeSignature[i] = true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this._isTypeSignature[i] = false;
                }
                ++i;
            }
        }
        return this._isTypeSignature;
    }
}

