/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.util;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsf.facesconfig.common.utils.JavaModelUtil;
import org.eclipse.jst.jsf.facesconfig.ui.util.JavaBeanProperty;
import org.eclipse.jst.jsf.facesconfig.ui.util.JavaClassUtils;

public final class JavaBeanUtils {
    public static final String JAVA_UTIL_LIST = "java.util.List";
    public static final String JAVA_UTIL_MAP = "java.util.Map";

    private JavaBeanUtils() {
    }

    private static IMethod getPropertyGetterMethod(IType type, String propertyName) throws JavaModelException {
        if (type == null || !type.exists() || propertyName == null) {
            return null;
        }
        IMethod getterMethod = null;
        String methodBaseName = null;
        methodBaseName = propertyName.length() == 1 ? propertyName.substring(0, 1).toUpperCase() : String.valueOf(propertyName.substring(0, 1).toUpperCase()) + propertyName.substring(1);
        String getterMethodName = "get" + methodBaseName;
        getterMethod = type.getMethod(getterMethodName, null);
        if (!(getterMethod != null && getterMethod.exists() && JavaClassUtils.isPublicMethod(getterMethod) || (getterMethod = type.getMethod(getterMethodName = "is" + methodBaseName, null)) != null && getterMethod.exists() && JavaClassUtils.isPublicMethod(getterMethod))) {
            getterMethod = null;
        }
        return getterMethod;
    }

    private static IMethod getPropertyGetterMethodInTypeHierarchy(IType type, String propertyName) throws JavaModelException {
        if (type == null || !type.exists() || propertyName == null) {
            return null;
        }
        IMethod getterMethod = null;
        getterMethod = JavaBeanUtils.getPropertyGetterMethod(type, propertyName);
        if (getterMethod == null) {
            ITypeHierarchy typeHierarchy = null;
            typeHierarchy = type.newSupertypeHierarchy(null);
            if (typeHierarchy == null) {
                return null;
            }
            IType[] superTypes = typeHierarchy.getAllSuperclasses(type);
            if (superTypes == null || superTypes.length == 0) {
                return null;
            }
            int i = 0;
            while (i < superTypes.length) {
                if (!superTypes[i].getFullyQualifiedName().equals("java.lang.Object") && (getterMethod = JavaBeanUtils.getPropertyGetterMethod(superTypes[i], propertyName)) != null) break;
                ++i;
            }
        }
        return getterMethod;
    }

    private static IMethod getPropertySetterMethodInTypeHierarchy(IType type, String propertyName) throws JavaModelException {
        if (type == null || !type.exists() || propertyName == null) {
            return null;
        }
        IMethod setterMethod = null;
        setterMethod = JavaBeanUtils.getPropertySetterMethod(type, propertyName);
        if (setterMethod == null) {
            ITypeHierarchy typeHierarchy = null;
            typeHierarchy = type.newSupertypeHierarchy(null);
            if (typeHierarchy == null) {
                return null;
            }
            IType[] superTypes = typeHierarchy.getAllSuperclasses(type);
            if (superTypes == null || superTypes.length == 0) {
                return null;
            }
            int i = 0;
            while (i < superTypes.length) {
                if (!superTypes[i].getFullyQualifiedName().equals("java.lang.Object") && (setterMethod = JavaBeanUtils.getPropertySetterMethod(superTypes[i], propertyName)) != null) break;
                ++i;
            }
        }
        return setterMethod;
    }

    private static IMethod getPropertySetterMethod(IType type, String propertyName) throws JavaModelException {
        if (type == null || !type.exists() || propertyName == null) {
            return null;
        }
        IMethod setterMethod = null;
        String methodBaseName = null;
        methodBaseName = propertyName.length() == 1 ? propertyName.substring(0, 1).toUpperCase() : String.valueOf(propertyName.substring(0, 1).toUpperCase()) + propertyName.substring(1);
        String setterMethodName = "set" + methodBaseName;
        IMethod[] methods = null;
        methods = type.getMethods();
        if (methods == null || methods.length == 0) {
            return null;
        }
        int i = 0;
        while (i < methods.length) {
            String[] params;
            String returnType;
            if (methods[i].getElementName().equals(setterMethodName) && methods[i] != null && methods[i].exists() && JavaClassUtils.isPublicMethod(methods[i]) && (returnType = methods[i].getReturnType()).equals("V") && (params = methods[i].getParameterTypes()).length == 1) {
                setterMethod = methods[i];
            }
            ++i;
        }
        return setterMethod;
    }

    public static boolean isBeanProperty(IType baseType, String propertyName) throws JavaModelException {
        if (baseType == null || !baseType.exists() || propertyName == null) {
            return false;
        }
        return JavaBeanUtils.getBeanPropertyType(baseType, propertyName) != null;
    }

    public static IType getBeanPropertyType(IType baseType, String propertyName) {
        if (baseType == null || !baseType.exists() || propertyName == null) {
            return null;
        }
        String typeSignature = null;
        IMethod getterMethod = null;
        IMethod setterMethod = null;
        IType declaredType = baseType;
        try {
            getterMethod = JavaBeanUtils.getPropertyGetterMethodInTypeHierarchy(baseType, propertyName);
            setterMethod = JavaBeanUtils.getPropertySetterMethodInTypeHierarchy(baseType, propertyName);
        }
        catch (JavaModelException javaModelException) {}
        if (getterMethod != null && setterMethod == null) {
            declaredType = getterMethod.getDeclaringType();
            try {
                typeSignature = getterMethod.getReturnType();
            }
            catch (JavaModelException javaModelException) {}
        } else if (setterMethod != null && getterMethod == null) {
            declaredType = setterMethod.getDeclaringType();
            typeSignature = setterMethod.getParameterTypes()[0];
        } else if (setterMethod != null && getterMethod != null) {
            declaredType = getterMethod.getDeclaringType();
            try {
                if (getterMethod.getReturnType().equals(setterMethod.getParameterTypes()[0])) {
                    typeSignature = getterMethod.getReturnType();
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        if (typeSignature == null) {
            return null;
        }
        IType type = null;
        try {
            String typeName = JavaModelUtil.getResolvedTypeName((String)typeSignature, (IType)declaredType);
            if (typeName != null) {
                type = baseType.getJavaProject().findType(typeName);
            }
        }
        catch (JavaModelException javaModelException) {}
        return type;
    }

    public static IMethod[] getBeanPropertyMethods(IType baseType, String propertyName) {
        if (baseType == null || !baseType.exists() || propertyName == null) {
            return null;
        }
        IMethod[] methods = new IMethod[2];
        IMethod getterMethod = null;
        IMethod setterMethod = null;
        try {
            getterMethod = JavaBeanUtils.getPropertyGetterMethodInTypeHierarchy(baseType, propertyName);
            setterMethod = JavaBeanUtils.getPropertySetterMethodInTypeHierarchy(baseType, propertyName);
        }
        catch (JavaModelException javaModelException) {}
        if (getterMethod != null && setterMethod == null) {
            methods[0] = getterMethod;
        } else if (setterMethod != null && getterMethod == null) {
            methods[1] = setterMethod;
        } else if (setterMethod != null && getterMethod != null) {
            try {
                if (getterMethod.getReturnType().equals(setterMethod.getParameterTypes()[0])) {
                    methods[0] = getterMethod;
                    methods[1] = setterMethod;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return methods;
    }

    public static boolean isListType(IType type) {
        if (type == null) {
            return false;
        }
        if (type.getFullyQualifiedName().equalsIgnoreCase(JAVA_UTIL_LIST)) {
            return true;
        }
        return JavaClassUtils.isSubClassOf(type.getJavaProject(), type.getFullyQualifiedName(), JAVA_UTIL_LIST);
    }

    public static boolean isMapType(IType type) {
        if (type == null) {
            return false;
        }
        if (type.getFullyQualifiedName().equalsIgnoreCase(JAVA_UTIL_MAP)) {
            return true;
        }
        return JavaClassUtils.isSubClassOf(type.getJavaProject(), type.getFullyQualifiedName(), JAVA_UTIL_MAP);
    }

    public static boolean isGetterMethod(IMethod method) {
        block8: {
            block7: {
                block6: {
                    try {
                        if (JavaClassUtils.isPublicMethod(method)) break block6;
                        return false;
                    }
                    catch (JavaModelException javaModelException) {}
                }
                String[] params = method.getParameterTypes();
                if (params.length <= 0) break block7;
                return false;
            }
            if (method.getElementName().startsWith("get") || method.getElementName().startsWith("is")) break block8;
            return false;
        }
        String rtn = method.getReturnType();
        if (!rtn.equals("V")) {
            return true;
        }
        return false;
    }

    public static boolean isSetterMethod(IMethod method) {
        block8: {
            block7: {
                block6: {
                    try {
                        if (JavaClassUtils.isPublicMethod(method)) break block6;
                        return false;
                    }
                    catch (JavaModelException javaModelException) {}
                }
                if (method.getElementName().startsWith("set")) break block7;
                return false;
            }
            if (method.getParameterTypes().length == 1) break block8;
            return false;
        }
        String rtn = method.getReturnType();
        if (rtn.equals("V")) {
            return true;
        }
        return false;
    }

    public static String toLowCaseFirstChar(String str) {
        if (str != null && str.length() > 0) {
            str = str.length() == 1 ? str.toLowerCase() : String.valueOf(str.substring(0, 1).toLowerCase()) + str.substring(1);
        }
        return str;
    }

    public static String toUpperCaseFirstChar(String str) {
        if (str != null && str.length() > 0) {
            str = str.length() == 1 ? str.toUpperCase() : String.valueOf(str.substring(0, 1).toUpperCase()) + str.substring(1);
        }
        return str;
    }

    public static String getPropertyNameFromGetterMethod(IMethod method) {
        if (!JavaBeanUtils.isGetterMethod(method)) {
            return null;
        }
        String methodName = method.getElementName();
        String propertyName = null;
        if (methodName.startsWith("get") && methodName.length() > 3) {
            propertyName = methodName.substring(3);
        } else if (methodName.startsWith("is") && methodName.length() > 2) {
            propertyName = methodName.substring(2);
        }
        propertyName = Introspector.decapitalize(propertyName);
        return propertyName;
    }

    public static String getPropertyNameFromSetterMethod(IMethod method) {
        if (!JavaBeanUtils.isSetterMethod(method)) {
            return null;
        }
        String methodName = method.getElementName();
        String propertyName = null;
        if (methodName.startsWith("set") && methodName.length() > 3) {
            propertyName = methodName.substring(3);
        }
        propertyName = Introspector.decapitalize(propertyName);
        return propertyName;
    }

    private static IMethod getMethodWithSameParamters(IMethod[] methods, Map visitedMethods, IMethod foundMethod, String foundMethodName, String[] foundParamTypes) {
        int i;
        String[] foundParamQulifiedTypeNames = null;
        if (foundParamTypes != null && foundParamTypes.length > 0) {
            foundParamQulifiedTypeNames = new String[foundParamTypes.length];
            i = 0;
            while (i < foundParamTypes.length) {
                foundParamQulifiedTypeNames[i] = JavaClassUtils.getQualifiedTypeNameInTypeHierarchy(foundMethod.getDeclaringType(), foundParamTypes[i]);
                ++i;
            }
        }
        i = 0;
        while (i < methods.length) {
            if (visitedMethods.get(methods[i]) == null && methods[i].getElementName().equals(foundMethodName)) {
                if (methods[i].getParameterTypes() == null && foundParamTypes == null) {
                    return methods[i];
                }
                if (methods[i].getParameterTypes() != null && foundParamTypes != null && foundParamTypes.length == methods[i].getParameterTypes().length) {
                    boolean bSameParams = true;
                    String[] methodParamTypes = methods[i].getParameterTypes();
                    int j = 0;
                    while (j < foundParamQulifiedTypeNames.length) {
                        String methodParamQualifiedTypeName = JavaClassUtils.getQualifiedTypeNameInTypeHierarchy(methods[i].getDeclaringType(), methodParamTypes[j]);
                        if (!(methodParamQualifiedTypeName.equals(foundParamQulifiedTypeNames[j]) || JavaClassUtils.isSubClassOf(methods[i].getJavaProject(), methodParamQualifiedTypeName, foundParamQulifiedTypeNames[j]) || JavaClassUtils.isSubClassOf(methods[i].getJavaProject(), foundParamQulifiedTypeNames[j], methodParamQualifiedTypeName))) {
                            bSameParams = false;
                            break;
                        }
                        ++j;
                    }
                    if (bSameParams) {
                        return methods[i];
                    }
                }
            }
            ++i;
        }
        return null;
    }

    public static JavaBeanProperty[] getBeanProperties(IType classType) {
        IMethod[] methods;
        try {
            methods = JavaClassUtils.getMethods(classType);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        return JavaBeanUtils.getBeanProperties(classType, methods);
    }

    public static JavaBeanProperty[] getBeanProperties(IType type, IMethod[] methods) {
        if (methods == null || methods.length == 0) {
            return null;
        }
        ArrayList<JavaBeanProperty> properties = new ArrayList<JavaBeanProperty>();
        HashMap<IMethod, IMethod> visitedMethods = new HashMap<IMethod, IMethod>();
        int m = 0;
        while (m < methods.length) {
            block17: {
                String propertyName = null;
                if (visitedMethods.get(methods[m]) == null) {
                    visitedMethods.put(methods[m], methods[m]);
                    propertyName = JavaBeanUtils.getPropertyNameFromGetterMethod(methods[m]);
                    if (propertyName != null && propertyName.length() > 0) {
                        String setterMethodName = "set" + JavaBeanUtils.toUpperCaseFirstChar(propertyName);
                        String getterReturnType = null;
                        try {
                            getterReturnType = methods[m].getReturnType();
                        }
                        catch (JavaModelException javaModelException) {
                            break block17;
                        }
                        IMethod setterMethod = JavaBeanUtils.getMethodWithSameParamters(methods, visitedMethods, methods[m], setterMethodName, new String[]{getterReturnType});
                        if (setterMethod != null && setterMethod.exists()) {
                            visitedMethods.put(setterMethod, setterMethod);
                        }
                        properties.add(new JavaBeanProperty(propertyName, getterReturnType, methods[m], setterMethod));
                    } else {
                        propertyName = JavaBeanUtils.getPropertyNameFromSetterMethod(methods[m]);
                        if (propertyName != null && propertyName.length() > 0) {
                            String getterMethodName = "get" + JavaBeanUtils.toUpperCaseFirstChar(propertyName);
                            IMethod getterMethod = JavaBeanUtils.getMethodWithSameParamters(methods, visitedMethods, methods[m], getterMethodName, null);
                            if (getterMethod != null && getterMethod.exists()) {
                                try {
                                    if (getterMethod.getReturnType().equals(methods[m].getParameterTypes()[0])) {
                                        visitedMethods.put(getterMethod, getterMethod);
                                    }
                                }
                                catch (JavaModelException javaModelException) {}
                            } else {
                                getterMethodName = "is" + JavaBeanUtils.toUpperCaseFirstChar(propertyName);
                                getterMethod = JavaBeanUtils.getMethodWithSameParamters(methods, visitedMethods, methods[m], getterMethodName, null);
                                try {
                                    if (getterMethod != null && getterMethod.exists() && getterMethod.getReturnType().equals(methods[m].getParameterTypes()[0])) {
                                        visitedMethods.put(getterMethod, getterMethod);
                                    }
                                }
                                catch (JavaModelException javaModelException) {}
                            }
                            properties.add(new JavaBeanProperty(propertyName, methods[m].getParameterTypes()[0], getterMethod, methods[m]));
                        }
                    }
                }
            }
            ++m;
        }
        JavaBeanProperty[] propertyArray = properties.toArray(new JavaBeanProperty[properties.size()]);
        Arrays.sort(propertyArray, new Comparator(){

            public int compare(Object o1, Object o2) {
                String name1 = ((JavaBeanProperty)o1).getName();
                String name2 = ((JavaBeanProperty)o2).getName();
                return name1.compareTo(name2);
            }
        });
        return propertyArray;
    }
}

