/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jst.jsf.facesconfig.common.utils.JavaModelUtil;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;

public class JavaClassUtils {
    public static boolean hasIllegalCharacters(String text) {
        if (text.length() == 0 || !Character.isJavaIdentifierStart(text.charAt(0))) {
            return true;
        }
        int i = 1;
        while (i < text.length()) {
            if (!Character.isJavaIdentifierPart(text.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasNoConstructor(IMethod[] methods) {
        int m = 0;
        while (m < methods.length) {
            try {
                if (methods[m].isConstructor()) {
                    return false;
                }
            }
            catch (JavaModelException javaModelException) {}
            ++m;
        }
        return true;
    }

    public static boolean isPublicMethod(IMethod method) {
        int accessFlags = 0;
        try {
            accessFlags = method.getFlags();
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
        boolean isPublic = Flags.isPublic((int)accessFlags);
        if (!(Flags.isPrivate((int)accessFlags) || Flags.isProtected((int)accessFlags) || Flags.isPublic((int)accessFlags))) {
            isPublic = true;
        }
        return isPublic;
    }

    public static boolean hasPublicConstructor(IMethod[] methods) {
        int m = 0;
        while (m < methods.length) {
            try {
                String[] params;
                if (methods[m].isConstructor() && JavaClassUtils.isPublicMethod(methods[m]) && (params = methods[m].getParameterTypes()).length == 0) {
                    String rtn = methods[m].getReturnType();
                    if (!rtn.equals("V")) break;
                    return true;
                }
            }
            catch (JavaModelException javaModelException) {}
            ++m;
        }
        return false;
    }

    public static boolean isPrimitiveType(IType classType, String signatureName) throws JavaModelException {
        while (signatureName.startsWith("[")) {
            signatureName = signatureName.substring(1);
        }
        int kind = Signature.getTypeSignatureKind((String)signatureName);
        if (kind == 2 || signatureName.equals("V")) {
            return true;
        }
        String qualifiedName = JavaClassUtils.getQualifiedTypeNameInTypeHierarchy(classType, signatureName);
        return qualifiedName.startsWith("java.lang") || qualifiedName.startsWith("java.util");
    }

    public static IType getType(IProject project, String className) {
        if (project == null) {
            return null;
        }
        IType cunit = null;
        if (className.length() > 0) {
            IJavaProject jProject = JavaCore.create((IProject)project);
            try {
                cunit = jProject.findType(className);
            }
            catch (JavaModelException javaModelException) {}
        }
        return cunit;
    }

    public static boolean openType(IType type) {
        if (type == null || !type.exists()) {
            return false;
        }
        try {
            IEditorPart editorPart = JavaUI.openInEditor((IJavaElement)type.getPrimaryElement());
            if (editorPart != null) {
                JavaUI.revealInEditor((IEditorPart)editorPart, (IJavaElement)type.getPrimaryElement());
                return true;
            }
        }
        catch (PartInitException partInitException) {
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    public static String getPackageName(IFile javaFile) {
        if (javaFile == null) {
            return null;
        }
        String ext = "." + javaFile.getFileExtension();
        if (!ext.equalsIgnoreCase("java")) {
            return null;
        }
        String packagename = new String();
        ICompilationUnit cunit = JavaCore.createCompilationUnitFrom((IFile)javaFile);
        try {
            IPackageDeclaration[] packages = cunit.getPackageDeclarations();
            packagename = packages.length == 0 ? new String() : packages[0].getElementName();
        }
        catch (JavaModelException javaModelException) {}
        return packagename;
    }

    private static void copyToMethodList(List methodList, IMethod[] methods) throws JavaModelException {
        if (methods != null && methods.length > 0) {
            int i = 0;
            while (i < methods.length) {
                if (!JavaClassUtils.isDuplicateMethod(methodList, methods[i])) {
                    methodList.add(methods[i]);
                }
                ++i;
            }
        }
    }

    private static boolean isDuplicateMethod(List methodList, IMethod method) throws JavaModelException {
        if (method == null || !method.exists()) {
            return false;
        }
        String[] paramTypes = method.getParameterTypes();
        String methodName = method.getElementName();
        Iterator iter = methodList.iterator();
        while (iter.hasNext()) {
            IMethod existedMethod = (IMethod)iter.next();
            if (!JavaClassUtils.isSameMethodSignature(methodName, paramTypes, existedMethod)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSameMethodSignature(String name, String[] paramTypes, IMethod curr) throws JavaModelException {
        String[] currParamTypes;
        if (name.equals(curr.getElementName()) && paramTypes.length == (currParamTypes = curr.getParameterTypes()).length) {
            int i = 0;
            while (i < paramTypes.length) {
                String t2;
                String t1 = Signature.getSimpleName((String)Signature.toString((String)paramTypes[i]));
                if (!t1.equals(t2 = Signature.getSimpleName((String)Signature.toString((String)currParamTypes[i])))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static IMethod[] getMethods(IType classType) throws JavaModelException {
        IType[] superTypes;
        if (classType == null) {
            return null;
        }
        ArrayList methodList = new ArrayList();
        IMethod[] methods = classType.getMethods();
        JavaClassUtils.copyToMethodList(methodList, methods);
        ITypeHierarchy typeHierarchy = classType.newSupertypeHierarchy(null);
        if (typeHierarchy != null && (superTypes = typeHierarchy.getAllSuperclasses(classType)) != null && superTypes.length > 0) {
            int i = 0;
            while (i < superTypes.length) {
                if (!superTypes[i].getFullyQualifiedName().equals("java.lang.Object")) {
                    methods = superTypes[i].getMethods();
                    JavaClassUtils.copyToMethodList(methodList, methods);
                }
                ++i;
            }
        }
        if (methodList != null && methodList.size() > 0) {
            IMethod[] validMethods = methodList.toArray(new IMethod[methodList.size()]);
            Arrays.sort(validMethods, new Comparator(){

                public int compare(Object o1, Object o2) {
                    String name1 = ((IMethod)o1).getElementName();
                    String name2 = ((IMethod)o2).getElementName();
                    return name1.compareTo(name2);
                }
            });
            return validMethods;
        }
        return null;
    }

    public static String getQualifiedTypeNameInTypeHierarchy(IType classType, String signatureName) {
        int arrayNum = 0;
        while (signatureName.startsWith("[")) {
            ++arrayNum;
            signatureName = signatureName.substring(1);
        }
        String qualifiedTypeName = Signature.toString((String)signatureName);
        int kind = Signature.getTypeSignatureKind((String)signatureName);
        if (kind == 2 || signatureName.equals("V")) {
            while (arrayNum > 0) {
                qualifiedTypeName = String.valueOf(qualifiedTypeName) + "[]";
                --arrayNum;
            }
            return qualifiedTypeName;
        }
        String typeName = Signature.toString((String)signatureName);
        String foundName = JavaClassUtils.getQualifiedTypeName(classType, typeName);
        if (foundName != null) {
            qualifiedTypeName = foundName;
        } else {
            IType[] superTypes;
            ITypeHierarchy typeHierarchy = null;
            try {
                typeHierarchy = classType.newSupertypeHierarchy(null);
            }
            catch (JavaModelException javaModelException) {}
            if (typeHierarchy != null && (superTypes = typeHierarchy.getAllSupertypes(classType)) != null && superTypes.length > 0) {
                int i = 0;
                while (i < superTypes.length) {
                    if (!superTypes[i].getFullyQualifiedName().equals("java.lang.Object") && (foundName = JavaClassUtils.getQualifiedTypeName(superTypes[i], typeName)) != null) {
                        qualifiedTypeName = foundName;
                        break;
                    }
                    ++i;
                }
            }
        }
        while (arrayNum > 0) {
            qualifiedTypeName = String.valueOf(qualifiedTypeName) + "[]";
            --arrayNum;
        }
        return qualifiedTypeName;
    }

    public static String getQualifiedTypeName(IType classType, String typeName) {
        String qualifiedTypeName = null;
        try {
            String[][] resolvedNames = classType.resolveType(typeName);
            if (resolvedNames != null && resolvedNames.length > 0) {
                qualifiedTypeName = JavaModelUtil.concatenateName((String)resolvedNames[0][0], (String)resolvedNames[0][1]);
            }
        }
        catch (JavaModelException javaModelException) {}
        return qualifiedTypeName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isSubClassOf(IJavaProject jProject, String subClass, String superClass) {
        if (jProject == null) return false;
        if (subClass == null) return false;
        if (superClass == null) {
            return false;
        }
        try {
            IType subClassType = jProject.findType(subClass);
            if (subClassType == null) return false;
            ITypeHierarchy typeHierarchy = null;
            try {
                typeHierarchy = subClassType.newSupertypeHierarchy(null);
            }
            catch (JavaModelException javaModelException) {}
            IType[] superTypes = typeHierarchy.getAllSupertypes(subClassType);
            if (superTypes == null) return false;
            if (superTypes.length <= 0) return false;
            int i = 0;
            while (true) {
                if (i >= superTypes.length) {
                    return false;
                }
                if (superTypes[i].getFullyQualifiedName().equals(superClass)) {
                    return true;
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }
}

