/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.core.connection;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.connection.CallableStatementAdapter;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfoImpl;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionManagerImpl;
import org.eclipse.wst.rdb.internal.core.connection.IConnectionTest;
import org.eclipse.wst.rdb.internal.core.connection.INativeConnectionLock;
import org.eclipse.wst.rdb.internal.core.connection.JDBCManager;
import org.eclipse.wst.rdb.internal.core.connection.PreparedStatementAdapter;
import org.eclipse.wst.rdb.internal.core.connection.StatementAdapter;

public class ConnectionAdapter
implements Connection {
    private static final HashMap testMap = new HashMap();
    private static final String DEBUG_INITIALIZE = "Initialize";
    private static final String DEBUG_RELEASE = "Release";
    private ConnectionInfoImpl info;
    private Connection connection;
    private int statementCount;
    private JDBCManager.IConnectionThread connectionThread;
    private boolean debug;
    private boolean debugStatement;
    private boolean debugCount;
    private boolean forceOpen;

    static {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("org.eclipse.wst.rdb.core", "connectionTest");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                if (configElements[j].getName().equals("provider")) {
                    String product = configElements[j].getAttribute("product");
                    try {
                        IConnectionTest test = (IConnectionTest)configElements[j].createExecutableExtension("class");
                        testMap.put(product, test);
                    }
                    catch (CoreException e) {
                        Status status = new Status(4, RDBCorePlugin.getDefault().getBundle().getSymbolicName(), 4, "Error loading Database Connection tests", (Throwable)e);
                        RDBCorePlugin.getDefault().getLog().log((IStatus)status);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private void debug(String statement) {
        if (this.debug) {
            System.out.println(statement);
        }
    }

    private void printStack(String message) {
        if (this.debugStatement) {
            Thread.dumpStack();
        }
        if (this.debugCount) {
            System.out.println(String.valueOf(message) + " ** Count -> " + this.statementCount);
        }
    }

    private void reopenNativeConnection() throws Exception {
        this.debug("Start Reopen Native -> " + this.info.getName());
        this.connectionThread = (JDBCManager.IConnectionThread)this.connectionThread.clone();
        Connection tempConnection = this.connectionThread.activateConnection(this);
        if (tempConnection != null) {
            this.connection = tempConnection;
        }
        this.debug("End Reopen Native -> " + this.info.getName());
    }

    /*
     * Exception decompiling
     */
    private void checkConnectionOpen() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [3 : 127->131)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void initializeStatementIntegrity() throws SQLException {
        ++this.statementCount;
        try {
            this.initializeConnectionIntegrity();
        }
        catch (SQLException e) {
            --this.statementCount;
            throw e;
        }
    }

    private void initializeConnectionIntegrity() throws SQLException {
        try {
            if (this.info.hasTimedOut()) {
                this.debug("Start Reopen Native [this.info.hasTimedOut()]");
                this.reopenNativeConnection();
            } else if (this.connection != null && this.connection.isClosed()) {
                this.debug("Start Reopen Native [this.connection != null && connection.isClosed()]");
                this.reopenNativeConnection();
            } else {
                this.checkConnectionOpen();
            }
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    private synchronized void cleanUpConnectionThread() {
        if (this.connectionThread != null) {
            this.connectionThread.interrupt();
        }
    }

    private synchronized Statement createStatementAdapter(Statement s) throws SQLException {
        return new StatementAdapter(this, s);
    }

    private synchronized CallableStatement createCallableStatementAdapter(CallableStatement s) throws SQLException {
        return new CallableStatementAdapter(this, s);
    }

    private synchronized PreparedStatement createPreparedStatementAdapter(PreparedStatement s) throws SQLException {
        return new PreparedStatementAdapter(this, s);
    }

    private void logException(SQLException e) {
        Status status = new Status(4, RDBCorePlugin.getDefault().getBundle().getSymbolicName(), 4, e.getClass().getName(), (Throwable)e);
        RDBCorePlugin.getDefault().getLog().log((IStatus)status);
        this.info.onSQLException(this, e);
    }

    public ConnectionAdapter(ConnectionInfo info, Connection connection) {
        this.info = (ConnectionInfoImpl)info;
        this.connection = connection;
        this.statementCount = 0;
        this.forceOpen = false;
        this.debug = ((ConnectionManagerImpl)RDBCorePlugin.getDefault().getConnectionManager()).isDebugging();
        this.debugStatement = ((ConnectionManagerImpl)RDBCorePlugin.getDefault().getConnectionManager()).isDebuggingStatement();
        this.debugCount = ((ConnectionManagerImpl)RDBCorePlugin.getDefault().getConnectionManager()).isDebuggingCountStatement();
    }

    public void setNativeConnection(Connection connection) {
        this.connection = connection;
    }

    public void setConnectionThread(JDBCManager.IConnectionThread connectionThread) {
        this.connectionThread = connectionThread;
    }

    public INativeConnectionLock getNativeConnectionLock() {
        return new INativeConnectionLock(){

            public Connection lockJDBCConnection() throws SQLException {
                ConnectionAdapter.this.initializeConnectionIntegrity();
                ConnectionAdapter.this.debug(" -- Acquiring Native Connection Lock -- ");
                ConnectionAdapter.this.forceOpen = true;
                return ConnectionAdapter.this.getNativeConnection();
            }

            public void releaseLock() {
                ConnectionAdapter.this.forceOpen = false;
                ConnectionAdapter.this.debug(" -- Releasing Native Connection Lock -- ");
            }
        };
    }

    public ConnectionInfo getConnectionInfo() {
        return this.info;
    }

    public Connection getNativeConnection() {
        return this.connection;
    }

    public synchronized void releaseStatement() {
        if (this.statementCount > 0) {
            --this.statementCount;
        }
        this.printStack(DEBUG_RELEASE);
    }

    public String nativeSQL(String arg0) throws SQLException {
        this.initializeConnectionIntegrity();
        return this.nativeSQL(arg0);
    }

    public void setAutoCommit(boolean arg0) throws SQLException {
        this.initializeConnectionIntegrity();
        this.connection.setAutoCommit(arg0);
    }

    public boolean getAutoCommit() throws SQLException {
        this.initializeConnectionIntegrity();
        return this.connection.getAutoCommit();
    }

    public void commit() throws SQLException {
        this.connection.commit();
    }

    public void rollback() throws SQLException {
        this.connection.rollback();
    }

    public synchronized boolean timeOut() throws SQLException {
        if (this.statementCount == 0 && !this.isClosed() && !this.forceOpen) {
            this.debug("Timed-out and Close JDBC Connection...");
            this.connection.close();
            this.cleanUpConnectionThread();
            return true;
        }
        if (this.statementCount != 0 && !this.forceOpen) {
            this.debug("Cannot close - Statement count -> " + this.statementCount);
        } else if (this.forceOpen) {
            this.debug("** Force Open **");
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void close() throws SQLException {
        try {
            if (!this.isClosed()) {
                this.debug("*** Close JDBC Connection... *** Connection [" + this.connection.toString() + "] - Connection Name -> " + this.info.getName());
                this.connection.close();
                this.cleanUpConnectionThread();
            }
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            ConnectionManagerImpl.INSTANCE.disconnect(this.info, this);
            this.connectionThread = null;
            this.connection = null;
            throw throwable;
        }
        {
            Object var1_3 = null;
            ConnectionManagerImpl.INSTANCE.disconnect(this.info, this);
            this.connectionThread = null;
            this.connection = null;
            return;
        }
    }

    public boolean isClosed() throws SQLException {
        return this.connection == null || this.connection.isClosed();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.initializeConnectionIntegrity();
        return this.connection.getMetaData();
    }

    public void setReadOnly(boolean arg0) throws SQLException {
        this.connection.setReadOnly(arg0);
    }

    public boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    public void setCatalog(String arg0) throws SQLException {
        this.connection.setCatalog(arg0);
    }

    public String getCatalog() throws SQLException {
        return this.connection.getCatalog();
    }

    public void setTransactionIsolation(int arg0) throws SQLException {
        this.connection.setTransactionIsolation(arg0);
    }

    public int getTransactionIsolation() throws SQLException {
        return this.connection.getTransactionIsolation();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.connection.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.connection.clearWarnings();
    }

    public Map getTypeMap() throws SQLException {
        return this.connection.getTypeMap();
    }

    public void setTypeMap(Map arg0) throws SQLException {
        this.connection.setTypeMap(arg0);
    }

    public void setHoldability(int arg0) throws SQLException {
        this.connection.setHoldability(arg0);
    }

    public int getHoldability() throws SQLException {
        return this.connection.getHoldability();
    }

    public Savepoint setSavepoint() throws SQLException {
        return this.connection.setSavepoint();
    }

    public Savepoint setSavepoint(String arg0) throws SQLException {
        return this.connection.setSavepoint(arg0);
    }

    public void rollback(Savepoint arg0) throws SQLException {
        this.connection.rollback(arg0);
    }

    public void releaseSavepoint(Savepoint arg0) throws SQLException {
        this.connection.releaseSavepoint(arg0);
    }

    public synchronized Statement createStatement() throws SQLException {
        try {
            this.initializeStatementIntegrity();
            this.printStack(DEBUG_INITIALIZE);
            return this.createStatementAdapter(this.connection.createStatement());
        }
        catch (SQLException e) {
            this.releaseStatement();
            this.logException(e);
            throw e;
        }
    }

    public synchronized PreparedStatement prepareStatement(String arg0) throws SQLException {
        try {
            this.initializeStatementIntegrity();
            this.printStack(DEBUG_INITIALIZE);
            return this.createPreparedStatementAdapter(this.connection.prepareStatement(arg0));
        }
        catch (SQLException e) {
            this.releaseStatement();
            this.logException(e);
            throw e;
        }
    }

    public synchronized CallableStatement prepareCall(String arg0) throws SQLException {
        try {
            this.initializeStatementIntegrity();
            this.printStack(DEBUG_INITIALIZE);
            return this.createCallableStatementAdapter(this.connection.prepareCall(arg0));
        }
        catch (SQLException e) {
            this.releaseStatement();
            this.logException(e);
            throw e;
        }
    }

    public Statement createStatement(int arg0, int arg1) throws SQLException {
        try {
            this.initializeStatementIntegrity();
            this.printStack(DEBUG_INITIALIZE);
            return this.createStatementAdapter(this.connection.createStatement(arg0, arg1));
        }
        catch (SQLException e) {
            this.releaseStatement();
            this.logException(e);
            throw e;
        }
    }

    public PreparedStatement prepareStatement(String arg0, int arg1, int arg2) throws SQLException {
        try {
            this.initializeStatementIntegrity();
            this.printStack(DEBUG_INITIALIZE);
            return this.createPreparedStatementAdapter(this.connection.prepareStatement(arg0, arg1, arg2));
        }
        catch (SQLException e) {
            this.releaseStatement();
            this.logException(e);
            throw e;
        }
    }

    public CallableStatement prepareCall(String arg0, int arg1, int arg2) throws SQLException {
        try {
            this.initializeStatementIntegrity();
            this.printStack(DEBUG_INITIALIZE);
            return this.createCallableStatementAdapter(this.connection.prepareCall(arg0, arg1, arg2));
        }
        catch (SQLException e) {
            this.releaseStatement();
            this.logException(e);
            throw e;
        }
    }

    public Statement createStatement(int arg0, int arg1, int arg2) throws SQLException {
        try {
            this.initializeStatementIntegrity();
            this.printStack(DEBUG_INITIALIZE);
            return this.createStatementAdapter(this.connection.createStatement(arg0, arg1, arg2));
        }
        catch (SQLException e) {
            this.releaseStatement();
            this.logException(e);
            throw e;
        }
    }

    public PreparedStatement prepareStatement(String arg0, int arg1, int arg2, int arg3) throws SQLException {
        try {
            this.initializeStatementIntegrity();
            this.printStack(DEBUG_INITIALIZE);
            return this.createPreparedStatementAdapter(this.connection.prepareStatement(arg0, arg1, arg2, arg3));
        }
        catch (SQLException e) {
            this.releaseStatement();
            this.logException(e);
            throw e;
        }
    }

    public CallableStatement prepareCall(String arg0, int arg1, int arg2, int arg3) throws SQLException {
        try {
            this.initializeStatementIntegrity();
            this.printStack(DEBUG_INITIALIZE);
            return this.createCallableStatementAdapter(this.connection.prepareCall(arg0, arg1, arg2, arg3));
        }
        catch (SQLException e) {
            this.releaseStatement();
            this.logException(e);
            throw e;
        }
    }

    public PreparedStatement prepareStatement(String arg0, int arg1) throws SQLException {
        try {
            this.initializeStatementIntegrity();
            this.printStack(DEBUG_INITIALIZE);
            return this.createPreparedStatementAdapter(this.connection.prepareStatement(arg0, arg1));
        }
        catch (SQLException e) {
            this.releaseStatement();
            this.logException(e);
            throw e;
        }
    }

    public PreparedStatement prepareStatement(String arg0, int[] arg1) throws SQLException {
        try {
            this.initializeStatementIntegrity();
            this.printStack(DEBUG_INITIALIZE);
            return this.createPreparedStatementAdapter(this.connection.prepareStatement(arg0, arg1));
        }
        catch (SQLException e) {
            this.releaseStatement();
            this.logException(e);
            throw e;
        }
    }

    public PreparedStatement prepareStatement(String arg0, String[] arg1) throws SQLException {
        try {
            this.initializeStatementIntegrity();
            this.printStack(DEBUG_INITIALIZE);
            return this.createPreparedStatementAdapter(this.connection.prepareStatement(arg0, arg1));
        }
        catch (SQLException e) {
            this.releaseStatement();
            this.logException(e);
            throw e;
        }
    }
}

