/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.derby.catalog;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionFilter;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.rte.ICatalogObject;
import org.eclipse.wst.rdb.internal.core.rte.RefreshManager;
import org.eclipse.wst.rdb.internal.derby.catalog.DerbyCatalogSchema;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;
import org.eclipse.wst.rdb.internal.models.sql.schema.impl.DatabaseImpl;

public class DerbyCatalogDatabase
extends DatabaseImpl
implements ICatalogObject {
    private static final long serialVersionUID = 3257562914901669687L;
    private Connection connection;
    private boolean schemasLoaded = false;

    public DerbyCatalogDatabase(Connection connection) {
        if (connection == null) {
            System.err.println("null connection");
            throw new RuntimeException();
        }
        this.connection = connection;
    }

    public synchronized void refresh() {
        if (this.schemasLoaded) {
            this.schemasLoaded = false;
            this.schemas.clear();
        }
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public EList getSchemas() {
        if (!this.schemasLoaded) {
            this.loadSchemas();
        }
        return this.schemas;
    }

    public boolean isSystemObject() {
        return false;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Database getCatalogDatabase() {
        return this;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 9) {
            this.getSchemas();
        }
        return super.eIsSet(eFeature);
    }

    private synchronized void loadSchemas() {
        if (this.schemasLoaded) {
            return;
        }
        EList schemaList = super.getSchemas();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            ConnectionInfo connectionInfo = RDBCorePlugin.getDefault().getConnectionManager().getConnectionInfo((SQLObject)this);
            ConnectionFilter filter = connectionInfo.getFilter(String.valueOf(this.getName()) + "::" + "DatatoolsSchemaFilterPredicate");
            if (filter == null) {
                filter = connectionInfo.getFilter("DatatoolsSchemaFilterPredicate");
            }
            String query = "SELECT SCHEMANAME FROM SYS.SYSSCHEMAS";
            if (filter != null) {
                query = String.valueOf(query) + " WHERE SCHEMANAME " + filter.getPredicate();
            }
            Statement s = this.connection.createStatement();
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                String schemaName = r.getString(1);
                DerbyCatalogSchema schema = new DerbyCatalogSchema();
                schema.setName(schemaName);
                schemaList.add((Object)schema);
            }
            this.schemasLoaded = true;
            r.close();
            s.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        this.eSetDeliver(deliver);
    }
}

