/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.tests.dbdefinition;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;
import org.eclipse.wst.rdb.internal.models.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.wst.rdb.internal.models.sql.routines.Procedure;
import org.eclipse.wst.rdb.internal.models.sql.routines.SQLRoutinesFactory;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;

public class OracleTest
extends TestCase {
    private final int MAXIMUM_IDENTIFIER_LENGTH_COLUMN_8 = 30;
    private final int MAXIMUM_IDENTIFIER_LENGTH_DATABASE_8 = 8;
    private final int MAXIMUM_IDENTIFIER_LENGTH_SCHEMA_8 = 30;
    private final int MAXIMUM_IDENTIFIER_LENGTH_STORED_PROCEDURE_8 = 30;
    private final int MAXIMUM_IDENTIFIER_LENGTH_TABLE_8 = 30;
    private final int MAXIMUM_IDENTIFIER_LENGTH_TABLESPACE_8 = 30;
    private final int MAXIMUM_IDENTIFIER_LENGTH_VIEW_8 = 30;
    private final int MAXIMUM_LENGTH_CHAR_8 = 2000;
    private final int MAXIMUM_LENGTH_NCHAR_8 = 2000;
    private final int MAXIMUM_LENGTH_NVARCHAR2_8 = 4000;
    private final int MAXIMUM_LENGTH_RAW_8 = 2000;
    private final int MAXIMUM_LENGTH_VARCHAR2_8 = 4000;
    private final int MAXIMUM_PRECISION_FLOAT_8 = 38;
    private final int MAXIMUM_PRECISION_NUMBER_8 = 38;
    private final int MAXIMUM_SCALE_NUMBER_8 = 127;
    private final int MINIMUM_SCALE_NUMBER_8 = -84;
    private final int MAXIMUM_IDENTIFIER_LENGTH_COLUMN_9 = 30;
    private final int MAXIMUM_IDENTIFIER_LENGTH_DATABASE_9 = 8;
    private final int MAXIMUM_IDENTIFIER_LENGTH_SCHEMA_9 = 30;
    private final int MAXIMUM_IDENTIFIER_LENGTH_STORED_PROCEDURE_9 = 30;
    private final int MAXIMUM_IDENTIFIER_LENGTH_TABLE_9 = 30;
    private final int MAXIMUM_IDENTIFIER_LENGTH_TABLESPACE_9 = 30;
    private final int MAXIMUM_IDENTIFIER_LENGTH_VIEW_9 = 30;
    private final int MAXIMUM_LENGTH_CHAR_9 = 2000;
    private final int MAXIMUM_LENGTH_NCHAR_9 = 2000;
    private final int MAXIMUM_LENGTH_NVARCHAR2_9 = 4000;
    private final int MAXIMUM_LENGTH_RAW_9 = 2000;
    private final int MAXIMUM_LENGTH_VARCHAR2_9 = 4000;
    private final int MAXIMUM_PRECISION_FLOAT_9 = 38;
    private final int MAXIMUM_PRECISION_NUMBER_9 = 38;
    private final int MAXIMUM_PRECISION_TIMESTAMP_9 = 9;
    private final int MAXIMUM_PRECISION_TIMESTAMP_WITH_LOCAL_TIME_ZONE_9 = 9;
    private final int MAXIMUM_PRECISION_TIMESTAMP_WITH_TIME_ZONE_9 = 9;
    private final int MAXIMUM_SCALE_NUMBER_9 = 127;
    private final int MINIMUM_SCALE_NUMBER_9 = -84;
    private final int MAXIMUM_IDENTIFIER_LENGTH_COLUMN_10 = 30;
    private final int MAXIMUM_IDENTIFIER_LENGTH_DATABASE_10 = 8;
    private final int MAXIMUM_IDENTIFIER_LENGTH_SCHEMA_10 = 30;
    private final int MAXIMUM_IDENTIFIER_LENGTH_STORED_PROCEDURE_10 = 30;
    private final int MAXIMUM_IDENTIFIER_LENGTH_TABLE_10 = 30;
    private final int MAXIMUM_IDENTIFIER_LENGTH_TABLESPACE_10 = 30;
    private final int MAXIMUM_IDENTIFIER_LENGTH_VIEW_10 = 30;
    private final int MAXIMUM_LENGTH_CHAR_10 = 2000;
    private final int MAXIMUM_LENGTH_NCHAR_10 = 2000;
    private final int MAXIMUM_LENGTH_NVARCHAR2_10 = 4000;
    private final int MAXIMUM_LENGTH_RAW_10 = 2000;
    private final int MAXIMUM_LENGTH_VARCHAR2_10 = 4000;
    private final int MAXIMUM_PRECISION_FLOAT_10 = 38;
    private final int MAXIMUM_PRECISION_NUMBER_10 = 38;
    private final int MAXIMUM_PRECISION_TIMESTAMP_10 = 9;
    private final int MAXIMUM_PRECISION_TIMESTAMP_WITH_LOCAL_TIME_ZONE_10 = 9;
    private final int MAXIMUM_PRECISION_TIMESTAMP_WITH_TIME_ZONE_10 = 9;
    private final int MAXIMUM_SCALE_NUMBER_10 = 127;
    private final int MINIMUM_SCALE_NUMBER_10 = -84;
    private final String strProduct = "Oracle";
    private final String PACKAGE_NAME = "org.eclipse.wst.rdb.internal.models.dbdefinition";
    private int expectedValue = 0;
    private int actualValue = 0;
    private Iterator productVersion = null;
    private Iterator dataType;
    private List dataTypeList;
    private ArrayList definitionCollection = new ArrayList();
    private ArrayList dbInformationCollection = new ArrayList();
    private String strProductVersion = null;
    private DatabaseDefinition definition = null;
    private PredefinedDataTypeDefinition typeDefinition = null;
    private Procedure procedure = null;

    public void setUp() {
        try {
            this.productVersion = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getVersions("Oracle");
            OracleTest.assertNotNull((String)"\nMethod: getVersions()\nError: The method returns a NULL value in startUp()", (Object)this.productVersion);
            while (this.productVersion.hasNext()) {
                this.strProductVersion = this.productVersion.next().toString();
                this.definition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition("Oracle", this.strProductVersion);
                OracleTest.assertNotNull((String)"\nMethod: getDefinition()\nError: The method returns a NULL value in startUp()", (Object)this.definition);
                this.dbInformationCollection.add(this.strProductVersion);
                this.definitionCollection.add(this.definition);
            }
        }
        catch (Exception e) {
            OracleTest.fail((String)("\nMethod: setUp()\nException: " + e.toString() + "\nDescription: The set up is incomplete"));
        }
    }

    public void testGetMaximumPrecision_NUMBER_8() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("8")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedValue = 38;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("NUMBER")) {
                            OracleTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumPrecision()", this.dbInformationCollection.get(i), "NUMBER"), (int)this.expectedValue, (int)this.typeDefinition.getMaximumPrecision());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getMaximumPrecision()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetMinumumScale_NUMBER_8() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("8")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedValue = -84;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("NUMBER")) {
                            OracleTest.assertEquals((String)this.getAssertionFailureMessage("getMinimumScale()", this.dbInformationCollection.get(i), "NUMBER"), (int)this.expectedValue, (int)this.typeDefinition.getMinimumScale());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getMinimumScale()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetMaximumScale_NUMBER_8() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("8")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedValue = 127;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("NUMBER")) {
                            OracleTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumScale()", this.dbInformationCollection.get(i), "NUMBER"), (int)this.expectedValue, (int)this.typeDefinition.getMaximumScale());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getMaximumScale()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetMaximumPrecision_FLOAT_8() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("8")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedValue = 38;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("FLOAT")) {
                            OracleTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumPrecision()", this.dbInformationCollection.get(i), "FLOAT"), (int)this.expectedValue, (int)this.typeDefinition.getMaximumPrecision());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getMaximumPrecision()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_CHAR_8() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("8")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedValue = 2000;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("CHAR")) {
                            OracleTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "CHAR"), (int)this.expectedValue, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_NCHAR_8() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("8")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedValue = 2000;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("NCHAR")) {
                            OracleTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "NCHAR"), (int)this.expectedValue, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_VARCHAR2_8() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("8")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedValue = 4000;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("VARCHAR2")) {
                            OracleTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "VARCHAR2"), (int)this.expectedValue, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_NVARCHAR2_8() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("8")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedValue = 4000;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("NVARCHAR2")) {
                            OracleTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "NVARCHAR2"), (int)this.expectedValue, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_RAW_8() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("8")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedValue = 2000;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("RAW")) {
                            OracleTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "RAW"), (int)this.expectedValue, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetDatabaseMaximumIdentifierLength_8() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("8")) {
                    this.actualValue = ((DatabaseDefinition)this.definitionCollection.get(i)).getDatabaseMaximumIdentifierLength();
                    this.expectedValue = 8;
                    OracleTest.assertEquals((String)this.getAssertionFailureMessage("getDatabaseMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedValue, (int)this.actualValue);
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getDatabaseMaximumIdentifierLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetSchemaMaximumIdentifierLength_8() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("8")) {
                    this.actualValue = ((DatabaseDefinition)this.definitionCollection.get(i)).getSchemaMaximumIdentifierLength();
                    this.expectedValue = 30;
                    OracleTest.assertEquals((String)this.getAssertionFailureMessage("getSchemaMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.actualValue, (int)this.expectedValue);
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getSchemaMaximumIdentifierLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetTableMaximumIdentifierLength_8() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("8")) {
                    this.actualValue = ((DatabaseDefinition)this.definitionCollection.get(i)).getTableMaximumIdentifierLength();
                    this.expectedValue = 30;
                    OracleTest.assertEquals((String)this.getAssertionFailureMessage("getTableMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedValue, (int)this.actualValue);
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getTableMaximumIdentifierLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetViewMaximumIdentifierLength_8() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("8")) {
                    this.actualValue = ((DatabaseDefinition)this.definitionCollection.get(i)).getViewMaximumIdentifierLength();
                    this.expectedValue = 30;
                    OracleTest.assertEquals((String)this.getAssertionFailureMessage("getViewMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedValue, (int)this.actualValue);
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getViewMaximumIdentifierLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetColumnMaximumIdentifierLength_8() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("8")) {
                    this.actualValue = ((DatabaseDefinition)this.definitionCollection.get(i)).getColumnMaximumIdentifierLength();
                    this.expectedValue = 30;
                    OracleTest.assertEquals((String)this.getAssertionFailureMessage("getColumnMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedValue, (int)this.actualValue);
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getColumnMaximumIdentifierLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetTablespaceMaximumIdentifierLength_8() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("8")) {
                    this.actualValue = ((DatabaseDefinition)this.definitionCollection.get(i)).getTablespaceMaximumIdentifierLength();
                    this.expectedValue = 30;
                    OracleTest.assertEquals((String)this.getAssertionFailureMessage("getTablespaceMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedValue, (int)this.actualValue);
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getTablespaceMaximumIdentifierLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetStoredProcedureMaximumIdentifierLength_8() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("8")) {
                    this.procedure = SQLRoutinesFactory.eINSTANCE.createProcedure();
                    this.actualValue = ((DatabaseDefinition)this.definitionCollection.get(i)).getMaximumIdentifierLength((SQLObject)this.procedure);
                    this.expectedValue = 30;
                    OracleTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumIdentifierLength(SQLObject sqlObject)", this.dbInformationCollection.get(i), ""), (int)this.expectedValue, (int)this.actualValue);
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getMaximumIdentifierLength(SQLObject sqlObject)", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetMaximumPrecision_NUMBER_9() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("9")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedValue = 38;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("NUMBER")) {
                            OracleTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumPrecision()", this.dbInformationCollection.get(i), "NUMBER"), (int)this.expectedValue, (int)this.typeDefinition.getMaximumPrecision());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getMaximumPrecision()", this.dbInformationCollection.get(2), e));
            }
            ++i;
        }
    }

    public void testGetMinumumScale_NUMBER_9() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("9")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedValue = -84;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("NUMBER")) {
                            OracleTest.assertEquals((String)this.getAssertionFailureMessage("getMinimumScale()", this.dbInformationCollection.get(i), "NUMBER"), (int)this.expectedValue, (int)this.typeDefinition.getMinimumScale());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getMinimumScale()", this.dbInformationCollection.get(2), e));
            }
            ++i;
        }
    }

    public void testGetMaximumScale_NUMBER_9() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("9")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedValue = 127;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("NUMBER")) {
                            OracleTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumScale()", this.dbInformationCollection.get(i), "NUMBER"), (int)this.expectedValue, (int)this.typeDefinition.getMaximumScale());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getMaximumScale()", this.dbInformationCollection.get(2), e));
            }
            ++i;
        }
    }

    public void testGetMaximumPrecision_FLOAT_9() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("9")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedValue = 38;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("FLOAT")) {
                            OracleTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumPrecision()", this.dbInformationCollection.get(i), "FLOAT"), (int)this.expectedValue, (int)this.typeDefinition.getMaximumPrecision());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getMaximumPrecision()", this.dbInformationCollection.get(2), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_CHAR_9() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("9")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedValue = 2000;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("CHAR")) {
                            OracleTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "CHAR"), (int)this.expectedValue, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(2), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_NCHAR_9() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("9")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedValue = 2000;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("NCHAR")) {
                            OracleTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "NCHAR"), (int)this.expectedValue, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(2), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_VARCHAR2_9() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("9")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedValue = 4000;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("VARCHAR2")) {
                            OracleTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "VARCHAR2"), (int)this.expectedValue, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(2), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_NVARCHAR2_9() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("9")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedValue = 4000;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("NVARCHAR2")) {
                            OracleTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "NVARCHAR2"), (int)this.expectedValue, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(2), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_RAW_9() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("9")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedValue = 2000;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("RAW")) {
                            OracleTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "RAW"), (int)this.expectedValue, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(2), e));
            }
            ++i;
        }
    }

    public void testGetMaximumPrecision_TIMESTAMP_WITH_TIME_ZONE_9() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("9")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedValue = 9;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("TIMESTAMP WITH TIME ZONE")) {
                            OracleTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumPrecision()", this.dbInformationCollection.get(i), "TIMESTAMP WITH TIME ZONE"), (int)this.expectedValue, (int)this.typeDefinition.getMaximumPrecision());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getMaximumPrecision()", this.dbInformationCollection.get(2), e));
            }
            ++i;
        }
    }

    public void testGetMaximumPrecision_TIMESTAMP_WITH_LOCAL_TIME_ZONE_9() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("9")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedValue = 9;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("TIMESTAMP WITH LOCAL TIME ZONE")) {
                            OracleTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumPrecision()", this.dbInformationCollection.get(i), "TIMESTAMP WITH LOCAL TIME ZONE"), (int)this.expectedValue, (int)this.typeDefinition.getMaximumPrecision());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getMaximumPrecision()", this.dbInformationCollection.get(2), e));
            }
            ++i;
        }
    }

    public void testGetMaximumPrecision_TIMESTAMP_9() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("9")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedValue = 9;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("TIMESTAMP")) {
                            OracleTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumPrecision()", this.dbInformationCollection.get(i), "TIMESTAMP"), (int)this.expectedValue, (int)this.typeDefinition.getMaximumPrecision());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getMaximumPrecision()", this.dbInformationCollection.get(2), e));
            }
            ++i;
        }
    }

    public void testGetDatabaseMaximumIdentifierLength_9() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("9")) {
                    this.actualValue = ((DatabaseDefinition)this.definitionCollection.get(i)).getDatabaseMaximumIdentifierLength();
                    this.expectedValue = 8;
                    OracleTest.assertEquals((String)this.getAssertionFailureMessage("getDatabaseMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedValue, (int)this.actualValue);
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getDatabaseMaximumIdentifierLength()", this.dbInformationCollection.get(2), e));
            }
            ++i;
        }
    }

    public void testGetSchemaMaximumIdentifierLength_9() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("9")) {
                    this.actualValue = ((DatabaseDefinition)this.definitionCollection.get(i)).getSchemaMaximumIdentifierLength();
                    this.expectedValue = 30;
                    OracleTest.assertEquals((String)this.getAssertionFailureMessage("getSchemaMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.actualValue, (int)this.expectedValue);
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getSchemaMaximumIdentifierLength()", this.dbInformationCollection.get(2), e));
            }
            ++i;
        }
    }

    public void testGetTableMaximumIdentifierLength_9() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("9")) {
                    this.actualValue = ((DatabaseDefinition)this.definitionCollection.get(i)).getTableMaximumIdentifierLength();
                    this.expectedValue = 30;
                    OracleTest.assertEquals((String)this.getAssertionFailureMessage("getTableMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedValue, (int)this.actualValue);
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getTableMaximumIdentifierLength()", this.dbInformationCollection.get(2), e));
            }
            ++i;
        }
    }

    public void testGetViewMaximumIdentifierLength_9() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("9")) {
                    this.actualValue = ((DatabaseDefinition)this.definitionCollection.get(i)).getViewMaximumIdentifierLength();
                    this.expectedValue = 30;
                    OracleTest.assertEquals((String)this.getAssertionFailureMessage("getViewMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedValue, (int)this.actualValue);
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getViewMaximumIdentifierLength()", this.dbInformationCollection.get(2), e));
            }
            ++i;
        }
    }

    public void testGetColumnMaximumIdentifierLength_9() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("9")) {
                    this.actualValue = ((DatabaseDefinition)this.definitionCollection.get(i)).getColumnMaximumIdentifierLength();
                    this.expectedValue = 30;
                    OracleTest.assertEquals((String)this.getAssertionFailureMessage("getColumnMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedValue, (int)this.actualValue);
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getColumnMaximumIdentifierLength()", this.dbInformationCollection.get(2), e));
            }
            ++i;
        }
    }

    public void testGetTablespaceMaximumIdentifierLength_9() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("9")) {
                    this.actualValue = ((DatabaseDefinition)this.definitionCollection.get(i)).getTablespaceMaximumIdentifierLength();
                    this.expectedValue = 30;
                    OracleTest.assertEquals((String)this.getAssertionFailureMessage("getTablespaceMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedValue, (int)this.actualValue);
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getTablespaceMaximumIdentifierLength()", this.dbInformationCollection.get(2), e));
            }
            ++i;
        }
    }

    public void testGetStoredProcedureMaximumIdentifierLength_9() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("9")) {
                    this.procedure = SQLRoutinesFactory.eINSTANCE.createProcedure();
                    this.actualValue = ((DatabaseDefinition)this.definitionCollection.get(i)).getMaximumIdentifierLength((SQLObject)this.procedure);
                    this.expectedValue = 30;
                    OracleTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumIdentifierLength(SQLObject sqlObject)", this.dbInformationCollection.get(i), ""), (int)this.expectedValue, (int)this.actualValue);
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getMaximumIdentifierLength(SQLObject sqlObject)", this.dbInformationCollection.get(2), e));
            }
            ++i;
        }
    }

    public void testGetMaximumPrecision_NUMBER_10() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("10")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedValue = 38;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("NUMBER")) {
                            OracleTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumPrecision()", this.dbInformationCollection.get(i), "NUMBER"), (int)this.expectedValue, (int)this.typeDefinition.getMaximumPrecision());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getMaximumPrecision()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetMinumumScale_NUMBER_10() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("10")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedValue = -84;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("NUMBER")) {
                            OracleTest.assertEquals((String)this.getAssertionFailureMessage("getMinimumScale()", this.dbInformationCollection.get(i), "NUMBER"), (int)this.expectedValue, (int)this.typeDefinition.getMinimumScale());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getMinimumScale()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetMaximumScale_NUMBER_10() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("10")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedValue = 127;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("NUMBER")) {
                            OracleTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumScale()", this.dbInformationCollection.get(i), "NUMBER"), (int)this.expectedValue, (int)this.typeDefinition.getMaximumScale());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getMaximumScale()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetMaximumPrecision_FLOAT_10() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("10")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedValue = 38;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("FLOAT")) {
                            OracleTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumPrecision()", this.dbInformationCollection.get(i), "FLOAT"), (int)this.expectedValue, (int)this.typeDefinition.getMaximumPrecision());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getMaximumPrecision()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_CHAR_10() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("10")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedValue = 2000;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("CHAR")) {
                            OracleTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "CHAR"), (int)this.expectedValue, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_NCHAR_10() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("10")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedValue = 2000;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("NCHAR")) {
                            OracleTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "NCHAR"), (int)this.expectedValue, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_VARCHAR2_10() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("10")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedValue = 4000;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("VARCHAR2")) {
                            OracleTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "VARCHAR2"), (int)this.expectedValue, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_NVARCHAR2_10() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("10")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedValue = 4000;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("NVARCHAR2")) {
                            OracleTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "NVARCHAR2"), (int)this.expectedValue, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_RAW_10() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("10")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedValue = 2000;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("RAW")) {
                            OracleTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "RAW"), (int)this.expectedValue, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetMaximumPrecision_TIMESTAMP_WITH_TIME_ZONE_10() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("10")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedValue = 9;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("TIMESTAMP WITH TIME ZONE")) {
                            OracleTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumPrecision()", this.dbInformationCollection.get(i), "TIMESTAMP WITH TIME ZONE"), (int)this.expectedValue, (int)this.typeDefinition.getMaximumPrecision());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getMaximumPrecision()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetMaximumPrecision_TIMESTAMP_WITH_LOCAL_TIME_ZONE_10() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("10")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedValue = 9;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("TIMESTAMP WITH LOCAL TIME ZONE")) {
                            OracleTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumPrecision()", this.dbInformationCollection.get(i), "TIMESTAMP WITH LOCAL TIME ZONE"), (int)this.expectedValue, (int)this.typeDefinition.getMaximumPrecision());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getMaximumPrecision()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetMaximumPrecision_TIMESTAMP_10() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("10")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedValue = 9;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("TIMESTAMP")) {
                            OracleTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumPrecision()", this.dbInformationCollection.get(i), "TIMESTAMP"), (int)this.expectedValue, (int)this.typeDefinition.getMaximumPrecision());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getMaximumPrecision()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetDatabaseMaximumIdentifierLength_10() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("10")) {
                    this.actualValue = ((DatabaseDefinition)this.definitionCollection.get(i)).getDatabaseMaximumIdentifierLength();
                    this.expectedValue = 8;
                    OracleTest.assertEquals((String)this.getAssertionFailureMessage("getDatabaseMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedValue, (int)this.actualValue);
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getDatabaseMaximumIdentifierLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetSchemaMaximumIdentifierLength_10() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("10")) {
                    this.actualValue = ((DatabaseDefinition)this.definitionCollection.get(i)).getSchemaMaximumIdentifierLength();
                    this.expectedValue = 30;
                    OracleTest.assertEquals((String)this.getAssertionFailureMessage("getSchemaMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.actualValue, (int)this.expectedValue);
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getSchemaMaximumIdentifierLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetTableMaximumIdentifierLength_10() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("10")) {
                    this.actualValue = ((DatabaseDefinition)this.definitionCollection.get(i)).getTableMaximumIdentifierLength();
                    this.expectedValue = 30;
                    OracleTest.assertEquals((String)this.getAssertionFailureMessage("getTableMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedValue, (int)this.actualValue);
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getTableMaximumIdentifierLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetViewMaximumIdentifierLength_10() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("10")) {
                    this.actualValue = ((DatabaseDefinition)this.definitionCollection.get(i)).getViewMaximumIdentifierLength();
                    this.expectedValue = 30;
                    OracleTest.assertEquals((String)this.getAssertionFailureMessage("getViewMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedValue, (int)this.actualValue);
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getViewMaximumIdentifierLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetColumnMaximumIdentifierLength_10() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("10")) {
                    this.actualValue = ((DatabaseDefinition)this.definitionCollection.get(i)).getColumnMaximumIdentifierLength();
                    this.expectedValue = 30;
                    OracleTest.assertEquals((String)this.getAssertionFailureMessage("getColumnMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedValue, (int)this.actualValue);
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getColumnMaximumIdentifierLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetTablespaceMaximumIdentifierLength_10() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("10")) {
                    this.actualValue = ((DatabaseDefinition)this.definitionCollection.get(i)).getTablespaceMaximumIdentifierLength();
                    this.expectedValue = 30;
                    OracleTest.assertEquals((String)this.getAssertionFailureMessage("getTablespaceMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedValue, (int)this.actualValue);
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getTablespaceMaximumIdentifierLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetStoredProcedureMaximumIdentifierLength_10() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("10")) {
                    this.procedure = SQLRoutinesFactory.eINSTANCE.createProcedure();
                    this.actualValue = ((DatabaseDefinition)this.definitionCollection.get(i)).getMaximumIdentifierLength((SQLObject)this.procedure);
                    this.expectedValue = 30;
                    OracleTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumIdentifierLength(SQLObject sqlObject)", this.dbInformationCollection.get(i), ""), (int)this.expectedValue, (int)this.actualValue);
                }
            }
            catch (Exception e) {
                OracleTest.fail((String)this.getExceptionMessage("getMaximumIdentifierLength(SQLObject sqlObject)", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    private String getAssertionFailureMessage(String methodName, Object versionName, String dataName) {
        String temp = "\nData type: ";
        if (dataName.equals("")) {
            temp = "";
        }
        return "\nPackage: org.eclipse.wst.rdb.internal.models.dbdefinition\nMethod: " + methodName + "\nProduct: " + "Oracle" + "\nVersion: " + versionName + temp + dataName + "\nResult: The actual value does not agree with vendor doc. ";
    }

    private String getExceptionMessage(String methodName, Object versionName, Exception e) {
        return "\nMethod: " + methodName + "\nProduct: " + "Oracle" + "\nVersion: " + versionName + "\nException: " + e.toString() + "\nDescription: The exception is thrown in the test case";
    }

    private int getProperIndex(int rawIndex) {
        if (rawIndex == 0) {
            return 1;
        }
        if (rawIndex == 1) {
            return 2;
        }
        return 0;
    }

    public void tearDown() {
        this.expectedValue = 0;
        this.actualValue = 0;
        this.productVersion = null;
        this.dataType = null;
        this.dataTypeList = null;
        this.definitionCollection = new ArrayList();
        this.dbInformationCollection = new ArrayList();
        this.strProductVersion = null;
        this.definition = null;
        this.typeDefinition = null;
        this.procedure = null;
    }
}

