/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.tests.dbdefinition;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;
import org.eclipse.wst.rdb.internal.models.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.wst.rdb.internal.models.sql.routines.Procedure;
import org.eclipse.wst.rdb.internal.models.sql.routines.SQLRoutinesFactory;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;

public class SQLServerTest
extends TestCase {
    private final int MAXIMUM_IDENTIFIER_LENGTH_COLUMN_2000 = 128;
    private final int MAXIMUM_IDENTIFIER_LENGTH_DATABASE_2000 = 128;
    private final int MAXIMUM_IDENTIFIER_LENGTH_SCHEMA_2000 = 128;
    private final int MAXIMUM_IDENTIFIER_LENGTH_STORED_PROCEDURE_2000 = 128;
    private final int MAXIMUM_IDENTIFIER_LENGTH_TABLE_2000 = 128;
    private final int MAXIMUM_IDENTIFIER_LENGTH_TRIGGER_2000 = 128;
    private final int MAXIMUM_IDENTIFIER_LENGTH_VIEW_2000 = 128;
    private final int MAXIMUM_LENGTH_BINARY_2000 = 8000;
    private final int MAXIMUM_LENGTH_CHAR_2000 = 8000;
    private final int MAXIMUM_LENGTH_NCHAR_2000 = 4000;
    private final int MAXIMUM_LENGTH_VARBINARY_2000 = 8000;
    private final int MAXIMUM_LENGTH_VARCHAR_2000 = 8000;
    private final int MAXIMUM_PRECISION_DECIMAL_2000 = 38;
    private final int MAXIMUM_PRECISION_FLOAT_2000 = 53;
    private final int MAXIMUM_PRECISION_NUMERIC_2000 = 38;
    private final int MAXIMUM_IDENTIFIER_LENGTH_COLUMN_2005 = 128;
    private final int MAXIMUM_IDENTIFIER_LENGTH_DATABASE_2005 = 128;
    private final int MAXIMUM_IDENTIFIER_LENGTH_SCHEMA_2005 = 128;
    private final int MAXIMUM_IDENTIFIER_LENGTH_STORED_PROCEDURE_2005 = 128;
    private final int MAXIMUM_IDENTIFIER_LENGTH_TABLE_2005 = 128;
    private final int MAXIMUM_IDENTIFIER_LENGTH_TRIGGER_2005 = 128;
    private final int MAXIMUM_IDENTIFIER_LENGTH_VIEW_2005 = 128;
    private final int MAXIMUM_LENGTH_BINARY_2005 = 8000;
    private final int MAXIMUM_LENGTH_CHAR_2005 = 8000;
    private final int MAXIMUM_LENGTH_NCHAR_2005 = 4000;
    private final int MAXIMUM_LENGTH_VARBINARY_2005 = 8000;
    private final int MAXIMUM_LENGTH_VARCHAR_2005 = 8000;
    private final int MAXIMUM_PRECISION_DECIMAL_2005 = 38;
    private final int MAXIMUM_PRECISION_FLOAT_2005 = 53;
    private final int MAXIMUM_PRECISION_NUMERIC_2005 = 38;
    private final String strProduct = "SQL Server";
    private final String PACKAGE_NAME = "org.eclipse.wst.rdb.internal.models.dbdefinition";
    private int expectedMaxPrecision = 0;
    private int expectedMaxLength = 0;
    private int expectedIdentifierLength = 0;
    private int actualIdentifierLength = 0;
    private Iterator productVersion = null;
    private Iterator dataType;
    private List dataTypeList;
    private ArrayList definitionCollection = new ArrayList();
    private ArrayList dbInformationCollection = new ArrayList();
    private String strProductVersion = null;
    private DatabaseDefinition definition = null;
    private PredefinedDataTypeDefinition typeDefinition = null;
    private Procedure procedure = null;

    public void setUp() {
        try {
            this.productVersion = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getVersions("SQL Server");
            SQLServerTest.assertNotNull((String)"\nMethod: getVersions()\nError: The method returns a NULL value in startUp()", (Object)this.productVersion);
            while (this.productVersion.hasNext()) {
                this.strProductVersion = this.productVersion.next().toString();
                this.definition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition("SQL Server", this.strProductVersion);
                SQLServerTest.assertNotNull((String)"\nMethod: getDefinition()\nError: The method returns a NULL value in startUp()", (Object)this.definition);
                this.dbInformationCollection.add(this.strProductVersion);
                this.definitionCollection.add(this.definition);
            }
        }
        catch (Exception e) {
            SQLServerTest.fail((String)("\nMethod: setUp()\nException: " + e.toString() + "\nDescription: The set up is incomplete"));
        }
    }

    public void testGetMaximumPrecision_DECIMAL_2000() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("2000")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxPrecision = 38;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("DECIMAL")) {
                            SQLServerTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumPrecision()", this.dbInformationCollection.get(i), "DECIMAL"), (int)this.expectedMaxPrecision, (int)this.typeDefinition.getMaximumPrecision());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                SQLServerTest.fail((String)this.getExceptionMessage("getMaximumPrecision()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetMaximumPrecision_NUMERIC_2000() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("2000")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxPrecision = 38;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("NUMERIC")) {
                            SQLServerTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumPrecision()", this.dbInformationCollection.get(i), "NUMERIC"), (int)this.expectedMaxPrecision, (int)this.typeDefinition.getMaximumPrecision());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                SQLServerTest.fail((String)this.getExceptionMessage("getMaximumPrecision()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetMaximumPrecision_FLOAT_2000() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("2000")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxPrecision = 53;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("FLOAT")) {
                            SQLServerTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumPrecision()", this.dbInformationCollection.get(i), "FLOAT"), (int)this.expectedMaxPrecision, (int)this.typeDefinition.getMaximumPrecision());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                SQLServerTest.fail((String)this.getExceptionMessage("getMaximumPrecision()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_CHAR_2000() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("2000")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxLength = 8000;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("CHAR")) {
                            SQLServerTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "CHAR"), (int)this.expectedMaxLength, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                SQLServerTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_NCHAR_2000() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("2000")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxLength = 4000;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("NCHAR")) {
                            SQLServerTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "NCHAR"), (int)this.expectedMaxLength, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                SQLServerTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_VARCHAR_2000() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("2000")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxLength = 8000;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("VARCHAR")) {
                            SQLServerTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "VARCHAR"), (int)this.expectedMaxLength, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                SQLServerTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_BINARY_2000() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("2000")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxLength = 8000;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("BINARY")) {
                            SQLServerTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "BINARY"), (int)this.expectedMaxLength, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                SQLServerTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_VARBINARY_2000() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("2000")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxLength = 8000;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("VARBINARY")) {
                            SQLServerTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "VARBINARY"), (int)this.expectedMaxLength, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                SQLServerTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetDatabaseMaximumIdentifierLength_2000() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("2000")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getDatabaseMaximumIdentifierLength();
                    this.expectedIdentifierLength = 128;
                    SQLServerTest.assertEquals((String)this.getAssertionFailureMessage("getDatabaseMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                SQLServerTest.fail((String)this.getExceptionMessage("getDatabaseMaximumIdentifierLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetSchemaMaximumIdentifierLength_2000() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("2000")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getSchemaMaximumIdentifierLength();
                    this.expectedIdentifierLength = 128;
                    SQLServerTest.assertEquals((String)this.getAssertionFailureMessage("getSchemaMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                SQLServerTest.fail((String)this.getExceptionMessage("getSchemaMaximumIdentifierLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetTableMaximumIdentifierLength_2000() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("2000")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getTableMaximumIdentifierLength();
                    this.expectedIdentifierLength = 128;
                    SQLServerTest.assertEquals((String)this.getAssertionFailureMessage("getTableMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                SQLServerTest.fail((String)this.getExceptionMessage("getTableMaximumIdentifierLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetViewMaximumIdentifierLength_2000() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("2000")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getViewMaximumIdentifierLength();
                    this.expectedIdentifierLength = 128;
                    SQLServerTest.assertEquals((String)this.getAssertionFailureMessage("getViewMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                SQLServerTest.fail((String)this.getExceptionMessage("getViewMaximumIdentifierLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetColumnMaximumIdentifierLength_2000() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("2000")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getColumnMaximumIdentifierLength();
                    this.expectedIdentifierLength = 128;
                    SQLServerTest.assertEquals((String)this.getAssertionFailureMessage("getColumnMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                SQLServerTest.fail((String)this.getExceptionMessage("getColumnMaximumIdentifierLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetTriggerMaximumIdentifierLength_2000() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("2000")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getTriggerMaximumIdentifierLength();
                    this.expectedIdentifierLength = 128;
                    SQLServerTest.assertEquals((String)this.getAssertionFailureMessage("getTriggerMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                SQLServerTest.fail((String)this.getExceptionMessage("getTriggerMaximumIdentifierLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetStoredProcedureMaximumIdentifierLength_2000() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("2000")) {
                    this.procedure = SQLRoutinesFactory.eINSTANCE.createProcedure();
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getMaximumIdentifierLength((SQLObject)this.procedure);
                    this.expectedIdentifierLength = 128;
                    SQLServerTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumIdentifierLength(SQLObject sqlObject)", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                SQLServerTest.fail((String)this.getExceptionMessage("getMaximumIdentifierLength(SQLObject sqlObject)", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetMaximumPrecision_DECIMAL_2005() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("2005")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxPrecision = 38;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("DECIMAL")) {
                            SQLServerTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumPrecision()", this.dbInformationCollection.get(i), "DECIMAL"), (int)this.expectedMaxPrecision, (int)this.typeDefinition.getMaximumPrecision());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                SQLServerTest.fail((String)this.getExceptionMessage("getMaximumPrecision()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetMaximumPrecision_NUMERIC_2005() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("2005")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxPrecision = 38;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("NUMERIC")) {
                            SQLServerTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumPrecision()", this.dbInformationCollection.get(i), "NUMERIC"), (int)this.expectedMaxPrecision, (int)this.typeDefinition.getMaximumPrecision());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                SQLServerTest.fail((String)this.getExceptionMessage("getMaximumPrecision()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetMaximumPrecision_FLOAT_2005() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("2005")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxPrecision = 53;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("FLOAT")) {
                            SQLServerTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumPrecision()", this.dbInformationCollection.get(i), "FLOAT"), (int)this.expectedMaxPrecision, (int)this.typeDefinition.getMaximumPrecision());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                SQLServerTest.fail((String)this.getExceptionMessage("getMaximumPrecision()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_CHAR_2005() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("2005")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxLength = 8000;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("CHAR")) {
                            SQLServerTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "CHAR"), (int)this.expectedMaxLength, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                SQLServerTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_NCHAR_2005() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("2005")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxLength = 4000;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("NCHAR")) {
                            SQLServerTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "NCHAR"), (int)this.expectedMaxLength, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                SQLServerTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_VARCHAR_2005() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("2005")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxLength = 8000;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("VARCHAR")) {
                            SQLServerTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "VARCHAR"), (int)this.expectedMaxLength, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                SQLServerTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_BINARY_2005() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("2005")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxLength = 8000;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("BINARY")) {
                            SQLServerTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "BINARY"), (int)this.expectedMaxLength, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                SQLServerTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_VARBINARY_2005() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("2005")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxLength = 8000;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("VARBINARY")) {
                            SQLServerTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "VARBINARY"), (int)this.expectedMaxLength, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                SQLServerTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetDatabaseMaximumIdentifierLength_2005() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("2005")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getDatabaseMaximumIdentifierLength();
                    this.expectedIdentifierLength = 128;
                    SQLServerTest.assertEquals((String)this.getAssertionFailureMessage("getDatabaseMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                SQLServerTest.fail((String)this.getExceptionMessage("getDatabaseMaximumIdentifierLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetSchemaMaximumIdentifierLength_2005() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("2005")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getSchemaMaximumIdentifierLength();
                    this.expectedIdentifierLength = 128;
                    SQLServerTest.assertEquals((String)this.getAssertionFailureMessage("getSchemaMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                SQLServerTest.fail((String)this.getExceptionMessage("getSchemaMaximumIdentifierLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetTableMaximumIdentifierLength_2005() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("2005")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getTableMaximumIdentifierLength();
                    this.expectedIdentifierLength = 128;
                    SQLServerTest.assertEquals((String)this.getAssertionFailureMessage("getTableMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                SQLServerTest.fail((String)this.getExceptionMessage("getTableMaximumIdentifierLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetViewMaximumIdentifierLength_2005() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("2005")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getViewMaximumIdentifierLength();
                    this.expectedIdentifierLength = 128;
                    SQLServerTest.assertEquals((String)this.getAssertionFailureMessage("getViewMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                SQLServerTest.fail((String)this.getExceptionMessage("getViewMaximumIdentifierLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetColumnMaximumIdentifierLength_2005() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("2005")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getColumnMaximumIdentifierLength();
                    this.expectedIdentifierLength = 128;
                    SQLServerTest.assertEquals((String)this.getAssertionFailureMessage("getColumnMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                SQLServerTest.fail((String)this.getExceptionMessage("getColumnMaximumIdentifierLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetTriggerMaximumIdentifierLength_2005() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("2005")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getTriggerMaximumIdentifierLength();
                    this.expectedIdentifierLength = 128;
                    SQLServerTest.assertEquals((String)this.getAssertionFailureMessage("getTriggerMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                SQLServerTest.fail((String)this.getExceptionMessage("getTriggerMaximumIdentifierLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetStoredProcedureMaximumIdentifierLength_2005() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("2005")) {
                    this.procedure = SQLRoutinesFactory.eINSTANCE.createProcedure();
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getMaximumIdentifierLength((SQLObject)this.procedure);
                    this.expectedIdentifierLength = 128;
                    SQLServerTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumIdentifierLength(SQLObject sqlObject)", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                SQLServerTest.fail((String)this.getExceptionMessage("getMaximumIdentifierLength(SQLObject sqlObject)", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    private String getAssertionFailureMessage(String methodName, Object versionName, String dataName) {
        String temp = "\nData type: ";
        if (dataName.equals("")) {
            temp = "";
        }
        return "\nPackage: org.eclipse.wst.rdb.internal.models.dbdefinition\nMethod: " + methodName + "\nProduct: " + "SQL Server" + "\nVersion: " + versionName + temp + dataName + "\nResult: The actual value does not agree with vendor doc. ";
    }

    private String getExceptionMessage(String methodName, Object versionName, Exception e) {
        return "\nMethod: " + methodName + "\nProduct: " + "SQL Server" + "\nVersion: " + versionName + "\nException: " + e.toString() + "\nDescription: The exception is thrown in the test case";
    }

    public void tearDown() {
        this.expectedMaxPrecision = 0;
        this.expectedMaxLength = 0;
        this.expectedIdentifierLength = 0;
        this.actualIdentifierLength = 0;
        this.productVersion = null;
        this.dataType = null;
        this.dataTypeList = null;
        this.definitionCollection = new ArrayList();
        this.dbInformationCollection = new ArrayList();
        this.strProductVersion = null;
        this.definition = null;
        this.typeDefinition = null;
        this.procedure = null;
    }
}

