/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.asd.design.editparts;

import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.ColumnEditPart;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.DefinitionsEditPart;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.InterfaceEditPart;
import org.eclipse.wst.wsdl.ui.internal.asd.design.figures.ComponentReferenceConnection;

class EditPartNavigationHandlerUtil {
    EditPartNavigationHandlerUtil() {
    }

    static GraphicalEditPart getRelativeEditPart(GraphicalEditPart focusEditPart, int direction) {
        int dx = 5;
        int dy = 5;
        IFigure contentPane = focusEditPart.getContentPane();
        Rectangle r = focusEditPart.getFigure().getBounds().getCopy();
        focusEditPart.getFigure().translateToAbsolute((Translatable)r);
        if (contentPane != focusEditPart.getFigure()) {
            Rectangle contentPaneBounds = contentPane.getBounds().getCopy();
            contentPane.translateToAbsolute((Translatable)contentPaneBounds);
            if (contentPaneBounds.y > r.y) {
                r.height = contentPaneBounds.y - r.y;
                r.x = contentPaneBounds.x;
            }
            if (contentPaneBounds.x > r.x) {
                r.width = contentPaneBounds.x - r.x;
            }
        }
        Point p = null;
        if (direction == 1) {
            p = r.getTopLeft();
            p.y -= dy;
        } else if (direction == 4) {
            p = r.getBottomLeft();
            p.x += dx;
            p.y += dy;
        } else if (direction == 16) {
            p = r.getTopRight();
            p.x += dx;
        } else if (direction == 8) {
            p = r.getLeft();
            p.x -= dx;
        }
        EditPart t = focusEditPart.getViewer().findObjectAt(p);
        if (t instanceof ColumnEditPart || t instanceof DefinitionsEditPart) {
            t = null;
        }
        return (GraphicalEditPart)t;
    }

    static EditPart getNextSibling(EditPart editPart) {
        List children;
        int index;
        EditPart result = null;
        EditPart parent = editPart.getParent();
        if (parent != null && (index = (children = parent.getChildren()).indexOf(editPart)) + 1 < children.size()) {
            result = (EditPart)children.get(index + 1);
        }
        return result;
    }

    static EditPart getPrevSibling(EditPart editPart) {
        List children;
        int index;
        EditPart result = null;
        EditPart parent = editPart.getParent();
        if (parent != null && (index = (children = parent.getChildren()).indexOf(editPart)) - 1 >= 0) {
            result = (EditPart)children.get(index - 1);
        }
        return result;
    }

    static EditPart getNextInterface(EditPart editPart) {
        EditPart result = null;
        EditPart e = editPart;
        while (e != null) {
            if (e instanceof InterfaceEditPart) {
                InterfaceEditPart ie = (InterfaceEditPart)e;
                result = EditPartNavigationHandlerUtil.getNextSibling((EditPart)ie);
                break;
            }
            e = e.getParent();
        }
        return result;
    }

    static EditPart getSourceConnectionEditPart(AbstractGraphicalEditPart editPart) {
        EditPart result = null;
        EditPartViewer viewer = editPart.getViewer();
        LayerManager manager = (LayerManager)editPart.getViewer().getEditPartRegistry().get(LayerManager.ID);
        IFigure layer = manager.getLayer((Object)"Connection Layer");
        Iterator i = layer.getChildren().iterator();
        while (i.hasNext()) {
            ComponentReferenceConnection componentReferenceConnection;
            ConnectionAnchor targetAnchor;
            Figure figure = (Figure)i.next();
            if (!(figure instanceof ComponentReferenceConnection) || (targetAnchor = (componentReferenceConnection = (ComponentReferenceConnection)figure).getTargetAnchor()).getOwner() != editPart.getFigure()) continue;
            ConnectionAnchor sourceAnchor = componentReferenceConnection.getSourceAnchor();
            IFigure sourceFigure = sourceAnchor.getOwner();
            EditPart part = null;
            while (part == null && sourceFigure != null) {
                part = (EditPart)viewer.getVisualPartMap().get(sourceFigure);
                sourceFigure = sourceFigure.getParent();
            }
            result = part;
            break;
        }
        return result;
    }
}

