/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.pluginconversion.PluginConversionException;
import org.eclipse.osgi.service.pluginconversion.PluginConverter;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateDelta;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ExecutionEnvironmentAnalyzer;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatform;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.util.tracker.ServiceTracker;

public class MinimalState {
    protected State fState;
    protected long fId;
    private PluginConverter fConverter = null;
    private boolean fEEListChanged = false;
    private String[] fExecutionEnvironments;
    private boolean fNoProfile;
    private static final String SYSTEM_BUNDLE = "org.eclipse.osgi";
    protected static boolean DEBUG = false;
    protected static StateObjectFactory stateObjectFactory;
    protected static String DIR;
    static /* synthetic */ Class class$0;

    static {
        DEBUG = PDECore.getDefault().isDebugging() && "true".equals(Platform.getDebugOption((String)"org.eclipse.pde.core/cache"));
        DIR = PDECore.getDefault().getStateLocation().toOSString();
        stateObjectFactory = Platform.getPlatformAdmin().getFactory();
    }

    protected MinimalState() {
    }

    public MinimalState(Dictionary properties) {
        this.fState = stateObjectFactory.createState(true);
        this.fState.setPlatformProperties(properties);
    }

    public void addBundle(IPluginModelBase model, boolean update) {
        BundleDescription desc;
        if (!update) {
            BundleDescription[] bundles = this.fState.getBundles(model.getPluginBase().getId());
            int i = 0;
            while (i < bundles.length) {
                this.fState.removeBundle(bundles[i]);
                ++i;
            }
        }
        long bundleId = (desc = model.getBundleDescription()) == null || !update ? -1L : desc.getBundleId();
        try {
            model.setBundleDescription(this.addBundle(new File(model.getInstallLocation()), bundleId));
        }
        catch (IOException iOException) {
        }
        catch (PluginConversionException pluginConversionException) {
        }
        catch (CoreException e) {
            PDECore.log(e);
        }
    }

    public BundleDescription addBundle(IPluginModelBase model, long bundleId) {
        try {
            return this.addBundle(new File(model.getInstallLocation()), -1L);
        }
        catch (IOException iOException) {
        }
        catch (PluginConversionException pluginConversionException) {
        }
        catch (CoreException coreException) {}
        return null;
    }

    public BundleDescription addBundle(Dictionary manifest, File bundleLocation, long bundleId) {
        try {
            BundleDescription descriptor = stateObjectFactory.createBundleDescription(this.fState, manifest, bundleLocation.getAbsolutePath(), bundleId == -1L ? this.getNextId() : bundleId);
            if (bundleId == -1L) {
                this.fState.addBundle(descriptor);
            } else if (!this.fState.updateBundle(descriptor)) {
                this.fState.addBundle(descriptor);
            }
            return descriptor;
        }
        catch (BundleException bundleException) {
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return null;
    }

    public BundleDescription addBundle(File bundleLocation, long bundleId) throws PluginConversionException, CoreException, IOException {
        BundleDescription desc;
        boolean hasBundleStructure;
        Dictionary manifest = MinimalState.loadManifest(bundleLocation);
        boolean bl = hasBundleStructure = manifest != null && manifest.get("Bundle-SymbolicName") != null;
        if (!hasBundleStructure) {
            if (!(bundleLocation.isFile() || new File(bundleLocation, "plugin.xml").exists() || new File(bundleLocation, "fragment.xml").exists())) {
                return null;
            }
            PluginConverter converter = this.acquirePluginConverter();
            manifest = converter.convertManifest(bundleLocation, false, null, false, null);
            if (manifest == null || manifest.get("Bundle-SymbolicName") == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", 4, "Error parsing plug-in manifest file at " + bundleLocation.toString(), null));
            }
        }
        if ((desc = this.addBundle(manifest, bundleLocation, bundleId)) != null && SYSTEM_BUNDLE.equals(desc.getSymbolicName())) {
            this.fEEListChanged = true;
        }
        if (desc != null) {
            this.addAuxiliaryData(desc, manifest, hasBundleStructure);
        }
        return desc;
    }

    protected void addAuxiliaryData(BundleDescription desc, Dictionary manifest, boolean hasBundleStructure) {
    }

    protected void saveState(File dir) {
        this.saveState(this.fState, dir);
    }

    protected void saveState(State state, File dir) {
        try {
            if (!dir.exists()) {
                dir.mkdirs();
            }
            stateObjectFactory.writeState(state, dir);
        }
        catch (FileNotFoundException e) {
            PDECore.log(e);
        }
        catch (IOException e) {
            PDECore.log(e);
        }
    }

    public static Dictionary loadManifest(File bundleLocation) throws IOException {
        Object var4_4;
        Properties properties;
        ZipFile jarFile = null;
        InputStream manifestStream = null;
        try {
            String extension = new Path(bundleLocation.getName()).getFileExtension();
            if (extension != null && extension.equals("jar") && bundleLocation.isFile()) {
                jarFile = new ZipFile(bundleLocation, 1);
                ZipEntry manifestEntry = jarFile.getEntry("META-INF/MANIFEST.MF");
                if (manifestEntry != null) {
                    manifestStream = jarFile.getInputStream(manifestEntry);
                }
            } else {
                File file = new File(bundleLocation, "META-INF/MANIFEST.MF");
                if (file.exists()) {
                    manifestStream = new FileInputStream(file);
                }
            }
        }
        catch (IOException iOException) {}
        if (manifestStream == null) {
            return null;
        }
        try {
            Manifest m = new Manifest(manifestStream);
            properties = MinimalState.manifestToProperties(m.getMainAttributes());
            var4_4 = null;
        }
        catch (Throwable throwable) {
            var4_4 = null;
            try {
                manifestStream.close();
            }
            catch (IOException iOException) {}
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            manifestStream.close();
        }
        catch (IOException iOException) {}
        try {
            if (jarFile != null) {
                jarFile.close();
            }
        }
        catch (IOException iOException) {}
        return properties;
    }

    private static Properties manifestToProperties(Attributes d) {
        Iterator<Object> iter = d.keySet().iterator();
        Properties result = new Properties();
        while (iter.hasNext()) {
            Attributes.Name key = (Attributes.Name)iter.next();
            result.put(key.toString(), d.get(key));
        }
        return result;
    }

    public StateDelta resolveState(boolean incremental) {
        return this.internalResolveState(incremental);
    }

    private synchronized StateDelta internalResolveState(boolean incremental) {
        if (this.fExecutionEnvironments == null && !this.fNoProfile) {
            this.setExecutionEnvironments();
        }
        if (this.fEEListChanged) {
            incremental = !this.fState.setPlatformProperties(this.getProfilePlatformProperties());
            this.fEEListChanged = false;
        }
        return this.fState.resolve(incremental);
    }

    private Dictionary[] getProfilePlatformProperties() {
        if (this.fExecutionEnvironments == null || this.fExecutionEnvironments.length == 0) {
            return new Dictionary[]{TargetPlatform.getTargetEnvironment()};
        }
        ArrayList<Dictionary> result = new ArrayList<Dictionary>(this.fExecutionEnvironments.length);
        int i = 0;
        while (i < this.fExecutionEnvironments.length) {
            Properties profileProps = this.getJavaProfileProperties(this.fExecutionEnvironments[i]);
            if (profileProps != null) {
                String ee;
                Dictionary props = TargetPlatform.getTargetEnvironment();
                String systemPackages = profileProps.getProperty("org.osgi.framework.system.packages");
                if (systemPackages != null) {
                    props.put("org.osgi.framework.system.packages", systemPackages);
                }
                if ((ee = profileProps.getProperty("org.osgi.framework.executionenvironment")) != null) {
                    props.put("org.osgi.framework.executionenvironment", ee);
                }
                result.add(props);
            }
            ++i;
        }
        if (result.size() > 0) {
            return result.toArray(new Dictionary[result.size()]);
        }
        return new Dictionary[]{TargetPlatform.getTargetEnvironment()};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties getJavaProfileProperties(String ee) {
        ZipFile zipFile;
        block23: {
            BundleDescription osgiBundle = this.fState.getBundle(SYSTEM_BUNDLE, null);
            if (osgiBundle == null) {
                return null;
            }
            File location = new File(osgiBundle.getLocation());
            String filename = String.valueOf(ee.replace('/', '_')) + ".profile";
            InputStream is = null;
            zipFile = null;
            try {
                block21: {
                    Properties properties;
                    block22: {
                        try {
                            if (location.isDirectory()) {
                                File file = new File(location, filename);
                                if (file.exists()) {
                                    is = new FileInputStream(file);
                                }
                            } else {
                                zipFile = null;
                                try {
                                    zipFile = new ZipFile(location, 1);
                                    ZipEntry entry = zipFile.getEntry(filename);
                                    if (entry != null) {
                                        is = zipFile.getInputStream(entry);
                                    }
                                }
                                catch (IOException iOException) {}
                            }
                            if (is == null) break block21;
                            Properties profile = new Properties();
                            profile.load(is);
                            properties = profile;
                            Object var8_9 = null;
                            if (is == null) break block22;
                        }
                        catch (IOException iOException) {}
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (zipFile == null) return properties;
                    try {
                        zipFile.close();
                        return properties;
                    }
                    catch (IOException iOException) {}
                    return properties;
                }
                Object var8_11 = null;
                if (is == null) break block23;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (is != null) {
                    try {}
                    catch (IOException iOException) {}
                    is.close();
                }
                if (zipFile == null) throw throwable;
                try {}
                catch (IOException iOException) {}
                zipFile.close();
                throw throwable;
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            is.close();
        }
        if (zipFile == null) return null;
        try {}
        catch (IOException iOException) {
            return null;
        }
        zipFile.close();
        return null;
    }

    public void removeBundleDescription(BundleDescription description) {
        if (description != null) {
            this.fState.removeBundle(description);
        }
    }

    public State getState() {
        return this.fState;
    }

    private void setExecutionEnvironments() {
        String jreProfile = System.getProperty("pde.jreProfile");
        if (jreProfile != null && jreProfile.length() > 0) {
            if ("none".equals(jreProfile)) {
                this.fNoProfile = true;
            } else {
                this.fExecutionEnvironments = new String[]{jreProfile};
            }
        } else {
            this.fExecutionEnvironments = ExecutionEnvironmentAnalyzer.getKnownExecutionEnvironments();
        }
        this.fEEListChanged = true;
    }

    public void addBundleDescription(BundleDescription toAdd) {
        this.fState.addBundle(toAdd);
    }

    private PluginConverter acquirePluginConverter() {
        if (this.fConverter == null) {
            BundleContext bundleContext = PDECore.getDefault().getBundleContext();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.osgi.service.pluginconversion.PluginConverter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ServiceTracker tracker = new ServiceTracker(bundleContext, clazz.getName(), null);
            tracker.open();
            this.fConverter = (PluginConverter)tracker.getService();
            tracker.close();
        }
        return this.fConverter;
    }

    public long getNextId() {
        return ++this.fId;
    }

    private BundleDescription findActiveBundle(String symbolicName) {
        BundleDescription[] bundles = this.fState.getBundles(symbolicName);
        int i = 0;
        while (i < bundles.length) {
            if (bundles[i].isResolved()) {
                return bundles[i];
            }
            ++i;
        }
        return null;
    }

    protected void logResolutionErrors() {
        MultiStatus errors = new MultiStatus(PDECore.getPluginId(), 1, "Problems occurred during the resolution of the target platform", null);
        StateHelper helper = Platform.getPlatformAdmin().getStateHelper();
        BundleDescription[] all = this.fState.getBundles();
        int i = 0;
        while (i < all.length) {
            if (!all[i].isResolved()) {
                String message;
                VersionConstraint[] unsatisfiedConstraints = helper.getUnsatisfiedConstraints(all[i]);
                if (unsatisfiedConstraints.length == 0) {
                    if (DEBUG) {
                        BundleDescription activeBundle = this.findActiveBundle(all[i].getSymbolicName());
                        message = "Plug-in located at \"" + all[i].getLocation() + "\" was disabled because plug-in located at \"" + activeBundle.getLocation() + "\" was selected.";
                        System.out.print(message);
                    }
                } else {
                    int j = 0;
                    while (j < unsatisfiedConstraints.length) {
                        message = this.getResolutionFailureMessage(unsatisfiedConstraints[j]);
                        if (message != null) {
                            errors.add((IStatus)new Status(2, all[i].getSymbolicName(), 2, message, null));
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        if (errors.getChildren().length > 0) {
            PDECore.log((IStatus)errors);
        }
    }

    private String getResolutionFailureMessage(VersionConstraint unsatisfied) {
        if (unsatisfied.isResolved()) {
            throw new IllegalArgumentException();
        }
        if (unsatisfied instanceof ImportPackageSpecification) {
            return "Missing imported package: " + this.toString(unsatisfied);
        }
        if (unsatisfied instanceof BundleSpecification && !((BundleSpecification)unsatisfied).isOptional()) {
            return "Missing required plug-in: " + this.toString(unsatisfied);
        }
        if (unsatisfied instanceof HostSpecification) {
            return "Missing Fragment Host: " + this.toString(unsatisfied);
        }
        return null;
    }

    private String toString(VersionConstraint constraint) {
        VersionRange versionRange = constraint.getVersionRange();
        if (versionRange == null || versionRange.getMinimum() != null) {
            return constraint.getName();
        }
        return String.valueOf(constraint.getName()) + '_' + versionRange;
    }
}

