/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.internal;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.internal.CopyOnWriteSet;
import org.eclipse.wst.common.project.facet.core.internal.EventHandler;
import org.eclipse.wst.common.project.facet.core.internal.FacetCorePlugin;
import org.eclipse.wst.common.project.facet.core.internal.ProjectFacet;
import org.eclipse.wst.common.project.facet.core.internal.ProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.common.project.facet.core.runtime.internal.UnknownRuntime;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public final class FacetedProject
implements IFacetedProject {
    private static final String TRACING_DELEGATE_CALLS = "org.eclipse.wst.common.project.facet.core/delegate/calls";
    private static final String FACETS_METADATA_FILE = ".settings/org.eclipse.wst.common.project.facet.core.xml";
    private static final String EL_RUNTIME = "runtime";
    private static final String EL_SECONDARY_RUNTIME = "secondary-runtime";
    private static final String EL_FIXED = "fixed";
    private static final String EL_INSTALLED = "installed";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_FACET = "facet";
    private static final String ATTR_VERSION = "version";
    private final IProject project;
    private final CopyOnWriteSet facets;
    private final CopyOnWriteSet fixed;
    private final Map unknownFacets = new HashMap();
    private final CopyOnWriteSet targetedRuntimes;
    private String primaryRuntime;
    IFile f;
    private long fModificationStamp = -1L;
    private final List listeners;
    private final Object lock = new Object();
    private boolean isBeingModified = false;
    private Thread modifierThread = null;
    static /* synthetic */ Class class$0;

    FacetedProject(IProject project) throws CoreException {
        this.project = project;
        this.facets = new CopyOnWriteSet();
        this.fixed = new CopyOnWriteSet();
        this.targetedRuntimes = new CopyOnWriteSet();
        this.listeners = new ArrayList();
        this.f = project.getFile(FACETS_METADATA_FILE);
        this.refresh();
    }

    public IProject getProject() {
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getProjectFacets() {
        Object object = this.lock;
        synchronized (object) {
            return this.facets.getReadOnlySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasProjectFacet(IProjectFacet f) {
        Object object = this.lock;
        synchronized (object) {
            IProjectFacetVersion fv;
            Iterator itr = this.facets.iterator();
            do {
                if (itr.hasNext()) continue;
                return false;
            } while ((fv = (IProjectFacetVersion)itr.next()).getProjectFacet() != f);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasProjectFacet(IProjectFacetVersion fv) {
        Object object = this.lock;
        synchronized (object) {
            return this.facets.contains(fv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IProjectFacetVersion getInstalledVersion(IProjectFacet f) {
        Object object = this.lock;
        synchronized (object) {
            Iterator itr = this.facets.iterator();
            while (itr.hasNext()) {
                IProjectFacetVersion fv = (IProjectFacetVersion)itr.next();
                if (fv.getProjectFacet() != f) continue;
                return fv;
            }
            return null;
        }
    }

    public void installProjectFacet(IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        IFacetedProject.Action action = new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, fv, config);
        this.modify(Collections.singleton(action), monitor);
    }

    public void uninstallProjectFacet(IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        IFacetedProject.Action action = new IFacetedProject.Action(IFacetedProject.Action.Type.UNINSTALL, fv, config);
        this.modify(Collections.singleton(action), monitor);
    }

    public void modify(final Set actions, IProgressMonitor monitor) throws CoreException {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws CoreException {
                FacetedProject.this.beginModification();
                try {
                    FacetedProject.this.modifyInternal(actions, monitor);
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    FacetedProject.this.endModification();
                    throw throwable;
                }
                {
                    Object var2_4 = null;
                }
                FacetedProject.this.endModification();
            }
        };
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        ws.run(wr, (ISchedulingRule)ws.getRoot(), 1, monitor);
        this.notifyListeners();
    }

    /*
     * Exception decompiling
     */
    private void modifyInternal(Set actions, IProgressMonitor monitor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [4 : 444->448)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getFixedProjectFacets() {
        Object object = this.lock;
        synchronized (object) {
            return this.fixed.getReadOnlySet();
        }
    }

    public void setFixedProjectFacets(final Set facets) throws CoreException {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws CoreException {
                FacetedProject.this.beginModification();
                try {
                    Object object = FacetedProject.this.lock;
                    synchronized (object) {
                        FacetedProject.this.fixed.clear();
                        FacetedProject.this.fixed.addAll((Collection)facets);
                    }
                    FacetedProject.this.save();
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    FacetedProject.this.endModification();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                FacetedProject.this.endModification();
            }
        };
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        ws.run(wr, (ISchedulingRule)ws.getRoot(), 1, null);
        this.notifyListeners();
    }

    public IRuntime getRuntime() {
        return this.getPrimaryRuntime();
    }

    public void setRuntime(IRuntime runtime, IProgressMonitor monitor) throws CoreException {
        Set<IRuntime> runtimes = runtime == null ? Collections.EMPTY_SET : Collections.singleton(runtime);
        this.setTargetedRuntimes(runtimes, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getTargetedRuntimes() {
        Object object = this.lock;
        synchronized (object) {
            HashSet<IRuntime> result = new HashSet<IRuntime>();
            Iterator itr = this.targetedRuntimes.iterator();
            while (itr.hasNext()) {
                result.add(FacetedProject.getRuntimeFromName((String)itr.next()));
            }
            return Collections.unmodifiableSet(result);
        }
    }

    public void setTargetedRuntimes(final Set runtimes, IProgressMonitor monitor) throws CoreException {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws CoreException {
                FacetedProject.this.beginModification();
                try {
                    FacetedProject.this.setTargetedRuntimesInternal(runtimes, monitor);
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    FacetedProject.this.endModification();
                    throw throwable;
                }
                {
                    Object var2_4 = null;
                }
                FacetedProject.this.endModification();
            }
        };
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        ws.run(wr, (ISchedulingRule)ws.getRoot(), 1, null);
        this.notifyListeners();
    }

    /*
     * Exception decompiling
     */
    private void setTargetedRuntimesInternal(Set runtimes, IProgressMonitor monitor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [4 : 414->418)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void addTargetedRuntime(final IRuntime runtime, IProgressMonitor monitor) throws CoreException {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws CoreException {
                FacetedProject.this.beginModification();
                try {
                    FacetedProject.this.addTargetedRuntimeInternal(runtime, monitor);
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    FacetedProject.this.endModification();
                    throw throwable;
                }
                {
                    Object var2_4 = null;
                }
                FacetedProject.this.endModification();
            }
        };
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        ws.run(wr, (ISchedulingRule)ws.getRoot(), 1, null);
        this.notifyListeners();
    }

    /*
     * Exception decompiling
     */
    private void addTargetedRuntimeInternal(IRuntime runtime, IProgressMonitor monitor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [4 : 192->196)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void removeTargetedRuntime(final IRuntime runtime, IProgressMonitor monitor) throws CoreException {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws CoreException {
                FacetedProject.this.beginModification();
                try {
                    FacetedProject.this.removeTargetedRuntimeInternal(runtime, monitor);
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    FacetedProject.this.endModification();
                    throw throwable;
                }
                {
                    Object var2_4 = null;
                }
                FacetedProject.this.endModification();
            }
        };
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        ws.run(wr, (ISchedulingRule)ws.getRoot(), 1, null);
        this.notifyListeners();
    }

    /*
     * Exception decompiling
     */
    private void removeTargetedRuntimeInternal(IRuntime runtime, IProgressMonitor monitor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [4 : 203->207)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRuntime getPrimaryRuntime() {
        Object object = this.lock;
        synchronized (object) {
            block4: {
                if (this.primaryRuntime != null) break block4;
                return null;
            }
            return FacetedProject.getRuntimeFromName(this.primaryRuntime);
        }
    }

    public void setPrimaryRuntime(final IRuntime runtime, IProgressMonitor monitor) throws CoreException {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws CoreException {
                FacetedProject.this.beginModification();
                try {
                    FacetedProject.this.setPrimaryRuntimeInternal(runtime, monitor);
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    FacetedProject.this.endModification();
                    throw throwable;
                }
                {
                    Object var2_4 = null;
                }
                FacetedProject.this.endModification();
            }
        };
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        ws.run(wr, (ISchedulingRule)ws.getRoot(), 1, null);
        this.notifyListeners();
    }

    /*
     * Exception decompiling
     */
    private void setPrimaryRuntimeInternal(IRuntime runtime, IProgressMonitor monitor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [4 : 223->227)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static IRuntime getRuntimeFromName(String name) {
        if (RuntimeManager.isRuntimeDefined(name)) {
            return RuntimeManager.getRuntime(name);
        }
        return new UnknownRuntime(name);
    }

    private void assignPrimaryRuntimeIfNecessary() {
        if (this.targetedRuntimes.isEmpty()) {
            this.primaryRuntime = null;
        } else if (this.primaryRuntime == null || !this.targetedRuntimes.contains(this.primaryRuntime)) {
            this.primaryRuntime = (String)this.targetedRuntimes.iterator().next();
        }
    }

    public IMarker createErrorMarker(String message) throws CoreException {
        return this.createErrorMarker("org.eclipse.wst.common.project.facet.core.validation.marker", message);
    }

    public IMarker createErrorMarker(String type, String message) throws CoreException {
        return this.createMarker(2, type, message);
    }

    public IMarker createWarningMarker(String message) throws CoreException {
        return this.createWarningMarker("org.eclipse.wst.common.project.facet.core.validation.marker", message);
    }

    public IMarker createWarningMarker(String type, String message) throws CoreException {
        return this.createMarker(1, type, message);
    }

    private IMarker createMarker(int severity, String type, String message) throws CoreException {
        IMarker[] existing = this.project.findMarkers(type, false, 0);
        int i = 0;
        while (i < existing.length) {
            IMarker m = existing[i];
            if (m.getAttribute("severity", -1) == severity && m.getAttribute("message", "").equals(message)) {
                return m;
            }
            ++i;
        }
        IMarker m = this.project.createMarker(type);
        m.setAttribute("message", (Object)message);
        m.setAttribute("severity", severity);
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IFacetedProjectListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IFacetedProjectListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners() {
        Object[] copy;
        List list = this.listeners;
        synchronized (list) {
            copy = this.listeners.toArray();
        }
        int i = 0;
        while (i < copy.length) {
            try {
                ((IFacetedProjectListener)copy[i]).projectChanged();
            }
            catch (Exception e) {
                FacetCorePlugin.log(e);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void beginModification() throws CoreException {
        Object object = this.lock;
        synchronized (object) {
            while (true) {
                if (!this.isBeingModified) {
                    this.isBeingModified = true;
                    this.modifierThread = Thread.currentThread();
                    return;
                }
                if (this.modifierThread == Thread.currentThread()) {
                    String msg = Resources.illegalModificationMsg;
                    IStatus st = FacetCorePlugin.createErrorStatus(msg);
                    throw new CoreException(st);
                }
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endModification() {
        Object object = this.lock;
        synchronized (object) {
            this.isBeingModified = false;
            this.modifierThread = null;
            this.lock.notifyAll();
        }
    }

    private EventHandler.Type getPreEventHandlerType(IFacetedProject.Action.Type t) {
        if (t == IFacetedProject.Action.Type.INSTALL) {
            return EventHandler.Type.PRE_INSTALL;
        }
        if (t == IFacetedProject.Action.Type.UNINSTALL) {
            return EventHandler.Type.PRE_UNINSTALL;
        }
        if (t == IFacetedProject.Action.Type.VERSION_CHANGE) {
            return EventHandler.Type.PRE_VERSION_CHANGE;
        }
        throw new IllegalStateException();
    }

    private EventHandler.Type getPostEventHandlerType(IFacetedProject.Action.Type t) {
        if (t == IFacetedProject.Action.Type.INSTALL) {
            return EventHandler.Type.POST_INSTALL;
        }
        if (t == IFacetedProject.Action.Type.UNINSTALL) {
            return EventHandler.Type.POST_UNINSTALL;
        }
        if (t == IFacetedProject.Action.Type.VERSION_CHANGE) {
            return EventHandler.Type.POST_VERSION_CHANGE;
        }
        throw new IllegalStateException();
    }

    /*
     * Exception decompiling
     */
    private void callEventHandlers(IProjectFacetVersion fv, EventHandler.Type type, Object config, IProgressMonitor monitor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 158->162)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void callDelegate(IProjectFacetVersion fv, IDelegate delegate, Object config, Object context, IProgressMonitor monitor) throws CoreException {
        String tracingDelegateCallsStr = Platform.getDebugOption((String)TRACING_DELEGATE_CALLS);
        boolean tracingDelegateCalls = tracingDelegateCallsStr == null ? false : tracingDelegateCallsStr.equals("true");
        long timeStarted = -1L;
        if (tracingDelegateCalls) {
            String msg = Resources.bind(Resources.tracingDelegateStarting, fv.getProjectFacet().getId(), fv.getVersionString(), context.toString(), delegate.getClass().getName());
            System.out.println(msg);
            timeStarted = System.currentTimeMillis();
        }
        try {
            delegate.execute(this.project, fv, config, monitor);
        }
        catch (Exception e) {
            String msg;
            if (context == IFacetedProject.Action.Type.INSTALL || context == EventHandler.Type.PRE_INSTALL || context == EventHandler.Type.POST_INSTALL) {
                msg = NLS.bind((String)Resources.failedOnInstall, (Object)fv);
            } else if (context == IFacetedProject.Action.Type.UNINSTALL || context == EventHandler.Type.PRE_UNINSTALL || context == EventHandler.Type.POST_UNINSTALL) {
                msg = NLS.bind((String)Resources.failedOnUninstall, (Object)fv);
            } else if (context == IFacetedProject.Action.Type.VERSION_CHANGE || context == EventHandler.Type.PRE_VERSION_CHANGE || context == EventHandler.Type.POST_VERSION_CHANGE) {
                msg = NLS.bind((String)Resources.failedOnVersionChange, (Object)fv.getProjectFacet().getLabel(), (Object)fv.getVersionString());
            } else if (context == EventHandler.Type.RUNTIME_CHANGED) {
                msg = NLS.bind((String)Resources.failedOnRuntimeChanged, (Object)fv);
            } else {
                throw new IllegalStateException(context.toString());
            }
            Status status = new Status(4, "org.eclipse.wst.common.project.facet.core", 0, msg, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        if (tracingDelegateCalls) {
            long duration = System.currentTimeMillis() - timeStarted;
            String msg = NLS.bind((String)Resources.tracingDelegateFinished, (Object)String.valueOf(duration));
            System.out.println(msg);
        }
    }

    private void apply(IFacetedProject.Action action) {
        IFacetedProject.Action.Type type = action.getType();
        IProjectFacetVersion fv = action.getProjectFacetVersion();
        if (type == IFacetedProject.Action.Type.INSTALL) {
            this.facets.add(fv);
        } else if (type == IFacetedProject.Action.Type.UNINSTALL) {
            this.facets.remove(fv);
        } else if (type == IFacetedProject.Action.Type.VERSION_CHANGE) {
            Iterator itr = this.facets.iterator();
            while (itr.hasNext()) {
                IProjectFacetVersion x = (IProjectFacetVersion)itr.next();
                if (x.getProjectFacet() != fv.getProjectFacet()) continue;
                itr.remove();
                break;
            }
            this.facets.add(fv);
        }
    }

    private void save() throws CoreException {
        byte[] bytes;
        StringWriter w = new StringWriter();
        PrintWriter out = new PrintWriter(w);
        String nl = System.getProperty("line.separator");
        out.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.print(nl);
        out.print("<faceted-project>");
        out.print(nl);
        if (this.primaryRuntime != null) {
            out.print("  <runtime name=\"");
            out.print(this.primaryRuntime);
            out.print("\"/>");
            out.print(nl);
        }
        Iterator itr = this.targetedRuntimes.iterator();
        while (itr.hasNext()) {
            String name = (String)itr.next();
            if (name.equals(this.primaryRuntime)) continue;
            out.print("  <secondary-runtime name=\"");
            out.print(name);
            out.print("\"/>");
            out.print(nl);
        }
        itr = this.fixed.iterator();
        while (itr.hasNext()) {
            IProjectFacet f = (IProjectFacet)itr.next();
            out.print("  <fixed facet=\"");
            out.print(f.getId());
            out.print("\"/>");
            out.print(nl);
        }
        itr = this.facets.iterator();
        while (itr.hasNext()) {
            IProjectFacetVersion fv = (IProjectFacetVersion)itr.next();
            out.print("  <installed facet=\"");
            out.print(fv.getProjectFacet().getId());
            out.print("\" version=\"");
            out.print(fv.getVersionString());
            out.print("\"/>");
            out.print(nl);
        }
        out.print("</faceted-project>");
        out.print(nl);
        try {
            bytes = w.getBuffer().toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        if (this.f.exists()) {
            this.f.setContents((InputStream)in, true, false, null);
        } else {
            IFolder parent = (IFolder)this.f.getParent();
            if (!parent.exists()) {
                parent.create(true, true, null);
            }
            this.f.create((InputStream)in, true, null);
        }
        this.fModificationStamp = this.f.getModificationStamp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void refresh() throws CoreException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isBeingModified) {
                return;
            }
            if (this.f.exists() && this.f.getModificationStamp() == this.fModificationStamp) {
                return;
            }
            this.beginModification();
            try {
                this.facets.clear();
                this.fixed.clear();
                this.unknownFacets.clear();
                this.targetedRuntimes.clear();
                this.primaryRuntime = null;
                if (!this.f.exists()) {
                    this.fModificationStamp = -1L;
                    Object var11_2 = null;
                    this.endModification();
                    return;
                }
                this.fModificationStamp = this.f.getModificationStamp();
                Element root = FacetedProject.parse(this.f.getLocation().toFile());
                Element[] elements = this.children(root);
                int i = 0;
                while (i < elements.length) {
                    String id;
                    Element e = elements[i];
                    String name = e.getNodeName();
                    if (name.equals(EL_RUNTIME)) {
                        this.primaryRuntime = e.getAttribute(ATTR_NAME);
                        this.targetedRuntimes.add(this.primaryRuntime);
                    } else if (name.equals(EL_SECONDARY_RUNTIME)) {
                        this.targetedRuntimes.add(e.getAttribute(ATTR_NAME));
                    } else if (name.equals(EL_FIXED)) {
                        id = e.getAttribute(ATTR_FACET);
                        IProjectFacet f = ProjectFacetsManager.isProjectFacetDefined(id) ? ProjectFacetsManager.getProjectFacet(id) : this.createUnknownFacet(id);
                        this.fixed.add(f);
                    } else if (name.equals(EL_INSTALLED)) {
                        id = e.getAttribute(ATTR_FACET);
                        String version = e.getAttribute(ATTR_VERSION);
                        IProjectFacet f = ProjectFacetsManager.isProjectFacetDefined(id) ? ProjectFacetsManager.getProjectFacet(id) : this.createUnknownFacet(id);
                        IProjectFacetVersion fv = f.hasVersion(version) ? f.getVersion(version) : this.createUnknownFacetVersion(f, version);
                        this.facets.add(fv);
                    }
                    ++i;
                }
                this.notifyListeners();
                Object var11_4 = null;
                this.endModification();
                return;
            }
            catch (Throwable throwable) {
                Object var11_3 = null;
                this.endModification();
                throw throwable;
            }
        }
    }

    private ProjectFacet createUnknownFacet(String id) {
        ProjectFacet f = (ProjectFacet)this.unknownFacets.get(id);
        if (f == null) {
            f = new ProjectFacet();
            f.setId(id);
            f.setLabel(id);
            this.unknownFacets.put(id, f);
        }
        return f;
    }

    private ProjectFacetVersion createUnknownFacetVersion(IProjectFacet f, String version) {
        ProjectFacetVersion fv;
        if (f.hasVersion(version)) {
            fv = (ProjectFacetVersion)f.getVersion(version);
        } else {
            fv = new ProjectFacetVersion();
            fv.setProjectFacet((ProjectFacet)f);
            fv.setVersionString(version);
        }
        return fv;
    }

    private static Element parse(File f) {
        DocumentBuilder docbuilder;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            docbuilder = factory.newDocumentBuilder();
            docbuilder.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicID, String systemID) {
                    return new InputSource(new StringReader(""));
                }
            });
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        try {
            return docbuilder.parse(f).getDocumentElement();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Element[] children(Element element) {
        ArrayList<Node> list = new ArrayList<Node>();
        NodeList nl = element.getChildNodes();
        int i = 0;
        int n = nl.getLength();
        while (i < n) {
            Node node = nl.item(i);
            if (node.getNodeType() == 1) {
                list.add(node);
            }
            ++i;
        }
        return list.toArray(new Element[list.size()]);
    }

    private static IProgressMonitor submon(IProgressMonitor parent, int ticks) {
        return parent == null ? null : new SubProgressMonitor(parent, ticks);
    }

    private static boolean equals(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    private static final class Resources
    extends NLS {
        public static String failedOnInstall;
        public static String failedOnUninstall;
        public static String failedOnVersionChange;
        public static String failedOnRuntimeChanged;
        public static String facetNotDefined;
        public static String facetVersionNotDefined;
        public static String facetNotSupported;
        public static String illegalModificationMsg;
        public static String tracingDelegateStarting;
        public static String tracingDelegateFinished;
        public static String newPrimaryNotTargetRuntime;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.common.project.facet.core.internal.FacetedProject");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String string = clazz.getName();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.wst.common.project.facet.core.internal.FacetedProject$Resources");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Resources.initializeMessages((String)string, (Class)clazz2);
        }

        private Resources() {
        }

        public static final String bind(String msg, String arg1, String arg2, String arg3, String arg4) {
            return NLS.bind((String)msg, (Object[])new Object[]{arg1, arg2, arg3, arg4});
        }
    }
}

