/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.CompletionProposalCategory;
import org.eclipse.jdt.internal.ui.text.java.CompletionProposalComputerRegistry;
import org.eclipse.jdt.internal.ui.text.java.JavaTextMessages;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.jface.text.Assert;
import org.osgi.framework.Bundle;

final class CompletionProposalComputerDescriptor {
    private static final String DEFAULT_CATEGORY_ID = "org.eclipse.jdt.ui.defaultProposalCategory";
    private static final String CATEGORY_ID = "categoryId";
    private static final String TYPE = "type";
    private static final String CLASS = "class";
    private static final String ACTIVATE = "activate";
    private static final String PARTITION = "partition";
    private static final Set PARTITION_SET;
    private static final String PERFORMANCE_EVENT;
    private static final boolean MEASURE_PERFORMANCE;
    private static final long MAX_DELAY = 5000L;
    private static final String COMPUTE_COMPLETION_PROPOSALS = "computeCompletionProposals()";
    private static final String COMPUTE_CONTEXT_INFORMATION = "computeContextInformation()";
    private static final String SESSION_STARTED = "sessionStarted()";
    private static final String SESSION_ENDED = "sessionEnded()";
    private final String fId;
    private final String fName;
    private final String fClass;
    private final boolean fActivate;
    private final Set fPartitions;
    private final IConfigurationElement fElement;
    private final CompletionProposalComputerRegistry fRegistry;
    private IJavaCompletionProposalComputer fComputer;
    private final CompletionProposalCategory fCategory;
    private String fLastError;
    private boolean fIsReportingDelay = false;
    private long fStart;

    static {
        PERFORMANCE_EVENT = String.valueOf(JavaPlugin.getPluginId()) + "/perf/content_assist/extensions";
        MEASURE_PERFORMANCE = PerformanceStats.isEnabled((String)PERFORMANCE_EVENT);
        HashSet<String> partitions = new HashSet<String>();
        partitions.add("__dftl_partition_content_type");
        partitions.add("__java_javadoc");
        partitions.add("__java_multiline_comment");
        partitions.add("__java_singleline_comment");
        partitions.add("__java_string");
        partitions.add("__java_character");
        PARTITION_SET = Collections.unmodifiableSet(partitions);
    }

    CompletionProposalComputerDescriptor(IConfigurationElement element, CompletionProposalComputerRegistry registry, List categories) throws InvalidRegistryObjectException {
        Assert.isLegal((registry != null ? 1 : 0) != 0);
        Assert.isLegal((element != null ? 1 : 0) != 0);
        this.fRegistry = registry;
        this.fElement = element;
        IExtension extension = element.getDeclaringExtension();
        this.fId = extension.getUniqueIdentifier();
        this.checkNotNull(this.fId, "id");
        String name = extension.getLabel();
        this.fName = name.length() == 0 ? this.fId : name;
        HashSet<String> partitions = new HashSet<String>();
        IConfigurationElement[] children = element.getChildren(PARTITION);
        if (children.length == 0) {
            this.fPartitions = PARTITION_SET;
        } else {
            int i = 0;
            while (i < children.length) {
                String type = children[i].getAttribute(TYPE);
                this.checkNotNull(type, TYPE);
                partitions.add(type);
                ++i;
            }
            this.fPartitions = Collections.unmodifiableSet(partitions);
        }
        String activateAttribute = element.getAttribute(ACTIVATE);
        this.fActivate = Boolean.valueOf(activateAttribute);
        this.fClass = element.getAttribute(CLASS);
        this.checkNotNull(this.fClass, CLASS);
        String categoryId = element.getAttribute(CATEGORY_ID);
        if (categoryId == null) {
            categoryId = DEFAULT_CATEGORY_ID;
        }
        CompletionProposalCategory category = null;
        Iterator it = categories.iterator();
        while (it.hasNext()) {
            CompletionProposalCategory cat = (CompletionProposalCategory)it.next();
            if (!cat.getId().equals(categoryId)) continue;
            category = cat;
            break;
        }
        if (category == null) {
            this.fCategory = new CompletionProposalCategory(categoryId, this.fName, registry);
            categories.add(this.fCategory);
        } else {
            this.fCategory = category;
        }
    }

    private void checkNotNull(Object obj, String attribute) throws InvalidRegistryObjectException {
        if (obj == null) {
            Object[] args = new Object[]{this.getId(), this.fElement.getContributor().getName(), attribute};
            String message = Messages.format(JavaTextMessages.CompletionProposalComputerDescriptor_illegal_attribute_message, args);
            Status status = new Status(2, JavaPlugin.getPluginId(), 0, message, null);
            JavaPlugin.log((IStatus)status);
            throw new InvalidRegistryObjectException();
        }
    }

    public String getId() {
        return this.fId;
    }

    public String getName() {
        return this.fName;
    }

    public Set getPartitions() {
        return this.fPartitions;
    }

    private synchronized IJavaCompletionProposalComputer getComputer() throws CoreException, InvalidRegistryObjectException {
        if (this.fComputer == null && (this.fActivate || this.isPluginLoaded())) {
            this.fComputer = this.createComputer();
        }
        return this.fComputer;
    }

    private boolean isPluginLoaded() {
        Bundle bundle = this.getBundle();
        return bundle != null && bundle.getState() == 32;
    }

    private Bundle getBundle() {
        String namespace = this.fElement.getDeclaringExtension().getContributor().getName();
        Bundle bundle = Platform.getBundle((String)namespace);
        return bundle;
    }

    public IJavaCompletionProposalComputer createComputer() throws CoreException, InvalidRegistryObjectException {
        return (IJavaCompletionProposalComputer)this.fElement.createExecutableExtension(CLASS);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        IStatus status;
        if (!this.isEnabled()) {
            return Collections.EMPTY_LIST;
        }
        try {
            try {
                block13: {
                    List list;
                    IJavaCompletionProposalComputer computer = this.getComputer();
                    if (computer == null) {
                        List list2 = Collections.EMPTY_LIST;
                        Object var10_8 = null;
                        monitor.done();
                        return list2;
                    }
                    try {
                        PerformanceStats stats = this.startMeter(context, computer);
                        List proposals = computer.computeCompletionProposals(context, monitor);
                        this.stopMeter(stats, COMPUTE_COMPLETION_PROPOSALS);
                        if (proposals == null) break block13;
                        this.fLastError = computer.getErrorMessage();
                        list = proposals;
                        Object var7_15 = null;
                        this.fIsReportingDelay = true;
                    }
                    catch (Throwable throwable) {
                        Object var7_16 = null;
                        this.fIsReportingDelay = true;
                        throw throwable;
                    }
                    Object var10_9 = null;
                    monitor.done();
                    return list;
                }
                Object var7_17 = null;
                this.fIsReportingDelay = true;
                status = this.createAPIViolationStatus(COMPUTE_COMPLETION_PROPOSALS);
            }
            catch (InvalidRegistryObjectException x) {
                status = this.createExceptionStatus(x);
            }
            catch (CoreException x) {
                status = this.createExceptionStatus(x);
            }
            catch (RuntimeException x) {
                status = this.createExceptionStatus(x);
            }
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        this.fRegistry.informUser(this, status);
        return Collections.EMPTY_LIST;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        IStatus status;
        block12: {
            List list;
            block11: {
                List list2;
                block10: {
                    if (!this.isEnabled()) {
                        return Collections.EMPTY_LIST;
                    }
                    try {
                        try {
                            IJavaCompletionProposalComputer computer = this.getComputer();
                            if (computer == null) {
                                list2 = Collections.EMPTY_LIST;
                                Object var7_9 = null;
                                break block10;
                            }
                            PerformanceStats stats = this.startMeter(context, computer);
                            List proposals = computer.computeContextInformation(context, monitor);
                            this.stopMeter(stats, COMPUTE_CONTEXT_INFORMATION);
                            if (proposals != null) {
                                this.fLastError = computer.getErrorMessage();
                                list = proposals;
                                break block11;
                            }
                            status = this.createAPIViolationStatus(COMPUTE_CONTEXT_INFORMATION);
                        }
                        catch (InvalidRegistryObjectException x) {
                            status = this.createExceptionStatus(x);
                        }
                        catch (CoreException x) {
                            status = this.createExceptionStatus(x);
                        }
                        catch (RuntimeException x) {
                            status = this.createExceptionStatus(x);
                        }
                        break block12;
                    }
                    catch (Throwable throwable) {
                        Object var7_11 = null;
                        monitor.done();
                        throw throwable;
                    }
                }
                monitor.done();
                return list2;
            }
            Object var7_10 = null;
            monitor.done();
            return list;
        }
        Object var7_12 = null;
        monitor.done();
        this.fRegistry.informUser(this, status);
        return Collections.EMPTY_LIST;
    }

    public void sessionStarted() {
        IStatus status;
        if (!this.isEnabled()) {
            return;
        }
        try {
            IJavaCompletionProposalComputer computer = this.getComputer();
            if (computer == null) {
                return;
            }
            PerformanceStats stats = this.startMeter(SESSION_STARTED, computer);
            computer.sessionStarted();
            this.stopMeter(stats, SESSION_ENDED);
            return;
        }
        catch (InvalidRegistryObjectException x) {
            status = this.createExceptionStatus(x);
        }
        catch (CoreException x) {
            status = this.createExceptionStatus(x);
        }
        catch (RuntimeException x) {
            status = this.createExceptionStatus(x);
        }
        this.fRegistry.informUser(this, status);
    }

    public void sessionEnded() {
        IStatus status;
        if (!this.isEnabled()) {
            return;
        }
        try {
            IJavaCompletionProposalComputer computer = this.getComputer();
            if (computer == null) {
                return;
            }
            PerformanceStats stats = this.startMeter(SESSION_ENDED, computer);
            computer.sessionEnded();
            this.stopMeter(stats, SESSION_ENDED);
            return;
        }
        catch (InvalidRegistryObjectException x) {
            status = this.createExceptionStatus(x);
        }
        catch (CoreException x) {
            status = this.createExceptionStatus(x);
        }
        catch (RuntimeException x) {
            status = this.createExceptionStatus(x);
        }
        this.fRegistry.informUser(this, status);
    }

    private PerformanceStats startMeter(Object context, IJavaCompletionProposalComputer computer) {
        PerformanceStats stats;
        if (MEASURE_PERFORMANCE) {
            stats = PerformanceStats.getStats((String)PERFORMANCE_EVENT, (Object)computer);
            stats.startRun(context.toString());
        } else {
            stats = null;
        }
        if (this.fIsReportingDelay) {
            this.fStart = System.currentTimeMillis();
        }
        return stats;
    }

    private void stopMeter(PerformanceStats stats, String operation) {
        long current;
        if (MEASURE_PERFORMANCE) {
            stats.endRun();
            if (stats.isFailure()) {
                IStatus status = this.createPerformanceStatus(operation);
                this.fRegistry.informUser(this, status);
                return;
            }
        }
        if (this.fIsReportingDelay && (current = System.currentTimeMillis()) - this.fStart > 5000L) {
            IStatus status = this.createPerformanceStatus(operation);
            this.fRegistry.informUser(this, status);
        }
    }

    private IStatus createExceptionStatus(InvalidRegistryObjectException x) {
        String blame = this.createBlameMessage();
        String reason = JavaTextMessages.CompletionProposalComputerDescriptor_reason_invalid;
        return new Status(1, JavaPlugin.getPluginId(), 0, String.valueOf(blame) + " " + reason, (Throwable)x);
    }

    private IStatus createExceptionStatus(CoreException x) {
        String blame = this.createBlameMessage();
        String reason = JavaTextMessages.CompletionProposalComputerDescriptor_reason_instantiation;
        return new Status(4, JavaPlugin.getPluginId(), 0, String.valueOf(blame) + " " + reason, (Throwable)x);
    }

    private IStatus createExceptionStatus(RuntimeException x) {
        String blame = this.createBlameMessage();
        String reason = JavaTextMessages.CompletionProposalComputerDescriptor_reason_runtime_ex;
        return new Status(2, JavaPlugin.getPluginId(), 0, String.valueOf(blame) + " " + reason, (Throwable)x);
    }

    private IStatus createAPIViolationStatus(String operation) {
        String blame = this.createBlameMessage();
        Object[] args = new Object[]{operation};
        String reason = Messages.format(JavaTextMessages.CompletionProposalComputerDescriptor_reason_API, args);
        return new Status(2, JavaPlugin.getPluginId(), 0, String.valueOf(blame) + " " + reason, null);
    }

    private IStatus createPerformanceStatus(String operation) {
        String blame = this.createBlameMessage();
        Object[] args = new Object[]{operation};
        String reason = Messages.format(JavaTextMessages.CompletionProposalComputerDescriptor_reason_performance, args);
        return new Status(2, JavaPlugin.getPluginId(), 0, String.valueOf(blame) + " " + reason, null);
    }

    private String createBlameMessage() {
        Object[] args = new Object[]{this.getName(), this.fElement.getDeclaringExtension().getContributor().getName()};
        String disable = Messages.format(JavaTextMessages.CompletionProposalComputerDescriptor_blame_message, args);
        return disable;
    }

    private boolean isEnabled() {
        return this.fCategory.isEnabled();
    }

    CompletionProposalCategory getCategory() {
        return this.fCategory;
    }

    public String getErrorMessage() {
        return this.fLastError;
    }

    IContributor getContributor() {
        try {
            return this.fElement.getContributor();
        }
        catch (InvalidRegistryObjectException invalidRegistryObjectException) {
            return null;
        }
    }
}

