/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jem.util.logger.LogEntry;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.frameworks.internal.ui.WTPUIPlugin;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.GlobalConfiguration;
import org.eclipse.wst.validation.internal.ProjectConfiguration;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.operations.ValidatorManager;
import org.eclipse.wst.validation.internal.ui.DelegatingValidatorPreferencesDialog;
import org.eclipse.wst.validation.internal.ui.ResourceHandler;
import org.eclipse.wst.validation.internal.ui.ValidationPreferencePage;
import org.eclipse.wst.validation.internal.ui.ValidationUIMessages;
import org.eclipse.wst.validation.internal.ui.plugin.ValidationUIPlugin;

public class ValidationPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IValidationPage _pageImpl = null;

    protected Control createContents(Composite parent) {
        try {
            GlobalConfiguration gp = ConfigurationManager.getManager().getGlobalConfiguration();
            if (gp.numberOfValidators() == 0) {
                this._pageImpl = new NoValidatorsPage(parent);
            } else {
                try {
                    this._pageImpl = new ValidatorListPage(parent);
                }
                catch (InvocationTargetException exc) {
                    this._pageImpl = new InvalidPage(parent);
                    this.displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
                }
                catch (Throwable exc) {
                    this._pageImpl = new InvalidPage(parent);
                    this.displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
                }
            }
        }
        catch (InvocationTargetException exc) {
            this._pageImpl = new InvalidPage(parent);
            this.displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
        }
        catch (Throwable exc) {
            this._pageImpl = new InvalidPage(parent);
            this.displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
        }
        return this._pageImpl.getControl();
    }

    public void init(IWorkbench workbench) {
    }

    protected void noDefaultAndApplyButton() {
        super.noDefaultAndApplyButton();
    }

    protected void performDefaults() {
        super.performDefaults();
        try {
            this._pageImpl.performDefaults();
        }
        catch (InvocationTargetException exc) {
            this.displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
        }
        catch (Throwable exc) {
            this.displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
        }
    }

    public boolean performOk() {
        try {
            return this._pageImpl.performOk();
        }
        catch (InvocationTargetException exc) {
            this.displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
            return false;
        }
        catch (Throwable exc) {
            this.displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
            return false;
        }
    }

    public void dispose() {
        super.dispose();
        try {
            if (this._pageImpl != null) {
                this._pageImpl.dispose();
            }
        }
        catch (Throwable exc) {
            this.displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
        }
    }

    private void logError(Throwable exc) {
        Logger logger = WTPUIPlugin.getLogger();
        if (logger.isLoggingLevel(Level.SEVERE)) {
            LogEntry entry = ValidationUIPlugin.getLogEntry();
            entry.setSourceIdentifier("ValidationPreferencePage.displayAndLogError");
            entry.setMessageTypeIdentifier("VBF_EXC_INTERNAL_PAGE");
            entry.setTargetException(exc);
            logger.write(Level.SEVERE, (Object)entry);
            if (exc instanceof InvocationTargetException && ((InvocationTargetException)exc).getTargetException() != null) {
                entry.setTargetException(((InvocationTargetException)exc).getTargetException());
                logger.write(Level.SEVERE, (Object)entry);
            }
        }
    }

    void displayAndLogError(String title, String message, Throwable exc) {
        this.logError(exc);
        this.displayMessage(title, message, 1);
    }

    private void displayMessage(String title, String message, int iIconType) {
        MessageBox messageBox = new MessageBox(this.getShell(), 0x20 | iIconType | 0x10000);
        messageBox.setMessage(message);
        messageBox.setText(title);
        messageBox.open();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this._pageImpl == null) {
            return;
        }
        if (visible) {
            this._pageImpl.gainFocus();
        } else {
            this._pageImpl.loseFocus();
        }
    }

    protected Button getDefaultsButton() {
        return super.getDefaultsButton();
    }

    public static interface IValidationPage {
        public Composite createPage(Composite var1) throws InvocationTargetException;

        public boolean performOk() throws InvocationTargetException;

        public boolean performDefaults() throws InvocationTargetException;

        public Composite getControl();

        public void dispose();

        public void loseFocus();

        public void gainFocus();
    }

    public class InvalidPage
    implements IValidationPage {
        private Composite page = null;
        private Composite composite = null;
        private GridLayout layout = null;
        private Label messageLabel = null;

        public InvalidPage(Composite parent) {
            this.page = this.createPage(parent);
        }

        public Composite createPage(Composite parent) {
            ValidationPreferencePage.this.noDefaultAndApplyButton();
            ScrolledComposite sc1 = new ScrolledComposite(parent, 768);
            sc1.setLayoutData((Object)new GridData(1808));
            this.composite = new Composite((Composite)sc1, 0);
            sc1.setContent((Control)this.composite);
            this.layout = new GridLayout();
            this.composite.setLayout((Layout)this.layout);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.composite, "org.eclipse.wst.common.frameworks.ui.jvpp0000");
            this.messageLabel = new Label(this.composite, 0);
            this.messageLabel.setText(ResourceHandler.getExternalizedMessage("VBF_EXC_INVALID_REGISTER"));
            this.composite.setSize(this.composite.computeSize(-1, -1));
            return this.composite;
        }

        public boolean performDefaults() {
            return true;
        }

        public boolean performOk() {
            return true;
        }

        public Composite getControl() {
            return this.page;
        }

        public void dispose() {
            this.messageLabel.dispose();
            this.composite.dispose();
        }

        public void loseFocus() {
        }

        public void gainFocus() {
        }
    }

    private class NoValidatorsPage
    implements IValidationPage {
        private Composite page = null;
        private Composite composite = null;
        private GridLayout layout = null;
        private GridData data = null;
        private Label messageLabel = null;

        public NoValidatorsPage(Composite parent) {
            this.page = this.createPage(parent);
        }

        public Composite createPage(Composite parent) {
            ValidationPreferencePage.this.noDefaultAndApplyButton();
            ScrolledComposite sc1 = new ScrolledComposite(parent, 768);
            sc1.setLayoutData((Object)new GridData(1808));
            this.composite = new Composite((Composite)sc1, 0);
            sc1.setContent((Control)this.composite);
            this.layout = new GridLayout();
            this.composite.setLayout((Layout)this.layout);
            this.data = new GridData(272);
            this.composite.setLayoutData((Object)this.data);
            this.messageLabel = new Label(this.composite, 0);
            this.messageLabel.setText(ResourceHandler.getExternalizedMessage("VBF_UI_NO_VALIDATORS_INSTALLED"));
            this.composite.setSize(this.composite.computeSize(-1, -1));
            return this.composite;
        }

        public boolean performOk() {
            return true;
        }

        public boolean performDefaults() {
            return true;
        }

        public Composite getControl() {
            return this.page;
        }

        public void dispose() {
            this.messageLabel.dispose();
            this.composite.dispose();
        }

        public void loseFocus() {
        }

        public void gainFocus() {
        }
    }

    private class ValidatorListPage
    implements IValidationPage {
        private Composite page = null;
        private Composite composite = null;
        TableViewer validatorList = null;
        private Button enableAllButton = null;
        private Button disableAllButton = null;
        private Label emptyRowPlaceholder = null;
        Button disableAllValidation = null;
        Button overrideButton = null;
        Button saveButton = null;
        private Label listLabel = null;
        private Table validatorsTable;
        GlobalConfiguration pagePreferences = new GlobalConfiguration(ConfigurationManager.getManager().getGlobalConfiguration());
        private ValidatorMetaData[] _oldVmd = this.pagePreferences.getEnabledValidators();
        private Map _oldDelegates = new HashMap(this.pagePreferences.getDelegatingValidators());
        private boolean _allow = this.pagePreferences.canProjectsOverride();

        public ValidatorListPage(Composite parent) throws InvocationTargetException {
            this.page = this.createPage(parent);
        }

        private void setupTableColumns(Table table, TableViewer viewer) {
            TableColumn validatorColumn = new TableColumn(table, 0);
            validatorColumn.setText(ResourceHandler.getExternalizedMessage("VALIDATOR"));
            validatorColumn.setResizable(false);
            validatorColumn.setWidth(320);
            TableColumn manualColumn = new TableColumn(table, 0);
            manualColumn.setText(ResourceHandler.getExternalizedMessage("MANUAL"));
            manualColumn.setResizable(false);
            manualColumn.setWidth(40);
            TableColumn buildColumn = new TableColumn(table, 0);
            buildColumn.setText(ResourceHandler.getExternalizedMessage("BUILD"));
            buildColumn.setResizable(false);
            buildColumn.setWidth(40);
            TableColumn settingsColumn = new TableColumn(table, 0);
            settingsColumn.setText(ResourceHandler.getExternalizedMessage("SETTINGS"));
            settingsColumn.setResizable(false);
            settingsColumn.setWidth(50);
        }

        public Composite createPage(Composite parent) throws InvocationTargetException {
            ScrolledComposite sc1 = new ScrolledComposite(parent, 768);
            sc1.setLayoutData((Object)new GridData(1808));
            this.composite = new Composite((Composite)sc1, 0);
            sc1.setContent((Control)this.composite);
            this.composite.setLayout((Layout)new GridLayout());
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.composite, "org.eclipse.wst.common.frameworks.ui.jvgp0000");
            Composite validatorGroup = new Composite(this.composite, 0);
            GridLayout validatorGroupLayout = new GridLayout();
            validatorGroupLayout.numColumns = 2;
            validatorGroup.setLayout((Layout)validatorGroupLayout);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)validatorGroup, "org.eclipse.wst.common.frameworks.ui.jvgp0000");
            GridData overrideData = new GridData(768);
            this.emptyRowPlaceholder = new Label(validatorGroup, 0);
            this.emptyRowPlaceholder.setLayoutData((Object)new GridData());
            this.emptyRowPlaceholder = new Label(validatorGroup, 0);
            this.emptyRowPlaceholder.setLayoutData((Object)new GridData());
            overrideData.horizontalSpan = 2;
            this.overrideButton = new Button(validatorGroup, 32);
            this.overrideButton.setLayoutData((Object)overrideData);
            this.overrideButton.setText(ResourceHandler.getExternalizedMessage("PREF_BUTTON_OVERRIDE"));
            this.overrideButton.setEnabled(true);
            this.overrideButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ValidatorListPage this$1;
                {
                    this.this$1 = validatorListPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.pagePreferences.setCanProjectsOverride(this.this$1.overrideButton.getSelection());
                    try {
                        this.this$1.updateWidgets();
                    }
                    catch (InvocationTargetException exc) {
                        ValidatorListPage.access$3(this.this$1).displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
                    }
                }
            });
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.overrideButton, "org.eclipse.wst.common.frameworks.ui.jvgp0005");
            this.emptyRowPlaceholder = new Label(validatorGroup, 0);
            this.emptyRowPlaceholder.setLayoutData((Object)new GridData());
            GridData disableValidationData = new GridData(768);
            disableValidationData.horizontalSpan = 2;
            this.disableAllValidation = new Button(validatorGroup, 32);
            this.disableAllValidation.setLayoutData((Object)disableValidationData);
            this.disableAllValidation.setText(ResourceHandler.getExternalizedMessage("DISABLE_VALIDATION"));
            this.disableAllValidation.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ValidatorListPage this$1;
                {
                    this.this$1 = validatorListPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.pagePreferences.setDisableAllValidation(this.this$1.disableAllValidation.getSelection());
                    this.this$1.disableAllValidation.setFocus();
                    ValidatorListPage.access$0(this.this$1).setEnabled(!this.this$1.disableAllValidation.getSelection());
                    ValidatorListPage.access$1(this.this$1).setEnabled(!this.this$1.disableAllValidation.getSelection());
                    ValidatorListPage.access$2(this.this$1).setEnabled(!this.this$1.disableAllValidation.getSelection());
                    this.this$1.validatorList.refresh();
                }
            });
            this.emptyRowPlaceholder = new Label(validatorGroup, 0);
            this.emptyRowPlaceholder.setLayoutData((Object)new GridData());
            GridData saveFileData = new GridData(768);
            saveFileData.horizontalSpan = 2;
            this.saveButton = new Button(validatorGroup, 32);
            this.saveButton.setLayoutData((Object)saveFileData);
            this.saveButton.setText(ValidationUIMessages.PrefPage_always_save);
            this.saveButton.setSelection(this.pagePreferences.getSaveAutomatically());
            this.saveButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ValidatorListPage this$1;
                {
                    this.this$1 = validatorListPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.pagePreferences.setSaveAutomatically(this.this$1.saveButton.getSelection());
                    this.this$1.saveButton.setFocus();
                }
            });
            this.emptyRowPlaceholder = new Label(validatorGroup, 0);
            this.emptyRowPlaceholder.setLayoutData((Object)new GridData());
            this.listLabel = new Label(validatorGroup, 0);
            GridData listLabelData = new GridData(768);
            listLabelData.horizontalSpan = 2;
            this.listLabel.setLayoutData((Object)listLabelData);
            this.listLabel.setText(ResourceHandler.getExternalizedMessage("PREF_VALLIST_TITLE"));
            this.validatorsTable = new Table(validatorGroup, 67584);
            TableLayout tableLayout = new TableLayout();
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(160, true));
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(40, true));
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, true));
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(40, true));
            this.validatorsTable.setHeaderVisible(true);
            this.validatorsTable.setLinesVisible(true);
            this.validatorsTable.setLayout((Layout)tableLayout);
            this.validatorList = new TableViewer(this.validatorsTable);
            GridData validatorListData = new GridData(768);
            validatorListData.horizontalSpan = 2;
            this.validatorsTable.setLayoutData((Object)validatorListData);
            this.validatorList.getTable().setLayoutData((Object)validatorListData);
            this.validatorList.setLabelProvider((IBaseLabelProvider)new ValidationLabelProvider());
            this.validatorList.setContentProvider((IContentProvider)new ValidationContentProvider());
            this.validatorList.setSorter((ViewerSorter)new ValidationViewerSorter());
            this.setupTableColumns(this.validatorsTable, this.validatorList);
            this.validatorList.setInput((Object)this.pagePreferences.getValidators());
            this.validatorsTable.addMouseListener((MouseListener)new MouseAdapter(this){
                final /* synthetic */ ValidatorListPage this$1;
                {
                    this.this$1 = validatorListPage;
                }

                public void mouseDown(MouseEvent e) {
                    int columnNumber;
                    if (e.button != 1) {
                        return;
                    }
                    TableItem tableItem = ValidatorListPage.access$0(this.this$1).getItem(new Point(e.x, e.y));
                    if (tableItem == null || tableItem.isDisposed()) {
                        return;
                    }
                    int columnsCount = ValidatorListPage.access$0(this.this$1).getColumnCount();
                    if (columnsCount == 0) {
                        columnNumber = 0;
                    } else {
                        columnNumber = -1;
                        int i = 0;
                        while (i < columnsCount) {
                            Rectangle bounds = tableItem.getBounds(i);
                            if (bounds.contains(e.x, e.y)) {
                                columnNumber = i;
                                break;
                            }
                            ++i;
                        }
                        if (columnNumber == -1) {
                            return;
                        }
                    }
                    this.this$1.columnClicked(columnNumber);
                }
            });
            this.validatorsTable.setMenu(this.createContextMenu());
            this.validatorsTable.addFocusListener((FocusListener)new FocusAdapter(this){
                final /* synthetic */ ValidatorListPage this$1;
                {
                    this.this$1 = validatorListPage;
                }

                public void focusGained(FocusEvent e) {
                    super.focusGained(e);
                    if (ValidatorListPage.access$0(this.this$1).getSelectionCount() == 0) {
                        ValidatorListPage.access$0(this.this$1).select(0);
                    }
                }
            });
            this.enableAllButton = new Button(validatorGroup, 8);
            this.enableAllButton.setLayoutData((Object)new GridData());
            this.enableAllButton.setText(ResourceHandler.getExternalizedMessage("PREF_BUTTON_ENABLEALL"));
            this.enableAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ValidatorListPage this$1;
                {
                    this.this$1 = validatorListPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    try {
                        this.this$1.performEnableAll();
                    }
                    catch (InvocationTargetException exc) {
                        ValidatorListPage.access$3(this.this$1).displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
                    }
                }
            });
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.enableAllButton, "org.eclipse.wst.common.frameworks.ui.jvgp0000");
            this.disableAllButton = new Button(validatorGroup, 8);
            this.disableAllButton.setLayoutData((Object)new GridData());
            this.disableAllButton.setText(ResourceHandler.getExternalizedMessage("PREF_BUTTON_DISABLEALL"));
            this.disableAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ValidatorListPage this$1;
                {
                    this.this$1 = validatorListPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    try {
                        this.this$1.performDisableAll();
                    }
                    catch (InvocationTargetException exc) {
                        ValidatorListPage.access$3(this.this$1).displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
                    }
                }
            });
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.disableAllButton, "org.eclipse.wst.common.frameworks.ui.jvgp0000");
            Composite buttonGroup = new Composite(this.composite, 0);
            GridLayout buttonGroupLayout = new GridLayout();
            buttonGroupLayout.numColumns = 2;
            buttonGroup.setLayout((Layout)buttonGroupLayout);
            buttonGroup.setLayoutData((Object)new GridData(256));
            validatorGroup.setTabList(new Control[]{this.overrideButton, this.disableAllValidation, this.saveButton, this.validatorList.getTable(), this.enableAllButton, this.disableAllButton});
            this.updateWidgets();
            ValidationPreferencePage.this.applyDialogFont(this.composite);
            this.composite.setSize(this.composite.computeSize(-1, -1));
            return this.composite;
        }

        protected Menu createContextMenu() {
            Menu menu = new Menu((Decorations)this.validatorsTable.getShell(), 8);
            MenuItem manualItem = new MenuItem(menu, 32);
            manualItem.setText(ResourceHandler.getExternalizedMessage("PREF_MNU_MANUAL"));
            MenuItem buildItem = new MenuItem(menu, 32);
            buildItem.setText(ResourceHandler.getExternalizedMessage("PREF_MNU_BUILD"));
            MenuItem settingsItem = new MenuItem(menu, 8);
            settingsItem.setText(ResourceHandler.getExternalizedMessage("PREF_MNU_SETTINGS"));
            class MenuItemListener
            extends SelectionAdapter {
                final /* synthetic */ ValidatorListPage this$1;
                private final /* synthetic */ Menu val$menu;

                MenuItemListener(ValidatorListPage validatorListPage, Menu menu) {
                    this.this$1 = validatorListPage;
                    this.val$menu = menu;
                }

                public void widgetSelected(SelectionEvent e) {
                    MenuItem menuItem = (MenuItem)e.getSource();
                    int index = this.val$menu.indexOf(menuItem) + 1;
                    this.this$1.columnClicked(index);
                }
            }
            MenuItemListener listener = new MenuItemListener(this, menu);
            manualItem.addSelectionListener((SelectionListener)listener);
            buildItem.addSelectionListener((SelectionListener)listener);
            settingsItem.addSelectionListener((SelectionListener)listener);
            menu.addMenuListener((MenuListener)new MenuAdapter(this, manualItem, buildItem, settingsItem){
                final /* synthetic */ ValidatorListPage this$1;
                private final /* synthetic */ MenuItem val$manualItem;
                private final /* synthetic */ MenuItem val$buildItem;
                private final /* synthetic */ MenuItem val$settingsItem;
                {
                    this.this$1 = validatorListPage;
                    this.val$manualItem = menuItem;
                    this.val$buildItem = menuItem2;
                    this.val$settingsItem = menuItem3;
                }

                public void menuShown(MenuEvent e) {
                    IStructuredSelection selection = (IStructuredSelection)this.this$1.validatorList.getSelection();
                    ValidatorMetaData vmd = (ValidatorMetaData)selection.getFirstElement();
                    this.val$manualItem.setSelection(vmd.isManualValidation());
                    this.val$buildItem.setSelection(vmd.isBuildValidation());
                    this.val$settingsItem.setEnabled(vmd.isDelegating());
                }
            });
            return menu;
        }

        protected void columnClicked(int columnToEdit) {
            IStructuredSelection selection = (IStructuredSelection)this.validatorList.getSelection();
            ValidatorMetaData vmd = (ValidatorMetaData)selection.getFirstElement();
            switch (columnToEdit) {
                case 1: {
                    vmd.setManualValidation(!vmd.isManualValidation());
                    break;
                }
                case 2: {
                    vmd.setBuildValidation(!vmd.isBuildValidation());
                    break;
                }
                case 3: {
                    if (!vmd.isDelegating()) break;
                    String delegateID = this.pagePreferences.getDelegateUniqueName(vmd);
                    Shell shell = Display.getCurrent().getActiveShell();
                    DelegatingValidatorPreferencesDialog dialog = new DelegatingValidatorPreferencesDialog(shell, vmd, delegateID);
                    dialog.setBlockOnOpen(true);
                    dialog.create();
                    int result = dialog.open();
                    if (result != 0) break;
                    this.pagePreferences.setDelegateUniqueName(vmd, dialog.getDelegateID());
                    break;
                }
            }
            this.validatorList.refresh();
        }

        protected void updateWidgets() throws InvocationTargetException {
            this.updateTable();
            this.updateAllWidgets();
            this.updateHelp();
        }

        protected void updateWidgetsForDefaults() throws InvocationTargetException {
            this.updateTableForDefaults();
            this.updateAllWidgets();
            this.updateHelp();
        }

        private void updateAllWidgets() throws InvocationTargetException {
            this.overrideButton.setSelection(this.pagePreferences.canProjectsOverride());
            this.disableAllValidation.setSelection(this.pagePreferences.isDisableAllValidation());
            this.validatorsTable.setEnabled(!this.disableAllValidation.getSelection());
            this.enableAllButton.setEnabled(!this.disableAllValidation.getSelection());
            this.disableAllButton.setEnabled(!this.disableAllValidation.getSelection());
        }

        protected void updateTable() throws InvocationTargetException {
            TableItem[] items = this.validatorsTable.getItems();
            int i = 0;
            while (i < items.length) {
                TableItem item = items[i];
                ValidatorMetaData vmd = (ValidatorMetaData)item.getData();
                if (this.pagePreferences.isManualEnabled(vmd)) {
                    vmd.setManualValidation(true);
                } else {
                    vmd.setManualValidation(false);
                }
                if (this.pagePreferences.isBuildEnabled(vmd)) {
                    vmd.setBuildValidation(true);
                } else {
                    vmd.setBuildValidation(false);
                }
                ++i;
            }
            this.validatorList.refresh();
        }

        protected void updateTableForDefaults() throws InvocationTargetException {
            TableItem[] items = this.validatorsTable.getItems();
            int i = 0;
            while (i < items.length) {
                TableItem item = items[i];
                ValidatorMetaData vmd = (ValidatorMetaData)item.getData();
                if (this.pagePreferences.isEnabled(vmd)) {
                    vmd.setManualValidation(true);
                    vmd.setBuildValidation(true);
                } else {
                    vmd.setManualValidation(false);
                    vmd.setBuildValidation(false);
                }
                ++i;
            }
            this.validatorList.refresh();
        }

        protected void enableManualAndBuildValues() {
            TableItem[] items = this.validatorsTable.getItems();
            int i = 0;
            while (i < items.length) {
                TableItem item = items[i];
                ValidatorMetaData vmd = (ValidatorMetaData)item.getData();
                vmd.setManualValidation(true);
                vmd.setBuildValidation(true);
                ++i;
            }
            this.validatorList.refresh();
        }

        protected void disableManualAndBuildValues() {
            TableItem[] items = this.validatorsTable.getItems();
            int i = 0;
            while (i < items.length) {
                TableItem item = items[i];
                ValidatorMetaData vmd = (ValidatorMetaData)item.getData();
                vmd.setManualValidation(false);
                vmd.setBuildValidation(false);
                ++i;
            }
            this.validatorList.refresh();
        }

        public boolean performOk() throws InvocationTargetException {
            this.storeValues();
            this.updateTaskList();
            return true;
        }

        public boolean performDefaults() throws InvocationTargetException {
            this.pagePreferences.restoreDefaults();
            this.updateWidgetsForDefaults();
            ValidationPreferencePage.this.getDefaultsButton().setFocus();
            return true;
        }

        public boolean performEnableAll() throws InvocationTargetException {
            this.setAllValidators(true);
            this.pagePreferences.setEnabledValidators(this.getEnabledValidators());
            this.enableManualAndBuildValues();
            this.enableAllButton.setFocus();
            return true;
        }

        private void setAllValidators(boolean bool) {
            TableItem[] items = this.validatorsTable.getItems();
            int i = 0;
            while (i < items.length) {
                ValidatorMetaData validatorMetaData = (ValidatorMetaData)items[i].getData();
                validatorMetaData.setManualValidation(bool);
                validatorMetaData.setBuildValidation(bool);
                ++i;
            }
        }

        public ValidatorMetaData[] getEnabledValidators() {
            ArrayList<ValidatorMetaData> enabledValidators = new ArrayList<ValidatorMetaData>();
            TableItem[] items = this.validatorsTable.getItems();
            int i = 0;
            while (i < items.length) {
                ValidatorMetaData validatorMetaData = (ValidatorMetaData)items[i].getData();
                if (validatorMetaData.isManualValidation() || validatorMetaData.isBuildValidation()) {
                    enabledValidators.add(validatorMetaData);
                }
                ++i;
            }
            return enabledValidators.toArray(new ValidatorMetaData[enabledValidators.size()]);
        }

        public ValidatorMetaData[] getEnabledManualValidators() {
            ArrayList<ValidatorMetaData> enabledValidators = new ArrayList<ValidatorMetaData>();
            TableItem[] items = this.validatorsTable.getItems();
            int i = 0;
            while (i < items.length) {
                ValidatorMetaData validatorMetaData = (ValidatorMetaData)items[i].getData();
                if (validatorMetaData.isManualValidation()) {
                    enabledValidators.add(validatorMetaData);
                }
                ++i;
            }
            return enabledValidators.toArray(new ValidatorMetaData[enabledValidators.size()]);
        }

        public ValidatorMetaData[] getEnabledBuildValidators() {
            ArrayList<ValidatorMetaData> enabledValidators = new ArrayList<ValidatorMetaData>();
            TableItem[] items = this.validatorsTable.getItems();
            int i = 0;
            while (i < items.length) {
                ValidatorMetaData validatorMetaData = (ValidatorMetaData)items[i].getData();
                if (validatorMetaData.isBuildValidation()) {
                    enabledValidators.add(validatorMetaData);
                }
                ++i;
            }
            return enabledValidators.toArray(new ValidatorMetaData[enabledValidators.size()]);
        }

        public boolean performDisableAll() throws InvocationTargetException {
            this.setAllValidators(false);
            this.pagePreferences.setEnabledValidators(this.getEnabledValidators());
            this.disableManualAndBuildValues();
            this.disableAllButton.setFocus();
            return true;
        }

        protected void updateHelp() {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.disableAllValidation, "org.eclipse.wst.common.frameworks.ui.jvgp0010");
        }

        private void storeValues() throws InvocationTargetException {
            this.pagePreferences.setCanProjectsOverride(this.overrideButton.getSelection());
            if (this.disableAllValidation.isEnabled()) {
                this.pagePreferences.setDisableAllValidation(this.disableAllValidation.getSelection());
            }
            this.pagePreferences.setEnabledManualValidators(this.getEnabledManualValidators());
            this.pagePreferences.setEnabledBuildValidators(this.getEnabledBuildValidators());
            this.pagePreferences.passivate();
            this.pagePreferences.store();
            if (!this.pagePreferences.canProjectsOverride()) {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IProject[] projects = workspace.getRoot().getProjects();
                int i = 0;
                while (i < projects.length) {
                    IProject project = projects[i];
                    try {
                        if (project.isOpen() && ConfigurationManager.getManager().isMigrated(project)) {
                            ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(project);
                            prjp.setDoesProjectOverride(false);
                            prjp.passivate();
                            prjp.store();
                        }
                    }
                    catch (InvocationTargetException exc) {
                        ValidationPreferencePage.this.displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
                    }
                    ++i;
                }
            }
        }

        private void updateTaskList() {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProject[] projects = workspace.getRoot().getProjects();
            boolean allowChanged = this.pagePreferences.canProjectsOverride() ^ this._allow;
            int i = 0;
            while (i < projects.length) {
                IProject project = projects[i];
                try {
                    ProjectConfiguration prjp;
                    if (project.isOpen() && !(prjp = ConfigurationManager.getManager().getProjectConfiguration(project)).doesProjectOverride()) {
                        if (!prjp.hasEnabledValidatorsChanged(this._oldVmd, allowChanged)) {
                            // empty if block
                        }
                        if (!prjp.haveDelegatesChanged(this._oldDelegates, allowChanged)) {
                            // empty if block
                        }
                        ValidatorManager.getManager().updateTaskList(project);
                    }
                }
                catch (InvocationTargetException exc) {
                    ValidationPreferencePage.this.displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
                }
                ++i;
            }
        }

        public Composite getControl() {
            return this.page;
        }

        public void dispose() {
            this.listLabel.dispose();
            this.overrideButton.dispose();
            this.disableAllValidation.dispose();
            this.emptyRowPlaceholder.dispose();
            this.disableAllButton.dispose();
            this.enableAllButton.dispose();
            this.validatorList.getTable().dispose();
            this.composite.dispose();
        }

        public void loseFocus() {
        }

        public void gainFocus() {
        }

        static /* synthetic */ Button access$1(ValidatorListPage validatorListPage) {
            return validatorListPage.enableAllButton;
        }

        static /* synthetic */ Button access$2(ValidatorListPage validatorListPage) {
            return validatorListPage.disableAllButton;
        }

        static /* synthetic */ ValidationPreferencePage access$3(ValidatorListPage validatorListPage) {
            return validatorListPage.ValidationPreferencePage.this;
        }

        public class ValidationContentProvider
        implements IStructuredContentProvider {
            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof ValidatorMetaData[]) {
                    return (ValidatorMetaData[])inputElement;
                }
                return new Object[0];
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        }

        public class ValidationLabelProvider
        extends LabelProvider
        implements ITableLabelProvider {
            public String getText(Object element) {
                if (element == null) {
                    return "";
                }
                if (element instanceof ValidatorMetaData) {
                    return ((ValidatorMetaData)element).getValidatorDisplayName();
                }
                return super.getText(element);
            }

            private Image getImage(String imageName) {
                boolean isDisabled;
                boolean bl = isDisabled = !ValidatorListPage.this.validatorsTable.isEnabled();
                if (isDisabled) {
                    imageName = String.valueOf(imageName) + "_disabled";
                }
                Image image = ValidationUIPlugin.getPlugin().getImage(imageName);
                return image;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                ValidatorMetaData vmd;
                if (columnIndex == 1) {
                    if (((ValidatorMetaData)element).isManualValidation()) {
                        return this.getImage("ok_tbl");
                    }
                    return this.getImage("fail_tbl");
                }
                if (columnIndex == 2) {
                    if (((ValidatorMetaData)element).isBuildValidation()) {
                        return this.getImage("ok_tbl");
                    }
                    return this.getImage("fail_tbl");
                }
                if (columnIndex == 3 && (vmd = (ValidatorMetaData)element).isDelegating()) {
                    return this.getImage("settings");
                }
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (columnIndex == 0) {
                    return ((ValidatorMetaData)element).getValidatorDisplayName();
                }
                return null;
            }
        }

        public class ValidationViewerSorter
        extends ViewerSorter {
            public int compare(Viewer viewer, Object e1, Object e2) {
                return super.compare(viewer, e1, e2);
            }
        }
    }
}

