/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
 package org.eclipse.wst.rdb.server.internal.ui.actions.providers;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonMenuConstants;
import org.eclipse.wst.rdb.server.internal.ui.actions.FilterAction;

public final class FilterProvider extends CommonActionProvider {

	private static final FilterAction action = new FilterAction();
	protected ISelectionProvider selectionProvider;
	protected CommonViewer viewer;
	protected ActionContributionItem ITEM;

	public void init(ICommonActionExtensionSite aSite)
	{
		super.init(aSite);
		this.selectionProvider = aSite.getViewSite().getSelectionProvider();
		this.viewer = (CommonViewer) aSite.getStructuredViewer();
		initActionContributionItem();
	}

	public void fillContextMenu(IMenuManager menu)
	{
		action.selectionChanged(new SelectionChangedEvent(this.selectionProvider, this.getContext().getSelection()));
		menu.appendToGroup(ICommonMenuConstants.GROUP_ADDITIONS, ITEM);
	}

	protected void initActionContributionItem()
	{
		ITEM = new ActionContributionItem(action);
	}

}
