/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.server.internal.ui.explorer.providers.label;

import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IVirtualNode;
import org.eclipse.wst.rdb.core.internal.ui.services.IDataToolsUIServiceManager;
import org.eclipse.wst.rdb.core.internal.ui.services.StateManager;
import org.eclipse.wst.rdb.core.internal.ui.services.IStateProvider.State;
import org.eclipse.wst.rdb.internal.models.sql.schema.Dependency;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLSchemaPackage;
import org.eclipse.wst.rdb.server.internal.ui.util.resources.ResourceLoader;


/**
 * @author ljulien
 */
public class ServerExplorerLabelProvider extends LabelProvider implements ICommonLabelProvider//, IColorProvider
{
	private static final ResourceLoader resourceLoader = ResourceLoader.INSTANCE;
	private static final IDataToolsUIServiceManager imageService = IDataToolsUIServiceManager.INSTANCE;
	private static final String EXTERNAL_DEPENDENCY = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.EXTERNAL_DEPENDENCY"); //$NON-NLS-1$
	private static final StateManager stateManager = StateManager.INSTANCE;
	private static final String SPACE = " "; //$NON-NLS-1$
	
	private static Color background = null;
	
	private State getState (SQLObject sqlObject)
	{
		return stateManager.getState(sqlObject);
	}
	
	public static Integer RGBToInteger(RGB rgb) 
	{
		return new Integer((rgb.blue << 16) | (rgb.green << 8) | rgb.red);
	}

	public static Color integerToColor(Integer i) {
		if (i == null)
			return null;
		int color = i.intValue();
		return new Color(
			null,
			(color & 0x000000FF),
			(color & 0x0000FF00) >> 8,
			(color & 0x00FF0000) >> 16);
	}
	
	public void dispose ()
	{
		if (this.background != null && !this.background.isDisposed())
		{
			this.background.dispose ();
		}
		this.background = null;
	}
	
	/**
     * @return the Image associated with this element
     */
    public Image getImage(Object element)
    {
        return imageService.getLabelService(element).getIcon();
    }

    /**
     * @return the Text associated with this element
     */
    public String getText(Object element)
    {
		if (element instanceof IVirtualNode)
		{
			return ((IVirtualNode) element).getDisplayName();
		}
		else if (element instanceof Dependency)
		{
		    return EXTERNAL_DEPENDENCY;
		}
		else if (element instanceof ENamedElement)
		{
			if (SQLSchemaPackage.eINSTANCE.getSQLObject().isSuperTypeOf(((EObject)element).eClass()))
			{
				//State state = getState((SQLObject) element);
				//if (state == State.CREATE || state == State.ALTER)
				//{
					//return ((ENamedElement)element).getName() + SPACE + state.getDisplayState();
				//}
			}
		    return ((ENamedElement)element).getName();
		}
		else 
		{
			return imageService.getLabelService(element).getName();
		}
    }

	public Color getBackground(Object element)
	{
		if (element instanceof SQLObject)
		{
			State state = getState((SQLObject) element);
			if (state == State.CREATE || state == State.ALTER)
			{
				return this.background;
			}
		}
		return null;
	}

	public Color getForeground(Object element)
	{
		if (element instanceof SQLObject)
		{
			State state = getState((SQLObject) element);
			if (state == State.ALTER)
			{
				return Display.getCurrent().getSystemColor(SWT.COLOR_RED);
			}
			else if (state == State.CREATE)
			{
				return Display.getCurrent().getSystemColor(SWT.COLOR_GRAY);
			}
		}
		return null;
	}

	public String getDescription(Object element)
	{
		return imageService.getLabelService(element).getName();
	}

	public void init(ICommonContentExtensionSite aConfig)
	{
		this.background = integerToColor(RGBToInteger(new RGB(232, 242, 254)));
	}

	public void restoreState(IMemento aMemento)
	{
	}

	public void saveState(IMemento aMemento)
	{
	}
}
