/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.server.internal.ui.query.execute;

import java.sql.Connection;
import java.sql.Statement;


public interface ISQLExecutionProvider 
{
  /* Returns a boolean which indicates whether this provider can be used 
   * to execute the SQL string passed in. */
  public boolean isProviderFor(String sqlStatementStr);

  /* Executes the SQL statement passed in on teh connection 
   * passed in.  The string must be a complete statement.  This 
   * method must only be called after the isProviderFor() method 
   * has returned true. Returns the JDBC statement that was 
   * created to execute the SQL statement passed in.  */
  public Statement execute(Connection con, String sqlStatementStr) throws Exception;
}