/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.internal.models.sql.tables;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.AbstractEnumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Action Time Type</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * The literals of this enumeration are used to indicate whether the actionStatement of Trigger are executed before or after rows are inserted into a table, rows are deleted from a table, or one or more columns are updated in rows of a table.
 * <!-- end-model-doc -->
 * @see org.eclipse.wst.rdb.internal.models.sql.tables.SQLTablesPackage#getActionTimeType()
 * @model
 * @generated
 */
public final class ActionTimeType extends AbstractEnumerator {
	/**
	 * The '<em><b>AFTER</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #AFTER_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int AFTER = 0;

	/**
	 * The '<em><b>BEFORE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #BEFORE_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int BEFORE = 1;

	/**
	 * The '<em><b>INSTEADOF</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #INSTEADOF_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int INSTEADOF = 2;

	/**
	 * The '<em><b>AFTER</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>AFTER</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #AFTER
	 * @generated
	 * @ordered
	 */
	public static final ActionTimeType AFTER_LITERAL = new ActionTimeType(AFTER, "AFTER", "AFTER"); //$NON-NLS-1$

	/**
	 * The '<em><b>BEFORE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>BEFORE</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #BEFORE
	 * @generated
	 * @ordered
	 */
	public static final ActionTimeType BEFORE_LITERAL = new ActionTimeType(BEFORE, "BEFORE", "BEFORE"); //$NON-NLS-1$

	/**
	 * The '<em><b>INSTEADOF</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>INSTEADOF</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #INSTEADOF
	 * @generated
	 * @ordered
	 */
	public static final ActionTimeType INSTEADOF_LITERAL = new ActionTimeType(INSTEADOF, "INSTEADOF", "INSTEADOF"); //$NON-NLS-1$

	/**
	 * An array of all the '<em><b>Action Time Type</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final ActionTimeType[] VALUES_ARRAY =
		new ActionTimeType[] {
			AFTER_LITERAL,
			BEFORE_LITERAL,
			INSTEADOF_LITERAL,
		};

	/**
	 * A public read-only list of all the '<em><b>Action Time Type</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Action Time Type</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static ActionTimeType get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ActionTimeType result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Action Time Type</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static ActionTimeType getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ActionTimeType result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Action Time Type</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static ActionTimeType get(int value) {
		switch (value) {
			case AFTER: return AFTER_LITERAL;
			case BEFORE: return BEFORE_LITERAL;
			case INSTEADOF: return INSTEADOF_LITERAL;
		}
		return null;	
	}

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private ActionTimeType(int value, String name, String literal) {
		super(value, name, literal);
	}

} //ActionTimeType
