/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.internal.core.connection;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class CallableStatementAdapter implements CallableStatement
{
	private ConnectionAdapter conection;
	private CallableStatement statement;

	public CallableStatementAdapter(ConnectionAdapter connection, CallableStatement statement)
	{
		this.conection = connection;
		this.statement = statement;
	}

	public void addBatch() throws SQLException
	{
		statement.addBatch();
	}

	public void addBatch(String sql) throws SQLException
	{
		statement.addBatch(sql);
	}

	public void cancel() throws SQLException
	{
		statement.cancel();
	}

	public void clearBatch() throws SQLException
	{
		statement.clearBatch();
	}

	public void clearParameters() throws SQLException
	{
		statement.clearParameters();
	}

	public void clearWarnings() throws SQLException
	{
		statement.clearWarnings();
	}

	public void close() throws SQLException
	{
		this.conection.releaseStatement();
		statement.close();
	}

	public boolean execute() throws SQLException
	{
		try
		{
			return statement.execute();
		}
		catch (SQLException e)
		{
			this.conection.releaseStatement();
			throw e;
		}
	}

	public boolean execute(String sql, int autoGeneratedKeys) throws SQLException
	{
		return statement.execute(sql, autoGeneratedKeys);
	}

	public boolean execute(String sql, int[] columnIndexes) throws SQLException
	{
		return statement.execute(sql, columnIndexes);
	}

	public boolean execute(String sql, String[] columnNames) throws SQLException
	{
		return statement.execute(sql, columnNames);
	}

	public boolean execute(String sql) throws SQLException
	{
		return statement.execute(sql);
	}

	public int[] executeBatch() throws SQLException
	{
		return statement.executeBatch();
	}

	public ResultSet executeQuery() throws SQLException
	{
		return statement.executeQuery();
	}

	public ResultSet executeQuery(String sql) throws SQLException
	{
		return statement.executeQuery(sql);
	}

	public int executeUpdate() throws SQLException
	{
		return statement.executeUpdate();
	}

	public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException
	{
		return statement.executeUpdate(sql, autoGeneratedKeys);
	}

	public int executeUpdate(String sql, int[] columnIndexes) throws SQLException
	{
		return statement.executeUpdate(sql, columnIndexes);
	}

	public int executeUpdate(String sql, String[] columnNames) throws SQLException
	{
		return statement.executeUpdate(sql, columnNames);
	}

	public int executeUpdate(String sql) throws SQLException
	{
		return statement.executeUpdate(sql);
	}

	public Array getArray(int i) throws SQLException
	{
		return statement.getArray(i);
	}

	public Array getArray(String parameterName) throws SQLException
	{
		return statement.getArray(parameterName);
	}

	public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException
	{
		return statement.getBigDecimal(parameterIndex, scale);
	}

	public BigDecimal getBigDecimal(int parameterIndex) throws SQLException
	{
		return statement.getBigDecimal(parameterIndex);
	}

	public BigDecimal getBigDecimal(String parameterName) throws SQLException
	{
		return statement.getBigDecimal(parameterName);
	}

	public Blob getBlob(int i) throws SQLException
	{
		return statement.getBlob(i);
	}

	public Blob getBlob(String parameterName) throws SQLException
	{
		return statement.getBlob(parameterName);
	}

	public boolean getBoolean(int parameterIndex) throws SQLException
	{
		return statement.getBoolean(parameterIndex);
	}

	public boolean getBoolean(String parameterName) throws SQLException
	{
		return statement.getBoolean(parameterName);
	}

	public byte getByte(int parameterIndex) throws SQLException
	{
		return statement.getByte(parameterIndex);
	}

	public byte getByte(String parameterName) throws SQLException
	{
		return statement.getByte(parameterName);
	}

	public byte[] getBytes(int parameterIndex) throws SQLException
	{
		return statement.getBytes(parameterIndex);
	}

	public byte[] getBytes(String parameterName) throws SQLException
	{
		return statement.getBytes(parameterName);
	}

	public Clob getClob(int i) throws SQLException
	{
		return statement.getClob(i);
	}

	public Clob getClob(String parameterName) throws SQLException
	{
		return statement.getClob(parameterName);
	}

	public Connection getConnection() throws SQLException
	{
		return this.conection;
	}

	public Date getDate(int parameterIndex, Calendar cal) throws SQLException
	{
		return statement.getDate(parameterIndex, cal);
	}

	public Date getDate(int parameterIndex) throws SQLException
	{
		return statement.getDate(parameterIndex);
	}

	public Date getDate(String parameterName, Calendar cal) throws SQLException
	{
		return statement.getDate(parameterName, cal);
	}

	public Date getDate(String parameterName) throws SQLException
	{
		return statement.getDate(parameterName);
	}

	public double getDouble(int parameterIndex) throws SQLException
	{
		return statement.getDouble(parameterIndex);
	}

	public double getDouble(String parameterName) throws SQLException
	{
		return statement.getDouble(parameterName);
	}

	public int getFetchDirection() throws SQLException
	{
		return statement.getFetchDirection();
	}

	public int getFetchSize() throws SQLException
	{
		return statement.getFetchSize();
	}

	public float getFloat(int parameterIndex) throws SQLException
	{
		return statement.getFloat(parameterIndex);
	}

	public float getFloat(String parameterName) throws SQLException
	{
		return statement.getFloat(parameterName);
	}

	public ResultSet getGeneratedKeys() throws SQLException
	{
		return statement.getGeneratedKeys();
	}

	public int getInt(int parameterIndex) throws SQLException
	{
		return statement.getInt(parameterIndex);
	}

	public int getInt(String parameterName) throws SQLException
	{
		return statement.getInt(parameterName);
	}

	public long getLong(int parameterIndex) throws SQLException
	{
		return statement.getLong(parameterIndex);
	}

	public long getLong(String parameterName) throws SQLException
	{
		return statement.getLong(parameterName);
	}

	public int getMaxFieldSize() throws SQLException
	{
		return statement.getMaxFieldSize();
	}

	public int getMaxRows() throws SQLException
	{
		return statement.getMaxRows();
	}

	public ResultSetMetaData getMetaData() throws SQLException
	{
		return statement.getMetaData();
	}

	public boolean getMoreResults() throws SQLException
	{
		return statement.getMoreResults();
	}

	public boolean getMoreResults(int current) throws SQLException
	{
		return statement.getMoreResults(current);
	}

	public Object getObject(int arg0, Map arg1) throws SQLException
	{
		return statement.getObject(arg0, arg1);
	}

	public Object getObject(int parameterIndex) throws SQLException
	{
		return statement.getObject(parameterIndex);
	}

	public Object getObject(String arg0, Map arg1) throws SQLException
	{
		return statement.getObject(arg0, arg1);
	}

	public Object getObject(String parameterName) throws SQLException
	{
		return statement.getObject(parameterName);
	}

	public ParameterMetaData getParameterMetaData() throws SQLException
	{
		return statement.getParameterMetaData();
	}

	public int getQueryTimeout() throws SQLException
	{
		return statement.getQueryTimeout();
	}

	public Ref getRef(int i) throws SQLException
	{
		return statement.getRef(i);
	}

	public Ref getRef(String parameterName) throws SQLException
	{
		return statement.getRef(parameterName);
	}

	public ResultSet getResultSet() throws SQLException
	{
		return statement.getResultSet();
	}

	public int getResultSetConcurrency() throws SQLException
	{
		return statement.getResultSetConcurrency();
	}

	public int getResultSetHoldability() throws SQLException
	{
		return statement.getResultSetHoldability();
	}

	public int getResultSetType() throws SQLException
	{
		return statement.getResultSetType();
	}

	public short getShort(int parameterIndex) throws SQLException
	{
		return statement.getShort(parameterIndex);
	}

	public short getShort(String parameterName) throws SQLException
	{
		return statement.getShort(parameterName);
	}

	public String getString(int parameterIndex) throws SQLException
	{
		return statement.getString(parameterIndex);
	}

	public String getString(String parameterName) throws SQLException
	{
		return statement.getString(parameterName);
	}

	public Time getTime(int parameterIndex, Calendar cal) throws SQLException
	{
		return statement.getTime(parameterIndex, cal);
	}

	public Time getTime(int parameterIndex) throws SQLException
	{
		return statement.getTime(parameterIndex);
	}

	public Time getTime(String parameterName, Calendar cal) throws SQLException
	{
		return statement.getTime(parameterName, cal);
	}

	public Time getTime(String parameterName) throws SQLException
	{
		return statement.getTime(parameterName);
	}

	public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException
	{
		return statement.getTimestamp(parameterIndex, cal);
	}

	public Timestamp getTimestamp(int parameterIndex) throws SQLException
	{
		return statement.getTimestamp(parameterIndex);
	}

	public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException
	{
		return statement.getTimestamp(parameterName, cal);
	}

	public Timestamp getTimestamp(String parameterName) throws SQLException
	{
		return statement.getTimestamp(parameterName);
	}

	public int getUpdateCount() throws SQLException
	{
		return statement.getUpdateCount();
	}

	public URL getURL(int parameterIndex) throws SQLException
	{
		return statement.getURL(parameterIndex);
	}

	public URL getURL(String parameterName) throws SQLException
	{
		return statement.getURL(parameterName);
	}

	public SQLWarning getWarnings() throws SQLException
	{
		return statement.getWarnings();
	}

	public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException
	{
		statement.registerOutParameter(parameterIndex, sqlType, scale);
	}

	public void registerOutParameter(int paramIndex, int sqlType, String typeName) throws SQLException
	{
		statement.registerOutParameter(paramIndex, sqlType, typeName);
	}

	public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException
	{
		statement.registerOutParameter(parameterIndex, sqlType);
	}

	public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException
	{
		statement.registerOutParameter(parameterName, sqlType, scale);
	}

	public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException
	{
		statement.registerOutParameter(parameterName, sqlType, typeName);
	}

	public void registerOutParameter(String parameterName, int sqlType) throws SQLException
	{
		statement.registerOutParameter(parameterName, sqlType);
	}

	public void setArray(int i, Array x) throws SQLException
	{
		statement.setArray(i, x);
	}

	public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException
	{
		statement.setAsciiStream(parameterIndex, x, length);
	}

	public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException
	{
		statement.setAsciiStream(parameterName, x, length);
	}

	public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException
	{
		statement.setBigDecimal(parameterIndex, x);
	}

	public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException
	{
		statement.setBigDecimal(parameterName, x);
	}

	public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException
	{
		statement.setBinaryStream(parameterIndex, x, length);
	}

	public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException
	{
		statement.setBinaryStream(parameterName, x, length);
	}

	public void setBlob(int i, Blob x) throws SQLException
	{
		statement.setBlob(i, x);
	}

	public void setBoolean(int parameterIndex, boolean x) throws SQLException
	{
		statement.setBoolean(parameterIndex, x);
	}

	public void setBoolean(String parameterName, boolean x) throws SQLException
	{
		statement.setBoolean(parameterName, x);
	}

	public void setByte(int parameterIndex, byte x) throws SQLException
	{
		statement.setByte(parameterIndex, x);
	}

	public void setByte(String parameterName, byte x) throws SQLException
	{
		statement.setByte(parameterName, x);
	}

	public void setBytes(int parameterIndex, byte[] x) throws SQLException
	{
		statement.setBytes(parameterIndex, x);
	}

	public void setBytes(String parameterName, byte[] x) throws SQLException
	{
		statement.setBytes(parameterName, x);
	}

	public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException
	{
		statement.setCharacterStream(parameterIndex, reader, length);
	}

	public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException
	{
		statement.setCharacterStream(parameterName, reader, length);
	}

	public void setClob(int i, Clob x) throws SQLException
	{
		statement.setClob(i, x);
	}

	public void setCursorName(String name) throws SQLException
	{
		statement.setCursorName(name);
	}

	public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException
	{
		statement.setDate(parameterIndex, x, cal);
	}

	public void setDate(int parameterIndex, Date x) throws SQLException
	{
		statement.setDate(parameterIndex, x);
	}

	public void setDate(String parameterName, Date x, Calendar cal) throws SQLException
	{
		statement.setDate(parameterName, x, cal);
	}

	public void setDate(String parameterName, Date x) throws SQLException
	{
		statement.setDate(parameterName, x);
	}

	public void setDouble(int parameterIndex, double x) throws SQLException
	{
		statement.setDouble(parameterIndex, x);
	}

	public void setDouble(String parameterName, double x) throws SQLException
	{
		statement.setDouble(parameterName, x);
	}

	public void setEscapeProcessing(boolean enable) throws SQLException
	{
		statement.setEscapeProcessing(enable);
	}

	public void setFetchDirection(int direction) throws SQLException
	{
		statement.setFetchDirection(direction);
	}

	public void setFetchSize(int rows) throws SQLException
	{
		statement.setFetchSize(rows);
	}

	public void setFloat(int parameterIndex, float x) throws SQLException
	{
		statement.setFloat(parameterIndex, x);
	}

	public void setFloat(String parameterName, float x) throws SQLException
	{
		statement.setFloat(parameterName, x);
	}

	public void setInt(int parameterIndex, int x) throws SQLException
	{
		statement.setInt(parameterIndex, x);
	}

	public void setInt(String parameterName, int x) throws SQLException
	{
		statement.setInt(parameterName, x);
	}

	public void setLong(int parameterIndex, long x) throws SQLException
	{
		statement.setLong(parameterIndex, x);
	}

	public void setLong(String parameterName, long x) throws SQLException
	{
		statement.setLong(parameterName, x);
	}

	public void setMaxFieldSize(int max) throws SQLException
	{
		statement.setMaxFieldSize(max);
	}

	public void setMaxRows(int max) throws SQLException
	{
		statement.setMaxRows(max);
	}

	public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException
	{
		statement.setNull(paramIndex, sqlType, typeName);
	}

	public void setNull(int parameterIndex, int sqlType) throws SQLException
	{
		statement.setNull(parameterIndex, sqlType);
	}

	public void setNull(String parameterName, int sqlType, String typeName) throws SQLException
	{
		statement.setNull(parameterName, sqlType, typeName);
	}

	public void setNull(String parameterName, int sqlType) throws SQLException
	{
		statement.setNull(parameterName, sqlType);
	}

	public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException
	{
		statement.setObject(parameterIndex, x, targetSqlType, scale);
	}

	public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException
	{
		statement.setObject(parameterIndex, x, targetSqlType);
	}

	public void setObject(int parameterIndex, Object x) throws SQLException
	{
		statement.setObject(parameterIndex, x);
	}

	public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException
	{
		statement.setObject(parameterName, x, targetSqlType, scale);
	}

	public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException
	{
		statement.setObject(parameterName, x, targetSqlType);
	}

	public void setObject(String parameterName, Object x) throws SQLException
	{
		statement.setObject(parameterName, x);
	}

	public void setQueryTimeout(int seconds) throws SQLException
	{
		statement.setQueryTimeout(seconds);
	}

	public void setRef(int i, Ref x) throws SQLException
	{
		statement.setRef(i, x);
	}

	public void setShort(int parameterIndex, short x) throws SQLException
	{
		statement.setShort(parameterIndex, x);
	}

	public void setShort(String parameterName, short x) throws SQLException
	{
		statement.setShort(parameterName, x);
	}

	public void setString(int parameterIndex, String x) throws SQLException
	{
		statement.setString(parameterIndex, x);
	}

	public void setString(String parameterName, String x) throws SQLException
	{
		statement.setString(parameterName, x);
	}

	public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException
	{
		statement.setTime(parameterIndex, x, cal);
	}

	public void setTime(int parameterIndex, Time x) throws SQLException
	{
		statement.setTime(parameterIndex, x);
	}

	public void setTime(String parameterName, Time x, Calendar cal) throws SQLException
	{
		statement.setTime(parameterName, x, cal);
	}

	public void setTime(String parameterName, Time x) throws SQLException
	{
		statement.setTime(parameterName, x);
	}

	public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException
	{
		statement.setTimestamp(parameterIndex, x, cal);
	}

	public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException
	{
		statement.setTimestamp(parameterIndex, x);
	}

	public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException
	{
		statement.setTimestamp(parameterName, x, cal);
	}

	public void setTimestamp(String parameterName, Timestamp x) throws SQLException
	{
		statement.setTimestamp(parameterName, x);
	}

	public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException
	{
		statement.setUnicodeStream(parameterIndex, x, length);
	}

	public void setURL(int parameterIndex, URL x) throws SQLException
	{
		statement.setURL(parameterIndex, x);
	}

	public void setURL(String parameterName, URL val) throws SQLException
	{
		statement.setURL(parameterName, val);
	}

	public boolean wasNull() throws SQLException
	{
		return statement.wasNull();
	}
}
