/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.internal.core.productConfig;

import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class ProductConfigHelper {
	private static final String ALTERNATE_SQL_EDITOR_CLASS = "class"; //$NON-NLS-1$   
    private static final String PRODUCT_CONFIG_EXT_POINT = "org.eclipse.wst.rdb.core.productConfig";  
    
	public static boolean isRCPApplication() {
		IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
		IExtensionPoint extensionPoint = 
			extensionRegistry.getExtensionPoint(PRODUCT_CONFIG_EXT_POINT);
		IExtension [] extensions = extensionPoint.getExtensions();
		try {
		for(int i=0; i<extensions.length; i++)
		{
			IExtension ext = extensions[i];
			IProductConfiguration prodConfig = (IProductConfiguration)ext.getConfigurationElements()[0].createExecutableExtension(ALTERNATE_SQL_EDITOR_CLASS);
			if(prodConfig.isRCPApplication())
				return true;
		}
		}
		catch(Exception e) {
			e.printStackTrace();
		}
    	return false;
	}
}
