/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.core.internal.ui.explorer.providers.content.virtual;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wst.rdb.core.internal.ui.explorer.filter.IFilterNode;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IViewNode;
import org.eclipse.wst.rdb.core.internal.ui.icons.ImageDescription;
import org.eclipse.wst.rdb.core.internal.ui.util.resources.ResourceLoader;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionFilter;
import org.eclipse.wst.rdb.internal.core.containment.GroupID;
import org.eclipse.wst.rdb.internal.models.sql.schema.Schema;
import org.eclipse.wst.rdb.internal.models.sql.tables.SQLTablesPackage;


/**
 * @author ljulien
 */
public class ViewNode extends VirtualNode implements IViewNode, IFilterNode
{
	/**
	 * @param name
	 * @param displayName
	 */
	public ViewNode(String name, String displayName, Object parent)
	{
		super(name, displayName, parent);
	}

    public String getGroupID ()
    {
        return GroupID.VIEW;
    }

    public String getFilterName()
    {
        return ((Schema)getParent()).getName() + IFilterNode.SEPARATOR + ConnectionFilter.VIEW_FILTER;
    }
    
    //@Override
	public ImageDescriptor[] getCreateImageDescriptor() {
		return new ImageDescriptor[] { 
				ImageDescription.getViewDescriptor()
		};
	}

	//@Override
	public String[] getCreateLabel() {
		return new String[] {
				ResourceLoader.getResourceLoader().queryString("SCHEMA_MANAGEMENT_CREATE_VIEW")
		};
	}

	//@Override
	public EClass[] getCreateType() {
		return new EClass[] {
				SQLTablesPackage.eINSTANCE.getViewTable()
		};
	}

	//@Override
	public boolean shouldDisplayCreate() {
		return true;
	}

	//@Override
	public boolean shouldDisplayAdd() {
		return false;
	}

}
