/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.core.internal.ui.explorer.providers.label;

import org.eclipse.wst.rdb.core.internal.ui.services.LabelSelector;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;
import org.eclipse.wst.rdb.internal.models.sql.accesscontrol.User;

public class AuthorizationSelector implements LabelSelector
{
	public boolean select(Object element)
	{
		DatabaseDefinition dd = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(
				((User) element).getDatabase());
		return dd.isAuthorizationIdentifierSupported() && !dd.isUserSupported();
	}
}
