/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.core.internal.ui.preferences;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.wst.rdb.core.internal.ui.util.resources.ImagePath;
import org.eclipse.wst.rdb.core.internal.ui.util.resources.ResourceLoader;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.util.RDBCorePluginConstants;

public class PreferencePage extends org.eclipse.jface.preference.PreferencePage implements IWorkbenchPreferencePage
{
	private static final RDBCorePlugin core = RDBCorePlugin.getDefault();
	private static final ResourceLoader loader = ResourceLoader.getResourceLoader();

	private static final String C_TIMEOUT_ERR1 = loader.queryString("PREFERENCES.CONNECTION_TIMEOUT_ERR1"); //$NON-NLS-1$
	private static final String C_TIMEOUT_ERR2 = loader.queryString("PREFERENCES.CONNECTION_TIMEOUT_ERR2"); //$NON-NLS-1$
	private static final String C_TIMEOUT_LB = loader.queryString("PREFERENCES.CONNECTION_TIMEOUT_LB"); //$NON-NLS-1$
	private static final String C_DB_SETTINGS = loader.queryString ("PREFERENCES.CONNECTION_DB_SETTINGS"); //$NON-NLS-1$
	private static final String C_DB_RECONNECT = loader.queryString ("PREFERENCES.CONNECTION_DB_RECONN"); //$NON-NLS-1$
	private static final String C_DB_RECONNECT_T = loader.queryString ("PREFERENCES.CONNECTION_DB_RECONN_T"); //$NON-NLS-1$
	private static final String C_PASS_GROUP = loader.queryString ("PREFERENCES.CONNECTION_PASS_G"); //$NON-NLS-1$
	private static final String C_PASS_STORE = loader.queryString ("PREFERENCES.CONNECTION_PASS_S"); //$NON-NLS-1$
	private static final String C_PASS_NEVER = loader.queryString ("PREFERENCES.CONNECTION_PASS_NEVER"); //$NON-NLS-1$
	private static final String C_PASS_APP = loader.queryString ("PREFERENCES.CONNECTION_PASS_APP"); //$NON-NLS-1$
	private static final String C_PASS_APP_T = loader.queryString ("PREFERENCES.CONNECTION_PASS_S_T"); //$NON-NLS-1$
	private static final String C_PASS_PERS = loader.queryString ("PREFERENCES.CONNECTION_PASS_PERS"); //$NON-NLS-1$
	private static final String C_PASS_ENC = loader.queryString ("PREFERENCES.CONNECTION_PASS_ENC"); //$NON-NLS-1$
	private static final String C_PASS_ENC_M = loader.queryString ("PREFERENCES.CONNECTION_PASS_ENC_M"); //$NON-NLS-1$
	private static final String C_PASS_ENC_S = loader.queryString ("PREFERENCES.CONNECTION_PASS_ENC_S"); //$NON-NLS-1$
	private static final String C_RECONN = loader.queryString ("PREFERENCES.CONNECTION_RECONNE_S"); //$NON-NLS-1$
	private static final String C_VIRTUAL_CONNECTION = loader.queryString ("PREFERENCES.CONNECTION_VIRTUAL_CONNECTIONS"); //$NON-NLS-1$
	private static final String C_VIRTUAL_CONNECTION_T = loader.queryString ("PREFERENCES.CONNECTION_VIRTUAL_CONNECTIONS_T"); //$NON-NLS-1$

	private static final String INFOPOP = "org.eclipse.wst.rdb.core.ui.data_preference_page"; //$NON-NLS-1$
	
	private FormColors formColors;
	
	private Button reconnect;
	private Button reconnectStartup;
	private Button virtualConnection;
	private Text timeout;
	private Combo encriptionKey;
	private Combo storedPassword;
	private Label encriptionLabel;

	private void createSeparator(Composite parent, boolean visible) 
	{
		Label label = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
		label.setVisible(visible);
		GridData separatorData = new GridData(GridData.FILL_HORIZONTAL);
		separatorData.horizontalSpan = 2;
		label.setLayoutData(separatorData);
	}

	private class LabelPainter implements PaintListener
	{
		private String text;
		
		private void fillColor (GC gc, Control control, int marginWidth, int marginHeight, Rectangle bounds)
		{
			Color bg = formColors.getColor(FormColors.TB_BG);
			Color gbg = formColors.getColor(FormColors.TB_GBG);
			Color foreground = gc.getForeground();
			gc.setForeground(bg);
			gc.setBackground(gbg);
			gc.fillGradientRectangle(marginWidth, marginHeight, bounds.width - 1, bounds.height - 1, false);
			gc.setForeground(foreground);
		}
		
		public LabelPainter (String text)
		{
			this.text = text;
		}
		
		public void paintControl(PaintEvent e)
		{
			Control control = (Control) e.widget;
			GC g = e.gc;
			
			Display display= e.widget.getDisplay();

			Point size= control.getSize();
			int w = size.x;
					
			fillColor (g, control, 0, 1, control.getBounds());
			
			g.setBackground(display.getSystemColor(SWT.COLOR_WIDGET_NORMAL_SHADOW));
			g.fillRectangle(0, 1, w, 1);
			g.fillRectangle(0, size.y-1, w, size.y-1);
			
			Font previousFont = g.getFont();
			
			FontData data = new FontData (previousFont.getFontData()[0].getName(), previousFont.getFontData()[0].getHeight(), SWT.BOLD);
			Font newFont = new Font (display, data);
			g.setFont(newFont);
			Point textSize = g.textExtent(this.text);
			g.drawImage(loader.queryImageFromRegistry(ImagePath.SERVER_EXPLORER), 1, 2);
			g.drawText(this.text, 25, (e.height - textSize.y) / 2, true);
			newFont.dispose();
			
			g.setFont(previousFont);
		}
	}
	
	protected Control createContents(Composite parent)
	{
		this.formColors = new FormColors(Display.getCurrent());
		this.formColors.initializeSectionToolBarColors();
		
		Composite preferenceParent = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout();
		layout.numColumns = 2;
		GridData data = new GridData(GridData.FILL_BOTH);
		preferenceParent.setLayout(layout);
		preferenceParent.setLayoutData(data);

		CLabel descriptionLabel = new CLabel (preferenceParent, SWT.FLAT);
		descriptionLabel.addPaintListener(new LabelPainter(C_DB_SETTINGS));
		GridData descriptionData = new GridData(GridData.FILL_HORIZONTAL);
		descriptionData.horizontalSpan = 2;
		descriptionLabel.setLayoutData(descriptionData);

		createSeparator(preferenceParent, false);
		
		virtualConnection = new Button (preferenceParent, SWT.CHECK);
		virtualConnection.setText(C_VIRTUAL_CONNECTION);
		virtualConnection.setToolTipText(C_VIRTUAL_CONNECTION_T);
		GridData virtualConnectionData = new GridData(GridData.FILL_HORIZONTAL);
		virtualConnectionData.horizontalSpan = 2;
		virtualConnection.setLayoutData(virtualConnectionData);		
		
		createSeparator(preferenceParent, false);
		createSeparator(preferenceParent, true);
		createSeparator(preferenceParent, false);
		
		Label timeoutLabel = new Label (preferenceParent, SWT.NONE);
		timeoutLabel.setText (C_TIMEOUT_LB);
		
		timeout = new Text(preferenceParent, SWT.FLAT | SWT.BORDER);
		timeout.setLayoutData(new GridData (GridData.FILL_HORIZONTAL));
		timeout.addModifyListener(new ModifyListener ()
		{
			public void modifyText(ModifyEvent e)
			{
				try 
				{
					final int x = Integer.parseInt(timeout.getText());
					if (x >= 0)
					{
						setErrorMessage(null);
						setValid(true);
					}
					else 
					{
						setErrorMessage(C_TIMEOUT_ERR1); 
						setValid(false);
					}
				} 
				catch (NumberFormatException ex) 
				{
					setErrorMessage(C_TIMEOUT_ERR2); 
					setValid(false);
				}
			}
		});
		
		reconnect = new Button (preferenceParent, SWT.CHECK);
		reconnect.setText(C_DB_RECONNECT);
		reconnect.setToolTipText(C_DB_RECONNECT_T);
		GridData reconnectData = new GridData(GridData.FILL_HORIZONTAL);
		reconnectData.horizontalSpan = 2;
		reconnect.setLayoutData(reconnectData);

		createSeparator(preferenceParent, false);
		createSeparator(preferenceParent, true);
		createSeparator(preferenceParent, false);
		
		Group passwordGroup = new Group (preferenceParent, SWT.NONE);
		passwordGroup.setText(C_PASS_GROUP);
		GridLayout groupLayout = new GridLayout();
		groupLayout.numColumns = 2;
		GridData groupData = new GridData(GridData.FILL_HORIZONTAL);
		groupData.horizontalSpan = 2;
		passwordGroup.setLayoutData(groupData);
		passwordGroup.setLayout(groupLayout);

		Label scopeLabel = new Label (passwordGroup, SWT.NONE);
		scopeLabel.setText(C_PASS_STORE);
		scopeLabel.setToolTipText(C_PASS_APP_T);
		
		storedPassword = new Combo(passwordGroup, SWT.FLAT | SWT.READ_ONLY | SWT.DROP_DOWN);
		storedPassword.add(C_PASS_NEVER);
		storedPassword.add(C_PASS_APP);
		storedPassword.add(C_PASS_PERS);
		storedPassword.addSelectionListener(new SelectionListener ()
		{
			public void widgetDefaultSelected(SelectionEvent e)
			{
				widgetSelected(e);
			}

			public void widgetSelected(SelectionEvent e)
			{
				enableEncriptionControls();
			}
		});
		
		encriptionLabel = new Label (passwordGroup, SWT.NONE);
		encriptionLabel.setText(C_PASS_ENC);
		
		encriptionKey = new Combo(passwordGroup, SWT.FLAT | SWT.READ_ONLY | SWT.DROP_DOWN);
		encriptionKey.add(C_PASS_ENC_S);
		encriptionKey.add(C_PASS_ENC_M);
		
		reconnectStartup = new Button (passwordGroup, SWT.CHECK);
		reconnectStartup.setText(C_RECONN);
		GridData reconnectsData = new GridData(GridData.FILL_HORIZONTAL);
		reconnectsData.horizontalSpan = 2;
		reconnectStartup.setLayoutData(reconnectsData);
		
		applyPreferences ();
		
		PlatformUI.getWorkbench().getHelpSystem().setHelp(parent, INFOPOP);
		
		return parent;
	}
	
	private void enableEncriptionControls ()
	{
		encriptionLabel.setEnabled(storedPassword.getSelectionIndex() == 2);
		encriptionKey.setEnabled(storedPassword.getSelectionIndex() == 2);
		reconnectStartup.setEnabled(storedPassword.getSelectionIndex() == 2);
	}
	
	private void applyPreferences ()
	{
		timeout.setText(core.getPluginPreferences().getString(RDBCorePluginConstants.CONNECTION_TIMEOUT));
		reconnect.setSelection(core.getPluginPreferences().getBoolean(RDBCorePluginConstants.RECONNECT_ON_TIMEOUT));
		storedPassword.select(core.getPluginPreferences().getInt(RDBCorePluginConstants.PASSWORD_SCOPE));
		encriptionKey.select(core.getPluginPreferences().getInt(RDBCorePluginConstants.ENCRIPTION_STRENGTH));
		reconnectStartup.setSelection(core.getPluginPreferences().getBoolean(RDBCorePluginConstants.RECONNECT_AT_STARTUP));
		virtualConnection.setSelection(core.getPluginPreferences().getBoolean(RDBCorePluginConstants.VIRTUAL_CONNECTION));
		enableEncriptionControls();
	}
	
	private void storePreferences ()
	{
    	core.getPluginPreferences().setValue(RDBCorePluginConstants.CONNECTION_TIMEOUT, timeout.getText());
    	core.getPluginPreferences().setValue(RDBCorePluginConstants.RECONNECT_ON_TIMEOUT, reconnect.getSelection());
    	core.getPluginPreferences().setValue(RDBCorePluginConstants.PASSWORD_SCOPE, storedPassword.getSelectionIndex());
    	core.getPluginPreferences().setValue(RDBCorePluginConstants.ENCRIPTION_STRENGTH, encriptionKey.getSelectionIndex());
    	core.getPluginPreferences().setValue(RDBCorePluginConstants.RECONNECT_AT_STARTUP, reconnectStartup.getSelection());
    	core.getPluginPreferences().setValue(RDBCorePluginConstants.VIRTUAL_CONNECTION, virtualConnection.getSelection());
        core.savePluginPreferences();
	}
	
    protected void performDefaults()
    {
		core.getPluginPreferences().setValue(RDBCorePluginConstants.CONNECTION_TIMEOUT,
				core.getPluginPreferences().getDefaultString(RDBCorePluginConstants.CONNECTION_TIMEOUT));
		core.getPluginPreferences().setValue(RDBCorePluginConstants.RECONNECT_ON_TIMEOUT,
				core.getPluginPreferences().getDefaultBoolean(RDBCorePluginConstants.RECONNECT_ON_TIMEOUT));
		core.getPluginPreferences().setValue(RDBCorePluginConstants.PASSWORD_SCOPE,
				core.getPluginPreferences().getDefaultInt(RDBCorePluginConstants.PASSWORD_SCOPE));
		core.getPluginPreferences().setValue(RDBCorePluginConstants.ENCRIPTION_STRENGTH,
				core.getPluginPreferences().getDefaultInt(RDBCorePluginConstants.ENCRIPTION_STRENGTH));
		core.getPluginPreferences().setValue(RDBCorePluginConstants.RECONNECT_AT_STARTUP,
				core.getPluginPreferences().getDefaultBoolean(RDBCorePluginConstants.RECONNECT_AT_STARTUP));
		core.getPluginPreferences().setValue(RDBCorePluginConstants.VIRTUAL_CONNECTION,
				core.getPluginPreferences().getDefaultBoolean(RDBCorePluginConstants.VIRTUAL_CONNECTION));
		applyPreferences();
	}
    
    /**
     * @see org.eclipse.jface.preference.IPreferencePage#performOk()
     */
    public boolean performOk()
    {
        storePreferences();
        return super.performOk();   
    }
    
    /**
     * @see org.eclipse.jface.preference.PreferencePage#performApply()
     */
    protected void performApply()
    {
        storePreferences();
        super.performApply();
    }
	
	public void dispose ()
	{
		this.formColors.dispose();
		this.formColors = null;
	}
	
	public void init(IWorkbench workbench)
	{
	}
}