/*******************************************************************************
* Copyright (c) 2000, 2004 IBM Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     IBM Corporation - initial API and implementation
*******************************************************************************/
package org.eclipse.wst.rdb.internal.outputview;

import java.sql.SQLException;

/**
 * Represents a procedure call.
 */
public interface ProcedureCallCache 
{
   /** 
    * Gets the number of rows in the result set. 
    * @return The number of rows.
    */
   public int getNumRows();
   /**
    * Gets the value for a given column as a String.
    * @param index The column index.
    * @return The String value.
    */
   public String getColumnValueToString(int index);
   /** Moves to the next row. */
   public void nextRow();
   /**
    * Determines whether the current result set is the last one.
    * @return True if  the current result set is the last one.
    */
   public boolean isLastResult();
   /**
    * Gest the index of the current result set.
    * @return The index of the current result set.
    * @throws SQLException
    */
   public int getCurrentResult() throws SQLException;
   /**
    * Moves to the previous result set. 
    * @throws SQLException
    */
   public void previousResult() throws SQLException;
   /**
    * Moves the the next result set.
    * @throws SQLException
    */
   public void nextResult() throws SQLException;
   /**
    * Gets the number of columns.
    * @return The number of columns.
    */
   public int getColumnCount();
   /**
    * Gets the column length for a given column.
    * @param index The column index.
    * @return The length.
    */
   public int getColumnLength(int index);
   /**
    * Gets the name of a given column.
    * @param index The column index.
    * @return The name.
    */
   public String getColumnName(int index);
   /**
    * Gets the SQL type code for a given column.
    * @param index The column index.
    * @return The type code.
    */
   public int getColumnSQLType(int index);
   /**
    * Gets the SQL type name for a given column.
    * @param index the column index
    * @return the name of the given column type
    */  
   public String getColumnSQLTypeName(int index);
}
