/*******************************************************************************
 * Copyright (c) 2000, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.server.extensions.internal.actions;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.texteditor.IWorkbenchActionDefinitionIds;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IVirtualNode;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.containment.ContainmentService;
import org.eclipse.wst.rdb.internal.core.containment.GroupID;
import org.eclipse.wst.rdb.internal.core.rte.ICatalogObject;
import org.eclipse.wst.rdb.internal.models.sql.constraints.Assertion;
import org.eclipse.wst.rdb.internal.models.sql.constraints.Index;
import org.eclipse.wst.rdb.internal.models.sql.constraints.TableConstraint;
import org.eclipse.wst.rdb.internal.models.sql.datatypes.DistinctUserDefinedType;
import org.eclipse.wst.rdb.internal.models.sql.routines.Routine;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;
import org.eclipse.wst.rdb.internal.models.sql.schema.Schema;
import org.eclipse.wst.rdb.internal.models.sql.schema.Sequence;
import org.eclipse.wst.rdb.internal.models.sql.tables.Table;
import org.eclipse.wst.rdb.internal.models.sql.tables.Trigger;
import org.eclipse.wst.rdb.server.extensions.internal.ServerExtensionsPlugin;
import org.eclipse.wst.rdb.server.extensions.internal.drop.DropObject;
import org.eclipse.wst.rdb.server.extensions.internal.icons.ImageDescription;
import org.eclipse.wst.rdb.server.extensions.internal.util.Utility;
import org.eclipse.wst.rdb.server.internal.ui.services.IServicesManager;

public class DropAction extends AbstractAction implements IViewActionDelegate

{
	private static final String TEXT = ServerExtensionsPlugin.getString("UI_MENU_DROP"); //$NON-NLS-1$  
	
	public void initialize ()
	{
		ImageDescriptor descriptor = ImageDescription.getDropDescriptor();
    	initializeAction(descriptor, descriptor, TEXT, TEXT);
        setActionDefinitionId("org.eclipse.ui.edit.delete"); //$NON-NLS-1$
	}

	public String getActionDefinitionId() 
	{
		return IWorkbenchActionDefinitionIds.DELETE;
	}
	
	public void run() 
	{		
		Iterator iterSel = selection.iterator(); 
		int queryDelete = 0;
		ArrayList refreshSchemaList = new ArrayList();
	
		while (iterSel.hasNext()) {
			Object obj = iterSel.next();			   
			SQLObject sqlObj =(SQLObject)obj;
			
			if (sqlObj != null) {
				if (queryDelete != 1) // 1 = YES_TO_ALL 
				{  
					queryDelete = Utility.isOkayToDrop(sqlObj.getName());
					switch (queryDelete) 
					{
					   case 2 :        // NO pressed
					      continue; 
					   case 3 :        // CANCEL pressed
					   case -1 :
					      return;
					   default :       // YES, YES_TO_ALL
					      break;   
					}
				}
				
				DropObject dropObj = new DropObject(sqlObj);
				ConnectionInfo conInfo = null;
				if (obj instanceof ICatalogObject) {
				   ICatalogObject catalogObject = (ICatalogObject)obj;
				   
				   Database database = catalogObject.getCatalogDatabase();
				   conInfo = Utility.getConnectionInfo(database);
				   
				   Object parent = IServicesManager.INSTANCE.getServerExplorerNavigationService().getParent(obj);				   
				   if (parent != null && parent instanceof IVirtualNode) {
				      Object schema = ((IVirtualNode)parent).getParent();
				      if (schema != null && !refreshSchemaList.contains(schema)) {
				         refreshSchemaList.add(schema);
				      }
				   }
				}
				
				dropObj.run(conInfo);
			}
		} 

		// refresh schema folders
		Iterator itRefreshSchemas = refreshSchemaList.iterator();
		while (itRefreshSchemas.hasNext()) {
		   IServicesManager.INSTANCE.getServerExplorerRefreshService().refresh(itRefreshSchemas.next());
		}
				
	}
    
	public void selectionChanged(SelectionChangedEvent event) {
        
        super.selectionChanged(event);
        
        if (!isEnabled())
            return;
        
        boolean ok = true; 
        
        if (selection instanceof IStructuredSelection) {
            ContainmentService containmentService = RDBCorePlugin.getDefault().getContainmentService();
            Iterator it = ((IStructuredSelection)selection).iterator();
            while (it.hasNext()) {                
            	Object o = it.next();
                if (o instanceof EObject) {
                    String groupID = containmentService.getGroupId((EObject)o);
                    if (groupID==null || !groupID.startsWith(GroupID.CORE_PREFIX)) {
                        ok = false;
                        break;
                    }
                } else {
                    ok = false;
                    break;
                }
            }                       
        } else {
            ok = false;
        }
        
        setEnabled(ok);        
	}

	public void init(IViewPart view) {
		// TODO Auto-generated method stub
		// database and connection can change from invocation to invocation
		
    	table = null;
    	schema = null;
    	database = null;
    	connection = null;
    	dbDef = null;
    	
    	if (selection==null || selection.isEmpty() || selection.size() == 0)
			return;

    	selectedObj = selection.getFirstElement();
    	
		Object obj = selectedObj;

		while (obj instanceof IVirtualNode)
			obj = ((IVirtualNode) obj).getParent();
		
		if (obj instanceof Table) {
			table = (Table) obj;
			schema = table.getSchema();
			database = schema.getDatabase();
		} else if (obj instanceof Schema) {
			schema = (Schema) obj;
			database = schema.getDatabase();
		} else if (obj instanceof Routine) {
		   schema = ((Routine)obj).getSchema();
		   database = schema.getDatabase();
		} else if (obj instanceof DistinctUserDefinedType) {
			schema = ((DistinctUserDefinedType)obj).getSchema();
			database = schema.getDatabase();
		} else if (obj instanceof Sequence) {
			schema = ((Sequence)obj).getSchema();
			database = schema.getDatabase();
		} else if (obj instanceof Trigger) {
			schema = ((Trigger)obj).getSchema();
			database = schema.getDatabase();
		} else if (obj instanceof Index) {
			schema = ((Index)obj).getSchema();
			database = schema.getDatabase();
		} else if (obj instanceof TableConstraint) {
			schema = ((Table)((TableConstraint) obj).getContainer()).getSchema();
			database = schema.getDatabase();
		} else if (obj instanceof Assertion) {
			schema = ((Assertion)obj).getSchema();
			database = schema.getDatabase();
		} else if (obj instanceof ICatalogObject) {
			ICatalogObject catalogObject = (ICatalogObject) obj;
			database = catalogObject.getCatalogDatabase();
		} else
			return;
		
		connection = Utility.getConnectionInfo(database).getSharedConnection();
		dbDef = Utility.getDBDef(database);

	}

	public void run(IAction action) {
		// TODO Auto-generated method stub
		Iterator iterSel = selection.iterator(); 
		int queryDelete = 0;
		ArrayList refreshSchemaList = new ArrayList();
	
		while (iterSel.hasNext()) {
			Object obj = iterSel.next();			   
			SQLObject sqlObj =(SQLObject)obj;
			
			if (sqlObj != null) {
				if (queryDelete != 1) // 1 = YES_TO_ALL 
				{  
					queryDelete = Utility.isOkayToDrop(sqlObj.getName());
					switch (queryDelete) 
					{
					   case 2 :        // NO pressed
					      continue; 
					   case 3 :        // CANCEL pressed
					   case -1 :
					      return;
					   default :       // YES, YES_TO_ALL
					      break;   
					}
				}
				
				DropObject dropObj = new DropObject(sqlObj);
				ConnectionInfo conInfo = null;
				if (obj instanceof ICatalogObject) {
				   ICatalogObject catalogObject = (ICatalogObject)obj;
				   
				   Database database = catalogObject.getCatalogDatabase();
				   conInfo = Utility.getConnectionInfo(database);
				   
				   Object parent = IServicesManager.INSTANCE.getServerExplorerNavigationService().getParent(obj);				   
				   if (parent != null && parent instanceof IVirtualNode) {
				      Object schema = ((IVirtualNode)parent).getParent();
				      if (schema != null && !refreshSchemaList.contains(schema)) {
				         refreshSchemaList.add(schema);
				      }
				   }
				}
				
				dropObj.run(conInfo);
			}
		} 

		// refresh schema folders
		Iterator itRefreshSchemas = refreshSchemaList.iterator();
		while (itRefreshSchemas.hasNext()) {
		   IServicesManager.INSTANCE.getServerExplorerRefreshService().refresh(itRefreshSchemas.next());
		}	

	}

	public void selectionChanged(IAction action, ISelection selection) {
		// TODO Auto-generated method stub
		 
        //super.selectionChanged(action, selection);
		if (selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection) selection;
        }
		
        if (!action.isEnabled())
            return;
        
        boolean ok = true; 
        
        if (selection instanceof IStructuredSelection) {
            ContainmentService containmentService = RDBCorePlugin.getDefault().getContainmentService();
            Iterator it = ((IStructuredSelection)selection).iterator();
            while (it.hasNext()) {                
            	Object o = it.next();
                if (o instanceof EObject) {
                    String groupID = containmentService.getGroupId((EObject)o);
                    if (groupID==null || !groupID.startsWith(GroupID.CORE_PREFIX)) {
                        ok = false;
                        break;
                    }
                } else {
                    ok = false;
                    break;
                }
            }                       
        } else {
            ok = false;
        }
        
        action.setEnabled(ok);        
	}

}


