/*******************************************************************************
 * Copyright (c) 2000, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.server.extensions.internal.actions;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.wst.rdb.server.extensions.internal.ServerExtensionsPlugin;

public class NewStatementAction extends AbstractAction implements IViewActionDelegate
{
   private static final String TITLE = ServerExtensionsPlugin.getString("NEW_STATEMENT"); //$NON-NLS-1$    

   /**
    * Launch the SQL Editor with no SQL template at all.
    */
   public void run(IAction action) {
      try {
         getEditorLaunch().launchSQLEditor( "", null, TITLE );
      }
      catch (Exception e) {
         ServerExtensionsPlugin.getDefault().writeLog(IStatus.ERROR, 0, e.getMessage(), e);
      }
   }

	protected void initialize()
	{
	}
	
	public void init(IViewPart view)
	{
	}
	
	public void selectionChanged(IAction action, ISelection selection)
	{
	}
}