/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.server.extensions.internal.actions.providers;

import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonMenuConstants;
import org.eclipse.wst.rdb.server.extensions.internal.ServerExtensionsPlugin;

public class OpenGroupProvider extends CommonActionProvider
{
	private static final String MENU_LABEL = ServerExtensionsPlugin.getString("UI_MENU_OPEN"); //$NON-NLS-1$  
	
	public static final String ID = "org.eclipse.wst.rdb.server.extensions.actions.opengroup"; //$NON-NLS-1$  
	
    public void fillContextMenu(IMenuManager menu) 
    {
    	menu.appendToGroup(ICommonMenuConstants.GROUP_OPEN, new MenuManager(MENU_LABEL, ID));
    }

}
