/*******************************************************************************
 * Copyright (c) 2000, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.server.extensions.internal.actions;

import java.sql.Connection;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IVirtualNode;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;
import org.eclipse.wst.rdb.internal.core.rte.ICatalogObject;
import org.eclipse.wst.rdb.internal.models.sql.constraints.Assertion;
import org.eclipse.wst.rdb.internal.models.sql.constraints.Index;
import org.eclipse.wst.rdb.internal.models.sql.constraints.TableConstraint;
import org.eclipse.wst.rdb.internal.models.sql.datatypes.DistinctUserDefinedType;
import org.eclipse.wst.rdb.internal.models.sql.routines.Routine;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.models.sql.schema.Schema;
import org.eclipse.wst.rdb.internal.models.sql.schema.Sequence;
import org.eclipse.wst.rdb.internal.models.sql.tables.Table;
import org.eclipse.wst.rdb.internal.models.sql.tables.Trigger;
import org.eclipse.wst.rdb.server.extensions.internal.ServerExtensionsPlugin;
import org.eclipse.wst.rdb.server.extensions.internal.editorlaunch.LaunchEditor;
import org.eclipse.wst.rdb.server.extensions.internal.templates.SQLTemplate;
import org.eclipse.wst.rdb.server.extensions.internal.templates.TemplateRegistry;
import org.eclipse.wst.rdb.server.extensions.internal.util.Utility;


public abstract class AbstractAction extends Action {

    protected IStructuredSelection selection = null;
    protected Object selectedObj;
    protected Connection connection = null;
    protected Database database = null;
    protected Schema schema = null;
    protected Table table = null;
    protected DatabaseDefinition dbDef = null;
    protected LaunchEditor editLaunch = null;
	
    public AbstractAction ()
	{
		initialize ();
	}
    
	protected void initializeAction (ImageDescriptor image, ImageDescriptor disabledImage, String text, String toopTip)
    {
		if (image != null)
		{
			this.setImageDescriptor(image);
		}
		if (disabledImage != null)
		{
			this.setDisabledImageDescriptor(disabledImage);
		}
		this.setText(text);
		this.setToolTipText(toopTip);
    }
	
	protected abstract void initialize ();

    public void selectionChanged(SelectionChangedEvent event) 
    {
        if (event.getSelection() instanceof IStructuredSelection) 
        {
            this.selection = (IStructuredSelection) event.getSelection();
        }
    }

    public void openSQLTemplate() {
        
    	SQLTemplate template = TemplateRegistry.getInstance().getTemplate(selectedObj, dbDef.getProduct()); 
    	if (template==null)
    		template = TemplateRegistry.getInstance().getTemplate(selectedObj, "default"); //$NON-NLS-1$
    	
    	if (template == null)  //  could not locate template file, pass in an empty one
    	{
    		getEditorLaunch().launchSQLEditor("", Utility.getConnectionInfo(database),  //$NON-NLS-1$
    				ServerExtensionsPlugin.getString("DEFAULT_TITLE")); //$NON-NLS-1$
    	}else
    	{    	    		
    		String ddl = template.getDdl();
	    	// If the DDL has a schema tag (<schema>) , replace it with the actual
			// schema name
	    	if (schema != null) {   	    
	    		ddl = ddl.replaceAll("<schema>",schema.getName()); //$NON-NLS-1$
	    	}           
	    	// If the DDL has a schema tag (<table>) , replace it with the actual
			// table name
	    	if (table != null) {    	    
	    		ddl = ddl.replaceAll("<table>",table.getName()); //$NON-NLS-1$
    	    }
	    	getEditorLaunch().launchSQLEditor(ddl, Utility.getConnectionInfo(database), template.getTitle());
        }
    		 
        
    }
    
    protected LaunchEditor getEditorLaunch(){
    	if (editLaunch == null)
            editLaunch = new LaunchEditor();
    	return editLaunch;
    }
    

    protected void init()
    {
		// database and connection can change from invocation to invocation
		
    	table = null;
    	schema = null;
    	database = null;
    	connection = null;
    	dbDef = null;
    	
    	if (selection==null || selection.isEmpty() || selection.size() == 0)
			return;

    	selectedObj = selection.getFirstElement();
    	
		Object obj = selectedObj;

		while (obj instanceof IVirtualNode)
			obj = ((IVirtualNode) obj).getParent();
		
		if (obj instanceof Table) {
			table = (Table) obj;
			schema = table.getSchema();
			database = schema.getDatabase();
		} else if (obj instanceof Schema) {
			schema = (Schema) obj;
			database = schema.getDatabase();
		} else if (obj instanceof Routine) {
		   schema = ((Routine)obj).getSchema();
		   database = schema.getDatabase();
		} else if (obj instanceof DistinctUserDefinedType) {
			schema = ((DistinctUserDefinedType)obj).getSchema();
			database = schema.getDatabase();
		} else if (obj instanceof Sequence) {
			schema = ((Sequence)obj).getSchema();
			database = schema.getDatabase();
		} else if (obj instanceof Trigger) {
			schema = ((Trigger)obj).getSchema();
			database = schema.getDatabase();
		} else if (obj instanceof Index) {
			schema = ((Index)obj).getSchema();
			database = schema.getDatabase();
		} else if (obj instanceof TableConstraint) {
			schema = ((Table)((TableConstraint) obj).getContainer()).getSchema();
			database = schema.getDatabase();
		} else if (obj instanceof Assertion) {
			schema = ((Assertion)obj).getSchema();
			database = schema.getDatabase();
		} else if (obj instanceof ICatalogObject) {
			ICatalogObject catalogObject = (ICatalogObject) obj;
			database = catalogObject.getCatalogDatabase();
		} else
			return;
		
		connection = Utility.getConnectionInfo(database).getSharedConnection();
		dbDef = Utility.getDBDef(database);

	}

}