/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.internal.core.connection;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class PreparedStatementAdapter implements PreparedStatement
{
	private ConnectionAdapter conection;
	private PreparedStatement statement;

	public PreparedStatementAdapter(ConnectionAdapter connection, PreparedStatement statement)
	{
		this.conection = connection;
		this.statement = statement;
	}

	public void addBatch() throws SQLException
	{
		statement.addBatch();
	}

	public void addBatch(String sql) throws SQLException
	{
		statement.addBatch(sql);
	}

	public void cancel() throws SQLException
	{
		statement.cancel();
	}

	public void clearBatch() throws SQLException
	{
		statement.clearBatch();
	}

	public void clearParameters() throws SQLException
	{
		statement.clearParameters();
	}

	public void clearWarnings() throws SQLException
	{
		statement.clearWarnings();
	}

	public void close() throws SQLException
	{
		this.conection.releaseStatement();
		statement.close();
	}

	public boolean execute() throws SQLException
	{
		return statement.execute();
	}

	public boolean execute(String sql, int autoGeneratedKeys) throws SQLException
	{
		return statement.execute(sql, autoGeneratedKeys);
	}

	public boolean execute(String sql, int[] columnIndexes) throws SQLException
	{
		return statement.execute(sql, columnIndexes);
	}

	public boolean execute(String sql, String[] columnNames) throws SQLException
	{
		return statement.execute(sql, columnNames);
	}

	public boolean execute(String sql) throws SQLException
	{
		return statement.execute(sql);
	}

	public int[] executeBatch() throws SQLException
	{
		return statement.executeBatch();
	}

	public ResultSet executeQuery() throws SQLException
	{
		return statement.executeQuery();
	}

	public ResultSet executeQuery(String sql) throws SQLException
	{
		return statement.executeQuery(sql);
	}

	public int executeUpdate() throws SQLException
	{
		return statement.executeUpdate();
	}

	public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException
	{
		return statement.executeUpdate(sql, autoGeneratedKeys);
	}

	public int executeUpdate(String sql, int[] columnIndexes) throws SQLException
	{
		return statement.executeUpdate(sql, columnIndexes);
	}

	public int executeUpdate(String sql, String[] columnNames) throws SQLException
	{
		return statement.executeUpdate(sql, columnNames);
	}

	public int executeUpdate(String sql) throws SQLException
	{
		return statement.executeUpdate(sql);
	}

	public Connection getConnection() throws SQLException
	{
		return this.conection;
	}

	public int getFetchDirection() throws SQLException
	{
		return statement.getFetchDirection();
	}

	public int getFetchSize() throws SQLException
	{
		return statement.getFetchSize();
	}

	public ResultSet getGeneratedKeys() throws SQLException
	{
		return statement.getGeneratedKeys();
	}

	public int getMaxFieldSize() throws SQLException
	{
		return statement.getMaxFieldSize();
	}

	public int getMaxRows() throws SQLException
	{
		return statement.getMaxRows();
	}

	public ResultSetMetaData getMetaData() throws SQLException
	{
		return statement.getMetaData();
	}

	public boolean getMoreResults() throws SQLException
	{
		return statement.getMoreResults();
	}

	public boolean getMoreResults(int current) throws SQLException
	{
		return statement.getMoreResults(current);
	}

	public ParameterMetaData getParameterMetaData() throws SQLException
	{
		return statement.getParameterMetaData();
	}

	public int getQueryTimeout() throws SQLException
	{
		return statement.getQueryTimeout();
	}

	public ResultSet getResultSet() throws SQLException
	{
		return statement.getResultSet();
	}

	public int getResultSetConcurrency() throws SQLException
	{
		return statement.getResultSetConcurrency();
	}

	public int getResultSetHoldability() throws SQLException
	{
		return statement.getResultSetHoldability();
	}

	public int getResultSetType() throws SQLException
	{
		return statement.getResultSetType();
	}

	public int getUpdateCount() throws SQLException
	{
		return statement.getUpdateCount();
	}

	public SQLWarning getWarnings() throws SQLException
	{
		return statement.getWarnings();
	}

	public void setArray(int i, Array x) throws SQLException
	{
		statement.setArray(i, x);
	}

	public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException
	{
		statement.setAsciiStream(parameterIndex, x, length);
	}

	public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException
	{
		statement.setBigDecimal(parameterIndex, x);
	}

	public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException
	{
		statement.setBinaryStream(parameterIndex, x, length);
	}

	public void setBlob(int i, Blob x) throws SQLException
	{
		statement.setBlob(i, x);
	}

	public void setBoolean(int parameterIndex, boolean x) throws SQLException
	{
		statement.setBoolean(parameterIndex, x);
	}

	public void setByte(int parameterIndex, byte x) throws SQLException
	{
		statement.setByte(parameterIndex, x);
	}

	public void setBytes(int parameterIndex, byte[] x) throws SQLException
	{
		statement.setBytes(parameterIndex, x);
	}

	public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException
	{
		statement.setCharacterStream(parameterIndex, reader, length);
	}

	public void setClob(int i, Clob x) throws SQLException
	{
		statement.setClob(i, x);
	}

	public void setCursorName(String name) throws SQLException
	{
		statement.setCursorName(name);
	}

	public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException
	{
		statement.setDate(parameterIndex, x, cal);
	}

	public void setDate(int parameterIndex, Date x) throws SQLException
	{
		statement.setDate(parameterIndex, x);
	}

	public void setDouble(int parameterIndex, double x) throws SQLException
	{
		statement.setDouble(parameterIndex, x);
	}

	public void setEscapeProcessing(boolean enable) throws SQLException
	{
		statement.setEscapeProcessing(enable);
	}

	public void setFetchDirection(int direction) throws SQLException
	{
		statement.setFetchDirection(direction);
	}

	public void setFetchSize(int rows) throws SQLException
	{
		statement.setFetchSize(rows);
	}

	public void setFloat(int parameterIndex, float x) throws SQLException
	{
		statement.setFloat(parameterIndex, x);
	}

	public void setInt(int parameterIndex, int x) throws SQLException
	{
		statement.setInt(parameterIndex, x);
	}

	public void setLong(int parameterIndex, long x) throws SQLException
	{
		statement.setLong(parameterIndex, x);
	}

	public void setMaxFieldSize(int max) throws SQLException
	{
		statement.setMaxFieldSize(max);
	}

	public void setMaxRows(int max) throws SQLException
	{
		statement.setMaxRows(max);
	}

	public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException
	{
		statement.setNull(paramIndex, sqlType, typeName);
	}

	public void setNull(int parameterIndex, int sqlType) throws SQLException
	{
		statement.setNull(parameterIndex, sqlType);
	}

	public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException
	{
		statement.setObject(parameterIndex, x, targetSqlType, scale);
	}

	public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException
	{
		statement.setObject(parameterIndex, x, targetSqlType);
	}

	public void setObject(int parameterIndex, Object x) throws SQLException
	{
		statement.setObject(parameterIndex, x);
	}

	public void setQueryTimeout(int seconds) throws SQLException
	{
		statement.setQueryTimeout(seconds);
	}

	public void setRef(int i, Ref x) throws SQLException
	{
		statement.setRef(i, x);
	}

	public void setShort(int parameterIndex, short x) throws SQLException
	{
		statement.setShort(parameterIndex, x);
	}

	public void setString(int parameterIndex, String x) throws SQLException
	{
		statement.setString(parameterIndex, x);
	}

	public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException
	{
		statement.setTime(parameterIndex, x, cal);
	}

	public void setTime(int parameterIndex, Time x) throws SQLException
	{
		statement.setTime(parameterIndex, x);
	}

	public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException
	{
		statement.setTimestamp(parameterIndex, x, cal);
	}

	public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException
	{
		statement.setTimestamp(parameterIndex, x);
	}

	public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException
	{
		statement.setUnicodeStream(parameterIndex, x, length);
	}

	public void setURL(int parameterIndex, URL x) throws SQLException
	{
		statement.setURL(parameterIndex, x);
	}
}
