/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.internal.core.connection.resource;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;

public class OfflineResource extends XMIResourceImpl {
	public OfflineResource() {
		super();
	}

	public OfflineResource(URI uri) {
		super();
		this.uri = uri;
	}

	protected boolean useUUIDs() {
		return true;
	}

	protected XMLSave createXMLSave() {
		return new OfflineSave(createXMLHelper());
	}

	protected XMLLoad createXMLLoad() {
		return new OfflineLoad(createXMLHelper());
	}

}
