/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.internal.core.connection.resource;

import java.util.List;
import java.util.Map;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMISaveImpl;
import org.eclipse.emf.ecore.xml.type.internal.DataValue.XMLChar;

public class OfflineSave extends XMISaveImpl {

	protected static class DataModelEscape extends Escape {
		/** A table of hex digits */
		protected static final char[] HEXES = { '0', '1', '2', '3', '4', '5',
				'6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F' };

		/**
		 * Converts a character into an char array containing the &#92;uxxxx
		 * encoding.
		 * 
		 * @param c
		 *            The character to convert
		 * @return A 6-character array for the encoding.
		 */
		public static char[] uuencode(char c) {
			char[] uu = new char[6];
			uu[0] = '\\';
			uu[1] = 'u';
			uu[2] = HEXES[(c >> 12) & 0xF];
			uu[3] = HEXES[(c >> 8) & 0xF];
			uu[4] = HEXES[(c >> 4) & 0xF];
			uu[5] = HEXES[c & 0xF];
			return uu;
		}

		/*
		 * Convert: & to &amp; < to &lt; " to &quot; \t to &#x9; \n to &#xA; \r
		 * to &#xD;
		 */
		public String convert(String input) {
			boolean changed = false;
			int inputLength = input.length();
			grow(inputLength);
			input.getChars(0, inputLength, value, 0);
			int pos = 0;
			char ch = 0;
			while (inputLength-- > 0) {
				ch = value[pos];
				switch (ch) {
				case '&':
					pos = replace(pos, AMP, inputLength);
					changed = true;
					break;
				case '<':
					pos = replace(pos, LESS, inputLength);
					changed = true;
					break;
				case '"':
					pos = replace(pos, QUOTE, inputLength);
					changed = true;
					break;
				case '\n': {
					pos = replace(pos, LF, inputLength);
					changed = true;
					break;
				}
				case '\r': {
					pos = replace(pos, CR, inputLength);
					changed = true;
					break;
				}
				case '\t': {
					pos = replace(pos, TAB, inputLength);
					changed = true;
					break;
				}
				case 0:
				case 1:
				case 2:
				case 3:
				case 4:
				case 5:
				case 6:
				case 7:
				case 8:
				case 11:
				case 12:
				case 14:
				case 15:
				case 16:
				case 17:
				case 18:
				case 19:
				case 20:
				case 21:
				case 22:
				case 23:
				case 24:
				case 25:
				case 26:
				case 27:
				case 28:
				case 29:
				case 30:
				case 31: {
					pos = replace(pos, uuencode(ch), inputLength);
					changed = true;
					break;
				}
				default:
					if (!XMLChar.isValid(ch)) {
						throw new RuntimeException(
								"An invalid XML character (Unicode: 0x"
										+ Integer.toHexString(ch)
										+ ") was found in the element content:"
										+ input);
					} else {
						pos++;
					}
					break;
				} // switch
			}// while
			return changed ? new String(value, 0, pos) : input;
		} // convert()
	}

	protected void init(XMLResource resource, Map options) {
		super.init(resource, options);
		escape = new DataModelEscape();
	}

	public OfflineSave(XMLHelper helper) {
		super(helper);
	}

	public OfflineSave(Map options, XMLHelper helper, String encoding) {
		super(options, helper, encoding);
	}

	public void traverse(List contents) {
		doc.add("<?xml version=\"" + XML_VERSION + "\" encoding=\"" + encoding
				+ "\"?>");
		doc.addLine();
		doc.addComment("xtools2_universal_type_manager");

		int size = contents.size();

		// Reserve a place to insert xmlns declarations after we know what they
		// all are.
		//
		Object mark;

		if (size == 1) {
			mark = writeTopObject((EObject) contents.get(0));
		} else {
			mark = writeTopObjects(contents);
		}

		// Go back and add all the XMLNS stuff.
		//
		doc.resetToMark(mark);
		addNamespaceDeclarations();
	}

}
