/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.Bag;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.HashBag;
import org.eclipse.jpt.utility.internal.Range;
import org.eclipse.jpt.utility.internal.ReverseComparator;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionToolsTests
extends TestCase {
    public CollectionToolsTests(String name) {
        super(name);
    }

    public void testAddObjectArrayObject1() {
        Object[] a = CollectionTools.add((Object[])this.buildObjectArray1(), (Object)"twenty");
        CollectionToolsTests.assertEquals((int)4, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((Object[])a, (Object)"twenty"));
        CollectionToolsTests.assertEquals((Object)"twenty", (Object)a[a.length - 1]);
    }

    public void testAddObjectArrayObject2() {
        Object[] a = (String[])CollectionTools.add((Object[])this.buildStringArray1(), (Object)"twenty");
        CollectionToolsTests.assertEquals((int)4, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((Object[])a, (Object)"twenty"));
        CollectionToolsTests.assertEquals((String)"twenty", (String)a[a.length - 1]);
    }

    public void testAddObjectArrayIntObject1() {
        Object[] a = new Object[]{"a", "b", "c", "d"};
        a = CollectionTools.add((Object[])a, (int)2, (Object)"X");
        CollectionToolsTests.assertEquals((int)5, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((Object[])a, (Object)"X"));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"a", "b", "X", "c", "d"}, a));
    }

    public void testAddObjectArrayIntObject2() {
        Object[] a = new String[]{"a", "b", "c", "d"};
        a = (String[])CollectionTools.add((Object[])a, (int)2, (Object)"X");
        CollectionToolsTests.assertEquals((int)5, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((Object[])a, (Object)"X"));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"a", "b", "X", "c", "d"}, a));
    }

    public void testAddObjectArrayIntObjectException() {
        Object[] a = new Object[]{"a", "b", "c", "d"};
        boolean exCaught = false;
        try {
            a = CollectionTools.add((Object[])a, (int)33, (Object)"X");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            exCaught = true;
        }
        CollectionToolsTests.assertTrue((boolean)exCaught);
    }

    public void testAddCharArrayChar() {
        char[] a = CollectionTools.add((char[])this.buildCharArray(), (char)'d');
        CollectionToolsTests.assertEquals((int)4, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((char[])a, (char)'d'));
    }

    public void testAddCharArrayIntChar() {
        char[] a = new char[]{'a', 'b', 'c', 'd'};
        a = CollectionTools.add((char[])a, (int)2, (char)'X');
        CollectionToolsTests.assertEquals((int)5, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((char[])a, (char)'X'));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'a', 'b', 'X', 'c', 'd'}, a));
    }

    public void testAddIntArrayInt() {
        int[] a = CollectionTools.add((int[])this.buildIntArray(), (int)30);
        CollectionToolsTests.assertEquals((int)4, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((int[])a, (int)30));
    }

    public void testAddIntArrayIntInt() {
        int[] a = new int[]{1, 2, 3, 4};
        a = CollectionTools.add((int[])a, (int)2, (int)99);
        CollectionToolsTests.assertEquals((int)5, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((int[])a, (int)99));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new int[]{1, 2, 99, 3, 4}, a));
    }

    public void testAddAllCollectionIterator1() {
        List<String> l1 = this.buildStringList1();
        List<String> l2 = this.buildStringList2();
        Set<String> s1 = this.buildStringSet1();
        List<String> l3 = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.addAll(l1, l2.iterator()));
        CollectionToolsTests.assertEquals((int)6, (int)l1.size());
        CollectionToolsTests.assertTrue((boolean)l1.containsAll(l2));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.addAll(s1, l3.iterator()));
        CollectionToolsTests.assertEquals((int)3, (int)s1.size());
        CollectionToolsTests.assertTrue((boolean)s1.containsAll(l3));
    }

    public void testAddAllCollectionIterator2() {
        List<Object> l1 = this.buildObjectList1();
        List<String> l2 = this.buildStringList2();
        Set<Object> s1 = this.buildObjectSet1();
        List<String> l3 = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.addAll(l1, l2.iterator()));
        CollectionToolsTests.assertEquals((int)6, (int)l1.size());
        CollectionToolsTests.assertTrue((boolean)l1.containsAll(l2));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.addAll(s1, l3.iterator()));
        CollectionToolsTests.assertEquals((int)3, (int)s1.size());
        CollectionToolsTests.assertTrue((boolean)s1.containsAll(l3));
    }

    public void testAddAllCollectionObjectArray1() {
        List<String> l = this.buildStringList1();
        Object[] a = this.buildStringArray1();
        Set<String> s = this.buildStringSet1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.addAll(l, (Object[])a));
        CollectionToolsTests.assertEquals((int)6, (int)l.size());
        CollectionToolsTests.assertTrue((boolean)l.containsAll(CollectionTools.collection((Object[])a)));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.addAll(s, (Object[])a));
        CollectionToolsTests.assertEquals((int)3, (int)s.size());
        CollectionToolsTests.assertTrue((boolean)s.containsAll(CollectionTools.collection((Object[])a)));
    }

    public void testAddAllCollectionObjectArray2() {
        List<Object> l = this.buildObjectList1();
        Object[] a = this.buildStringArray1();
        Set<Object> s = this.buildObjectSet1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.addAll(l, (Object[])a));
        CollectionToolsTests.assertEquals((int)6, (int)l.size());
        CollectionToolsTests.assertTrue((boolean)l.containsAll(CollectionTools.collection((Object[])a)));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.addAll(s, (Object[])a));
        CollectionToolsTests.assertEquals((int)3, (int)s.size());
        CollectionToolsTests.assertTrue((boolean)s.containsAll(CollectionTools.collection((Object[])a)));
    }

    public void testAddAllObjectArrayCollection1() {
        Object[] a = this.buildStringArray1();
        List<String> c = this.buildStringList2();
        Object[] newArray = (String[])CollectionTools.addAll((Object[])a, c);
        CollectionToolsTests.assertEquals((int)6, (int)newArray.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])newArray, c));
    }

    public void testAddAllObjectArrayCollection2() {
        Object[] a = this.buildObjectArray1();
        List<String> c = this.buildStringList2();
        Object[] newArray = CollectionTools.addAll((Object[])a, c);
        CollectionToolsTests.assertEquals((int)6, (int)newArray.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])newArray, c));
    }

    public void testAddAllObjectArrayIterator1() {
        Object[] a = this.buildStringArray1();
        Iterator<String> i = this.buildStringList1().iterator();
        Object[] newArray = (String[])CollectionTools.addAll((Object[])a, i);
        CollectionToolsTests.assertEquals((int)6, (int)newArray.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])newArray, this.buildStringList1()));
    }

    public void testAddAllObjectArrayIterator2() {
        Object[] a = this.buildStringArray1();
        Iterator<Object> i = this.buildObjectList1().iterator();
        Object[] newArray = CollectionTools.addAll((Object[])a, i);
        CollectionToolsTests.assertEquals((int)6, (int)newArray.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])newArray, this.buildObjectList1()));
    }

    public void testAddAllObjectArrayObjectArray1() {
        Object[] a1 = this.buildObjectArray1();
        Object[] a2 = this.buildObjectArray2();
        Object[] newArray = CollectionTools.addAll((Object[])a1, (Object[])a2);
        CollectionToolsTests.assertEquals((int)6, (int)newArray.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])newArray, (Object[])a1));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])newArray, (Object[])a2));
    }

    public void testAddAllObjectArrayObjectArray2() {
        Object[] a1 = this.buildStringArray1();
        Object[] a2 = this.buildStringArray2();
        Object[] newArray = (String[])CollectionTools.addAll((Object[])a1, (Object[])a2);
        CollectionToolsTests.assertEquals((int)6, (int)newArray.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])newArray, (Object[])a1));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])newArray, (Object[])a2));
    }

    public void testAddAllObjectArrayObjectArray3() {
        Object[] a1 = this.buildObjectArray1();
        Object[] a2 = this.buildStringArray2();
        Object[] newArray = CollectionTools.addAll((Object[])a1, (Object[])a2);
        CollectionToolsTests.assertEquals((int)6, (int)newArray.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])newArray, (Object[])a1));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])newArray, (Object[])a2));
    }

    public void testAddAllObjectArrayIntObjectArray1() {
        Object[] a = new Object[]{"a", "b", "c", "d"};
        a = CollectionTools.addAll((Object[])a, (int)2, (Object[])new Object[]{"X", "X", "X"});
        CollectionToolsTests.assertEquals((int)7, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((Object[])a, (Object)"X"));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"a", "b", "X", "X", "X", "c", "d"}, a));
    }

    public void testAddAllObjectArrayIntObjectArray2() {
        Object[] a = new String[]{"a", "b", "c", "d"};
        a = (String[])CollectionTools.addAll((Object[])a, (int)2, (Object[])new String[]{"X", "X", "X"});
        CollectionToolsTests.assertEquals((int)7, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((Object[])a, (Object)"X"));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"a", "b", "X", "X", "X", "c", "d"}, a));
    }

    public void testAddAllObjectArrayIntObjectArray3() {
        Object[] a = new Object[]{"a", "b", "c", "d"};
        a = CollectionTools.addAll((Object[])a, (int)2, (Object[])new String[]{"X", "X", "X"});
        CollectionToolsTests.assertEquals((int)7, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((Object[])a, (Object)"X"));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"a", "b", "X", "X", "X", "c", "d"}, a));
    }

    public void testAddAllCharArrayCharArray() {
        char[] a = CollectionTools.addAll((char[])this.buildCharArray(), (char[])new char[]{'d', 'e'});
        CollectionToolsTests.assertEquals((int)5, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((char[])a, (char)'d'));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((char[])a, (char)'e'));
    }

    public void testAddAllCharArrayIntCharArray() {
        char[] a = new char[]{'a', 'b', 'c', 'd'};
        a = CollectionTools.addAll((char[])a, (int)2, (char[])new char[]{'X', 'X', 'X'});
        CollectionToolsTests.assertEquals((int)7, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((char[])a, (char)'X'));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'a', 'b', 'X', 'X', 'X', 'c', 'd'}, a));
    }

    public void testAddAllIntArrayIntArray() {
        int[] a = CollectionTools.addAll((int[])this.buildIntArray(), (int[])new int[]{30, 40});
        CollectionToolsTests.assertEquals((int)5, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((int[])a, (int)30));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((int[])a, (int)40));
    }

    public void testAddAllIntArrayIntIntArray() {
        int[] a = new int[]{1, 2, 3, 4};
        a = CollectionTools.addAll((int[])a, (int)2, (int[])new int[]{99, 99, 99});
        CollectionToolsTests.assertEquals((int)7, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((int[])a, (int)99));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new int[]{1, 2, 99, 99, 99, 3, 4}, a));
    }

    public void testArrayIterator() {
        Object[] a = CollectionTools.array(this.buildStringList1().iterator());
        CollectionToolsTests.assertEquals((int)3, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])a, this.buildStringList1().iterator()));
    }

    public void testArrayIteratorObjectArray1() {
        Object[] a = (String[])CollectionTools.array(this.buildStringList1().iterator(), (Object[])new String[0]);
        CollectionToolsTests.assertEquals((int)3, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])a, this.buildStringList1().iterator()));
    }

    public void testArrayIteratorObjectArray2() {
        Object[] a = CollectionTools.array(this.buildStringList1().iterator(), (Object[])new Object[0]);
        CollectionToolsTests.assertEquals((int)3, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])a, this.buildStringList1().iterator()));
    }

    public void testBagEnumeration1() {
        Bag b = CollectionTools.bag(this.buildStringVector1().elements());
        CollectionToolsTests.assertEquals((int)3, (int)b.size());
        CollectionToolsTests.assertTrue((boolean)b.containsAll(this.buildStringVector1()));
    }

    public void testBagEnumeration2() {
        Bag b = CollectionTools.bag(this.buildStringVector1().elements());
        CollectionToolsTests.assertEquals((int)3, (int)b.size());
        CollectionToolsTests.assertTrue((boolean)b.containsAll(this.buildStringVector1()));
    }

    public void testBagIterator1() {
        Bag b = CollectionTools.bag(this.buildStringList1().iterator());
        CollectionToolsTests.assertEquals((int)3, (int)b.size());
        CollectionToolsTests.assertTrue((boolean)b.containsAll(this.buildStringList1()));
    }

    public void testBagIterator2() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("zero");
        c.add("one");
        c.add("two");
        c.add("three");
        Bag b = CollectionTools.bag(c.iterator());
        CollectionToolsTests.assertEquals((int)4, (int)b.size());
        CollectionToolsTests.assertTrue((boolean)b.containsAll(c));
    }

    public void testBagObjectArray1() {
        Bag b = CollectionTools.bag((Object[])this.buildStringArray1());
        CollectionToolsTests.assertEquals((int)3, (int)b.size());
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Collection)b, (Object[])this.buildStringArray1()));
    }

    public void testBagObjectArray2() {
        Bag b = CollectionTools.bag((Object[])new String[]{"foo", "bar", "baz"});
        CollectionToolsTests.assertEquals((int)3, (int)b.size());
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Collection)b, (Object[])new Object[]{"foo", "bar", "baz"}));
    }

    public void testCollectionEnumeration1() {
        Collection c = CollectionTools.collection(this.buildStringVector1().elements());
        CollectionToolsTests.assertEquals((int)3, (int)c.size());
        CollectionToolsTests.assertTrue((boolean)c.containsAll(this.buildStringVector1()));
    }

    public void testCollectionEnumeration2() {
        Collection c = CollectionTools.collection(this.buildStringVector1().elements());
        CollectionToolsTests.assertEquals((int)3, (int)c.size());
        CollectionToolsTests.assertTrue((boolean)c.containsAll(this.buildStringVector1()));
    }

    public void testCollectionIterator1() {
        Collection c = CollectionTools.collection(this.buildStringList1().iterator());
        CollectionToolsTests.assertEquals((int)3, (int)c.size());
        CollectionToolsTests.assertTrue((boolean)c.containsAll(this.buildStringList1()));
    }

    public void testCollectionIterator2() {
        Collection c = CollectionTools.collection(this.buildStringList1().iterator());
        CollectionToolsTests.assertEquals((int)3, (int)c.size());
        CollectionToolsTests.assertTrue((boolean)c.containsAll(this.buildStringList1()));
    }

    public void testCollectionObjectArray() {
        Collection c = CollectionTools.collection((Object[])this.buildStringArray1());
        CollectionToolsTests.assertEquals((int)3, (int)c.size());
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Collection)c, (Object[])this.buildStringArray1()));
    }

    public void testContainsEnumerationObject1() {
        Vector<String> v = this.buildStringVector1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains(v.elements(), (Object)"one"));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.contains(v.elements(), null));
        v.add(null);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains(v.elements(), null));
    }

    public void testContainsEnumerationObject2() {
        Vector<String> c = new Vector<String>();
        c.add("zero");
        c.add("one");
        c.add("two");
        c.add("three");
        String one = "one";
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains(c.elements(), (Object)one));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.contains(c.elements(), null));
        c.add(null);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains(c.elements(), null));
    }

    public void testContainsIteratorObject1() {
        List<String> c = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains(c.iterator(), (Object)"one"));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.contains(c.iterator(), null));
        c.add(null);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains(c.iterator(), null));
    }

    public void testContainsIteratorObject2() {
        HashBag c = new HashBag();
        c.add("zero");
        c.add("one");
        c.add("two");
        c.add("three");
        String one = "one";
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains(c.iterator(), (Object)one));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.contains(c.iterator(), null));
        c.add(null);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains(c.iterator(), null));
    }

    public void testContainsObjectArrayObject() {
        Object[] a = this.buildObjectArray1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((Object[])a, (Object)"one"));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.contains((Object[])a, null));
        Object[] a2 = CollectionTools.add((Object[])a, null);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((Object[])a2, null));
    }

    public void testContainsCharArrayChar() {
        char[] a = this.buildCharArray();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((char[])a, (char)'a'));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.contains((char[])a, (char)'z'));
        char[] a2 = CollectionTools.add((char[])a, (char)'z');
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((char[])a2, (char)'z'));
    }

    public void testContainsIntArrayInt() {
        int[] a = this.buildIntArray();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((int[])a, (int)10));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.contains((int[])a, (int)55));
        int[] a2 = CollectionTools.add((int[])a, (int)55);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((int[])a2, (int)55));
    }

    public void testContainsAllCollectionIterator1() {
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(this.buildStringList1(), this.buildStringList1().iterator()));
    }

    public void testContainsAllCollectionIterator2() {
        ArrayList<String> c1 = new ArrayList<String>();
        c1.add("zero");
        c1.add("one");
        c1.add("two");
        ArrayList<String> c2 = new ArrayList<String>();
        c2.add("two");
        c2.add("zero");
        c2.add("one");
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(c1, c2.iterator()));
    }

    public void testContainsAllCollectionObjectArray1() {
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(this.buildStringList1(), (Object[])this.buildObjectArray1()));
    }

    public void testContainsAllCollectionObjectArray2() {
        Object[] a = new Object[]{"zero", "one", "two"};
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(this.buildStringList1(), (Object[])a));
    }

    public void testContainsAllIteratorCollection1() {
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(this.buildStringList1().iterator(), this.buildStringList1()));
    }

    public void testContainsAllIteratorCollection2() {
        ArrayList<String> c1 = new ArrayList<String>();
        c1.add("zero");
        c1.add("one");
        c1.add("two");
        ArrayList<String> c2 = new ArrayList<String>();
        c2.add("zero");
        c2.add("one");
        c2.add("two");
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(c1.iterator(), c2));
    }

    public void testContainsAllIteratorIterator1() {
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(this.buildStringList1().iterator(), this.buildStringList1().iterator()));
    }

    public void testContainsAllIteratorIterator2() {
        ArrayList<String> c1 = new ArrayList<String>();
        c1.add("zero");
        c1.add("one");
        c1.add("two");
        ArrayList<String> c2 = new ArrayList<String>();
        c2.add("zero");
        c2.add("one");
        c2.add("two");
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(c1.iterator(), c2.iterator()));
    }

    public void testContainsAllIteratorObjectArray() {
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(this.buildStringList1().iterator(), (Object[])this.buildObjectArray1()));
    }

    public void testContainsAllObjectArrayCollection() {
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])this.buildObjectArray1(), this.buildStringList1()));
    }

    public void testContainsAllObjectArrayIterator() {
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])this.buildObjectArray1(), this.buildStringList1().iterator()));
    }

    public void testContainsAllObjectArrayObjectArray() {
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])this.buildObjectArray1(), (Object[])this.buildObjectArray1()));
    }

    public void testContainsAllCharArrayCharArray() {
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((char[])this.buildCharArray(), (char[])this.buildCharArray()));
    }

    public void testContainsAllIntArrayIntArray() {
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((int[])this.buildIntArray(), (int[])this.buildIntArray()));
    }

    public void testDiffEnd() {
        String a = "a";
        String b = "b";
        String c = "c";
        String d = "d";
        String e = "e";
        String a_ = new String("a");
        String b_ = new String("b");
        String c_ = new String("c");
        String d_ = new String("d");
        String e_ = new String("e");
        CollectionToolsTests.assertTrue((a != a_ && a.equals(a_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((b != b_ && b.equals(b_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((c != c_ && c.equals(c_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((d != d_ && d.equals(d_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((e != e_ && e.equals(e_) ? 1 : 0) != 0);
        Object[] array1 = new String[]{a, b, c, d, e};
        Object[] array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((int)-1, (int)CollectionTools.diffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{a};
        array2 = new String[]{a_};
        CollectionToolsTests.assertEquals((int)-1, (int)CollectionTools.diffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{b, c, d, e};
        array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((int)4, (int)CollectionTools.diffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((int)4, (int)CollectionTools.diffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{};
        array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((int)4, (int)CollectionTools.diffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{};
        CollectionToolsTests.assertEquals((int)4, (int)CollectionTools.diffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{};
        array2 = new String[]{};
        CollectionToolsTests.assertEquals((int)-1, (int)CollectionTools.diffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{b_, c_, a_, d_, e_};
        CollectionToolsTests.assertEquals((int)2, (int)CollectionTools.diffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{b, c, d, e};
        array2 = new String[]{a_, c_, d_, e_};
        CollectionToolsTests.assertEquals((int)0, (int)CollectionTools.diffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, e};
        array2 = new String[]{a_, b_, c_, d_};
        CollectionToolsTests.assertEquals((int)3, (int)CollectionTools.diffEnd((Object[])array1, (Object[])array2));
        String c__ = new String(c);
        CollectionToolsTests.assertTrue((c != c__ && c.equals(c_) ? 1 : 0) != 0);
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{a_, b_, c__, d_, e_};
        CollectionToolsTests.assertEquals((int)-1, (int)CollectionTools.diffEnd((Object[])array1, (Object[])array2));
        String[] stringArray = new String[5];
        stringArray[0] = a;
        stringArray[1] = b;
        stringArray[3] = d;
        stringArray[4] = e;
        array1 = stringArray;
        array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((int)2, (int)CollectionTools.diffEnd((Object[])array1, (Object[])array2));
        String[] stringArray2 = new String[5];
        stringArray2[0] = a;
        stringArray2[1] = b;
        stringArray2[3] = d;
        stringArray2[4] = e;
        array1 = stringArray2;
        String[] stringArray3 = new String[5];
        stringArray3[0] = a_;
        stringArray3[1] = b_;
        stringArray3[3] = d_;
        stringArray3[4] = e_;
        array2 = stringArray3;
        CollectionToolsTests.assertEquals((int)-1, (int)CollectionTools.diffEnd((Object[])array1, (Object[])array2));
    }

    public void testDiffRange() {
        String a = "a";
        String b = "b";
        String c = "c";
        String d = "d";
        String e = "e";
        String a_ = a;
        String b_ = b;
        String c_ = c;
        String d_ = d;
        String e_ = e;
        CollectionToolsTests.assertTrue((a == a_ && a.equals(a_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((b == b_ && b.equals(b_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((c == c_ && c.equals(c_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((d == d_ && d.equals(d_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((e == e_ && e.equals(e_) ? 1 : 0) != 0);
        Object[] array1 = new String[]{a, b, c, d, e};
        Object[] array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((Object)new Range(5, -1), (Object)CollectionTools.diffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{a};
        array2 = new String[]{a_};
        CollectionToolsTests.assertEquals((Object)new Range(1, -1), (Object)CollectionTools.diffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{b, c, d, e};
        array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((Object)new Range(0, 4), (Object)CollectionTools.diffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((Object)new Range(0, 4), (Object)CollectionTools.diffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{};
        array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((Object)new Range(0, 4), (Object)CollectionTools.diffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{};
        CollectionToolsTests.assertEquals((Object)new Range(0, 4), (Object)CollectionTools.diffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{};
        array2 = new String[]{};
        CollectionToolsTests.assertEquals((Object)new Range(0, -1), (Object)CollectionTools.diffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{b_, c_, a_, d_, e_};
        CollectionToolsTests.assertEquals((Object)new Range(0, 2), (Object)CollectionTools.diffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{b, c, d, e};
        array2 = new String[]{a_, c_, d_, e_};
        CollectionToolsTests.assertEquals((Object)new Range(0, 0), (Object)CollectionTools.diffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, e};
        array2 = new String[]{a_, b_, c_, d_};
        CollectionToolsTests.assertEquals((Object)new Range(3, 3), (Object)CollectionTools.diffRange((Object[])array1, (Object[])array2));
        String c__ = new String(c);
        CollectionToolsTests.assertTrue((c != c__ && c.equals(c_) ? 1 : 0) != 0);
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{a_, b_, c__, d_, e_};
        CollectionToolsTests.assertEquals((Object)new Range(5, -1), (Object)CollectionTools.diffRange((Object[])array1, (Object[])array2));
        String[] stringArray = new String[5];
        stringArray[0] = a;
        stringArray[1] = b;
        stringArray[3] = d;
        stringArray[4] = e;
        array1 = stringArray;
        array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((Object)new Range(2, 2), (Object)CollectionTools.diffRange((Object[])array1, (Object[])array2));
        String[] stringArray2 = new String[5];
        stringArray2[0] = a;
        stringArray2[1] = b;
        stringArray2[3] = d;
        stringArray2[4] = e;
        array1 = stringArray2;
        String[] stringArray3 = new String[5];
        stringArray3[0] = a_;
        stringArray3[1] = b_;
        stringArray3[3] = d_;
        stringArray3[4] = e_;
        array2 = stringArray3;
        CollectionToolsTests.assertEquals((Object)new Range(5, -1), (Object)CollectionTools.diffRange((Object[])array1, (Object[])array2));
    }

    public void testDiffStart() {
        String a = "a";
        String b = "b";
        String c = "c";
        String d = "d";
        String e = "e";
        String a_ = new String("a");
        String b_ = new String("b");
        String c_ = new String("c");
        String d_ = new String("d");
        String e_ = new String("e");
        CollectionToolsTests.assertTrue((a != a_ && a.equals(a_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((b != b_ && b.equals(b_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((c != c_ && c.equals(c_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((d != d_ && d.equals(d_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((e != e_ && e.equals(e_) ? 1 : 0) != 0);
        Object[] array1 = new String[]{a, b, c, d, e};
        Object[] array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((int)5, (int)CollectionTools.diffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{a};
        array2 = new String[]{a_};
        CollectionToolsTests.assertEquals((int)1, (int)CollectionTools.diffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d};
        array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((int)4, (int)CollectionTools.diffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{a_, b_, c_, d_};
        CollectionToolsTests.assertEquals((int)4, (int)CollectionTools.diffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{};
        array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((int)0, (int)CollectionTools.diffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{};
        CollectionToolsTests.assertEquals((int)0, (int)CollectionTools.diffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{};
        array2 = new String[]{};
        CollectionToolsTests.assertEquals((int)0, (int)CollectionTools.diffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{a_, b_, e_, c_, d_};
        CollectionToolsTests.assertEquals((int)2, (int)CollectionTools.diffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, e};
        array2 = new String[]{a_, b_, c_, d_};
        CollectionToolsTests.assertEquals((int)3, (int)CollectionTools.diffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{b, c, d, e};
        array2 = new String[]{a_, c_, d_, e_};
        CollectionToolsTests.assertEquals((int)0, (int)CollectionTools.diffStart((Object[])array1, (Object[])array2));
        String c__ = new String(c);
        CollectionToolsTests.assertTrue((c != c__ && c.equals(c__) ? 1 : 0) != 0);
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{a_, b_, c__, d_, e_};
        CollectionToolsTests.assertEquals((int)5, (int)CollectionTools.diffStart((Object[])array1, (Object[])array2));
        String[] stringArray = new String[5];
        stringArray[0] = a;
        stringArray[1] = b;
        stringArray[3] = d;
        stringArray[4] = e;
        array1 = stringArray;
        array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((int)2, (int)CollectionTools.diffStart((Object[])array1, (Object[])array2));
        String[] stringArray2 = new String[5];
        stringArray2[0] = a;
        stringArray2[1] = b;
        stringArray2[3] = d;
        stringArray2[4] = e;
        array1 = stringArray2;
        String[] stringArray3 = new String[5];
        stringArray3[0] = a_;
        stringArray3[1] = b_;
        stringArray3[3] = d_;
        stringArray3[4] = e_;
        array2 = stringArray3;
        CollectionToolsTests.assertEquals((int)5, (int)CollectionTools.diffStart((Object[])array1, (Object[])array2));
    }

    public void testEqualsListIteratorListIterator() {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("1000");
        list1.add("2000");
        list1.add("3000");
        list1.add("4000");
        ArrayList<String> list2 = new ArrayList<String>();
        int i = 0;
        while (i < list1.size()) {
            list2.add(String.valueOf((i + 1) * 1000));
            ++i;
        }
        CollectionToolsTests.assertFalse((boolean)CollectionTools.identical(list1.listIterator(), list2.listIterator()));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.equals(list1.listIterator(), list2.listIterator()));
    }

    public void testGetListIteratorInt() {
        List<String> list = this.buildStringList1();
        String o = (String)CollectionTools.get(list.listIterator(), (int)1);
        CollectionToolsTests.assertEquals((String)"one", (String)o);
        list.add(null);
        o = (String)CollectionTools.get(list.listIterator(), (int)(list.size() - 1));
        CollectionToolsTests.assertNull((Object)o);
        boolean exCaught = false;
        try {
            CollectionTools.get(list.listIterator(), (int)list.size());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            exCaught = true;
        }
        CollectionToolsTests.assertTrue((boolean)exCaught);
    }

    public void testIdenticalObjectArrayObjectArray() {
        Object[] a1 = new Object[4];
        int i = 0;
        while (i < a1.length) {
            a1[i] = String.valueOf(i * 1000);
            ++i;
        }
        Object[] a2 = new Object[a1.length];
        int i2 = 0;
        while (i2 < a2.length) {
            a2[i2] = a1[i2];
            ++i2;
        }
        CollectionToolsTests.assertTrue((boolean)CollectionTools.identical((Object[])a1, (Object[])a2));
        a2[2] = "2000";
        CollectionToolsTests.assertFalse((boolean)CollectionTools.identical((Object[])a1, (Object[])a2));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(a1, a2));
    }

    public void testIdenticalListIteratorListIterator() {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("0");
        list1.add("1");
        list1.add("2");
        list1.add("3");
        ArrayList<String> list2 = new ArrayList<String>();
        for (String s : list1) {
            list2.add(s);
        }
        CollectionToolsTests.assertTrue((boolean)CollectionTools.identical(list1.listIterator(), list2.listIterator()));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.equals(list1.listIterator(), list2.listIterator()));
    }

    public void testIdentityDiffEnd() {
        String a = "a";
        String b = "b";
        String c = "c";
        String d = "d";
        String e = "e";
        String a_ = a;
        String b_ = b;
        String c_ = c;
        String d_ = d;
        String e_ = e;
        CollectionToolsTests.assertTrue((a == a_ && a.equals(a_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((b == b_ && b.equals(b_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((c == c_ && c.equals(c_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((d == d_ && d.equals(d_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((e == e_ && e.equals(e_) ? 1 : 0) != 0);
        Object[] array1 = new String[]{a, b, c, d, e};
        Object[] array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((int)-1, (int)CollectionTools.identityDiffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{a};
        array2 = new String[]{a_};
        CollectionToolsTests.assertEquals((int)-1, (int)CollectionTools.identityDiffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{b, c, d, e};
        array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((int)4, (int)CollectionTools.identityDiffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((int)4, (int)CollectionTools.identityDiffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{};
        array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((int)4, (int)CollectionTools.identityDiffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{};
        CollectionToolsTests.assertEquals((int)4, (int)CollectionTools.identityDiffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{};
        array2 = new String[]{};
        CollectionToolsTests.assertEquals((int)-1, (int)CollectionTools.identityDiffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{b_, c_, a_, d_, e_};
        CollectionToolsTests.assertEquals((int)2, (int)CollectionTools.identityDiffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{b, c, d, e};
        array2 = new String[]{a_, c_, d_, e_};
        CollectionToolsTests.assertEquals((int)0, (int)CollectionTools.identityDiffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, e};
        array2 = new String[]{a_, b_, c_, d_};
        CollectionToolsTests.assertEquals((int)3, (int)CollectionTools.identityDiffEnd((Object[])array1, (Object[])array2));
        String c__ = new String(c);
        CollectionToolsTests.assertTrue((c != c__ && c.equals(c_) ? 1 : 0) != 0);
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{a_, b_, c__, d_, e_};
        CollectionToolsTests.assertEquals((int)2, (int)CollectionTools.identityDiffEnd((Object[])array1, (Object[])array2));
        String[] stringArray = new String[5];
        stringArray[0] = a;
        stringArray[1] = b;
        stringArray[3] = d;
        stringArray[4] = e;
        array1 = stringArray;
        array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((int)2, (int)CollectionTools.identityDiffEnd((Object[])array1, (Object[])array2));
        String[] stringArray2 = new String[5];
        stringArray2[0] = a;
        stringArray2[1] = b;
        stringArray2[3] = d;
        stringArray2[4] = e;
        array1 = stringArray2;
        String[] stringArray3 = new String[5];
        stringArray3[0] = a_;
        stringArray3[1] = b_;
        stringArray3[3] = d_;
        stringArray3[4] = e_;
        array2 = stringArray3;
        CollectionToolsTests.assertEquals((int)-1, (int)CollectionTools.identityDiffEnd((Object[])array1, (Object[])array2));
    }

    public void testIdentityDiffRange() {
        String a = "a";
        String b = "b";
        String c = "c";
        String d = "d";
        String e = "e";
        String a_ = a;
        String b_ = b;
        String c_ = c;
        String d_ = d;
        String e_ = e;
        CollectionToolsTests.assertTrue((a == a_ && a.equals(a_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((b == b_ && b.equals(b_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((c == c_ && c.equals(c_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((d == d_ && d.equals(d_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((e == e_ && e.equals(e_) ? 1 : 0) != 0);
        Object[] array1 = new String[]{a, b, c, d, e};
        Object[] array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((Object)new Range(5, -1), (Object)CollectionTools.identityDiffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{a};
        array2 = new String[]{a_};
        CollectionToolsTests.assertEquals((Object)new Range(1, -1), (Object)CollectionTools.identityDiffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{b, c, d, e};
        array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((Object)new Range(0, 4), (Object)CollectionTools.identityDiffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((Object)new Range(0, 4), (Object)CollectionTools.identityDiffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{};
        array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((Object)new Range(0, 4), (Object)CollectionTools.identityDiffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{};
        CollectionToolsTests.assertEquals((Object)new Range(0, 4), (Object)CollectionTools.identityDiffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{};
        array2 = new String[]{};
        CollectionToolsTests.assertEquals((Object)new Range(0, -1), (Object)CollectionTools.identityDiffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{b_, c_, a_, d_, e_};
        CollectionToolsTests.assertEquals((Object)new Range(0, 2), (Object)CollectionTools.identityDiffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{b, c, d, e};
        array2 = new String[]{a_, c_, d_, e_};
        CollectionToolsTests.assertEquals((Object)new Range(0, 0), (Object)CollectionTools.identityDiffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, e};
        array2 = new String[]{a_, b_, c_, d_};
        CollectionToolsTests.assertEquals((Object)new Range(3, 3), (Object)CollectionTools.identityDiffRange((Object[])array1, (Object[])array2));
        String c__ = new String(c);
        CollectionToolsTests.assertTrue((c != c__ && c.equals(c_) ? 1 : 0) != 0);
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{a_, b_, c__, d_, e_};
        CollectionToolsTests.assertEquals((Object)new Range(2, 2), (Object)CollectionTools.identityDiffRange((Object[])array1, (Object[])array2));
        String[] stringArray = new String[5];
        stringArray[0] = a;
        stringArray[1] = b;
        stringArray[3] = d;
        stringArray[4] = e;
        array1 = stringArray;
        array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((Object)new Range(2, 2), (Object)CollectionTools.identityDiffRange((Object[])array1, (Object[])array2));
        String[] stringArray2 = new String[5];
        stringArray2[0] = a;
        stringArray2[1] = b;
        stringArray2[3] = d;
        stringArray2[4] = e;
        array1 = stringArray2;
        String[] stringArray3 = new String[5];
        stringArray3[0] = a_;
        stringArray3[1] = b_;
        stringArray3[3] = d_;
        stringArray3[4] = e_;
        array2 = stringArray3;
        CollectionToolsTests.assertEquals((Object)new Range(5, -1), (Object)CollectionTools.identityDiffRange((Object[])array1, (Object[])array2));
    }

    public void testIdentityDiffStart() {
        String a = "a";
        String b = "b";
        String c = "c";
        String d = "d";
        String e = "e";
        String a_ = a;
        String b_ = b;
        String c_ = c;
        String d_ = d;
        String e_ = e;
        CollectionToolsTests.assertTrue((a == a_ && a.equals(a_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((b == b_ && b.equals(b_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((c == c_ && c.equals(c_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((d == d_ && d.equals(d_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((e == e_ && e.equals(e_) ? 1 : 0) != 0);
        Object[] array1 = new String[]{a, b, c, d, e};
        Object[] array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((int)5, (int)CollectionTools.identityDiffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{a};
        array2 = new String[]{a_};
        CollectionToolsTests.assertEquals((int)1, (int)CollectionTools.identityDiffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d};
        array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((int)4, (int)CollectionTools.identityDiffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{a_, b_, c_, d_};
        CollectionToolsTests.assertEquals((int)4, (int)CollectionTools.identityDiffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{};
        array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((int)0, (int)CollectionTools.identityDiffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{};
        CollectionToolsTests.assertEquals((int)0, (int)CollectionTools.identityDiffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{};
        array2 = new String[]{};
        CollectionToolsTests.assertEquals((int)0, (int)CollectionTools.identityDiffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{a_, b_, e_, c_, d_};
        CollectionToolsTests.assertEquals((int)2, (int)CollectionTools.identityDiffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, e};
        array2 = new String[]{a_, b_, c_, d_};
        CollectionToolsTests.assertEquals((int)3, (int)CollectionTools.identityDiffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{b, c, d, e};
        array2 = new String[]{a_, c_, d_, e_};
        CollectionToolsTests.assertEquals((int)0, (int)CollectionTools.identityDiffStart((Object[])array1, (Object[])array2));
        String c__ = new String(c);
        CollectionToolsTests.assertTrue((c != c__ && c.equals(c_) ? 1 : 0) != 0);
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{a_, b_, c__, d_, e_};
        CollectionToolsTests.assertEquals((int)2, (int)CollectionTools.identityDiffStart((Object[])array1, (Object[])array2));
        String[] stringArray = new String[5];
        stringArray[0] = a;
        stringArray[1] = b;
        stringArray[3] = d;
        stringArray[4] = e;
        array1 = stringArray;
        array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((int)2, (int)CollectionTools.identityDiffStart((Object[])array1, (Object[])array2));
        String[] stringArray2 = new String[5];
        stringArray2[0] = a;
        stringArray2[1] = b;
        stringArray2[3] = d;
        stringArray2[4] = e;
        array1 = stringArray2;
        String[] stringArray3 = new String[5];
        stringArray3[0] = a_;
        stringArray3[1] = b_;
        stringArray3[3] = d_;
        stringArray3[4] = e_;
        array2 = stringArray3;
        CollectionToolsTests.assertEquals((int)5, (int)CollectionTools.identityDiffStart((Object[])array1, (Object[])array2));
    }

    public void testIndexOfListIteratorObject1() {
        List<String> list = this.buildStringList1();
        CollectionToolsTests.assertEquals((int)1, (int)CollectionTools.indexOf(list.listIterator(), (Object)"one"));
        list.add(null);
        CollectionToolsTests.assertEquals((int)(list.size() - 1), (int)CollectionTools.indexOf(list.listIterator(), null));
    }

    public void testIndexOfListIteratorObject2() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("0");
        list.add("1");
        list.add("2");
        list.add("3");
        String one = "1";
        CollectionToolsTests.assertEquals((int)1, (int)CollectionTools.indexOf(list.listIterator(), (Object)one));
        list.add(null);
        CollectionToolsTests.assertEquals((int)(list.size() - 1), (int)CollectionTools.indexOf(list.listIterator(), null));
    }

    public void testIndexOfObjectArrayObject() {
        Object[] a = this.buildObjectArray1();
        CollectionToolsTests.assertEquals((int)1, (int)CollectionTools.indexOf((Object[])a, (Object)"one"));
        a = CollectionTools.add((Object[])a, null);
        CollectionToolsTests.assertEquals((int)(a.length - 1), (int)CollectionTools.indexOf((Object[])a, null));
    }

    public void testIndexOfCharArrayChar() {
        char[] a = this.buildCharArray();
        CollectionToolsTests.assertEquals((int)1, (int)CollectionTools.indexOf((char[])a, (char)'b'));
        a = CollectionTools.add((char[])a, (char)'d');
        CollectionToolsTests.assertEquals((int)(a.length - 1), (int)CollectionTools.indexOf((char[])a, (char)'d'));
    }

    public void testIndexOfIntArrayInt() {
        int[] a = this.buildIntArray();
        CollectionToolsTests.assertEquals((int)1, (int)CollectionTools.indexOf((int[])a, (int)10));
        a = CollectionTools.add((int[])a, (int)30);
        CollectionToolsTests.assertEquals((int)(a.length - 1), (int)CollectionTools.indexOf((int[])a, (int)30));
    }

    public void testInsertionIndexOfListComparable() {
        List<String> list = Arrays.asList("A", "C", "D");
        CollectionToolsTests.assertEquals((int)1, (int)CollectionTools.insertionIndexOf(list, (Comparable)((Object)"B")));
        list = Arrays.asList("A", "B", "C", "D");
        CollectionToolsTests.assertEquals((int)2, (int)CollectionTools.insertionIndexOf(list, (Comparable)((Object)"B")));
        list = Arrays.asList("A", "B", "B", "B", "C", "D");
        CollectionToolsTests.assertEquals((int)4, (int)CollectionTools.insertionIndexOf(list, (Comparable)((Object)"B")));
        list = Arrays.asList("A", "B", "B", "B", "C", "D");
        CollectionToolsTests.assertEquals((int)6, (int)CollectionTools.insertionIndexOf(list, (Comparable)((Object)"E")));
        list = Arrays.asList("B", "B", "B", "C", "D");
        CollectionToolsTests.assertEquals((int)0, (int)CollectionTools.insertionIndexOf(list, (Comparable)((Object)"A")));
        list = Arrays.asList("A", "A", "B", "B", "C", "D");
        CollectionToolsTests.assertEquals((int)2, (int)CollectionTools.insertionIndexOf(list, (Comparable)((Object)"A")));
    }

    public void testInsertionIndexOfListObjectComparator() {
        ReverseComparator c = new ReverseComparator();
        List<String> list = Arrays.asList("D", "C", "A");
        CollectionToolsTests.assertEquals((int)2, (int)CollectionTools.insertionIndexOf(list, (Object)"B", (Comparator)c));
        list = Arrays.asList("D", "C", "B", "A");
        CollectionToolsTests.assertEquals((int)3, (int)CollectionTools.insertionIndexOf(list, (Object)"B", (Comparator)c));
        list = Arrays.asList("D", "C", "B", "B", "B", "A");
        CollectionToolsTests.assertEquals((int)5, (int)CollectionTools.insertionIndexOf(list, (Object)"B", (Comparator)c));
        list = Arrays.asList("D", "C", "B", "B", "B", "A");
        CollectionToolsTests.assertEquals((int)0, (int)CollectionTools.insertionIndexOf(list, (Object)"E", (Comparator)c));
        list = Arrays.asList("D", "C", "B", "B", "B");
        CollectionToolsTests.assertEquals((int)5, (int)CollectionTools.insertionIndexOf(list, (Object)"A", (Comparator)c));
        list = Arrays.asList("D", "C", "B", "B", "A", "A");
        CollectionToolsTests.assertEquals((int)6, (int)CollectionTools.insertionIndexOf(list, (Object)"A", (Comparator)c));
    }

    public void testInsertionIndexOfObjectArrayComparable() {
        String[] a = new String[]{"A", "C", "D"};
        CollectionToolsTests.assertEquals((int)1, (int)CollectionTools.insertionIndexOf((Comparable[])a, (Comparable)((Object)"B")));
        a = new String[]{"A", "B", "C", "D"};
        CollectionToolsTests.assertEquals((int)2, (int)CollectionTools.insertionIndexOf((Comparable[])a, (Comparable)((Object)"B")));
        a = new String[]{"A", "B", "B", "B", "C", "D"};
        CollectionToolsTests.assertEquals((int)4, (int)CollectionTools.insertionIndexOf((Comparable[])a, (Comparable)((Object)"B")));
        a = new String[]{"A", "B", "B", "B", "C", "D"};
        CollectionToolsTests.assertEquals((int)6, (int)CollectionTools.insertionIndexOf((Comparable[])a, (Comparable)((Object)"E")));
        a = new String[]{"B", "B", "B", "C", "D"};
        CollectionToolsTests.assertEquals((int)0, (int)CollectionTools.insertionIndexOf((Comparable[])a, (Comparable)((Object)"A")));
        a = new String[]{"A", "A", "B", "B", "C", "D"};
        CollectionToolsTests.assertEquals((int)2, (int)CollectionTools.insertionIndexOf((Comparable[])a, (Comparable)((Object)"A")));
    }

    public void testInsertionIndexOfObjectArrayObjectComparator() {
        ReverseComparator c = new ReverseComparator();
        Object[] a = new String[]{"D", "C", "A"};
        CollectionToolsTests.assertEquals((int)2, (int)CollectionTools.insertionIndexOf((Object[])a, (Object)"B", (Comparator)c));
        a = new String[]{"D", "C", "B", "A"};
        CollectionToolsTests.assertEquals((int)3, (int)CollectionTools.insertionIndexOf((Object[])a, (Object)"B", (Comparator)c));
        a = new String[]{"D", "C", "B", "B", "B", "A"};
        CollectionToolsTests.assertEquals((int)5, (int)CollectionTools.insertionIndexOf((Object[])a, (Object)"B", (Comparator)c));
        a = new String[]{"D", "C", "B", "B", "B", "A"};
        CollectionToolsTests.assertEquals((int)0, (int)CollectionTools.insertionIndexOf((Object[])a, (Object)"E", (Comparator)c));
        a = new String[]{"D", "C", "B", "B", "B"};
        CollectionToolsTests.assertEquals((int)5, (int)CollectionTools.insertionIndexOf((Object[])a, (Object)"A", (Comparator)c));
        a = new String[]{"D", "C", "B", "B", "A", "A"};
        CollectionToolsTests.assertEquals((int)6, (int)CollectionTools.insertionIndexOf((Object[])a, (Object)"A", (Comparator)c));
    }

    public void testIteratorObjectArray() {
        Object[] a = this.buildStringArray1();
        int i = 0;
        Iterator stream = CollectionTools.iterator((Object[])a);
        while (stream.hasNext()) {
            CollectionToolsTests.assertEquals((String)a[i], (String)((String)stream.next()));
            ++i;
        }
    }

    public void testLastIndexOfListIteratorObject() {
        List<String> list = this.buildStringList1();
        CollectionToolsTests.assertEquals((int)1, (int)CollectionTools.lastIndexOf(list.listIterator(), (Object)"one"));
        list.add(null);
        CollectionToolsTests.assertEquals((int)(list.size() - 1), (int)CollectionTools.lastIndexOf(list.listIterator(), null));
    }

    public void testLastIndexOfObjectArrayObject() {
        Object[] a = this.buildObjectArray1();
        CollectionToolsTests.assertEquals((int)1, (int)CollectionTools.lastIndexOf((Object[])a, (Object)"one"));
        a = CollectionTools.add((Object[])a, null);
        CollectionToolsTests.assertEquals((int)(a.length - 1), (int)CollectionTools.lastIndexOf((Object[])a, null));
    }

    public void testLastIndexOfCharArrayChar() {
        char[] a = this.buildCharArray();
        CollectionToolsTests.assertEquals((int)1, (int)CollectionTools.lastIndexOf((char[])a, (char)'b'));
        a = CollectionTools.add((char[])a, (char)'d');
        CollectionToolsTests.assertEquals((int)(a.length - 1), (int)CollectionTools.lastIndexOf((char[])a, (char)'d'));
    }

    public void testLastIndexOfIntArrayInt() {
        int[] a = this.buildIntArray();
        CollectionToolsTests.assertEquals((int)1, (int)CollectionTools.lastIndexOf((int[])a, (int)10));
        a = CollectionTools.add((int[])a, (int)30);
        CollectionToolsTests.assertEquals((int)(a.length - 1), (int)CollectionTools.lastIndexOf((int[])a, (int)30));
    }

    public void testListIterator1() {
        List list = CollectionTools.list(this.buildStringList1().iterator());
        CollectionToolsTests.assertEquals(this.buildStringList1(), (Object)list);
    }

    public void testListIterator2() {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("0");
        list1.add("1");
        list1.add("2");
        list1.add("3");
        List list2 = CollectionTools.list(list1.iterator());
        CollectionToolsTests.assertEquals(list1, (Object)list2);
    }

    public void testListObjectArray() {
        List list = CollectionTools.list((Object[])this.buildStringArray1());
        CollectionToolsTests.assertEquals(this.buildStringList1(), (Object)list);
    }

    public void testListIteratorObjectArray() {
        Object[] a = this.buildStringArray1();
        int i = 0;
        ListIterator stream = CollectionTools.listIterator((Object[])a);
        while (stream.hasNext()) {
            CollectionToolsTests.assertEquals((String)a[i], (String)((String)stream.next()));
            ++i;
        }
    }

    public void testListIteratorObjectArrayInt() {
        Object[] a = this.buildStringArray1();
        int i = 1;
        ListIterator stream = CollectionTools.listIterator((Object[])a, (int)1);
        while (stream.hasNext()) {
            CollectionToolsTests.assertEquals((String)a[i], (String)((String)stream.next()));
            ++i;
        }
    }

    public void testMaxCharArray() {
        CollectionToolsTests.assertEquals((char)'c', (char)CollectionTools.max((char[])this.buildCharArray()));
    }

    public void testMaxIntArray() {
        CollectionToolsTests.assertEquals((int)20, (int)CollectionTools.max((int[])this.buildIntArray()));
    }

    public void testMinCharArray() {
        CollectionToolsTests.assertEquals((char)'a', (char)CollectionTools.min((char[])this.buildCharArray()));
    }

    public void testMinIntArray() {
        CollectionToolsTests.assertEquals((int)0, (int)CollectionTools.min((int[])this.buildIntArray()));
    }

    public void testRemoveAllObjectArrayObjectArray() {
        Object[] a1 = new String[]{"A", "A", "B", "B", "C", "C", "D", "D", "E", "E", "F", "F"};
        Object[] a2 = new String[]{"E", "B"};
        Object[] a3 = (String[])CollectionTools.removeAll((Object[])a1, (Object[])a2);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"A", "A", "C", "C", "D", "D", "F", "F"}, a3));
    }

    public void testRemoveAllCharArrayCharArray() {
        char[] a1 = new char[]{'A', 'A', 'B', 'B', 'C', 'C', 'D', 'D', 'E', 'E', 'F', 'F'};
        char[] a2 = new char[]{'E', 'B'};
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'A', 'A', 'C', 'C', 'D', 'D', 'F', 'F'}, CollectionTools.removeAll((char[])a1, (char[])a2)));
    }

    public void testRemoveAllIntArrayIntArray() {
        int[] a1 = new int[]{1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6};
        int[] a2 = new int[]{5, 2};
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new int[]{1, 1, 3, 3, 4, 4, 6, 6}, CollectionTools.removeAll((int[])a1, (int[])a2)));
    }

    public void testRemoveObjectArrayObject1() {
        Object[] a = this.buildObjectArray1();
        a = CollectionTools.add((Object[])a, (Object)"three");
        a = CollectionTools.add((Object[])a, (Object)"four");
        a = CollectionTools.add((Object[])a, (Object)"five");
        CollectionToolsTests.assertEquals((int)6, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((Object[])a, (Object)"three"));
        a = CollectionTools.remove((Object[])a, (Object)"three");
        CollectionToolsTests.assertEquals((int)5, (int)a.length);
        CollectionToolsTests.assertFalse((boolean)CollectionTools.contains((Object[])a, (Object)"three"));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((Object[])a, (Object)"four"));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((Object[])a, (Object)"five"));
    }

    public void testRemoveObjectArrayObject2() {
        Object[] a = this.buildStringArray1();
        a = (String[])CollectionTools.add((Object[])a, (Object)"three");
        a = (String[])CollectionTools.add((Object[])a, (Object)"four");
        a = (String[])CollectionTools.add((Object[])a, (Object)"five");
        CollectionToolsTests.assertEquals((int)6, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((Object[])a, (Object)"three"));
        a = (String[])CollectionTools.remove((Object[])a, (Object)"three");
        CollectionToolsTests.assertEquals((int)5, (int)a.length);
        CollectionToolsTests.assertFalse((boolean)CollectionTools.contains((Object[])a, (Object)"three"));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((Object[])a, (Object)"four"));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((Object[])a, (Object)"five"));
    }

    public void testRemoveCharArrayChar() {
        char[] a = this.buildCharArray();
        a = CollectionTools.add((char[])a, (char)'d');
        a = CollectionTools.add((char[])a, (char)'e');
        a = CollectionTools.add((char[])a, (char)'f');
        CollectionToolsTests.assertEquals((int)6, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((char[])a, (char)'d'));
        a = CollectionTools.remove((char[])a, (char)'d');
        CollectionToolsTests.assertEquals((int)5, (int)a.length);
        CollectionToolsTests.assertFalse((boolean)CollectionTools.contains((char[])a, (char)'d'));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((char[])a, (char)'e'));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((char[])a, (char)'f'));
    }

    public void testRemoveIntArrayInt() {
        int[] a = this.buildIntArray();
        a = CollectionTools.add((int[])a, (int)30);
        a = CollectionTools.add((int[])a, (int)40);
        a = CollectionTools.add((int[])a, (int)50);
        CollectionToolsTests.assertEquals((int)6, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((int[])a, (int)30));
        a = CollectionTools.remove((int[])a, (int)30);
        CollectionToolsTests.assertEquals((int)5, (int)a.length);
        CollectionToolsTests.assertFalse((boolean)CollectionTools.contains((int[])a, (int)30));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((int[])a, (int)40));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((int[])a, (int)50));
    }

    public void testRemoveAllCollectionIterator1() {
        List<String> c = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeAll(c, this.buildStringList1().iterator()));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("one"));
        CollectionToolsTests.assertFalse((boolean)c.contains("two"));
        CollectionToolsTests.assertFalse((boolean)c.contains("three"));
        c = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAll(c, this.buildStringList2().iterator()));
        CollectionToolsTests.assertEquals((int)this.buildStringList1().size(), (int)c.size());
        CollectionToolsTests.assertEquals(this.buildStringList1(), c);
    }

    public void testRemoveAllCollectionIterator2() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("a");
        c.add("a");
        c.add("b");
        c.add("c");
        c.add("d");
        c.add("d");
        Object[] a = new String[]{"a", "d"};
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeAll(c, (Iterator)new ArrayIterator(a)));
        CollectionToolsTests.assertEquals((int)2, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("a"));
        CollectionToolsTests.assertTrue((boolean)c.contains("b"));
        CollectionToolsTests.assertTrue((boolean)c.contains("c"));
        CollectionToolsTests.assertFalse((boolean)c.contains("d"));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAll(c, (Iterator)new ArrayIterator(a)));
    }

    public void testRemoveAllCollectionIterator3() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("a");
        c.add("a");
        c.add("b");
        c.add("c");
        c.add("d");
        c.add("d");
        Object[] a = new String[]{"a", "d"};
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeAll(c, (Iterator)new ArrayIterator(a)));
        CollectionToolsTests.assertEquals((int)2, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("a"));
        CollectionToolsTests.assertTrue((boolean)c.contains("b"));
        CollectionToolsTests.assertTrue((boolean)c.contains("c"));
        CollectionToolsTests.assertFalse((boolean)c.contains("d"));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAll(c, (Iterator)new ArrayIterator(a)));
    }

    public void testRemoveAllCollectionObjectArray1() {
        List<String> c = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeAll(c, (Object[])this.buildObjectArray1()));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("one"));
        CollectionToolsTests.assertFalse((boolean)c.contains("two"));
        CollectionToolsTests.assertFalse((boolean)c.contains("three"));
        c = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAll(c, (Object[])this.buildObjectArray2()));
        CollectionToolsTests.assertEquals((int)this.buildStringList1().size(), (int)c.size());
        CollectionToolsTests.assertEquals(this.buildStringList1(), c);
    }

    public void testRemoveAllCollectionObjectArray2() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("a");
        c.add("a");
        c.add("b");
        c.add("c");
        c.add("d");
        c.add("d");
        Object[] a = new String[]{"a", "d"};
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeAll(c, (Object[])a));
        CollectionToolsTests.assertEquals((int)2, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("a"));
        CollectionToolsTests.assertTrue((boolean)c.contains("b"));
        CollectionToolsTests.assertTrue((boolean)c.contains("c"));
        CollectionToolsTests.assertFalse((boolean)c.contains("d"));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAll(c, (Object[])a));
    }

    public void testRemoveAllCollectionObjectArray3() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("a");
        c.add("b");
        c.add("c");
        c.add("d");
        c.add("a");
        c.add("d");
        c.add("d");
        c.add("a");
        c.add("c");
        Object[] a = new String[]{"a", "d"};
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeAll(c, (Object[])a));
        CollectionToolsTests.assertEquals((int)3, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("a"));
        CollectionToolsTests.assertTrue((boolean)c.contains("b"));
        CollectionToolsTests.assertTrue((boolean)c.contains("c"));
        CollectionToolsTests.assertFalse((boolean)c.contains("d"));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAll(c, (Object[])a));
    }

    public void testRemoveAllOccurrencesCollectionObject() {
        List<String> c = this.buildStringList1();
        CollectionToolsTests.assertEquals((int)3, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAllOccurrences(c, (Object)"three"));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeAllOccurrences(c, (Object)"two"));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAllOccurrences(c, (Object)"two"));
        CollectionToolsTests.assertEquals((int)2, (int)c.size());
        c.add("five");
        c.add("five");
        c.add("five");
        CollectionToolsTests.assertEquals((int)5, (int)c.size());
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeAllOccurrences(c, (Object)"five"));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAllOccurrences(c, (Object)"five"));
        CollectionToolsTests.assertEquals((int)2, (int)c.size());
        c.add(null);
        c.add(null);
        c.add(null);
        CollectionToolsTests.assertEquals((int)5, (int)c.size());
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeAllOccurrences(c, null));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAllOccurrences(c, null));
        CollectionToolsTests.assertEquals((int)2, (int)c.size());
    }

    public void testRemoveAllOccurrencesObjectArrayObject() {
        Object[] a = this.buildStringArray1();
        CollectionToolsTests.assertEquals((int)3, (int)a.length);
        a = (String[])CollectionTools.removeAllOccurrences((Object[])a, (Object)"three");
        CollectionToolsTests.assertEquals((int)3, (int)a.length);
        a = (String[])CollectionTools.removeAllOccurrences((Object[])a, (Object)"two");
        CollectionToolsTests.assertEquals((int)2, (int)a.length);
        a = (String[])CollectionTools.removeAllOccurrences((Object[])a, (Object)"two");
        CollectionToolsTests.assertEquals((int)2, (int)a.length);
        a = (String[])CollectionTools.add((Object[])a, (Object)"five");
        a = (String[])CollectionTools.add((Object[])a, (Object)"five");
        a = (String[])CollectionTools.add((Object[])a, (Object)"five");
        CollectionToolsTests.assertEquals((int)5, (int)a.length);
        a = (String[])CollectionTools.removeAllOccurrences((Object[])a, (Object)"five");
        CollectionToolsTests.assertEquals((int)2, (int)a.length);
        a = (String[])CollectionTools.removeAllOccurrences((Object[])a, (Object)"five");
        CollectionToolsTests.assertEquals((int)2, (int)a.length);
        a = (String[])CollectionTools.add((Object[])a, null);
        a = (String[])CollectionTools.add((Object[])a, null);
        a = (String[])CollectionTools.add((Object[])a, null);
        CollectionToolsTests.assertEquals((int)5, (int)a.length);
        a = (String[])CollectionTools.removeAllOccurrences((Object[])a, null);
        CollectionToolsTests.assertEquals((int)2, (int)a.length);
        a = (String[])CollectionTools.removeAllOccurrences((Object[])a, null);
        CollectionToolsTests.assertEquals((int)2, (int)a.length);
    }

    public void testRemoveAllOccurrencesCharArrayChar() {
        char[] a = this.buildCharArray();
        CollectionToolsTests.assertEquals((int)3, (int)a.length);
        a = CollectionTools.removeAllOccurrences((char[])a, (char)'d');
        CollectionToolsTests.assertEquals((int)3, (int)a.length);
        a = CollectionTools.removeAllOccurrences((char[])a, (char)'b');
        CollectionToolsTests.assertEquals((int)2, (int)a.length);
        a = CollectionTools.removeAllOccurrences((char[])a, (char)'b');
        CollectionToolsTests.assertEquals((int)2, (int)a.length);
        a = CollectionTools.add((char[])a, (char)'g');
        a = CollectionTools.add((char[])a, (char)'g');
        a = CollectionTools.add((char[])a, (char)'g');
        CollectionToolsTests.assertEquals((int)5, (int)a.length);
        a = CollectionTools.removeAllOccurrences((char[])a, (char)'g');
        CollectionToolsTests.assertEquals((int)2, (int)a.length);
        a = CollectionTools.removeAllOccurrences((char[])a, (char)'g');
        CollectionToolsTests.assertEquals((int)2, (int)a.length);
    }

    public void testRemoveAllOccurrencesIntArrayInt() {
        int[] a = this.buildIntArray();
        CollectionToolsTests.assertEquals((int)3, (int)a.length);
        a = CollectionTools.removeAllOccurrences((int[])a, (int)55);
        CollectionToolsTests.assertEquals((int)3, (int)a.length);
        a = CollectionTools.removeAllOccurrences((int[])a, (int)10);
        CollectionToolsTests.assertEquals((int)2, (int)a.length);
        a = CollectionTools.removeAllOccurrences((int[])a, (int)10);
        CollectionToolsTests.assertEquals((int)2, (int)a.length);
        a = CollectionTools.add((int[])a, (int)77);
        a = CollectionTools.add((int[])a, (int)77);
        a = CollectionTools.add((int[])a, (int)77);
        CollectionToolsTests.assertEquals((int)5, (int)a.length);
        a = CollectionTools.removeAllOccurrences((int[])a, (int)77);
        CollectionToolsTests.assertEquals((int)2, (int)a.length);
        a = CollectionTools.removeAllOccurrences((int[])a, (int)77);
        CollectionToolsTests.assertEquals((int)2, (int)a.length);
    }

    public void testRemoveElementAtIndexObjectArrayInt() {
        Object[] a = new String[]{"A", "B", "A", "C", "A", "D"};
        a = (String[])CollectionTools.removeElementAtIndex((Object[])a, (int)3);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"A", "B", "A", "A", "D"}, a));
    }

    public void testRemoveElementAtIndexCharArrayInt() {
        char[] a = new char[]{'A', 'B', 'A', 'C', 'A', 'D'};
        a = CollectionTools.removeElementAtIndex((char[])a, (int)3);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'A', 'B', 'A', 'A', 'D'}, a));
    }

    public void testRemoveElementAtIndexIntArrayInt() {
        int[] a = new int[]{8, 6, 7, 33, 2, 11};
        a = CollectionTools.removeElementAtIndex((int[])a, (int)3);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new int[]{8, 6, 7, 2, 11}, a));
    }

    public void testReplaceAllObjectArray1() {
        Object[] a = new Object[]{"A", "B", "A", "C", "A", "D"};
        a = CollectionTools.replaceAll((Object[])a, (Object)"A", (Object)"Z");
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"Z", "B", "Z", "C", "Z", "D"}, a));
    }

    public void testReplaceAllObjectArray2() {
        Object[] a = new String[]{"A", "B", "A", "C", "A", "D"};
        a = (String[])CollectionTools.replaceAll((Object[])a, (Object)"A", (Object)"Z");
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"Z", "B", "Z", "C", "Z", "D"}, a));
    }

    public void testReplaceAllCharArray() {
        char[] a = new char[]{'A', 'B', 'A', 'C', 'A', 'D'};
        a = CollectionTools.replaceAll((char[])a, (char)'A', (char)'Z');
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'Z', 'B', 'Z', 'C', 'Z', 'D'}, a));
    }

    public void testReplaceAllIntArray() {
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[3] = 7;
        nArray[5] = 99;
        int[] a = nArray;
        a = CollectionTools.replaceAll((int[])a, (int)0, (int)13);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new int[]{13, 1, 13, 7, 13, 99}, a));
    }

    public void testRetainAllCollectionIterator1() {
        List<String> c = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.retainAll(c, this.buildStringList1().iterator()));
        CollectionToolsTests.assertEquals((int)this.buildStringList1().size(), (int)c.size());
        CollectionToolsTests.assertEquals(this.buildStringList1(), c);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.retainAll(c, this.buildStringList2().iterator()));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("one"));
        CollectionToolsTests.assertFalse((boolean)c.contains("two"));
        CollectionToolsTests.assertFalse((boolean)c.contains("three"));
    }

    public void testRetainAllCollectionIterator2() {
        ArrayList<String> c1 = new ArrayList<String>();
        c1.add("zero");
        c1.add("one");
        c1.add("two");
        ArrayList<String> c2 = new ArrayList<String>();
        c2.add("zero");
        c2.add("one");
        c2.add("two");
        CollectionToolsTests.assertFalse((boolean)CollectionTools.retainAll(c1, c2.iterator()));
        CollectionToolsTests.assertEquals((int)c2.size(), (int)c1.size());
        CollectionToolsTests.assertEquals(c2, c1);
        ArrayList<String> c3 = new ArrayList<String>();
        c3.add("three");
        c3.add("four");
        c3.add("five");
        CollectionToolsTests.assertTrue((boolean)CollectionTools.retainAll(c1, c3.iterator()));
        CollectionToolsTests.assertEquals((int)0, (int)c1.size());
        CollectionToolsTests.assertFalse((boolean)c1.contains("one"));
        CollectionToolsTests.assertFalse((boolean)c1.contains("two"));
        CollectionToolsTests.assertFalse((boolean)c1.contains("three"));
    }

    public void testRetainAllCollectionObjectArray() {
        List<String> c = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.retainAll(c, (Object[])this.buildObjectArray1()));
        CollectionToolsTests.assertEquals((int)this.buildStringList1().size(), (int)c.size());
        CollectionToolsTests.assertEquals(this.buildStringList1(), c);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.retainAll(c, (Object[])this.buildObjectArray2()));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("one"));
        CollectionToolsTests.assertFalse((boolean)c.contains("two"));
        CollectionToolsTests.assertFalse((boolean)c.contains("three"));
    }

    public void testRetainAllObjectArrayObjectArray() {
        Object[] a1 = new String[]{"A", "A", "B", "B", "C", "C", "D", "D", "E", "E", "F", "F"};
        Object[] a2 = new Object[]{"E", "B", new Integer(7)};
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"B", "B", "E", "E"}, CollectionTools.retainAll((Object[])a1, (Object[])a2)));
    }

    public void testRetainAllCharArrayCharArray() {
        char[] a1 = new char[]{'A', 'A', 'B', 'B', 'C', 'C', 'D', 'D', 'E', 'E', 'F', 'F'};
        char[] a2 = new char[]{'E', 'B'};
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'B', 'B', 'E', 'E'}, CollectionTools.retainAll((char[])a1, (char[])a2)));
    }

    public void testRetainAllIntArrayIntArray() {
        int[] a1 = new int[]{1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6};
        int[] a2 = new int[]{5, 2};
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new int[]{2, 2, 5, 5}, CollectionTools.retainAll((int[])a1, (int[])a2)));
    }

    public void testReverseObjectArray1() {
        Object[] a = this.buildObjectArray1();
        a = CollectionTools.reverse((Object[])a);
        CollectionToolsTests.assertEquals((Object)"two", (Object)a[0]);
        CollectionToolsTests.assertEquals((Object)"one", (Object)a[1]);
        CollectionToolsTests.assertEquals((Object)"zero", (Object)a[2]);
    }

    public void testReverseObjectArray2() {
        Object[] a = this.buildStringArray1();
        a = (String[])CollectionTools.reverse((Object[])a);
        CollectionToolsTests.assertEquals((String)"two", (String)a[0]);
        CollectionToolsTests.assertEquals((String)"one", (String)a[1]);
        CollectionToolsTests.assertEquals((String)"zero", (String)a[2]);
    }

    public void testReverseCharArray() {
        char[] a = this.buildCharArray();
        a = CollectionTools.reverse((char[])a);
        CollectionToolsTests.assertEquals((char)'c', (char)a[0]);
        CollectionToolsTests.assertEquals((char)'b', (char)a[1]);
        CollectionToolsTests.assertEquals((char)'a', (char)a[2]);
    }

    public void testReverseIntArray() {
        int[] a = this.buildIntArray();
        a = CollectionTools.reverse((int[])a);
        CollectionToolsTests.assertEquals((int)20, (int)a[0]);
        CollectionToolsTests.assertEquals((int)10, (int)a[1]);
        CollectionToolsTests.assertEquals((int)0, (int)a[2]);
    }

    public void testReverseListIterator1() {
        List actual = CollectionTools.reverseList(this.buildStringList1().iterator());
        List<String> expected = this.buildStringList1();
        Collections.reverse(expected);
        CollectionToolsTests.assertEquals(expected, (Object)actual);
    }

    public void testReverseListIterator2() {
        List actual = CollectionTools.reverseList(this.buildStringList1().iterator());
        List<Object> expected = this.buildObjectList1();
        Collections.reverse(expected);
        CollectionToolsTests.assertEquals(expected, (Object)actual);
    }

    public void testRotateObjectArray() {
        Object[] a = this.buildStringArray1();
        a = (String[])CollectionTools.rotate((Object[])a);
        CollectionToolsTests.assertEquals((String)"two", (String)a[0]);
        CollectionToolsTests.assertEquals((String)"zero", (String)a[1]);
        CollectionToolsTests.assertEquals((String)"one", (String)a[2]);
    }

    public void testRotateObjectArrayInt() {
        Object[] a = this.buildStringArray1();
        a = (String[])CollectionTools.rotate((Object[])a, (int)2);
        CollectionToolsTests.assertEquals((String)"one", (String)a[0]);
        CollectionToolsTests.assertEquals((String)"two", (String)a[1]);
        CollectionToolsTests.assertEquals((String)"zero", (String)a[2]);
    }

    public void testRotateCharArray() {
        char[] a = this.buildCharArray();
        a = CollectionTools.rotate((char[])a);
        CollectionToolsTests.assertEquals((char)'c', (char)a[0]);
        CollectionToolsTests.assertEquals((char)'a', (char)a[1]);
        CollectionToolsTests.assertEquals((char)'b', (char)a[2]);
    }

    public void testRotateCharArrayInt() {
        char[] a = this.buildCharArray();
        a = CollectionTools.rotate((char[])a, (int)2);
        CollectionToolsTests.assertEquals((char)'b', (char)a[0]);
        CollectionToolsTests.assertEquals((char)'c', (char)a[1]);
        CollectionToolsTests.assertEquals((char)'a', (char)a[2]);
    }

    public void testRotateIntArray() {
        int[] a = this.buildIntArray();
        a = CollectionTools.rotate((int[])a);
        CollectionToolsTests.assertEquals((int)20, (int)a[0]);
        CollectionToolsTests.assertEquals((int)0, (int)a[1]);
        CollectionToolsTests.assertEquals((int)10, (int)a[2]);
    }

    public void testRotateIntArrayInt() {
        int[] a = this.buildIntArray();
        a = CollectionTools.rotate((int[])a, (int)2);
        CollectionToolsTests.assertEquals((int)10, (int)a[0]);
        CollectionToolsTests.assertEquals((int)20, (int)a[1]);
        CollectionToolsTests.assertEquals((int)0, (int)a[2]);
    }

    public void testSetIterator1() {
        CollectionToolsTests.assertEquals(this.buildStringSet1(), (Object)CollectionTools.set(this.buildStringSet1().iterator()));
    }

    public void testSetIterator2() {
        HashSet<String> set1 = new HashSet<String>();
        set1.add("0");
        set1.add("1");
        set1.add("2");
        set1.add("3");
        Set set2 = CollectionTools.set(set1.iterator());
        CollectionToolsTests.assertEquals(set1, (Object)set2);
    }

    public void testSetObjectArray() {
        CollectionToolsTests.assertEquals(this.buildStringSet1(), (Object)CollectionTools.set((Object[])this.buildStringSet1().toArray()));
    }

    public void testShuffleObjectArray() {
        Object[] array1 = this.buildStringArray1();
        Object[] array2 = (String[])CollectionTools.shuffle((Object[])this.buildStringArray1());
        CollectionToolsTests.assertEquals((int)array1.length, (int)array2.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])array1, (Object[])array2));
    }

    public void testShuffleCharArray() {
        char[] array1 = this.buildCharArray();
        char[] array2 = CollectionTools.shuffle((char[])this.buildCharArray());
        CollectionToolsTests.assertEquals((int)array1.length, (int)array2.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((char[])array1, (char[])array2));
    }

    public void testShuffleIntArray() {
        int[] array1 = this.buildIntArray();
        int[] array2 = CollectionTools.shuffle((int[])this.buildIntArray());
        CollectionToolsTests.assertEquals((int)array1.length, (int)array2.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((int[])array1, (int[])array2));
    }

    public void testSingletonIterator1() {
        Iterator stream = CollectionTools.singletonIterator((Object)"foo");
        CollectionToolsTests.assertTrue((boolean)stream.hasNext());
        CollectionToolsTests.assertEquals((String)"foo", (String)((String)stream.next()));
    }

    public void testSingletonIterator2() {
        Iterator stream = CollectionTools.singletonIterator((Object)"foo");
        CollectionToolsTests.assertTrue((boolean)stream.hasNext());
        CollectionToolsTests.assertEquals((Object)"foo", stream.next());
    }

    public void testSingletonIterator3() {
        Iterator stream = CollectionTools.singletonIterator((Object)"foo");
        CollectionToolsTests.assertTrue((boolean)stream.hasNext());
        CollectionToolsTests.assertEquals((Object)"foo", stream.next());
    }

    public void testSizeIterator() {
        CollectionToolsTests.assertEquals((int)3, (int)CollectionTools.size(this.buildObjectList1().iterator()));
    }

    public void testSortedSetIterator1() {
        CollectionToolsTests.assertEquals(this.buildSortedStringSet1(), (Object)CollectionTools.set(this.buildSortedStringSet1().iterator()));
    }

    public void testSortedSetIterator2() {
        TreeSet<String> ss1 = new TreeSet<String>();
        ss1.add("0");
        ss1.add("2");
        ss1.add("3");
        ss1.add("1");
        SortedSet set2 = CollectionTools.sortedSet(ss1.iterator());
        CollectionToolsTests.assertEquals(ss1, (Object)set2);
    }

    public void testSortedSetObjectArray() {
        CollectionToolsTests.assertEquals(this.buildSortedStringSet1(), (Object)CollectionTools.set((Object[])this.buildSortedStringSet1().toArray()));
    }

    public void testSwapObjectArray() {
        Object[] a = this.buildStringArray1();
        a = (String[])CollectionTools.swap((Object[])a, (int)1, (int)2);
        CollectionToolsTests.assertEquals((String)"zero", (String)a[0]);
        CollectionToolsTests.assertEquals((String)"two", (String)a[1]);
        CollectionToolsTests.assertEquals((String)"one", (String)a[2]);
    }

    public void testSwapCharArray() {
        char[] a = this.buildCharArray();
        a = CollectionTools.swap((char[])a, (int)1, (int)2);
        CollectionToolsTests.assertEquals((char)'a', (char)a[0]);
        CollectionToolsTests.assertEquals((char)'c', (char)a[1]);
        CollectionToolsTests.assertEquals((char)'b', (char)a[2]);
    }

    public void testSwapIntArray() {
        int[] a = this.buildIntArray();
        a = CollectionTools.swap((int[])a, (int)1, (int)2);
        CollectionToolsTests.assertEquals((int)0, (int)a[0]);
        CollectionToolsTests.assertEquals((int)20, (int)a[1]);
        CollectionToolsTests.assertEquals((int)10, (int)a[2]);
    }

    public void testRemoveDuplicateElementsList() {
        List<String> list = this.buildStringVector1();
        list.add("zero");
        list.add("zero");
        list.add("two");
        list.add("zero");
        list = CollectionTools.removeDuplicateElements(list);
        int i = 0;
        CollectionToolsTests.assertEquals((String)"zero", (String)list.get(i++));
        CollectionToolsTests.assertEquals((String)"one", (String)list.get(i++));
        CollectionToolsTests.assertEquals((String)"two", (String)list.get(i++));
        CollectionToolsTests.assertEquals((int)i, (int)list.size());
    }

    public void testRemoveDuplicateElementsObjectArray1() {
        Vector<String> list = this.buildStringVector1();
        list.add("zero");
        list.add("zero");
        list.add("two");
        list.add("zero");
        String[] array = (String[])CollectionTools.removeDuplicateElements((Object[])list.toArray(new String[list.size()]));
        int i = 0;
        CollectionToolsTests.assertEquals((String)"zero", (String)array[i++]);
        CollectionToolsTests.assertEquals((String)"one", (String)array[i++]);
        CollectionToolsTests.assertEquals((String)"two", (String)array[i++]);
        CollectionToolsTests.assertEquals((int)i, (int)array.length);
    }

    public void testRemoveDuplicateElementsObjectArray2() {
        Vector<String> list = this.buildStringVector1();
        list.add("zero");
        list.add("zero");
        list.add("two");
        list.add("zero");
        String[] array = (String[])CollectionTools.removeDuplicateElements((Object[])list.toArray(new String[list.size()]));
        int i = 0;
        CollectionToolsTests.assertEquals((String)"zero", (String)array[i++]);
        CollectionToolsTests.assertEquals((String)"one", (String)array[i++]);
        CollectionToolsTests.assertEquals((String)"two", (String)array[i++]);
        CollectionToolsTests.assertEquals((int)i, (int)array.length);
    }

    public void testVectorIterator1() {
        Vector v = CollectionTools.vector(this.buildStringList1().iterator());
        CollectionToolsTests.assertEquals((int)3, (int)v.size());
        CollectionToolsTests.assertTrue((boolean)v.containsAll(this.buildStringList1()));
    }

    public void testVectorIterator2() {
        Vector v = CollectionTools.vector(this.buildStringList1().iterator());
        CollectionToolsTests.assertEquals((int)3, (int)v.size());
        CollectionToolsTests.assertTrue((boolean)v.containsAll(this.buildStringList1()));
    }

    public void testVectorObjectArray() {
        Vector v = CollectionTools.vector((Object[])this.buildStringArray1());
        CollectionToolsTests.assertEquals((int)3, (int)v.size());
        CollectionToolsTests.assertTrue((boolean)v.containsAll(this.buildStringList1()));
    }

    private Object[] buildObjectArray1() {
        return new Object[]{"zero", "one", "two"};
    }

    private String[] buildStringArray1() {
        return new String[]{"zero", "one", "two"};
    }

    private char[] buildCharArray() {
        return new char[]{'a', 'b', 'c'};
    }

    private int[] buildIntArray() {
        int[] nArray = new int[3];
        nArray[1] = 10;
        nArray[2] = 20;
        return nArray;
    }

    private Object[] buildObjectArray2() {
        return new Object[]{"three", "four", "five"};
    }

    private String[] buildStringArray2() {
        return new String[]{"three", "four", "five"};
    }

    private Vector<String> buildStringVector1() {
        Vector<String> v = new Vector<String>();
        this.addToCollection1(v);
        return v;
    }

    private List<String> buildStringList1() {
        ArrayList<String> l = new ArrayList<String>();
        this.addToCollection1(l);
        return l;
    }

    private List<Object> buildObjectList1() {
        ArrayList<Object> l = new ArrayList<Object>();
        this.addToCollection1(l);
        return l;
    }

    private void addToCollection1(Collection<? super String> c) {
        c.add("zero");
        c.add("one");
        c.add("two");
    }

    private List<String> buildStringList2() {
        ArrayList<String> l = new ArrayList<String>();
        this.addToCollection2(l);
        return l;
    }

    private void addToCollection2(Collection<? super String> c) {
        c.add("three");
        c.add("four");
        c.add("five");
    }

    private Set<String> buildStringSet1() {
        HashSet<String> s = new HashSet<String>();
        this.addToCollection1(s);
        return s;
    }

    private Set<Object> buildObjectSet1() {
        HashSet<Object> s = new HashSet<Object>();
        this.addToCollection1(s);
        return s;
    }

    private SortedSet<String> buildSortedStringSet1() {
        TreeSet<String> s = new TreeSet<String>();
        this.addToCollection1(s);
        return s;
    }
}

