/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal.iterators;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.iterators.ChainIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainIteratorTests
extends TestCase {
    private static final Class<?>[] VECTOR_HIERARCHY = new Class[]{Vector.class, AbstractList.class, AbstractCollection.class, Object.class};

    public ChainIteratorTests(String name) {
        super(name);
    }

    public void testHasNext() {
        int i = 0;
        Iterator<Class<?>> stream = this.buildIterator();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        ChainIteratorTests.assertEquals((int)VECTOR_HIERARCHY.length, (int)i);
    }

    public void testInnerHasNext() {
        int i = 0;
        Iterator<Class<?>> stream = this.buildInnerIterator();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        ChainIteratorTests.assertEquals((int)VECTOR_HIERARCHY.length, (int)i);
    }

    public void testNext() {
        int i = 0;
        Iterator<Class<?>> stream = this.buildIterator();
        while (stream.hasNext()) {
            ChainIteratorTests.assertEquals((String)"bogus link", VECTOR_HIERARCHY[i], stream.next());
            ++i;
        }
    }

    public void testInnerNext() {
        int i = 0;
        Iterator<Class<?>> stream = this.buildInnerIterator();
        while (stream.hasNext()) {
            ChainIteratorTests.assertEquals((String)"bogus link", VECTOR_HIERARCHY[i], stream.next());
            ++i;
        }
    }

    public void testNoSuchElementException() {
        boolean exCaught = false;
        Iterator<Class<?>> stream = this.buildIterator();
        Class<?> javaClass = null;
        while (stream.hasNext()) {
            javaClass = stream.next();
        }
        try {
            javaClass = stream.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        ChainIteratorTests.assertTrue((String)("NoSuchElementException not thrown: " + javaClass), (boolean)exCaught);
    }

    public void testUnsupportedOperationException() {
        boolean exCaught = false;
        Iterator<Class<?>> stream = this.buildIterator();
        while (stream.hasNext()) {
            if (stream.next() != AbstractCollection.class) continue;
            try {
                stream.remove();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                exCaught = true;
            }
        }
        ChainIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown", (boolean)exCaught);
    }

    private Iterator<Class<?>> buildIterator() {
        return this.buildChainIterator(Vector.class, this.buildLinker());
    }

    private Iterator<Class<?>> buildInnerIterator() {
        return this.buildInnerChainIterator(Vector.class);
    }

    private Iterator<Class<?>> buildChainIterator(Class<?> startLink, ChainIterator.Linker<Class<?>> linker) {
        return new ChainIterator(startLink, linker);
    }

    private ChainIterator.Linker<Class<?>> buildLinker() {
        return new ChainIterator.Linker<Class<?>>(){

            public Class<?> nextLink(Class<?> currentLink) {
                return currentLink.getSuperclass();
            }
        };
    }

    private Iterator<Class<?>> buildInnerChainIterator(Class<?> startLink) {
        return new ChainIterator<Class<?>>(startLink){

            protected Class<?> nextLink(Class<?> currentLink) {
                return currentLink.getSuperclass();
            }
        };
    }
}

