/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.context.symbol.tests;

import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IType;
import org.eclipse.jst.jsf.context.symbol.IBeanInstanceSymbol;
import org.eclipse.jst.jsf.context.symbol.IJavaTypeDescriptor2;
import org.eclipse.jst.jsf.context.symbol.IPropertySymbol;
import org.eclipse.jst.jsf.context.symbol.ITypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.SymbolFactory;
import org.eclipse.jst.jsf.test.util.JDTTestEnvironment;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.ProjectTestEnvironment;
import org.eclipse.jst.jsf.test.util.TestFileResource;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelBaseTestCase
extends TestCase {
    protected JDTTestEnvironment _jdtTestEnvironment;
    protected static final String srcFolderName = "src";

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        JSFTestUtil.setInternetProxyPreferences((boolean)true, (String)"www-proxy.uk.oracle.com", (String)"80");
        WebProjectTestEnvironment projectTestEnvironment = new WebProjectTestEnvironment("TestJDTBeanIntrospectorProject");
        projectTestEnvironment.createProject(true);
        this._jdtTestEnvironment = new JDTTestEnvironment((ProjectTestEnvironment)projectTestEnvironment);
    }

    protected void loadSourceClass(Bundle bundle, String fileName, String packageName, String beanClassName) throws Exception {
        TestFileResource codeRes = new TestFileResource();
        codeRes.load(bundle, fileName);
        String code = codeRes.toString();
        this._jdtTestEnvironment.addSourceFile(srcFolderName, packageName, beanClassName, code);
        ModelBaseTestCase.assertNotNull((Object)this._jdtTestEnvironment.getJavaProject().findType(String.valueOf(packageName) + "." + beanClassName));
    }

    protected IBeanInstanceSymbol setupBeanProperty(Bundle bundle, String fileName, String packageName, String beanClassName, Map<String, IPropertySymbol> properties) throws Exception {
        this.loadSourceClass(bundle, fileName, packageName, beanClassName);
        IType testBean1Type = this._jdtTestEnvironment.getJavaProject().findType(String.valueOf(packageName) + "." + beanClassName);
        ModelBaseTestCase.assertNotNull((Object)testBean1Type);
        IJavaTypeDescriptor2 testBeanDescriptor = SymbolFactory.eINSTANCE.createIJavaTypeDescriptor2();
        testBeanDescriptor.setType(testBean1Type);
        IBeanInstanceSymbol bean = SymbolFactory.eINSTANCE.createIBeanInstanceSymbol();
        bean.setTypeDescriptor((ITypeDescriptor)testBeanDescriptor);
        bean.setName(beanClassName);
        this.populatePropertyMap(bean, properties);
        return bean;
    }

    protected void populatePropertyMap(IBeanInstanceSymbol bean, Map<String, IPropertySymbol> properties) {
        EList propertyList = bean.getProperties();
        for (IPropertySymbol property : propertyList) {
            properties.put(property.getName(), property);
        }
    }
}

