/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.project.facet;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jst.j2ee.common.ParamValue;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.ContextParam;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.jsf.core.internal.project.facet.AbstractJSFFacetUninstallDelegate;
import org.eclipse.jst.jsf.core.internal.project.facet.JSFUtils11;

public class JSFJ2EEFacetUninstallDelegate
extends AbstractJSFFacetUninstallDelegate {
    protected void uninstallJSFReferencesFromWebApp(IProject project, IProgressMonitor monitor) {
        WebArtifactEdit artifactEdit = JSFUtils11.getWebArtifactEditForWrite(project);
        WebApp webApp = artifactEdit.getWebApp();
        try {
            Servlet servlet = JSFUtils11.findJSFServlet(webApp);
            if (servlet == null) {
                return;
            }
            this.removeJSFURLMappings(webApp, servlet);
            this.removeJSFContextParams(webApp, servlet);
            this.removeJSFServlet(webApp, servlet);
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.saveIfNecessary(monitor);
                artifactEdit.dispose();
            }
        }
    }

    private void removeJSFURLMappings(WebApp webApp, Servlet servlet) {
        while (webApp.getServletMapping(servlet) != null) {
            webApp.getServletMappings().remove((Object)webApp.getServletMapping(servlet));
        }
    }

    private void removeJSFContextParams(WebApp webApp, Servlet servlet) {
        if (webApp.getVersionID() == 23) {
            for (ContextParam cp : webApp.getContexts()) {
                if (!cp.getParamName().equals("javax.faces.CONFIG_FILES")) continue;
                webApp.getContexts().remove((Object)cp);
                break;
            }
        } else {
            for (ParamValue cp : webApp.getContextParams()) {
                if (!cp.getName().equals("javax.faces.CONFIG_FILES")) continue;
                webApp.getContextParams().remove((Object)cp);
                break;
            }
        }
    }

    private void removeJSFServlet(WebApp webApp, Servlet servlet) {
        webApp.getServlets().remove((Object)servlet);
    }
}

